import * as account from './entities/account.js';
import * as activity from './entities/activity.js';
import * as announcement from './entities/announcement.js';
import * as application from './entities/application.js';
import * as async_attachment from './entities/async_attachment.js';
import * as attachment from './entities/attachment.js';
import * as card from './entities/card.js';
import * as context from './entities/context.js';
import * as conversation from './entities/conversation.js';
import * as emoji from './entities/emoji.js';
import * as featured_tag from './entities/featured_tag.js';
import * as field from './entities/field.js';
import * as filter from './entities/filter.js';
import * as follow_request from './entities/follow_request.js';
import * as history from './entities/history.js';
import * as identity_proof from './entities/identity_proof.js';
import * as instance from './entities/instance.js';
import * as list from './entities/list.js';
import * as marker from './entities/marker.js';
import * as mention from './entities/mention.js';
import * as notification from './entities/notification.js';
import * as poll from './entities/poll.js';
import * as preferences from './entities/preferences.js';
import * as push_subscription from './entities/push_subscription.js';
import * as reaction from './entities/reaction.js';
import * as relationship from './entities/relationship.js';
import * as report from './entities/report.js';
import * as results from './entities/results.js';
import * as role from './entities/role.js';
import * as scheduled_status from './entities/scheduled_status.js';
import * as source from './entities/source.js';
import * as stats from './entities/stats.js';
import * as status from './entities/status.js';
import * as status_params from './entities/status_params.js';
import * as status_source from './entities/status_source.js';
import * as tag from './entities/tag.js';
import * as token from './entities/token.js';
import * as urls from './entities/urls.js';
import * as quote from './entities/quote.js';
export declare namespace Entity {
    type Account = account.Account;
    type Activity = activity.Activity;
    type Announcement = announcement.Announcement;
    type AnnouncementAccount = announcement.AnnouncementAccount;
    type AnnouncementStatus = announcement.AnnouncementStatus;
    type AnnouncementReaction = announcement.AnnouncementReaction;
    type Application = application.Application;
    type AsyncAttachment = async_attachment.AsyncAttachment;
    type Attachment = attachment.Attachment;
    type Sub = attachment.Sub;
    type Focus = attachment.Focus;
    type Meta = attachment.Meta;
    type Card = card.Card;
    type Context = context.Context;
    type Conversation = conversation.Conversation;
    type Emoji = emoji.Emoji;
    type FeaturedTag = featured_tag.FeaturedTag;
    type Field = field.Field;
    type Filter = filter.Filter;
    type FilterContext = filter.FilterContext;
    type FollowRequest = follow_request.FollowRequest;
    type History = history.History;
    type IdentityProof = identity_proof.IdentityProof;
    type Instance = instance.Instance;
    type InstanceRule = instance.InstanceRule;
    type List = list.List;
    type RepliesPolicy = list.RepliesPolicy;
    type Marker = marker.Marker;
    type Mention = mention.Mention;
    type Notification = notification.Notification;
    type NotificationType = notification.NotificationType;
    type Poll = poll.Poll;
    type PollOption = poll.PollOption;
    type Preferences = preferences.Preferences;
    type Alerts = push_subscription.Alerts;
    type PushSubscription = push_subscription.PushSubscription;
    type Reaction = reaction.Reaction;
    type Relationship = relationship.Relationship;
    type Report = report.Report;
    type Category = report.Category;
    type Results = results.Results;
    type Role = role.Role;
    type ScheduledStatus = scheduled_status.ScheduledStatus;
    type Source = source.Source;
    type Stats = stats.Stats;
    type Status = status.Status;
    type StatusVisibility = status.StatusVisibility;
    type StatusTag = status.StatusTag;
    type StatusParams = status_params.StatusParams;
    type StatusSource = status_source.StatusSource;
    type Tag = tag.Tag;
    type Token = token.Token;
    type URLs = urls.URLs;
    type Quote = quote.Quote;
    type ShallowQuote = quote.ShallowQuote;
    type QuotedStatus = quote.QuotedStatus;
    type QuoteState = quote.QuoteState;
}
export default Entity;
