import { type Action, type ActionDispatcher, type Logger, type Serializer, type WebSocketConnector, type WebSocketSubscriptionCounter } from "../../interfaces/index.js";
type WebSocketActionType = "close" | "prepare" | "subscribe";
type WebSocketAction = Action<WebSocketActionType>;
export declare class WebSocketActionDispatcher implements ActionDispatcher<WebSocketAction> {
    private readonly connector;
    private readonly counter;
    private readonly serializer;
    private readonly logger?;
    constructor(connector: WebSocketConnector, counter: WebSocketSubscriptionCounter, serializer: Serializer, logger?: Logger | undefined);
    dispatch<T>(action: WebSocketAction): T;
    [Symbol.dispose](): void;
}
export {};
