import { CustomError } from "ts-custom-error";
export declare class ExponentialBackoffError extends CustomError {
    constructor(attempts: number, options?: ErrorOptions);
}
export interface ExponentialBackoffProps {
    readonly base?: number;
    readonly factor?: number;
    readonly maxAttempts?: number;
}
export declare class ExponentialBackoff {
    private readonly props;
    private attempts;
    constructor(props?: ExponentialBackoffProps);
    sleep(): Promise<void>;
    clear(): void;
    private get factor();
    private get base();
    private get maxAttempts();
    private get timeout();
}
