"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toAsyncIterable = toAsyncIterable;
const events_to_async_1 = require("events-to-async");
const index_js_1 = require("../errors/index.js");
async function* toAsyncIterable(ws) {
    const handleClose = async (e) => {
        /* c8 ignore next 3 */
        if (!events.return) {
            throw new index_js_1.MastoUnexpectedError("events.return is undefined");
        }
        await events.return(e);
    };
    const handleError = async (e) => {
        /* c8 ignore next 3 */
        if (!events.return) {
            throw new index_js_1.MastoUnexpectedError("events.return is undefined");
        }
        await events.return(e);
    };
    const events = (0, events_to_async_1.on)((handler) => {
        ws.addEventListener("message", handler);
        ws.addEventListener("error", handleError);
        ws.addEventListener("close", handleClose);
        return () => {
            ws.removeEventListener("message", handler);
            ws.removeEventListener("error", handleError);
            ws.removeEventListener("close", handleClose);
        };
    });
    for await (const [event] of events) {
        yield event;
    }
}
