"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformKeys = void 0;
const index_js_1 = require("../../utils/index.js");
const _transformKeys = (data, transform) => {
    if (Array.isArray(data)) {
        return data.map((value) => _transformKeys(value, transform));
    }
    if ((0, index_js_1.isRecord)(data)) {
        return Object.fromEntries(Object.entries(data).map(([key, value]) => [
            transform(key),
            _transformKeys(value, transform),
        ]));
    }
    return data;
};
const transformKeys = (data, transform) => {
    const f = (key) => {
        // `PATCH /v1/preferences` uses `:` as a delimiter
        if (key.includes(":"))
            return key;
        // `PATCH /v2/filters` uses _destroy as a special key
        if (key.startsWith("_"))
            return key;
        return transform(key);
    };
    return _transformKeys(data, f);
};
exports.transformKeys = transformKeys;
