"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggerConsoleImpl = void 0;
class LoggerConsoleImpl {
    level;
    constructor(level) {
        this.level = level;
    }
    log(type, message, meta) {
        if (!this.level.satisfies(type)) {
            return;
        }
        const args = meta == undefined ? [message] : [message, meta];
        switch (type) {
            case "debug": {
                console.debug(...args);
                return;
            }
            case "info": {
                console.info(...args);
                return;
            }
            case "warn": {
                console.warn(...args);
                return;
            }
            case "error": {
                console.error(...args);
                return;
            }
        }
    }
}
exports.LoggerConsoleImpl = LoggerConsoleImpl;
