import { type Encoding, type Http, type HttpMetaParams, type HttpRequestParams, type HttpResponse } from "../../interfaces/index.js";
export declare abstract class BaseHttp implements Http {
    abstract request<T>(params: HttpRequestParams): Promise<HttpResponse<T>>;
    get<T>(path: string, data?: unknown, meta?: HttpMetaParams<Encoding>): Promise<HttpResponse<T>>;
    post<T>(path: string, data?: unknown, meta?: HttpMetaParams<Encoding>): Promise<HttpResponse<T>>;
    delete<T>(path: string, data?: unknown, meta?: HttpMetaParams<Encoding>): Promise<HttpResponse<T>>;
    put<T>(path: string, data?: unknown, meta?: HttpMetaParams<Encoding>): Promise<HttpResponse<T>>;
    patch<T>(path: string, data?: unknown, meta?: HttpMetaParams<Encoding>): Promise<HttpResponse<T>>;
}
