"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOAuthAPIClient = exports.createRestAPIClient = void 0;
exports.createStreamingAPIClient = createStreamingAPIClient;
const dispatcher_http_hook_mastodon_js_1 = require("./action/dispatcher-http-hook-mastodon.js");
const index_js_1 = require("./action/index.js");
const index_js_2 = require("./config/index.js");
const index_js_3 = require("./http/index.js");
const index_js_4 = require("./logger/index.js");
const index_js_5 = require("./serializers/index.js");
const index_js_6 = require("./ws/index.js");
const createRestAPIClient = (props) => {
    const serializer = new index_js_5.SerializerNativeImpl();
    const config = new index_js_2.HttpConfigImpl(props, serializer);
    const logger = (0, index_js_4.createLogger)(props.log);
    const http = new index_js_3.HttpNativeImpl(serializer, config, logger);
    const hook = new dispatcher_http_hook_mastodon_js_1.HttpActionDispatcherHookMastodon(http, props.mediaTimeout);
    const actionDispatcher = new index_js_1.HttpActionDispatcher(http, hook);
    const actionProxy = (0, index_js_1.createActionProxy)(actionDispatcher, {
        context: ["api"],
    });
    return actionProxy;
};
exports.createRestAPIClient = createRestAPIClient;
const createOAuthAPIClient = (props) => {
    const serializer = new index_js_5.SerializerNativeImpl();
    const config = new index_js_2.HttpConfigImpl(props, serializer);
    const logger = (0, index_js_4.createLogger)(props.log);
    const http = new index_js_3.HttpNativeImpl(serializer, config, logger);
    const hook = new dispatcher_http_hook_mastodon_js_1.HttpActionDispatcherHookMastodon(http);
    const actionDispatcher = new index_js_1.HttpActionDispatcher(http, hook);
    const actionProxy = (0, index_js_1.createActionProxy)(actionDispatcher, {
        context: ["oauth"],
    });
    return actionProxy;
};
exports.createOAuthAPIClient = createOAuthAPIClient;
function createStreamingAPIClient(props) {
    const serializer = new index_js_5.SerializerNativeImpl();
    const config = new index_js_2.WebSocketConfigImpl(props, serializer);
    const logger = (0, index_js_4.createLogger)(props.log);
    const connector = new index_js_6.WebSocketConnectorImpl({
        constructorParameters: [
            config.resolvePath("/api/v1/streaming"),
            config.getProtocols(),
        ],
        implementation: props.implementation,
        maxAttempts: config.getMaxAttempts(),
    }, logger);
    const counter = new index_js_6.WebSocketSubscriptionCounterImpl();
    const actionDispatcher = new index_js_1.WebSocketActionDispatcher(connector, counter, serializer, logger);
    const actionProxy = (0, index_js_1.createActionProxy)(actionDispatcher);
    return actionProxy;
}
