import { type LogType } from "../interfaces/index.js";
import { type mastodon } from "../mastodon/index.js";
import { type MastoHttpConfigProps, type WebSocketConfigProps } from "./config/index.js";
interface LogConfigProps {
    /**
     * Log level for the client.
     *
     * - `debug`: Log everything.
     * - `info`: Log important information.
     * - `warn`: Log warnings.
     * - `error`: Log errors.
     *
     * Defaults to `warn`.
     */
    readonly log?: LogType;
}
interface MediaConfigProps {
    /**
     * Timeout milliseconds for media upload processing.
     *
     * When uploading media via `/api/v2/media`, the library polls the server
     * to wait for media processing to complete before returning. This timeout
     * controls how long to wait before giving up.
     *
     * Defaults to 60000 (60 seconds).
     *
     * @experimental The behavior of this option may change without any announcement.
     */
    readonly mediaTimeout?: number;
}
export declare const createRestAPIClient: (props: MastoHttpConfigProps & LogConfigProps & MediaConfigProps) => mastodon.rest.Client;
export declare const createOAuthAPIClient: (props: MastoHttpConfigProps & LogConfigProps) => mastodon.oauth.Client;
interface WebSocketCustomImplProps {
    /**
     * Custom WebSocket implementation. In Deno, you can use `WebSocket` to avoid potential errors.
     *
     * Defaults to `window.WebSocket`.
     */
    readonly implementation?: unknown;
}
export declare function createStreamingAPIClient(props: WebSocketConfigProps & LogConfigProps & WebSocketCustomImplProps): mastodon.streaming.Client;
export {};
