"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createActionProxy = void 0;
const change_case_1 = require("change-case");
const noop_js_1 = require("../../utils/noop.js");
const createActionProxy = (actionDispatcher, options = {}) => {
    const { context = [], applicable = false } = options;
    let target = {};
    const handler = {
        get: get(actionDispatcher, context),
    };
    if (applicable) {
        target = noop_js_1.noop;
        handler.apply = apply(actionDispatcher, context);
    }
    return new Proxy(target, handler);
};
exports.createActionProxy = createActionProxy;
const SPECIAL_PROPERTIES = new Set([
    "then",
    "catch",
    "finally",
    "inspect",
    "toString",
    "valueOf",
    "toJSON",
    "constructor",
    "prototype",
    "length",
    "name",
    "caller",
    "callee",
    "arguments",
    "bind",
    "apply",
    "call",
]);
const get = (actionDispatcher, context) => (_, property) => {
    if (typeof property === "string" && SPECIAL_PROPERTIES.has(property)) {
        return;
    }
    if (property === Symbol.dispose) {
        return actionDispatcher[Symbol.dispose];
    }
    if (typeof property === "symbol") {
        return;
    }
    if (property.startsWith("$")) {
        return (0, exports.createActionProxy)(actionDispatcher, {
            context: [...context, property],
            applicable: true,
        });
    }
    return (0, exports.createActionProxy)(actionDispatcher, {
        context: [...context, (0, change_case_1.snakeCase)(property)],
        applicable: true,
    });
};
const apply = (actionDispatcher, context) => (_1, _2, args) => {
    let action = context.pop();
    let raw = false;
    if (action === "$select") {
        return (0, exports.createActionProxy)(actionDispatcher, {
            context: [...context, ...args],
            applicable: true,
        });
    }
    if (action === "$raw") {
        action = context.pop();
        raw = true;
    }
    /* c8 ignore next 3 */
    if (!action) {
        throw new Error("No action specified");
    }
    const path = "/" + context.join("/");
    const [data, meta] = args;
    return actionDispatcher.dispatch({
        type: action,
        path,
        data,
        meta: meta,
        raw,
    });
};
