"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketActionDispatcher = void 0;
const index_js_1 = require("../errors/index.js");
const index_js_2 = require("../ws/index.js");
class WebSocketActionDispatcher {
    connector;
    counter;
    serializer;
    logger;
    constructor(connector, counter, serializer, logger) {
        this.connector = connector;
        this.counter = counter;
        this.serializer = serializer;
        this.logger = logger;
    }
    dispatch(action) {
        if (action.type === "close") {
            this.connector.kill();
            return {};
        }
        if (action.type === "prepare") {
            return this.connector.acquire();
        }
        if (action.type !== "subscribe") {
            throw new index_js_1.MastoUnexpectedError(`Unknown action type ${action.type}`);
        }
        const data = action.data ?? {};
        const stream = action.path.replace(/^\//, "").replaceAll("/", ":");
        return new index_js_2.WebSocketSubscription(this.connector, this.counter, this.serializer, stream, this.logger, { ...data });
    }
    [Symbol.dispose]() {
        this.connector.kill();
    }
}
exports.WebSocketActionDispatcher = WebSocketActionDispatcher;
