"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.params = params;
const types_1 = require("../types");
const complex_1 = require("./complex");
const PrimitiveValidators = __importStar(require("./primitives"));
function params(lexicons, path, def, val) {
    // type
    const value = val && typeof val === 'object' ? val : {};
    const requiredProps = new Set(def.required ?? []);
    // properties
    let resultValue = value;
    if (typeof def.properties === 'object') {
        for (const key in def.properties) {
            const propDef = def.properties[key];
            const validated = propDef.type === 'array'
                ? (0, complex_1.array)(lexicons, key, propDef, value[key])
                : PrimitiveValidators.validate(lexicons, key, propDef, value[key]);
            const propValue = validated.success ? validated.value : value[key];
            const propIsUndefined = typeof propValue === 'undefined';
            // Return error for bad validation, giving required rule precedence
            if (propIsUndefined && requiredProps.has(key)) {
                return {
                    success: false,
                    error: new types_1.ValidationError(`${path} must have the property "${key}"`),
                };
            }
            else if (!propIsUndefined && !validated.success) {
                return validated;
            }
            // Adjust value based on e.g. applied defaults, cloning shallowly if there was a changed value
            if (propValue !== value[key]) {
                if (resultValue === value) {
                    // Lazy shallow clone
                    resultValue = { ...value };
                }
                resultValue[key] = propValue;
            }
        }
    }
    return { success: true, value: resultValue };
}
//# sourceMappingURL=xrpc.js.map