"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toLexUri = toLexUri;
exports.requiredPropertiesRefinement = requiredPropertiesRefinement;
const zod_1 = require("zod");
function toLexUri(str, baseUri) {
    if (str.split('#').length > 2) {
        throw new Error('Uri can only have one hash segment');
    }
    if (str.startsWith('lex:')) {
        return str;
    }
    if (str.startsWith('#')) {
        if (!baseUri) {
            throw new Error(`Unable to resolve uri without anchor: ${str}`);
        }
        return `${baseUri}${str}`;
    }
    return `lex:${str}`;
}
function requiredPropertiesRefinement(object, ctx) {
    // Required fields check
    if (object.required === undefined) {
        return;
    }
    if (!Array.isArray(object.required)) {
        ctx.addIssue({
            code: zod_1.z.ZodIssueCode.invalid_type,
            received: typeof object.required,
            expected: 'array',
        });
        return;
    }
    if (object.properties === undefined) {
        if (object.required.length > 0) {
            ctx.addIssue({
                code: zod_1.z.ZodIssueCode.custom,
                message: `Required fields defined but no properties defined`,
            });
        }
        return;
    }
    for (const field of object.required) {
        if (object.properties[field] === undefined) {
            ctx.addIssue({
                code: zod_1.z.ZodIssueCode.custom,
                message: `Required field "${field}" not defined`,
            });
        }
    }
}
//# sourceMappingURL=util.js.map