export declare const noUndefinedVals: <T>(obj: Record<string, T | undefined>) => Record<string, T>;
export declare function aggregateErrors(errors: unknown[], message?: string): Error | AggregateError;
/**
 * Returns a shallow copy of the object without the specified keys. If the input
 * is nullish, it returns the input.
 */
export declare function omit<T extends undefined | null | Record<string, unknown>, K extends keyof NonNullable<T>>(object: T, rejectedKeys: readonly K[]): T extends undefined ? undefined : T extends null ? null : Omit<T, K>;
export declare const jitter: (maxMs: number) => number;
export declare const wait: (ms: number) => Promise<unknown>;
export type BailableWait = {
    bail: () => void;
    wait: () => Promise<void>;
};
export declare const bailableWait: (ms: number) => BailableWait;
export declare const flattenUint8Arrays: (arrs: Uint8Array[]) => Uint8Array;
export declare const streamToBuffer: (stream: AsyncIterable<Uint8Array>) => Promise<Uint8Array>;
export declare const s32encode: (i: number) => string;
export declare const s32decode: (s: string) => number;
export declare const asyncFilter: <T>(arr: T[], fn: (t: T) => Promise<boolean>) => Promise<T[]>;
export declare const isErrnoException: (err: unknown) => err is NodeJS.ErrnoException;
export declare const errHasMsg: (err: unknown, msg: string) => boolean;
export declare const chunkArray: <T>(arr: T[], chunkSize: number) => T[][];
export declare const range: (num: number) => number[];
export declare const dedupeStrs: (strs: string[]) => string[];
export declare const parseIntWithFallback: <T>(value: string | undefined, fallback: T) => number | T;
//# sourceMappingURL=util.d.ts.map