/**
 * GENERATED CODE - DO NOT MODIFY
 */
import { Lexicons, type ValidationResult } from '@atproto/lexicon';
export declare const schemaDict: {
    readonly AppBskyActorDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.defs";
        readonly defs: {
            readonly profileViewBasic: {
                readonly type: "object";
                readonly required: ["did", "handle"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly displayName: {
                        readonly type: "string";
                        readonly maxGraphemes: 64;
                        readonly maxLength: 640;
                    };
                    readonly pronouns: {
                        readonly type: "string";
                    };
                    readonly avatar: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly associated: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileAssociated";
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#viewerState";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly verification: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#verificationState";
                    };
                    readonly status: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#statusView";
                    };
                    readonly debug: {
                        readonly type: "unknown";
                        readonly description: "Debug information for internal development";
                    };
                };
            };
            readonly profileView: {
                readonly type: "object";
                readonly required: ["did", "handle"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly displayName: {
                        readonly type: "string";
                        readonly maxGraphemes: 64;
                        readonly maxLength: 640;
                    };
                    readonly pronouns: {
                        readonly type: "string";
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly maxGraphemes: 256;
                        readonly maxLength: 2560;
                    };
                    readonly avatar: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly associated: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileAssociated";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#viewerState";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly verification: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#verificationState";
                    };
                    readonly status: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#statusView";
                    };
                    readonly debug: {
                        readonly type: "unknown";
                        readonly description: "Debug information for internal development";
                    };
                };
            };
            readonly profileViewDetailed: {
                readonly type: "object";
                readonly required: ["did", "handle"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly displayName: {
                        readonly type: "string";
                        readonly maxGraphemes: 64;
                        readonly maxLength: 640;
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly maxGraphemes: 256;
                        readonly maxLength: 2560;
                    };
                    readonly pronouns: {
                        readonly type: "string";
                    };
                    readonly website: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly avatar: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly banner: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly followersCount: {
                        readonly type: "integer";
                    };
                    readonly followsCount: {
                        readonly type: "integer";
                    };
                    readonly postsCount: {
                        readonly type: "integer";
                    };
                    readonly associated: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileAssociated";
                    };
                    readonly joinedViaStarterPack: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#starterPackViewBasic";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#viewerState";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly pinnedPost: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.repo.strongRef";
                    };
                    readonly verification: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#verificationState";
                    };
                    readonly status: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#statusView";
                    };
                    readonly debug: {
                        readonly type: "unknown";
                        readonly description: "Debug information for internal development";
                    };
                };
            };
            readonly profileAssociated: {
                readonly type: "object";
                readonly properties: {
                    readonly lists: {
                        readonly type: "integer";
                    };
                    readonly feedgens: {
                        readonly type: "integer";
                    };
                    readonly starterPacks: {
                        readonly type: "integer";
                    };
                    readonly labeler: {
                        readonly type: "boolean";
                    };
                    readonly chat: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileAssociatedChat";
                    };
                    readonly activitySubscription: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileAssociatedActivitySubscription";
                    };
                };
            };
            readonly profileAssociatedChat: {
                readonly type: "object";
                readonly required: ["allowIncoming"];
                readonly properties: {
                    readonly allowIncoming: {
                        readonly type: "string";
                        readonly knownValues: ["all", "none", "following"];
                    };
                };
            };
            readonly profileAssociatedActivitySubscription: {
                readonly type: "object";
                readonly required: ["allowSubscriptions"];
                readonly properties: {
                    readonly allowSubscriptions: {
                        readonly type: "string";
                        readonly knownValues: ["followers", "mutuals", "none"];
                    };
                };
            };
            readonly viewerState: {
                readonly type: "object";
                readonly description: "Metadata about the requesting account's relationship with the subject account. Only has meaningful content for authed requests.";
                readonly properties: {
                    readonly muted: {
                        readonly type: "boolean";
                    };
                    readonly mutedByList: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listViewBasic";
                    };
                    readonly blockedBy: {
                        readonly type: "boolean";
                    };
                    readonly blocking: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly blockingByList: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listViewBasic";
                    };
                    readonly following: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly followedBy: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly knownFollowers: {
                        readonly description: "This property is present only in selected cases, as an optimization.";
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#knownFollowers";
                    };
                    readonly activitySubscription: {
                        readonly description: "This property is present only in selected cases, as an optimization.";
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#activitySubscription";
                    };
                };
            };
            readonly knownFollowers: {
                readonly type: "object";
                readonly description: "The subject's followers whom you also follow";
                readonly required: ["count", "followers"];
                readonly properties: {
                    readonly count: {
                        readonly type: "integer";
                    };
                    readonly followers: {
                        readonly type: "array";
                        readonly minLength: 0;
                        readonly maxLength: 5;
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                        };
                    };
                };
            };
            readonly verificationState: {
                readonly type: "object";
                readonly description: "Represents the verification information about the user this object is attached to.";
                readonly required: ["verifications", "verifiedStatus", "trustedVerifierStatus"];
                readonly properties: {
                    readonly verifications: {
                        readonly type: "array";
                        readonly description: "All verifications issued by trusted verifiers on behalf of this user. Verifications by untrusted verifiers are not included.";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#verificationView";
                        };
                    };
                    readonly verifiedStatus: {
                        readonly type: "string";
                        readonly description: "The user's status as a verified account.";
                        readonly knownValues: ["valid", "invalid", "none"];
                    };
                    readonly trustedVerifierStatus: {
                        readonly type: "string";
                        readonly description: "The user's status as a trusted verifier.";
                        readonly knownValues: ["valid", "invalid", "none"];
                    };
                };
            };
            readonly verificationView: {
                readonly type: "object";
                readonly description: "An individual verification for an associated subject.";
                readonly required: ["issuer", "uri", "isValid", "createdAt"];
                readonly properties: {
                    readonly issuer: {
                        readonly type: "string";
                        readonly description: "The user who issued this verification.";
                        readonly format: "did";
                    };
                    readonly uri: {
                        readonly type: "string";
                        readonly description: "The AT-URI of the verification record.";
                        readonly format: "at-uri";
                    };
                    readonly isValid: {
                        readonly type: "boolean";
                        readonly description: "True if the verification passes validation, otherwise false.";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly description: "Timestamp when the verification was created.";
                        readonly format: "datetime";
                    };
                };
            };
            readonly preferences: {
                readonly type: "array";
                readonly items: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.actor.defs#adultContentPref", "lex:app.bsky.actor.defs#contentLabelPref", "lex:app.bsky.actor.defs#savedFeedsPref", "lex:app.bsky.actor.defs#savedFeedsPrefV2", "lex:app.bsky.actor.defs#personalDetailsPref", "lex:app.bsky.actor.defs#declaredAgePref", "lex:app.bsky.actor.defs#feedViewPref", "lex:app.bsky.actor.defs#threadViewPref", "lex:app.bsky.actor.defs#interestsPref", "lex:app.bsky.actor.defs#mutedWordsPref", "lex:app.bsky.actor.defs#hiddenPostsPref", "lex:app.bsky.actor.defs#bskyAppStatePref", "lex:app.bsky.actor.defs#labelersPref", "lex:app.bsky.actor.defs#postInteractionSettingsPref", "lex:app.bsky.actor.defs#verificationPrefs"];
                };
            };
            readonly adultContentPref: {
                readonly type: "object";
                readonly required: ["enabled"];
                readonly properties: {
                    readonly enabled: {
                        readonly type: "boolean";
                        readonly default: false;
                    };
                };
            };
            readonly contentLabelPref: {
                readonly type: "object";
                readonly required: ["label", "visibility"];
                readonly properties: {
                    readonly labelerDid: {
                        readonly type: "string";
                        readonly description: "Which labeler does this preference apply to? If undefined, applies globally.";
                        readonly format: "did";
                    };
                    readonly label: {
                        readonly type: "string";
                    };
                    readonly visibility: {
                        readonly type: "string";
                        readonly knownValues: ["ignore", "show", "warn", "hide"];
                    };
                };
            };
            readonly savedFeed: {
                readonly type: "object";
                readonly required: ["id", "type", "value", "pinned"];
                readonly properties: {
                    readonly id: {
                        readonly type: "string";
                    };
                    readonly type: {
                        readonly type: "string";
                        readonly knownValues: ["feed", "list", "timeline"];
                    };
                    readonly value: {
                        readonly type: "string";
                    };
                    readonly pinned: {
                        readonly type: "boolean";
                    };
                };
            };
            readonly savedFeedsPrefV2: {
                readonly type: "object";
                readonly required: ["items"];
                readonly properties: {
                    readonly items: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#savedFeed";
                        };
                    };
                };
            };
            readonly savedFeedsPref: {
                readonly type: "object";
                readonly required: ["pinned", "saved"];
                readonly properties: {
                    readonly pinned: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                    };
                    readonly saved: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                    };
                    readonly timelineIndex: {
                        readonly type: "integer";
                    };
                };
            };
            readonly personalDetailsPref: {
                readonly type: "object";
                readonly properties: {
                    readonly birthDate: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The birth date of account owner.";
                    };
                };
            };
            readonly declaredAgePref: {
                readonly type: "object";
                readonly description: "Read-only preference containing value(s) inferred from the user's declared birthdate. Absence of this preference object in the response indicates that the user has not made a declaration.";
                readonly properties: {
                    readonly isOverAge13: {
                        readonly type: "boolean";
                        readonly description: "Indicates if the user has declared that they are over 13 years of age.";
                    };
                    readonly isOverAge16: {
                        readonly type: "boolean";
                        readonly description: "Indicates if the user has declared that they are over 16 years of age.";
                    };
                    readonly isOverAge18: {
                        readonly type: "boolean";
                        readonly description: "Indicates if the user has declared that they are over 18 years of age.";
                    };
                };
            };
            readonly feedViewPref: {
                readonly type: "object";
                readonly required: ["feed"];
                readonly properties: {
                    readonly feed: {
                        readonly type: "string";
                        readonly description: "The URI of the feed, or an identifier which describes the feed.";
                    };
                    readonly hideReplies: {
                        readonly type: "boolean";
                        readonly description: "Hide replies in the feed.";
                    };
                    readonly hideRepliesByUnfollowed: {
                        readonly type: "boolean";
                        readonly description: "Hide replies in the feed if they are not by followed users.";
                        readonly default: true;
                    };
                    readonly hideRepliesByLikeCount: {
                        readonly type: "integer";
                        readonly description: "Hide replies in the feed if they do not have this number of likes.";
                    };
                    readonly hideReposts: {
                        readonly type: "boolean";
                        readonly description: "Hide reposts in the feed.";
                    };
                    readonly hideQuotePosts: {
                        readonly type: "boolean";
                        readonly description: "Hide quote posts in the feed.";
                    };
                };
            };
            readonly threadViewPref: {
                readonly type: "object";
                readonly properties: {
                    readonly sort: {
                        readonly type: "string";
                        readonly description: "Sorting mode for threads.";
                        readonly knownValues: ["oldest", "newest", "most-likes", "random", "hotness"];
                    };
                };
            };
            readonly interestsPref: {
                readonly type: "object";
                readonly required: ["tags"];
                readonly properties: {
                    readonly tags: {
                        readonly type: "array";
                        readonly maxLength: 100;
                        readonly items: {
                            readonly type: "string";
                            readonly maxLength: 640;
                            readonly maxGraphemes: 64;
                        };
                        readonly description: "A list of tags which describe the account owner's interests gathered during onboarding.";
                    };
                };
            };
            readonly mutedWordTarget: {
                readonly type: "string";
                readonly knownValues: ["content", "tag"];
                readonly maxLength: 640;
                readonly maxGraphemes: 64;
            };
            readonly mutedWord: {
                readonly type: "object";
                readonly description: "A word that the account owner has muted.";
                readonly required: ["value", "targets"];
                readonly properties: {
                    readonly id: {
                        readonly type: "string";
                    };
                    readonly value: {
                        readonly type: "string";
                        readonly description: "The muted word itself.";
                        readonly maxLength: 10000;
                        readonly maxGraphemes: 1000;
                    };
                    readonly targets: {
                        readonly type: "array";
                        readonly description: "The intended targets of the muted word.";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#mutedWordTarget";
                        };
                    };
                    readonly actorTarget: {
                        readonly type: "string";
                        readonly description: "Groups of users to apply the muted word to. If undefined, applies to all users.";
                        readonly knownValues: ["all", "exclude-following"];
                        readonly default: "all";
                    };
                    readonly expiresAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The date and time at which the muted word will expire and no longer be applied.";
                    };
                };
            };
            readonly mutedWordsPref: {
                readonly type: "object";
                readonly required: ["items"];
                readonly properties: {
                    readonly items: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#mutedWord";
                        };
                        readonly description: "A list of words the account owner has muted.";
                    };
                };
            };
            readonly hiddenPostsPref: {
                readonly type: "object";
                readonly required: ["items"];
                readonly properties: {
                    readonly items: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                        readonly description: "A list of URIs of posts the account owner has hidden.";
                    };
                };
            };
            readonly labelersPref: {
                readonly type: "object";
                readonly required: ["labelers"];
                readonly properties: {
                    readonly labelers: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#labelerPrefItem";
                        };
                    };
                };
            };
            readonly labelerPrefItem: {
                readonly type: "object";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
            readonly bskyAppStatePref: {
                readonly description: "A grab bag of state that's specific to the bsky.app program. Third-party apps shouldn't use this.";
                readonly type: "object";
                readonly properties: {
                    readonly activeProgressGuide: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#bskyAppProgressGuide";
                    };
                    readonly queuedNudges: {
                        readonly description: "An array of tokens which identify nudges (modals, popups, tours, highlight dots) that should be shown to the user.";
                        readonly type: "array";
                        readonly maxLength: 1000;
                        readonly items: {
                            readonly type: "string";
                            readonly maxLength: 100;
                        };
                    };
                    readonly nuxs: {
                        readonly description: "Storage for NUXs the user has encountered.";
                        readonly type: "array";
                        readonly maxLength: 100;
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#nux";
                        };
                    };
                };
            };
            readonly bskyAppProgressGuide: {
                readonly description: "If set, an active progress guide. Once completed, can be set to undefined. Should have unspecced fields tracking progress.";
                readonly type: "object";
                readonly required: ["guide"];
                readonly properties: {
                    readonly guide: {
                        readonly type: "string";
                        readonly maxLength: 100;
                    };
                };
            };
            readonly nux: {
                readonly type: "object";
                readonly description: "A new user experiences (NUX) storage object";
                readonly required: ["id", "completed"];
                readonly properties: {
                    readonly id: {
                        readonly type: "string";
                        readonly maxLength: 100;
                    };
                    readonly completed: {
                        readonly type: "boolean";
                        readonly default: false;
                    };
                    readonly data: {
                        readonly description: "Arbitrary data for the NUX. The structure is defined by the NUX itself. Limited to 300 characters.";
                        readonly type: "string";
                        readonly maxLength: 3000;
                        readonly maxGraphemes: 300;
                    };
                    readonly expiresAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The date and time at which the NUX will expire and should be considered completed.";
                    };
                };
            };
            readonly verificationPrefs: {
                readonly type: "object";
                readonly description: "Preferences for how verified accounts appear in the app.";
                readonly required: [];
                readonly properties: {
                    readonly hideBadges: {
                        readonly description: "Hide the blue check badges for verified accounts and trusted verifiers.";
                        readonly type: "boolean";
                        readonly default: false;
                    };
                };
            };
            readonly postInteractionSettingsPref: {
                readonly type: "object";
                readonly description: "Default post interaction settings for the account. These values should be applied as default values when creating new posts. These refs should mirror the threadgate and postgate records exactly.";
                readonly required: [];
                readonly properties: {
                    readonly threadgateAllowRules: {
                        readonly description: "Matches threadgate record. List of rules defining who can reply to this users posts. If value is an empty array, no one can reply. If value is undefined, anyone can reply.";
                        readonly type: "array";
                        readonly maxLength: 5;
                        readonly items: {
                            readonly type: "union";
                            readonly refs: ["lex:app.bsky.feed.threadgate#mentionRule", "lex:app.bsky.feed.threadgate#followerRule", "lex:app.bsky.feed.threadgate#followingRule", "lex:app.bsky.feed.threadgate#listRule"];
                        };
                    };
                    readonly postgateEmbeddingRules: {
                        readonly description: "Matches postgate record. List of rules defining who can embed this users posts. If value is an empty array or is undefined, no particular rules apply and anyone can embed.";
                        readonly type: "array";
                        readonly maxLength: 5;
                        readonly items: {
                            readonly type: "union";
                            readonly refs: ["lex:app.bsky.feed.postgate#disableRule"];
                        };
                    };
                };
            };
            readonly statusView: {
                readonly type: "object";
                readonly required: ["status", "record"];
                readonly properties: {
                    readonly status: {
                        readonly type: "string";
                        readonly description: "The status for the account.";
                        readonly knownValues: ["app.bsky.actor.status#live"];
                    };
                    readonly record: {
                        readonly type: "unknown";
                    };
                    readonly embed: {
                        readonly type: "union";
                        readonly description: "An optional embed associated with the status.";
                        readonly refs: ["lex:app.bsky.embed.external#view"];
                    };
                    readonly expiresAt: {
                        readonly type: "string";
                        readonly description: "The date when this status will expire. The application might choose to no longer return the status after expiration.";
                        readonly format: "datetime";
                    };
                    readonly isActive: {
                        readonly type: "boolean";
                        readonly description: "True if the status is not expired, false if it is expired. Only present if expiration was set.";
                    };
                };
            };
        };
    };
    readonly AppBskyActorGetPreferences: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.getPreferences";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get private preferences attached to the current account. Expected use is synchronization between multiple devices, and import/export during account migration. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {};
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["preferences"];
                        readonly properties: {
                            readonly preferences: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#preferences";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyActorGetProfile: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.getProfile";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get detailed profile view of an actor. Does not require auth, but contains relevant metadata with auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "Handle or DID of account to fetch profile of.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewDetailed";
                    };
                };
            };
        };
    };
    readonly AppBskyActorGetProfiles: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.getProfiles";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get detailed profile views of multiple actors.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actors"];
                    readonly properties: {
                        readonly actors: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                            };
                            readonly maxLength: 25;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["profiles"];
                        readonly properties: {
                            readonly profiles: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileViewDetailed";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyActorGetSuggestions: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.getSuggestions";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of suggested actors. Expected use is discovery of accounts to follow during new account onboarding.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actors"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly actors: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                            readonly recId: {
                                readonly type: "integer";
                                readonly description: "Snowflake for this recommendation, use when submitting recommendation events.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyActorProfile: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.profile";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "A declaration of a Bluesky account profile.";
                readonly key: "literal:self";
                readonly record: {
                    readonly type: "object";
                    readonly properties: {
                        readonly displayName: {
                            readonly type: "string";
                            readonly maxGraphemes: 64;
                            readonly maxLength: 640;
                        };
                        readonly description: {
                            readonly type: "string";
                            readonly description: "Free-form profile description text.";
                            readonly maxGraphemes: 256;
                            readonly maxLength: 2560;
                        };
                        readonly pronouns: {
                            readonly type: "string";
                            readonly description: "Free-form pronouns text.";
                            readonly maxGraphemes: 20;
                            readonly maxLength: 200;
                        };
                        readonly website: {
                            readonly type: "string";
                            readonly format: "uri";
                        };
                        readonly avatar: {
                            readonly type: "blob";
                            readonly description: "Small image to be displayed next to posts from account. AKA, 'profile picture'";
                            readonly accept: ["image/png", "image/jpeg"];
                            readonly maxSize: 1000000;
                        };
                        readonly banner: {
                            readonly type: "blob";
                            readonly description: "Larger horizontal image to display behind profile view.";
                            readonly accept: ["image/png", "image/jpeg"];
                            readonly maxSize: 1000000;
                        };
                        readonly labels: {
                            readonly type: "union";
                            readonly description: "Self-label values, specific to the Bluesky application, on the overall account.";
                            readonly refs: ["lex:com.atproto.label.defs#selfLabels"];
                        };
                        readonly joinedViaStarterPack: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.repo.strongRef";
                        };
                        readonly pinnedPost: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.repo.strongRef";
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyActorPutPreferences: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.putPreferences";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Set the private preferences attached to the account.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["preferences"];
                        readonly properties: {
                            readonly preferences: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#preferences";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyActorSearchActors: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.searchActors";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Find actors (profiles) matching search criteria. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly term: {
                            readonly type: "string";
                            readonly description: "DEPRECATED: use 'q' instead.";
                        };
                        readonly q: {
                            readonly type: "string";
                            readonly description: "Search query string. Syntax, phrase, boolean, and faceting is unspecified, but Lucene query syntax is recommended.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 25;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actors"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly actors: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyActorSearchActorsTypeahead: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.searchActorsTypeahead";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Find actor suggestions for a prefix search term. Expected use is for auto-completion during text field entry. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly term: {
                            readonly type: "string";
                            readonly description: "DEPRECATED: use 'q' instead.";
                        };
                        readonly q: {
                            readonly type: "string";
                            readonly description: "Search query prefix; not a full query string.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actors"];
                        readonly properties: {
                            readonly actors: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyActorStatus: {
        readonly lexicon: 1;
        readonly id: "app.bsky.actor.status";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "A declaration of a Bluesky account status.";
                readonly key: "literal:self";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["status", "createdAt"];
                    readonly properties: {
                        readonly status: {
                            readonly type: "string";
                            readonly description: "The status for the account.";
                            readonly knownValues: ["app.bsky.actor.status#live"];
                        };
                        readonly embed: {
                            readonly type: "union";
                            readonly description: "An optional embed associated with the status.";
                            readonly refs: ["lex:app.bsky.embed.external"];
                        };
                        readonly durationMinutes: {
                            readonly type: "integer";
                            readonly description: "The duration of the status in minutes. Applications can choose to impose minimum and maximum limits.";
                            readonly minimum: 1;
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
            readonly live: {
                readonly type: "token";
                readonly description: "Advertises an account as currently offering live content.";
            };
        };
    };
    readonly AppBskyAgeassuranceBegin: {
        readonly lexicon: 1;
        readonly id: "app.bsky.ageassurance.begin";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Initiate Age Assurance for an account.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["email", "language", "countryCode"];
                        readonly properties: {
                            readonly email: {
                                readonly type: "string";
                                readonly description: "The user's email address to receive Age Assurance instructions.";
                            };
                            readonly language: {
                                readonly type: "string";
                                readonly description: "The user's preferred language for communication during the Age Assurance process.";
                            };
                            readonly countryCode: {
                                readonly type: "string";
                                readonly description: "An ISO 3166-1 alpha-2 code of the user's location.";
                            };
                            readonly regionCode: {
                                readonly type: "string";
                                readonly description: "An optional ISO 3166-2 code of the user's region or state within the country.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#state";
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidEmail";
                }, {
                    readonly name: "DidTooLong";
                }, {
                    readonly name: "InvalidInitiation";
                }, {
                    readonly name: "RegionNotSupported";
                }];
            };
        };
    };
    readonly AppBskyAgeassuranceDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.ageassurance.defs";
        readonly defs: {
            readonly access: {
                readonly description: "The access level granted based on Age Assurance data we've processed.";
                readonly type: "string";
                readonly knownValues: ["unknown", "none", "safe", "full"];
            };
            readonly status: {
                readonly type: "string";
                readonly description: "The status of the Age Assurance process.";
                readonly knownValues: ["unknown", "pending", "assured", "blocked"];
            };
            readonly state: {
                readonly type: "object";
                readonly description: "The user's computed Age Assurance state.";
                readonly required: ["status", "access"];
                readonly properties: {
                    readonly lastInitiatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The timestamp when this state was last updated.";
                    };
                    readonly status: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#status";
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                };
            };
            readonly stateMetadata: {
                readonly type: "object";
                readonly description: "Additional metadata needed to compute Age Assurance state client-side.";
                readonly required: [];
                readonly properties: {
                    readonly accountCreatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The account creation timestamp.";
                    };
                };
            };
            readonly config: {
                readonly type: "object";
                readonly description: "";
                readonly required: ["regions"];
                readonly properties: {
                    readonly regions: {
                        readonly type: "array";
                        readonly description: "The per-region Age Assurance configuration.";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.ageassurance.defs#configRegion";
                        };
                    };
                };
            };
            readonly configRegion: {
                readonly type: "object";
                readonly description: "The Age Assurance configuration for a specific region.";
                readonly required: ["countryCode", "rules"];
                readonly properties: {
                    readonly countryCode: {
                        readonly type: "string";
                        readonly description: "The ISO 3166-1 alpha-2 country code this configuration applies to.";
                    };
                    readonly regionCode: {
                        readonly type: "string";
                        readonly description: "The ISO 3166-2 region code this configuration applies to. If omitted, the configuration applies to the entire country.";
                    };
                    readonly rules: {
                        readonly type: "array";
                        readonly description: "The ordered list of Age Assurance rules that apply to this region. Rules should be applied in order, and the first matching rule determines the access level granted. The rules array should always include a default rule as the last item.";
                        readonly items: {
                            readonly type: "union";
                            readonly refs: ["lex:app.bsky.ageassurance.defs#configRegionRuleDefault", "lex:app.bsky.ageassurance.defs#configRegionRuleIfDeclaredOverAge", "lex:app.bsky.ageassurance.defs#configRegionRuleIfDeclaredUnderAge", "lex:app.bsky.ageassurance.defs#configRegionRuleIfAssuredOverAge", "lex:app.bsky.ageassurance.defs#configRegionRuleIfAssuredUnderAge", "lex:app.bsky.ageassurance.defs#configRegionRuleIfAccountNewerThan", "lex:app.bsky.ageassurance.defs#configRegionRuleIfAccountOlderThan"];
                        };
                    };
                };
            };
            readonly configRegionRuleDefault: {
                readonly type: "object";
                readonly description: "Age Assurance rule that applies by default.";
                readonly required: ["access"];
                readonly properties: {
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                };
            };
            readonly configRegionRuleIfDeclaredOverAge: {
                readonly type: "object";
                readonly description: "Age Assurance rule that applies if the user has declared themselves equal-to or over a certain age.";
                readonly required: ["age", "access"];
                readonly properties: {
                    readonly age: {
                        readonly type: "integer";
                        readonly description: "The age threshold as a whole integer.";
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                };
            };
            readonly configRegionRuleIfDeclaredUnderAge: {
                readonly type: "object";
                readonly description: "Age Assurance rule that applies if the user has declared themselves under a certain age.";
                readonly required: ["age", "access"];
                readonly properties: {
                    readonly age: {
                        readonly type: "integer";
                        readonly description: "The age threshold as a whole integer.";
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                };
            };
            readonly configRegionRuleIfAssuredOverAge: {
                readonly type: "object";
                readonly description: "Age Assurance rule that applies if the user has been assured to be equal-to or over a certain age.";
                readonly required: ["age", "access"];
                readonly properties: {
                    readonly age: {
                        readonly type: "integer";
                        readonly description: "The age threshold as a whole integer.";
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                };
            };
            readonly configRegionRuleIfAssuredUnderAge: {
                readonly type: "object";
                readonly description: "Age Assurance rule that applies if the user has been assured to be under a certain age.";
                readonly required: ["age", "access"];
                readonly properties: {
                    readonly age: {
                        readonly type: "integer";
                        readonly description: "The age threshold as a whole integer.";
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                };
            };
            readonly configRegionRuleIfAccountNewerThan: {
                readonly type: "object";
                readonly description: "Age Assurance rule that applies if the account is equal-to or newer than a certain date.";
                readonly required: ["date", "access"];
                readonly properties: {
                    readonly date: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The date threshold as a datetime string.";
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                };
            };
            readonly configRegionRuleIfAccountOlderThan: {
                readonly type: "object";
                readonly description: "Age Assurance rule that applies if the account is older than a certain date.";
                readonly required: ["date", "access"];
                readonly properties: {
                    readonly date: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The date threshold as a datetime string.";
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                };
            };
            readonly event: {
                readonly type: "object";
                readonly description: "Object used to store Age Assurance data in stash.";
                readonly required: ["createdAt", "status", "access", "attemptId", "countryCode"];
                readonly properties: {
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The date and time of this write operation.";
                    };
                    readonly attemptId: {
                        readonly type: "string";
                        readonly description: "The unique identifier for this instance of the Age Assurance flow, in UUID format.";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly description: "The status of the Age Assurance process.";
                        readonly knownValues: ["unknown", "pending", "assured", "blocked"];
                    };
                    readonly access: {
                        readonly description: "The access level granted based on Age Assurance data we've processed.";
                        readonly type: "string";
                        readonly knownValues: ["unknown", "none", "safe", "full"];
                    };
                    readonly countryCode: {
                        readonly type: "string";
                        readonly description: "The ISO 3166-1 alpha-2 country code provided when beginning the Age Assurance flow.";
                    };
                    readonly regionCode: {
                        readonly type: "string";
                        readonly description: "The ISO 3166-2 region code provided when beginning the Age Assurance flow.";
                    };
                    readonly email: {
                        readonly type: "string";
                        readonly description: "The email used for Age Assurance.";
                    };
                    readonly initIp: {
                        readonly type: "string";
                        readonly description: "The IP address used when initiating the Age Assurance flow.";
                    };
                    readonly initUa: {
                        readonly type: "string";
                        readonly description: "The user agent used when initiating the Age Assurance flow.";
                    };
                    readonly completeIp: {
                        readonly type: "string";
                        readonly description: "The IP address used when completing the Age Assurance flow.";
                    };
                    readonly completeUa: {
                        readonly type: "string";
                        readonly description: "The user agent used when completing the Age Assurance flow.";
                    };
                };
            };
        };
    };
    readonly AppBskyAgeassuranceGetConfig: {
        readonly lexicon: 1;
        readonly id: "app.bsky.ageassurance.getConfig";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Returns Age Assurance configuration for use on the client.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#config";
                    };
                };
            };
        };
    };
    readonly AppBskyAgeassuranceGetState: {
        readonly lexicon: 1;
        readonly id: "app.bsky.ageassurance.getState";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Returns server-computed Age Assurance state, if available, and any additional metadata needed to compute Age Assurance state client-side.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["countryCode"];
                    readonly properties: {
                        readonly countryCode: {
                            readonly type: "string";
                        };
                        readonly regionCode: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["state", "metadata"];
                        readonly properties: {
                            readonly state: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.ageassurance.defs#state";
                            };
                            readonly metadata: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.ageassurance.defs#stateMetadata";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyBookmarkCreateBookmark: {
        readonly lexicon: 1;
        readonly id: "app.bsky.bookmark.createBookmark";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Creates a private bookmark for the specified record. Currently, only `app.bsky.feed.post` records are supported. Requires authentication.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uri", "cid"];
                        readonly properties: {
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "UnsupportedCollection";
                    readonly description: "The URI to be bookmarked is for an unsupported collection.";
                }];
            };
        };
    };
    readonly AppBskyBookmarkDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.bookmark.defs";
        readonly defs: {
            readonly bookmark: {
                readonly description: "Object used to store bookmark data in stash.";
                readonly type: "object";
                readonly required: ["subject"];
                readonly properties: {
                    readonly subject: {
                        readonly description: "A strong ref to the record to be bookmarked. Currently, only `app.bsky.feed.post` records are supported.";
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.repo.strongRef";
                    };
                };
            };
            readonly bookmarkView: {
                readonly type: "object";
                readonly required: ["subject", "item"];
                readonly properties: {
                    readonly subject: {
                        readonly description: "A strong ref to the bookmarked record.";
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.repo.strongRef";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly item: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.defs#blockedPost", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#postView"];
                    };
                };
            };
        };
    };
    readonly AppBskyBookmarkDeleteBookmark: {
        readonly lexicon: 1;
        readonly id: "app.bsky.bookmark.deleteBookmark";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Deletes a private bookmark for the specified record. Currently, only `app.bsky.feed.post` records are supported. Requires authentication.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uri"];
                        readonly properties: {
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "UnsupportedCollection";
                    readonly description: "The URI to be bookmarked is for an unsupported collection.";
                }];
            };
        };
    };
    readonly AppBskyBookmarkGetBookmarks: {
        readonly lexicon: 1;
        readonly id: "app.bsky.bookmark.getBookmarks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Gets views of records bookmarked by the authenticated user. Requires authentication.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["bookmarks"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly bookmarks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.bookmark.defs#bookmarkView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyContactDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.defs";
        readonly defs: {
            readonly matchAndContactIndex: {
                readonly description: "Associates a profile with the positional index of the contact import input in the call to `app.bsky.contact.importContacts`, so clients can know which phone caused a particular match.";
                readonly type: "object";
                readonly required: ["match", "contactIndex"];
                readonly properties: {
                    readonly match: {
                        readonly description: "Profile of the matched user.";
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileView";
                    };
                    readonly contactIndex: {
                        readonly description: "The index of this match in the import contact input.";
                        readonly type: "integer";
                        readonly minimum: 0;
                        readonly maximum: 999;
                    };
                };
            };
            readonly syncStatus: {
                readonly type: "object";
                readonly required: ["syncedAt", "matchesCount"];
                readonly properties: {
                    readonly syncedAt: {
                        readonly description: "Last date when contacts where imported.";
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly matchesCount: {
                        readonly description: "Number of existing contact matches resulting of the user imports and of their imported contacts having imported the user. Matches stop being counted when the user either follows the matched contact or dismisses the match.";
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                };
            };
            readonly notification: {
                readonly description: "A stash object to be sent via bsync representing a notification to be created.";
                readonly type: "object";
                readonly required: ["from", "to"];
                readonly properties: {
                    readonly from: {
                        readonly description: "The DID of who this notification comes from.";
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly to: {
                        readonly description: "The DID of who this notification should go to.";
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
        };
    };
    readonly AppBskyContactDismissMatch: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.dismissMatch";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Removes a match that was found via contact import. It shouldn't appear again if the same contact is re-imported. Requires authentication.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject"];
                        readonly properties: {
                            readonly subject: {
                                readonly description: "The subject's DID to dismiss the match with.";
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidDid";
                }, {
                    readonly name: "InternalError";
                }];
            };
        };
    };
    readonly AppBskyContactGetMatches: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.getMatches";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Returns the matched contacts (contacts that were mutually imported). Excludes dismissed matches. Requires authentication.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["matches"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly matches: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidDid";
                }, {
                    readonly name: "InvalidLimit";
                }, {
                    readonly name: "InvalidCursor";
                }, {
                    readonly name: "InternalError";
                }];
            };
        };
    };
    readonly AppBskyContactGetSyncStatus: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.getSyncStatus";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Gets the user's current contact import status. Requires authentication.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {};
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly syncStatus: {
                                readonly description: "If present, indicates the user has imported their contacts. If not present, indicates the user never used the feature or called `app.bsky.contact.removeData` and didn't import again since.";
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.contact.defs#syncStatus";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidDid";
                }, {
                    readonly name: "InternalError";
                }];
            };
        };
    };
    readonly AppBskyContactImportContacts: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.importContacts";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Import contacts for securely matching with other users. This follows the protocol explained in https://docs.bsky.app/blog/contact-import-rfc. Requires authentication.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["token", "contacts"];
                        readonly properties: {
                            readonly token: {
                                readonly description: "JWT to authenticate the call. Use the JWT received as a response to the call to `app.bsky.contact.verifyPhone`.";
                                readonly type: "string";
                            };
                            readonly contacts: {
                                readonly description: "List of phone numbers in global E.164 format (e.g., '+12125550123'). Phone numbers that cannot be normalized into a valid phone number will be discarded. Should not repeat the 'phone' input used in `app.bsky.contact.verifyPhone`.";
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                                readonly minLength: 1;
                                readonly maxLength: 1000;
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["matchesAndContactIndexes"];
                        readonly properties: {
                            readonly matchesAndContactIndexes: {
                                readonly description: "The users that matched during import and their indexes on the input contacts, so the client can correlate with its local list.";
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.contact.defs#matchAndContactIndex";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidDid";
                }, {
                    readonly name: "InvalidContacts";
                }, {
                    readonly name: "TooManyContacts";
                }, {
                    readonly name: "InvalidToken";
                }, {
                    readonly name: "InternalError";
                }];
            };
        };
    };
    readonly AppBskyContactRemoveData: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.removeData";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Removes all stored hashes used for contact matching, existing matches, and sync status. Requires authentication.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidDid";
                }, {
                    readonly name: "InternalError";
                }];
            };
        };
    };
    readonly AppBskyContactSendNotification: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.sendNotification";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "System endpoint to send notifications related to contact imports. Requires role authentication.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["from", "to"];
                        readonly properties: {
                            readonly from: {
                                readonly description: "The DID of who this notification comes from.";
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly to: {
                                readonly description: "The DID of who this notification should go to.";
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
            };
        };
    };
    readonly AppBskyContactStartPhoneVerification: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.startPhoneVerification";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Starts a phone verification flow. The phone passed will receive a code via SMS that should be passed to `app.bsky.contact.verifyPhone`. Requires authentication.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["phone"];
                        readonly properties: {
                            readonly phone: {
                                readonly description: "The phone number to receive the code via SMS.";
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
                readonly errors: [{
                    readonly name: "RateLimitExceeded";
                }, {
                    readonly name: "InvalidDid";
                }, {
                    readonly name: "InvalidPhone";
                }, {
                    readonly name: "InternalError";
                }];
            };
        };
    };
    readonly AppBskyContactVerifyPhone: {
        readonly lexicon: 1;
        readonly id: "app.bsky.contact.verifyPhone";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Verifies control over a phone number with a code received via SMS and starts a contact import session. Requires authentication.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["phone", "code"];
                        readonly properties: {
                            readonly phone: {
                                readonly description: "The phone number to verify. Should be the same as the one passed to `app.bsky.contact.startPhoneVerification`.";
                                readonly type: "string";
                            };
                            readonly code: {
                                readonly description: "The code received via SMS as a result of the call to `app.bsky.contact.startPhoneVerification`.";
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["token"];
                        readonly properties: {
                            readonly token: {
                                readonly description: "JWT to be used in a call to `app.bsky.contact.importContacts`. It is only valid for a single call.";
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "RateLimitExceeded";
                }, {
                    readonly name: "InvalidDid";
                }, {
                    readonly name: "InvalidPhone";
                }, {
                    readonly name: "InvalidCode";
                }, {
                    readonly name: "InternalError";
                }];
            };
        };
    };
    readonly AppBskyEmbedDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.embed.defs";
        readonly defs: {
            readonly aspectRatio: {
                readonly type: "object";
                readonly description: "width:height represents an aspect ratio. It may be approximate, and may not correspond to absolute dimensions in any given unit.";
                readonly required: ["width", "height"];
                readonly properties: {
                    readonly width: {
                        readonly type: "integer";
                        readonly minimum: 1;
                    };
                    readonly height: {
                        readonly type: "integer";
                        readonly minimum: 1;
                    };
                };
            };
        };
    };
    readonly AppBskyEmbedExternal: {
        readonly lexicon: 1;
        readonly id: "app.bsky.embed.external";
        readonly defs: {
            readonly main: {
                readonly type: "object";
                readonly description: "A representation of some externally linked content (eg, a URL and 'card'), embedded in a Bluesky record (eg, a post).";
                readonly required: ["external"];
                readonly properties: {
                    readonly external: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.external#external";
                    };
                };
            };
            readonly external: {
                readonly type: "object";
                readonly required: ["uri", "title", "description"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly title: {
                        readonly type: "string";
                    };
                    readonly description: {
                        readonly type: "string";
                    };
                    readonly thumb: {
                        readonly type: "blob";
                        readonly accept: ["image/*"];
                        readonly maxSize: 1000000;
                    };
                };
            };
            readonly view: {
                readonly type: "object";
                readonly required: ["external"];
                readonly properties: {
                    readonly external: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.external#viewExternal";
                    };
                };
            };
            readonly viewExternal: {
                readonly type: "object";
                readonly required: ["uri", "title", "description"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly title: {
                        readonly type: "string";
                    };
                    readonly description: {
                        readonly type: "string";
                    };
                    readonly thumb: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                };
            };
        };
    };
    readonly AppBskyEmbedImages: {
        readonly lexicon: 1;
        readonly id: "app.bsky.embed.images";
        readonly description: "A set of images embedded in a Bluesky record (eg, a post).";
        readonly defs: {
            readonly main: {
                readonly type: "object";
                readonly required: ["images"];
                readonly properties: {
                    readonly images: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.embed.images#image";
                        };
                        readonly maxLength: 4;
                    };
                };
            };
            readonly image: {
                readonly type: "object";
                readonly required: ["image", "alt"];
                readonly properties: {
                    readonly image: {
                        readonly type: "blob";
                        readonly accept: ["image/*"];
                        readonly maxSize: 1000000;
                    };
                    readonly alt: {
                        readonly type: "string";
                        readonly description: "Alt text description of the image, for accessibility.";
                    };
                    readonly aspectRatio: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.defs#aspectRatio";
                    };
                };
            };
            readonly view: {
                readonly type: "object";
                readonly required: ["images"];
                readonly properties: {
                    readonly images: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.embed.images#viewImage";
                        };
                        readonly maxLength: 4;
                    };
                };
            };
            readonly viewImage: {
                readonly type: "object";
                readonly required: ["thumb", "fullsize", "alt"];
                readonly properties: {
                    readonly thumb: {
                        readonly type: "string";
                        readonly format: "uri";
                        readonly description: "Fully-qualified URL where a thumbnail of the image can be fetched. For example, CDN location provided by the App View.";
                    };
                    readonly fullsize: {
                        readonly type: "string";
                        readonly format: "uri";
                        readonly description: "Fully-qualified URL where a large version of the image can be fetched. May or may not be the exact original blob. For example, CDN location provided by the App View.";
                    };
                    readonly alt: {
                        readonly type: "string";
                        readonly description: "Alt text description of the image, for accessibility.";
                    };
                    readonly aspectRatio: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.defs#aspectRatio";
                    };
                };
            };
        };
    };
    readonly AppBskyEmbedRecord: {
        readonly lexicon: 1;
        readonly id: "app.bsky.embed.record";
        readonly description: "A representation of a record embedded in a Bluesky record (eg, a post). For example, a quote-post, or sharing a feed generator record.";
        readonly defs: {
            readonly main: {
                readonly type: "object";
                readonly required: ["record"];
                readonly properties: {
                    readonly record: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.repo.strongRef";
                    };
                };
            };
            readonly view: {
                readonly type: "object";
                readonly required: ["record"];
                readonly properties: {
                    readonly record: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.embed.record#viewRecord", "lex:app.bsky.embed.record#viewNotFound", "lex:app.bsky.embed.record#viewBlocked", "lex:app.bsky.embed.record#viewDetached", "lex:app.bsky.feed.defs#generatorView", "lex:app.bsky.graph.defs#listView", "lex:app.bsky.labeler.defs#labelerView", "lex:app.bsky.graph.defs#starterPackViewBasic"];
                    };
                };
            };
            readonly viewRecord: {
                readonly type: "object";
                readonly required: ["uri", "cid", "author", "value", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly author: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                    };
                    readonly value: {
                        readonly type: "unknown";
                        readonly description: "The record data itself.";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly replyCount: {
                        readonly type: "integer";
                    };
                    readonly repostCount: {
                        readonly type: "integer";
                    };
                    readonly likeCount: {
                        readonly type: "integer";
                    };
                    readonly quoteCount: {
                        readonly type: "integer";
                    };
                    readonly embeds: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "union";
                            readonly refs: ["lex:app.bsky.embed.images#view", "lex:app.bsky.embed.video#view", "lex:app.bsky.embed.external#view", "lex:app.bsky.embed.record#view", "lex:app.bsky.embed.recordWithMedia#view"];
                        };
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly viewNotFound: {
                readonly type: "object";
                readonly required: ["uri", "notFound"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly notFound: {
                        readonly type: "boolean";
                        readonly const: true;
                    };
                };
            };
            readonly viewBlocked: {
                readonly type: "object";
                readonly required: ["uri", "blocked", "author"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly blocked: {
                        readonly type: "boolean";
                        readonly const: true;
                    };
                    readonly author: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#blockedAuthor";
                    };
                };
            };
            readonly viewDetached: {
                readonly type: "object";
                readonly required: ["uri", "detached"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly detached: {
                        readonly type: "boolean";
                        readonly const: true;
                    };
                };
            };
        };
    };
    readonly AppBskyEmbedRecordWithMedia: {
        readonly lexicon: 1;
        readonly id: "app.bsky.embed.recordWithMedia";
        readonly description: "A representation of a record embedded in a Bluesky record (eg, a post), alongside other compatible embeds. For example, a quote post and image, or a quote post and external URL card.";
        readonly defs: {
            readonly main: {
                readonly type: "object";
                readonly required: ["record", "media"];
                readonly properties: {
                    readonly record: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.record";
                    };
                    readonly media: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.embed.images", "lex:app.bsky.embed.video", "lex:app.bsky.embed.external"];
                    };
                };
            };
            readonly view: {
                readonly type: "object";
                readonly required: ["record", "media"];
                readonly properties: {
                    readonly record: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.record#view";
                    };
                    readonly media: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.embed.images#view", "lex:app.bsky.embed.video#view", "lex:app.bsky.embed.external#view"];
                    };
                };
            };
        };
    };
    readonly AppBskyEmbedVideo: {
        readonly lexicon: 1;
        readonly id: "app.bsky.embed.video";
        readonly description: "A video embedded in a Bluesky record (eg, a post).";
        readonly defs: {
            readonly main: {
                readonly type: "object";
                readonly required: ["video"];
                readonly properties: {
                    readonly video: {
                        readonly type: "blob";
                        readonly description: "The mp4 video file. May be up to 100mb, formerly limited to 50mb.";
                        readonly accept: ["video/mp4"];
                        readonly maxSize: 100000000;
                    };
                    readonly captions: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.embed.video#caption";
                        };
                        readonly maxLength: 20;
                    };
                    readonly alt: {
                        readonly type: "string";
                        readonly description: "Alt text description of the video, for accessibility.";
                        readonly maxGraphemes: 1000;
                        readonly maxLength: 10000;
                    };
                    readonly aspectRatio: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.defs#aspectRatio";
                    };
                };
            };
            readonly caption: {
                readonly type: "object";
                readonly required: ["lang", "file"];
                readonly properties: {
                    readonly lang: {
                        readonly type: "string";
                        readonly format: "language";
                    };
                    readonly file: {
                        readonly type: "blob";
                        readonly accept: ["text/vtt"];
                        readonly maxSize: 20000;
                    };
                };
            };
            readonly view: {
                readonly type: "object";
                readonly required: ["cid", "playlist"];
                readonly properties: {
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly playlist: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly thumbnail: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly alt: {
                        readonly type: "string";
                        readonly maxGraphemes: 1000;
                        readonly maxLength: 10000;
                    };
                    readonly aspectRatio: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.defs#aspectRatio";
                    };
                };
            };
        };
    };
    readonly AppBskyFeedDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.defs";
        readonly defs: {
            readonly postView: {
                readonly type: "object";
                readonly required: ["uri", "cid", "author", "record", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly author: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                    };
                    readonly record: {
                        readonly type: "unknown";
                    };
                    readonly embed: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.embed.images#view", "lex:app.bsky.embed.video#view", "lex:app.bsky.embed.external#view", "lex:app.bsky.embed.record#view", "lex:app.bsky.embed.recordWithMedia#view"];
                    };
                    readonly bookmarkCount: {
                        readonly type: "integer";
                    };
                    readonly replyCount: {
                        readonly type: "integer";
                    };
                    readonly repostCount: {
                        readonly type: "integer";
                    };
                    readonly likeCount: {
                        readonly type: "integer";
                    };
                    readonly quoteCount: {
                        readonly type: "integer";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#viewerState";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly threadgate: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#threadgateView";
                    };
                    readonly debug: {
                        readonly type: "unknown";
                        readonly description: "Debug information for internal development";
                    };
                };
            };
            readonly viewerState: {
                readonly type: "object";
                readonly description: "Metadata about the requesting account's relationship with the subject content. Only has meaningful content for authed requests.";
                readonly properties: {
                    readonly repost: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly like: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly bookmarked: {
                        readonly type: "boolean";
                    };
                    readonly threadMuted: {
                        readonly type: "boolean";
                    };
                    readonly replyDisabled: {
                        readonly type: "boolean";
                    };
                    readonly embeddingDisabled: {
                        readonly type: "boolean";
                    };
                    readonly pinned: {
                        readonly type: "boolean";
                    };
                };
            };
            readonly threadContext: {
                readonly type: "object";
                readonly description: "Metadata about this post within the context of the thread it is in.";
                readonly properties: {
                    readonly rootAuthorLike: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly feedViewPost: {
                readonly type: "object";
                readonly required: ["post"];
                readonly properties: {
                    readonly post: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#postView";
                    };
                    readonly reply: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#replyRef";
                    };
                    readonly reason: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.defs#reasonRepost", "lex:app.bsky.feed.defs#reasonPin"];
                    };
                    readonly feedContext: {
                        readonly type: "string";
                        readonly description: "Context provided by feed generator that may be passed back alongside interactions.";
                        readonly maxLength: 2000;
                    };
                    readonly reqId: {
                        readonly type: "string";
                        readonly description: "Unique identifier per request that may be passed back alongside interactions.";
                        readonly maxLength: 100;
                    };
                };
            };
            readonly replyRef: {
                readonly type: "object";
                readonly required: ["root", "parent"];
                readonly properties: {
                    readonly root: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.defs#postView", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                    };
                    readonly parent: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.defs#postView", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                    };
                    readonly grandparentAuthor: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                        readonly description: "When parent is a reply to another post, this is the author of that post.";
                    };
                };
            };
            readonly reasonRepost: {
                readonly type: "object";
                readonly required: ["by", "indexedAt"];
                readonly properties: {
                    readonly by: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                    };
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly reasonPin: {
                readonly type: "object";
                readonly properties: {};
            };
            readonly threadViewPost: {
                readonly type: "object";
                readonly required: ["post"];
                readonly properties: {
                    readonly post: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#postView";
                    };
                    readonly parent: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.defs#threadViewPost", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                    };
                    readonly replies: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "union";
                            readonly refs: ["lex:app.bsky.feed.defs#threadViewPost", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                        };
                    };
                    readonly threadContext: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#threadContext";
                    };
                };
            };
            readonly notFoundPost: {
                readonly type: "object";
                readonly required: ["uri", "notFound"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly notFound: {
                        readonly type: "boolean";
                        readonly const: true;
                    };
                };
            };
            readonly blockedPost: {
                readonly type: "object";
                readonly required: ["uri", "blocked", "author"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly blocked: {
                        readonly type: "boolean";
                        readonly const: true;
                    };
                    readonly author: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#blockedAuthor";
                    };
                };
            };
            readonly blockedAuthor: {
                readonly type: "object";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#viewerState";
                    };
                };
            };
            readonly generatorView: {
                readonly type: "object";
                readonly required: ["uri", "cid", "did", "creator", "displayName", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly creator: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileView";
                    };
                    readonly displayName: {
                        readonly type: "string";
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly maxGraphemes: 300;
                        readonly maxLength: 3000;
                    };
                    readonly descriptionFacets: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.richtext.facet";
                        };
                    };
                    readonly avatar: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly likeCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly acceptsInteractions: {
                        readonly type: "boolean";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#generatorViewerState";
                    };
                    readonly contentMode: {
                        readonly type: "string";
                        readonly knownValues: ["app.bsky.feed.defs#contentModeUnspecified", "app.bsky.feed.defs#contentModeVideo"];
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly generatorViewerState: {
                readonly type: "object";
                readonly properties: {
                    readonly like: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly skeletonFeedPost: {
                readonly type: "object";
                readonly required: ["post"];
                readonly properties: {
                    readonly post: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly reason: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.defs#skeletonReasonRepost", "lex:app.bsky.feed.defs#skeletonReasonPin"];
                    };
                    readonly feedContext: {
                        readonly type: "string";
                        readonly description: "Context that will be passed through to client and may be passed to feed generator back alongside interactions.";
                        readonly maxLength: 2000;
                    };
                };
            };
            readonly skeletonReasonRepost: {
                readonly type: "object";
                readonly required: ["repost"];
                readonly properties: {
                    readonly repost: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly skeletonReasonPin: {
                readonly type: "object";
                readonly properties: {};
            };
            readonly threadgateView: {
                readonly type: "object";
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly record: {
                        readonly type: "unknown";
                    };
                    readonly lists: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.graph.defs#listViewBasic";
                        };
                    };
                };
            };
            readonly interaction: {
                readonly type: "object";
                readonly properties: {
                    readonly item: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly event: {
                        readonly type: "string";
                        readonly knownValues: ["app.bsky.feed.defs#requestLess", "app.bsky.feed.defs#requestMore", "app.bsky.feed.defs#clickthroughItem", "app.bsky.feed.defs#clickthroughAuthor", "app.bsky.feed.defs#clickthroughReposter", "app.bsky.feed.defs#clickthroughEmbed", "app.bsky.feed.defs#interactionSeen", "app.bsky.feed.defs#interactionLike", "app.bsky.feed.defs#interactionRepost", "app.bsky.feed.defs#interactionReply", "app.bsky.feed.defs#interactionQuote", "app.bsky.feed.defs#interactionShare"];
                    };
                    readonly feedContext: {
                        readonly type: "string";
                        readonly description: "Context on a feed item that was originally supplied by the feed generator on getFeedSkeleton.";
                        readonly maxLength: 2000;
                    };
                    readonly reqId: {
                        readonly type: "string";
                        readonly description: "Unique identifier per request that may be passed back alongside interactions.";
                        readonly maxLength: 100;
                    };
                };
            };
            readonly requestLess: {
                readonly type: "token";
                readonly description: "Request that less content like the given feed item be shown in the feed";
            };
            readonly requestMore: {
                readonly type: "token";
                readonly description: "Request that more content like the given feed item be shown in the feed";
            };
            readonly clickthroughItem: {
                readonly type: "token";
                readonly description: "User clicked through to the feed item";
            };
            readonly clickthroughAuthor: {
                readonly type: "token";
                readonly description: "User clicked through to the author of the feed item";
            };
            readonly clickthroughReposter: {
                readonly type: "token";
                readonly description: "User clicked through to the reposter of the feed item";
            };
            readonly clickthroughEmbed: {
                readonly type: "token";
                readonly description: "User clicked through to the embedded content of the feed item";
            };
            readonly contentModeUnspecified: {
                readonly type: "token";
                readonly description: "Declares the feed generator returns any types of posts.";
            };
            readonly contentModeVideo: {
                readonly type: "token";
                readonly description: "Declares the feed generator returns posts containing app.bsky.embed.video embeds.";
            };
            readonly interactionSeen: {
                readonly type: "token";
                readonly description: "Feed item was seen by user";
            };
            readonly interactionLike: {
                readonly type: "token";
                readonly description: "User liked the feed item";
            };
            readonly interactionRepost: {
                readonly type: "token";
                readonly description: "User reposted the feed item";
            };
            readonly interactionReply: {
                readonly type: "token";
                readonly description: "User replied to the feed item";
            };
            readonly interactionQuote: {
                readonly type: "token";
                readonly description: "User quoted the feed item";
            };
            readonly interactionShare: {
                readonly type: "token";
                readonly description: "User shared the feed item";
            };
        };
    };
    readonly AppBskyFeedDescribeFeedGenerator: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.describeFeedGenerator";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get information about a feed generator, including policies and offered feed URIs. Does not require auth; implemented by Feed Generator services (not App View).";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did", "feeds"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly feeds: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.describeFeedGenerator#feed";
                                };
                            };
                            readonly links: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.describeFeedGenerator#links";
                            };
                        };
                    };
                };
            };
            readonly feed: {
                readonly type: "object";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly links: {
                readonly type: "object";
                readonly properties: {
                    readonly privacyPolicy: {
                        readonly type: "string";
                    };
                    readonly termsOfService: {
                        readonly type: "string";
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGenerator: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.generator";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record declaring of the existence of a feed generator, and containing metadata about it. The record can exist in any repository.";
                readonly key: "any";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["did", "displayName", "createdAt"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly displayName: {
                            readonly type: "string";
                            readonly maxGraphemes: 24;
                            readonly maxLength: 240;
                        };
                        readonly description: {
                            readonly type: "string";
                            readonly maxGraphemes: 300;
                            readonly maxLength: 3000;
                        };
                        readonly descriptionFacets: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.richtext.facet";
                            };
                        };
                        readonly avatar: {
                            readonly type: "blob";
                            readonly accept: ["image/png", "image/jpeg"];
                            readonly maxSize: 1000000;
                        };
                        readonly acceptsInteractions: {
                            readonly type: "boolean";
                            readonly description: "Declaration that a feed accepts feedback interactions from a client through app.bsky.feed.sendInteractions";
                        };
                        readonly labels: {
                            readonly type: "union";
                            readonly description: "Self-label values";
                            readonly refs: ["lex:com.atproto.label.defs#selfLabels"];
                        };
                        readonly contentMode: {
                            readonly type: "string";
                            readonly knownValues: ["app.bsky.feed.defs#contentModeUnspecified", "app.bsky.feed.defs#contentModeVideo"];
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetActorFeeds: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getActorFeeds";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of feeds (feed generator records) created by the actor (in the actor's repo).";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feeds"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feeds: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#generatorView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetActorLikes: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getActorLikes";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of posts liked by an actor. Requires auth, actor must be the requesting account.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feed"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feed: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "BlockedActor";
                }, {
                    readonly name: "BlockedByActor";
                }];
            };
        };
    };
    readonly AppBskyFeedGetAuthorFeed: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getAuthorFeed";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a view of an actor's 'author feed' (post and reposts by the author). Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly filter: {
                            readonly type: "string";
                            readonly description: "Combinations of post/repost types to include in response.";
                            readonly knownValues: ["posts_with_replies", "posts_no_replies", "posts_with_media", "posts_and_author_threads", "posts_with_video"];
                            readonly default: "posts_with_replies";
                        };
                        readonly includePins: {
                            readonly type: "boolean";
                            readonly default: false;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feed"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feed: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "BlockedActor";
                }, {
                    readonly name: "BlockedByActor";
                }];
            };
        };
    };
    readonly AppBskyFeedGetFeed: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getFeed";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a hydrated feed from an actor's selected feed generator. Implemented by App View.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["feed"];
                    readonly properties: {
                        readonly feed: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feed"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feed: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "UnknownFeed";
                }];
            };
        };
    };
    readonly AppBskyFeedGetFeedGenerator: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getFeedGenerator";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get information about a feed generator. Implemented by AppView.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["feed"];
                    readonly properties: {
                        readonly feed: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "AT-URI of the feed generator record.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["view", "isOnline", "isValid"];
                        readonly properties: {
                            readonly view: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#generatorView";
                            };
                            readonly isOnline: {
                                readonly type: "boolean";
                                readonly description: "Indicates whether the feed generator service has been online recently, or else seems to be inactive.";
                            };
                            readonly isValid: {
                                readonly type: "boolean";
                                readonly description: "Indicates whether the feed generator service is compatible with the record declaration.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetFeedGenerators: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getFeedGenerators";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get information about a list of feed generators.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["feeds"];
                    readonly properties: {
                        readonly feeds: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feeds"];
                        readonly properties: {
                            readonly feeds: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#generatorView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetFeedSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getFeedSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a skeleton of a feed provided by a feed generator. Auth is optional, depending on provider requirements, and provides the DID of the requester. Implemented by Feed Generator Service.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["feed"];
                    readonly properties: {
                        readonly feed: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference to feed generator record describing the specific feed being requested.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feed"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feed: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#skeletonFeedPost";
                                };
                            };
                            readonly reqId: {
                                readonly type: "string";
                                readonly description: "Unique identifier per request that may be passed back alongside interactions.";
                                readonly maxLength: 100;
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "UnknownFeed";
                }];
            };
        };
    };
    readonly AppBskyFeedGetLikes: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getLikes";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get like records which reference a subject (by AT-URI and CID).";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uri"];
                    readonly properties: {
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "AT-URI of the subject (eg, a post record).";
                        };
                        readonly cid: {
                            readonly type: "string";
                            readonly format: "cid";
                            readonly description: "CID of the subject record (aka, specific version of record), to filter likes.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uri", "likes"];
                        readonly properties: {
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly likes: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.getLikes#like";
                                };
                            };
                        };
                    };
                };
            };
            readonly like: {
                readonly type: "object";
                readonly required: ["indexedAt", "createdAt", "actor"];
                readonly properties: {
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly actor: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileView";
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetListFeed: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getListFeed";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a feed of recent posts from a list (posts and reposts from any actors on the list). Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["list"];
                    readonly properties: {
                        readonly list: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to the list record.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feed"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feed: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "UnknownList";
                }];
            };
        };
    };
    readonly AppBskyFeedGetPostThread: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getPostThread";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get posts in a thread. Does not require auth, but additional metadata and filtering will be applied for authed requests.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uri"];
                    readonly properties: {
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to post record.";
                        };
                        readonly depth: {
                            readonly type: "integer";
                            readonly description: "How many levels of reply depth should be included in response.";
                            readonly default: 6;
                            readonly minimum: 0;
                            readonly maximum: 1000;
                        };
                        readonly parentHeight: {
                            readonly type: "integer";
                            readonly description: "How many levels of parent (and grandparent, etc) post to include.";
                            readonly default: 80;
                            readonly minimum: 0;
                            readonly maximum: 1000;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["thread"];
                        readonly properties: {
                            readonly thread: {
                                readonly type: "union";
                                readonly refs: ["lex:app.bsky.feed.defs#threadViewPost", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                            };
                            readonly threadgate: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#threadgateView";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "NotFound";
                }];
            };
        };
    };
    readonly AppBskyFeedGetPosts: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getPosts";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Gets post views for a specified list of posts (by AT-URI). This is sometimes referred to as 'hydrating' a 'feed skeleton'.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uris"];
                    readonly properties: {
                        readonly uris: {
                            readonly type: "array";
                            readonly description: "List of post AT-URIs to return hydrated views for.";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly maxLength: 25;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["posts"];
                        readonly properties: {
                            readonly posts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#postView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetQuotes: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getQuotes";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of quotes for a given post.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uri"];
                    readonly properties: {
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) of post record";
                        };
                        readonly cid: {
                            readonly type: "string";
                            readonly format: "cid";
                            readonly description: "If supplied, filters to quotes of specific version (by CID) of the post record.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uri", "posts"];
                        readonly properties: {
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly posts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#postView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetRepostedBy: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getRepostedBy";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of reposts for a given post.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uri"];
                    readonly properties: {
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) of post record";
                        };
                        readonly cid: {
                            readonly type: "string";
                            readonly format: "cid";
                            readonly description: "If supplied, filters to reposts of specific version (by CID) of the post record.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uri", "repostedBy"];
                        readonly properties: {
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly repostedBy: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetSuggestedFeeds: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getSuggestedFeeds";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of suggested feeds (feed generators) for the requesting account.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feeds"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feeds: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#generatorView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedGetTimeline: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.getTimeline";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a view of the requesting account's home timeline. This is expected to be some form of reverse-chronological feed.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly algorithm: {
                            readonly type: "string";
                            readonly description: "Variant 'algorithm' for timeline. Implementation-specific. NOTE: most feed flexibility has been moved to feed generator mechanism.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feed"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feed: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedLike: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.like";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record declaring a 'like' of a piece of subject content.";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["subject", "createdAt"];
                    readonly properties: {
                        readonly subject: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.repo.strongRef";
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                        readonly via: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.repo.strongRef";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedPost: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.post";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record containing a Bluesky post.";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["text", "createdAt"];
                    readonly properties: {
                        readonly text: {
                            readonly type: "string";
                            readonly maxLength: 3000;
                            readonly maxGraphemes: 300;
                            readonly description: "The primary post content. May be an empty string, if there are embeds.";
                        };
                        readonly entities: {
                            readonly type: "array";
                            readonly description: "DEPRECATED: replaced by app.bsky.richtext.facet.";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.post#entity";
                            };
                        };
                        readonly facets: {
                            readonly type: "array";
                            readonly description: "Annotations of text (mentions, URLs, hashtags, etc)";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.richtext.facet";
                            };
                        };
                        readonly reply: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.feed.post#replyRef";
                        };
                        readonly embed: {
                            readonly type: "union";
                            readonly refs: ["lex:app.bsky.embed.images", "lex:app.bsky.embed.video", "lex:app.bsky.embed.external", "lex:app.bsky.embed.record", "lex:app.bsky.embed.recordWithMedia"];
                        };
                        readonly langs: {
                            readonly type: "array";
                            readonly description: "Indicates human language of post primary text content.";
                            readonly maxLength: 3;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "language";
                            };
                        };
                        readonly labels: {
                            readonly type: "union";
                            readonly description: "Self-label values for this post. Effectively content warnings.";
                            readonly refs: ["lex:com.atproto.label.defs#selfLabels"];
                        };
                        readonly tags: {
                            readonly type: "array";
                            readonly description: "Additional hashtags, in addition to any included in post text and facets.";
                            readonly maxLength: 8;
                            readonly items: {
                                readonly type: "string";
                                readonly maxLength: 640;
                                readonly maxGraphemes: 64;
                            };
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Client-declared timestamp when this post was originally created.";
                        };
                    };
                };
            };
            readonly replyRef: {
                readonly type: "object";
                readonly required: ["root", "parent"];
                readonly properties: {
                    readonly root: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.repo.strongRef";
                    };
                    readonly parent: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.repo.strongRef";
                    };
                };
            };
            readonly entity: {
                readonly type: "object";
                readonly description: "Deprecated: use facets instead.";
                readonly required: ["index", "type", "value"];
                readonly properties: {
                    readonly index: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.post#textSlice";
                    };
                    readonly type: {
                        readonly type: "string";
                        readonly description: "Expected values are 'mention' and 'link'.";
                    };
                    readonly value: {
                        readonly type: "string";
                    };
                };
            };
            readonly textSlice: {
                readonly type: "object";
                readonly description: "Deprecated. Use app.bsky.richtext instead -- A text segment. Start is inclusive, end is exclusive. Indices are for utf16-encoded strings.";
                readonly required: ["start", "end"];
                readonly properties: {
                    readonly start: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly end: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                };
            };
        };
    };
    readonly AppBskyFeedPostgate: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.postgate";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly key: "tid";
                readonly description: "Record defining interaction rules for a post. The record key (rkey) of the postgate record must match the record key of the post, and that record must be in the same repository.";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["post", "createdAt"];
                    readonly properties: {
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                        readonly post: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to the post record.";
                        };
                        readonly detachedEmbeddingUris: {
                            readonly type: "array";
                            readonly maxLength: 50;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly description: "List of AT-URIs embedding this post that the author has detached from.";
                        };
                        readonly embeddingRules: {
                            readonly description: "List of rules defining who can embed this post. If value is an empty array or is undefined, no particular rules apply and anyone can embed.";
                            readonly type: "array";
                            readonly maxLength: 5;
                            readonly items: {
                                readonly type: "union";
                                readonly refs: ["lex:app.bsky.feed.postgate#disableRule"];
                            };
                        };
                    };
                };
            };
            readonly disableRule: {
                readonly type: "object";
                readonly description: "Disables embedding of this post.";
                readonly properties: {};
            };
        };
    };
    readonly AppBskyFeedRepost: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.repost";
        readonly defs: {
            readonly main: {
                readonly description: "Record representing a 'repost' of an existing Bluesky post.";
                readonly type: "record";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["subject", "createdAt"];
                    readonly properties: {
                        readonly subject: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.repo.strongRef";
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                        readonly via: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.repo.strongRef";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyFeedSearchPosts: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.searchPosts";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Find posts matching search criteria, returning views of those posts. Note that this API endpoint may require authentication (eg, not public) for some service providers and implementations.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["q"];
                    readonly properties: {
                        readonly q: {
                            readonly type: "string";
                            readonly description: "Search query string; syntax, phrase, boolean, and faceting is unspecified, but Lucene query syntax is recommended.";
                        };
                        readonly sort: {
                            readonly type: "string";
                            readonly knownValues: ["top", "latest"];
                            readonly default: "latest";
                            readonly description: "Specifies the ranking order of results.";
                        };
                        readonly since: {
                            readonly type: "string";
                            readonly description: "Filter results for posts after the indicated datetime (inclusive). Expected to use 'sortAt' timestamp, which may not match 'createdAt'. Can be a datetime, or just an ISO date (YYYY-MM-DD).";
                        };
                        readonly until: {
                            readonly type: "string";
                            readonly description: "Filter results for posts before the indicated datetime (not inclusive). Expected to use 'sortAt' timestamp, which may not match 'createdAt'. Can be a datetime, or just an ISO date (YYY-MM-DD).";
                        };
                        readonly mentions: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "Filter to posts which mention the given account. Handles are resolved to DID before query-time. Only matches rich-text facet mentions.";
                        };
                        readonly author: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "Filter to posts by the given account. Handles are resolved to DID before query-time.";
                        };
                        readonly lang: {
                            readonly type: "string";
                            readonly format: "language";
                            readonly description: "Filter to posts in the given language. Expected to be based on post language field, though server may override language detection.";
                        };
                        readonly domain: {
                            readonly type: "string";
                            readonly description: "Filter to posts with URLs (facet links or embeds) linking to the given domain (hostname). Server may apply hostname normalization.";
                        };
                        readonly url: {
                            readonly type: "string";
                            readonly format: "uri";
                            readonly description: "Filter to posts with links (facet links or embeds) pointing to this URL. Server may apply URL normalization or fuzzy matching.";
                        };
                        readonly tag: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly maxLength: 640;
                                readonly maxGraphemes: 64;
                            };
                            readonly description: "Filter to posts with the given tag (hashtag), based on rich-text facet or tag field. Do not include the hash (#) prefix. Multiple tags can be specified, with 'AND' matching.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 25;
                        };
                        readonly cursor: {
                            readonly type: "string";
                            readonly description: "Optional pagination mechanism; may not necessarily allow scrolling through entire result set.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["posts"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly hitsTotal: {
                                readonly type: "integer";
                                readonly description: "Count of search hits. Optional, may be rounded/truncated, and may not be possible to paginate through all hits.";
                            };
                            readonly posts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#postView";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "BadQueryString";
                }];
            };
        };
    };
    readonly AppBskyFeedSendInteractions: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.sendInteractions";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Send information about interactions with feed items back to the feed generator that served them.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["interactions"];
                        readonly properties: {
                            readonly interactions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#interaction";
                                };
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
            };
        };
    };
    readonly AppBskyFeedThreadgate: {
        readonly lexicon: 1;
        readonly id: "app.bsky.feed.threadgate";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly key: "tid";
                readonly description: "Record defining interaction gating rules for a thread (aka, reply controls). The record key (rkey) of the threadgate record must match the record key of the thread's root post, and that record must be in the same repository.";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["post", "createdAt"];
                    readonly properties: {
                        readonly post: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to the post record.";
                        };
                        readonly allow: {
                            readonly description: "List of rules defining who can reply to this post. If value is an empty array, no one can reply. If value is undefined, anyone can reply.";
                            readonly type: "array";
                            readonly maxLength: 5;
                            readonly items: {
                                readonly type: "union";
                                readonly refs: ["lex:app.bsky.feed.threadgate#mentionRule", "lex:app.bsky.feed.threadgate#followerRule", "lex:app.bsky.feed.threadgate#followingRule", "lex:app.bsky.feed.threadgate#listRule"];
                            };
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                        readonly hiddenReplies: {
                            readonly type: "array";
                            readonly maxLength: 300;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly description: "List of hidden reply URIs.";
                        };
                    };
                };
            };
            readonly mentionRule: {
                readonly type: "object";
                readonly description: "Allow replies from actors mentioned in your post.";
                readonly properties: {};
            };
            readonly followerRule: {
                readonly type: "object";
                readonly description: "Allow replies from actors who follow you.";
                readonly properties: {};
            };
            readonly followingRule: {
                readonly type: "object";
                readonly description: "Allow replies from actors you follow.";
                readonly properties: {};
            };
            readonly listRule: {
                readonly type: "object";
                readonly description: "Allow replies from actors on a list.";
                readonly required: ["list"];
                readonly properties: {
                    readonly list: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
        };
    };
    readonly AppBskyGraphBlock: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.block";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record declaring a 'block' relationship against another account. NOTE: blocks are public in Bluesky; see blog posts for details.";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["subject", "createdAt"];
                    readonly properties: {
                        readonly subject: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account to be blocked.";
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.defs";
        readonly defs: {
            readonly listViewBasic: {
                readonly type: "object";
                readonly required: ["uri", "cid", "name", "purpose"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly name: {
                        readonly type: "string";
                        readonly maxLength: 64;
                        readonly minLength: 1;
                    };
                    readonly purpose: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listPurpose";
                    };
                    readonly avatar: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly listItemCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listViewerState";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly listView: {
                readonly type: "object";
                readonly required: ["uri", "cid", "creator", "name", "purpose", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly creator: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileView";
                    };
                    readonly name: {
                        readonly type: "string";
                        readonly maxLength: 64;
                        readonly minLength: 1;
                    };
                    readonly purpose: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listPurpose";
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly maxGraphemes: 300;
                        readonly maxLength: 3000;
                    };
                    readonly descriptionFacets: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.richtext.facet";
                        };
                    };
                    readonly avatar: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly listItemCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listViewerState";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly listItemView: {
                readonly type: "object";
                readonly required: ["uri", "subject"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly subject: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileView";
                    };
                };
            };
            readonly starterPackView: {
                readonly type: "object";
                readonly required: ["uri", "cid", "record", "creator", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly record: {
                        readonly type: "unknown";
                    };
                    readonly creator: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                    };
                    readonly list: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listViewBasic";
                    };
                    readonly listItemsSample: {
                        readonly type: "array";
                        readonly maxLength: 12;
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.graph.defs#listItemView";
                        };
                    };
                    readonly feeds: {
                        readonly type: "array";
                        readonly maxLength: 3;
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.feed.defs#generatorView";
                        };
                    };
                    readonly joinedWeekCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly joinedAllTimeCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly starterPackViewBasic: {
                readonly type: "object";
                readonly required: ["uri", "cid", "record", "creator", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly record: {
                        readonly type: "unknown";
                    };
                    readonly creator: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                    };
                    readonly listItemCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly joinedWeekCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly joinedAllTimeCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly listPurpose: {
                readonly type: "string";
                readonly knownValues: ["app.bsky.graph.defs#modlist", "app.bsky.graph.defs#curatelist", "app.bsky.graph.defs#referencelist"];
            };
            readonly modlist: {
                readonly type: "token";
                readonly description: "A list of actors to apply an aggregate moderation action (mute/block) on.";
            };
            readonly curatelist: {
                readonly type: "token";
                readonly description: "A list of actors used for curation purposes such as list feeds or interaction gating.";
            };
            readonly referencelist: {
                readonly type: "token";
                readonly description: "A list of actors used for only for reference purposes such as within a starter pack.";
            };
            readonly listViewerState: {
                readonly type: "object";
                readonly properties: {
                    readonly muted: {
                        readonly type: "boolean";
                    };
                    readonly blocked: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly notFoundActor: {
                readonly type: "object";
                readonly description: "indicates that a handle or DID could not be resolved";
                readonly required: ["actor", "notFound"];
                readonly properties: {
                    readonly actor: {
                        readonly type: "string";
                        readonly format: "at-identifier";
                    };
                    readonly notFound: {
                        readonly type: "boolean";
                        readonly const: true;
                    };
                };
            };
            readonly relationship: {
                readonly type: "object";
                readonly description: "lists the bi-directional graph relationships between one actor (not indicated in the object), and the target actors (the DID included in the object)";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly following: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "if the actor follows this DID, this is the AT-URI of the follow record";
                    };
                    readonly followedBy: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "if the actor is followed by this DID, contains the AT-URI of the follow record";
                    };
                    readonly blocking: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "if the actor blocks this DID, this is the AT-URI of the block record";
                    };
                    readonly blockedBy: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "if the actor is blocked by this DID, contains the AT-URI of the block record";
                    };
                    readonly blockingByList: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "if the actor blocks this DID via a block list, this is the AT-URI of the listblock record";
                    };
                    readonly blockedByList: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "if the actor is blocked by this DID via a block list, contains the AT-URI of the listblock record";
                    };
                };
            };
        };
    };
    readonly AppBskyGraphFollow: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.follow";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record declaring a social 'follow' relationship of another account. Duplicate follows will be ignored by the AppView.";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["subject", "createdAt"];
                    readonly properties: {
                        readonly subject: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                        readonly via: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.repo.strongRef";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetActorStarterPacks: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getActorStarterPacks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of starter packs created by the actor.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacks"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly starterPacks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#starterPackViewBasic";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetBlocks: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getBlocks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates which accounts the requesting account is currently blocking. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["blocks"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly blocks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetFollowers: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getFollowers";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates accounts which follow a specified account (actor).";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject", "followers"];
                        readonly properties: {
                            readonly subject: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#profileView";
                            };
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly followers: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetFollows: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getFollows";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates accounts which a specified account (actor) follows.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject", "follows"];
                        readonly properties: {
                            readonly subject: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#profileView";
                            };
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly follows: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetKnownFollowers: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getKnownFollowers";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates accounts which follow a specified account (actor) and are followed by the viewer.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject", "followers"];
                        readonly properties: {
                            readonly subject: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#profileView";
                            };
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly followers: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetList: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getList";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Gets a 'view' (with additional context) of a specified list.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["list"];
                    readonly properties: {
                        readonly list: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) of the list record to hydrate.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["list", "items"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly list: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.graph.defs#listView";
                            };
                            readonly items: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#listItemView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetListBlocks: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getListBlocks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get mod lists that the requesting account (actor) is blocking. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["lists"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly lists: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#listView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetListMutes: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getListMutes";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates mod lists that the requesting account (actor) currently has muted. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["lists"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly lists: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#listView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetLists: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getLists";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates the lists created by a specified account (actor).";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "The account (actor) to enumerate lists from.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly purposes: {
                            readonly type: "array";
                            readonly description: "Optional filter by list purpose. If not specified, all supported types are returned.";
                            readonly items: {
                                readonly type: "string";
                                readonly knownValues: ["modlist", "curatelist"];
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["lists"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly lists: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#listView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetListsWithMembership: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getListsWithMembership";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates the lists created by the session user, and includes membership information about `actor` in those lists. Only supports curation and moderation lists (no reference lists, used in starter packs). Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "The account (actor) to check for membership.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly purposes: {
                            readonly type: "array";
                            readonly description: "Optional filter by list purpose. If not specified, all supported types are returned.";
                            readonly items: {
                                readonly type: "string";
                                readonly knownValues: ["modlist", "curatelist"];
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["listsWithMembership"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly listsWithMembership: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.getListsWithMembership#listWithMembership";
                                };
                            };
                        };
                    };
                };
            };
            readonly listWithMembership: {
                readonly description: "A list and an optional list item indicating membership of a target user to that list.";
                readonly type: "object";
                readonly required: ["list"];
                readonly properties: {
                    readonly list: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listView";
                    };
                    readonly listItem: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listItemView";
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetMutes: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getMutes";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates accounts that the requesting account (actor) currently has muted. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["mutes"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly mutes: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetRelationships: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getRelationships";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates public relationships between one account, and a list of other accounts. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "Primary account requesting relationships for.";
                        };
                        readonly others: {
                            readonly type: "array";
                            readonly description: "List of 'other' accounts to be related back to the primary.";
                            readonly maxLength: 30;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["relationships"];
                        readonly properties: {
                            readonly actor: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly relationships: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:app.bsky.graph.defs#relationship", "lex:app.bsky.graph.defs#notFoundActor"];
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "ActorNotFound";
                    readonly description: "the primary actor at-identifier could not be resolved";
                }];
            };
        };
    };
    readonly AppBskyGraphGetStarterPack: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getStarterPack";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Gets a view of a starter pack.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["starterPack"];
                    readonly properties: {
                        readonly starterPack: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) of the starter pack record.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPack"];
                        readonly properties: {
                            readonly starterPack: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.graph.defs#starterPackView";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetStarterPacks: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getStarterPacks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get views for a list of starter packs.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uris"];
                    readonly properties: {
                        readonly uris: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly maxLength: 25;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacks"];
                        readonly properties: {
                            readonly starterPacks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#starterPackViewBasic";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetStarterPacksWithMembership: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getStarterPacksWithMembership";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates the starter packs created by the session user, and includes membership information about `actor` in those starter packs. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "The account (actor) to check for membership.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacksWithMembership"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly starterPacksWithMembership: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.getStarterPacksWithMembership#starterPackWithMembership";
                                };
                            };
                        };
                    };
                };
            };
            readonly starterPackWithMembership: {
                readonly description: "A starter pack and an optional list item indicating membership of a target user to that starter pack.";
                readonly type: "object";
                readonly required: ["starterPack"];
                readonly properties: {
                    readonly starterPack: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#starterPackView";
                    };
                    readonly listItem: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listItemView";
                    };
                };
            };
        };
    };
    readonly AppBskyGraphGetSuggestedFollowsByActor: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.getSuggestedFollowsByActor";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates follows similar to a given account (actor). Expected use is to recommend additional accounts immediately after following one account.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["suggestions"];
                        readonly properties: {
                            readonly suggestions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                            readonly isFallback: {
                                readonly type: "boolean";
                                readonly description: "If true, response has fallen-back to generic results, and is not scoped using relativeToDid";
                                readonly default: false;
                            };
                            readonly recId: {
                                readonly type: "integer";
                                readonly description: "Snowflake for this recommendation, use when submitting recommendation events.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphList: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.list";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record representing a list of accounts (actors). Scope includes both moderation-oriented lists and curration-oriented lists.";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["name", "purpose", "createdAt"];
                    readonly properties: {
                        readonly purpose: {
                            readonly type: "ref";
                            readonly description: "Defines the purpose of the list (aka, moderation-oriented or curration-oriented)";
                            readonly ref: "lex:app.bsky.graph.defs#listPurpose";
                        };
                        readonly name: {
                            readonly type: "string";
                            readonly maxLength: 64;
                            readonly minLength: 1;
                            readonly description: "Display name for list; can not be empty.";
                        };
                        readonly description: {
                            readonly type: "string";
                            readonly maxGraphemes: 300;
                            readonly maxLength: 3000;
                        };
                        readonly descriptionFacets: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.richtext.facet";
                            };
                        };
                        readonly avatar: {
                            readonly type: "blob";
                            readonly accept: ["image/png", "image/jpeg"];
                            readonly maxSize: 1000000;
                        };
                        readonly labels: {
                            readonly type: "union";
                            readonly refs: ["lex:com.atproto.label.defs#selfLabels"];
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphListblock: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.listblock";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record representing a block relationship against an entire an entire list of accounts (actors).";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["subject", "createdAt"];
                    readonly properties: {
                        readonly subject: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to the mod list record.";
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphListitem: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.listitem";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record representing an account's inclusion on a specific list. The AppView will ignore duplicate listitem records.";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["subject", "list", "createdAt"];
                    readonly properties: {
                        readonly subject: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The account which is included on the list.";
                        };
                        readonly list: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to the list record (app.bsky.graph.list).";
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphMuteActor: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.muteActor";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Creates a mute relationship for the specified account. Mutes are private in Bluesky. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actor"];
                        readonly properties: {
                            readonly actor: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphMuteActorList: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.muteActorList";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Creates a mute relationship for the specified list of accounts. Mutes are private in Bluesky. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["list"];
                        readonly properties: {
                            readonly list: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphMuteThread: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.muteThread";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Mutes a thread preventing notifications from the thread and any of its children. Mutes are private in Bluesky. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["root"];
                        readonly properties: {
                            readonly root: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphSearchStarterPacks: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.searchStarterPacks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Find starter packs matching search criteria. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["q"];
                    readonly properties: {
                        readonly q: {
                            readonly type: "string";
                            readonly description: "Search query string. Syntax, phrase, boolean, and faceting is unspecified, but Lucene query syntax is recommended.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 25;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacks"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly starterPacks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#starterPackViewBasic";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphStarterpack: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.starterpack";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record defining a starter pack of actors and feeds for new users.";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["name", "list", "createdAt"];
                    readonly properties: {
                        readonly name: {
                            readonly type: "string";
                            readonly maxGraphemes: 50;
                            readonly maxLength: 500;
                            readonly minLength: 1;
                            readonly description: "Display name for starter pack; can not be empty.";
                        };
                        readonly description: {
                            readonly type: "string";
                            readonly maxGraphemes: 300;
                            readonly maxLength: 3000;
                        };
                        readonly descriptionFacets: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.richtext.facet";
                            };
                        };
                        readonly list: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to the list record.";
                        };
                        readonly feeds: {
                            readonly type: "array";
                            readonly maxLength: 3;
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.graph.starterpack#feedItem";
                            };
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
            readonly feedItem: {
                readonly type: "object";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
        };
    };
    readonly AppBskyGraphUnmuteActor: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.unmuteActor";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Unmutes the specified account. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actor"];
                        readonly properties: {
                            readonly actor: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphUnmuteActorList: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.unmuteActorList";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Unmutes the specified list of accounts. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["list"];
                        readonly properties: {
                            readonly list: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphUnmuteThread: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.unmuteThread";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Unmutes the specified thread. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["root"];
                        readonly properties: {
                            readonly root: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyGraphVerification: {
        readonly lexicon: 1;
        readonly id: "app.bsky.graph.verification";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Record declaring a verification relationship between two accounts. Verifications are only considered valid by an app if issued by an account the app considers trusted.";
                readonly key: "tid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["subject", "handle", "displayName", "createdAt"];
                    readonly properties: {
                        readonly subject: {
                            readonly description: "DID of the subject the verification applies to.";
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly handle: {
                            readonly description: "Handle of the subject the verification applies to at the moment of verifying, which might not be the same at the time of viewing. The verification is only valid if the current handle matches the one at the time of verifying.";
                            readonly type: "string";
                            readonly format: "handle";
                        };
                        readonly displayName: {
                            readonly description: "Display name of the subject the verification applies to at the moment of verifying, which might not be the same at the time of viewing. The verification is only valid if the current displayName matches the one at the time of verifying.";
                            readonly type: "string";
                        };
                        readonly createdAt: {
                            readonly description: "Date of when the verification was created.";
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyLabelerDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.labeler.defs";
        readonly defs: {
            readonly labelerView: {
                readonly type: "object";
                readonly required: ["uri", "cid", "creator", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly creator: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileView";
                    };
                    readonly likeCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.labeler.defs#labelerViewerState";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                };
            };
            readonly labelerViewDetailed: {
                readonly type: "object";
                readonly required: ["uri", "cid", "creator", "policies", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly creator: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileView";
                    };
                    readonly policies: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.labeler.defs#labelerPolicies";
                    };
                    readonly likeCount: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.labeler.defs#labelerViewerState";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly reasonTypes: {
                        readonly description: "The set of report reason 'codes' which are in-scope for this service to review and action. These usually align to policy categories. If not defined (distinct from empty array), all reason types are allowed.";
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.moderation.defs#reasonType";
                        };
                    };
                    readonly subjectTypes: {
                        readonly description: "The set of subject types (account, record, etc) this service accepts reports on.";
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.moderation.defs#subjectType";
                        };
                    };
                    readonly subjectCollections: {
                        readonly type: "array";
                        readonly description: "Set of record types (collection NSIDs) which can be reported to this service. If not defined (distinct from empty array), default is any record type.";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "nsid";
                        };
                    };
                };
            };
            readonly labelerViewerState: {
                readonly type: "object";
                readonly properties: {
                    readonly like: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly labelerPolicies: {
                readonly type: "object";
                readonly required: ["labelValues"];
                readonly properties: {
                    readonly labelValues: {
                        readonly type: "array";
                        readonly description: "The label values which this labeler publishes. May include global or custom labels.";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#labelValue";
                        };
                    };
                    readonly labelValueDefinitions: {
                        readonly type: "array";
                        readonly description: "Label values created by this labeler and scoped exclusively to it. Labels defined here will override global label definitions for this labeler.";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#labelValueDefinition";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyLabelerGetServices: {
        readonly lexicon: 1;
        readonly id: "app.bsky.labeler.getServices";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get information about a list of labeler services.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["dids"];
                    readonly properties: {
                        readonly dids: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                        readonly detailed: {
                            readonly type: "boolean";
                            readonly default: false;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["views"];
                        readonly properties: {
                            readonly views: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:app.bsky.labeler.defs#labelerView", "lex:app.bsky.labeler.defs#labelerViewDetailed"];
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyLabelerService: {
        readonly lexicon: 1;
        readonly id: "app.bsky.labeler.service";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "A declaration of the existence of labeler service.";
                readonly key: "literal:self";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["policies", "createdAt"];
                    readonly properties: {
                        readonly policies: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.labeler.defs#labelerPolicies";
                        };
                        readonly labels: {
                            readonly type: "union";
                            readonly refs: ["lex:com.atproto.label.defs#selfLabels"];
                        };
                        readonly createdAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                        readonly reasonTypes: {
                            readonly description: "The set of report reason 'codes' which are in-scope for this service to review and action. These usually align to policy categories. If not defined (distinct from empty array), all reason types are allowed.";
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.moderation.defs#reasonType";
                            };
                        };
                        readonly subjectTypes: {
                            readonly description: "The set of subject types (account, record, etc) this service accepts reports on.";
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.moderation.defs#subjectType";
                            };
                        };
                        readonly subjectCollections: {
                            readonly type: "array";
                            readonly description: "Set of record types (collection NSIDs) which can be reported to this service. If not defined (distinct from empty array), default is any record type.";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "nsid";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationDeclaration: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.declaration";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "A declaration of the user's choices related to notifications that can be produced by them.";
                readonly key: "literal:self";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["allowSubscriptions"];
                    readonly properties: {
                        readonly allowSubscriptions: {
                            readonly type: "string";
                            readonly description: "A declaration of the user's preference for allowing activity subscriptions from other users. Absence of a record implies 'followers'.";
                            readonly knownValues: ["followers", "mutuals", "none"];
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.defs";
        readonly defs: {
            readonly recordDeleted: {
                readonly type: "object";
                readonly properties: {};
            };
            readonly chatPreference: {
                readonly type: "object";
                readonly required: ["include", "push"];
                readonly properties: {
                    readonly include: {
                        readonly type: "string";
                        readonly knownValues: ["all", "accepted"];
                    };
                    readonly push: {
                        readonly type: "boolean";
                    };
                };
            };
            readonly filterablePreference: {
                readonly type: "object";
                readonly required: ["include", "list", "push"];
                readonly properties: {
                    readonly include: {
                        readonly type: "string";
                        readonly knownValues: ["all", "follows"];
                    };
                    readonly list: {
                        readonly type: "boolean";
                    };
                    readonly push: {
                        readonly type: "boolean";
                    };
                };
            };
            readonly preference: {
                readonly type: "object";
                readonly required: ["list", "push"];
                readonly properties: {
                    readonly list: {
                        readonly type: "boolean";
                    };
                    readonly push: {
                        readonly type: "boolean";
                    };
                };
            };
            readonly preferences: {
                readonly type: "object";
                readonly required: ["chat", "follow", "like", "likeViaRepost", "mention", "quote", "reply", "repost", "repostViaRepost", "starterpackJoined", "subscribedPost", "unverified", "verified"];
                readonly properties: {
                    readonly chat: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#chatPreference";
                    };
                    readonly follow: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                    };
                    readonly like: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                    };
                    readonly likeViaRepost: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                    };
                    readonly mention: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                    };
                    readonly quote: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                    };
                    readonly reply: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                    };
                    readonly repost: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                    };
                    readonly repostViaRepost: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                    };
                    readonly starterpackJoined: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#preference";
                    };
                    readonly subscribedPost: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#preference";
                    };
                    readonly unverified: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#preference";
                    };
                    readonly verified: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#preference";
                    };
                };
            };
            readonly activitySubscription: {
                readonly type: "object";
                readonly required: ["post", "reply"];
                readonly properties: {
                    readonly post: {
                        readonly type: "boolean";
                    };
                    readonly reply: {
                        readonly type: "boolean";
                    };
                };
            };
            readonly subjectActivitySubscription: {
                readonly description: "Object used to store activity subscription data in stash.";
                readonly type: "object";
                readonly required: ["subject", "activitySubscription"];
                readonly properties: {
                    readonly subject: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly activitySubscription: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.notification.defs#activitySubscription";
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationGetPreferences: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.getPreferences";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get notification-related preferences for an account. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {};
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["preferences"];
                        readonly properties: {
                            readonly preferences: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#preferences";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationGetUnreadCount: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.getUnreadCount";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Count the number of unread notifications for the requesting account. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly priority: {
                            readonly type: "boolean";
                        };
                        readonly seenAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["count"];
                        readonly properties: {
                            readonly count: {
                                readonly type: "integer";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationListActivitySubscriptions: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.listActivitySubscriptions";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerate all accounts to which the requesting account is subscribed to receive notifications for. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subscriptions"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly subscriptions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationListNotifications: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.listNotifications";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerate notifications for the requesting account. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly reasons: {
                            readonly description: "Notification reasons to include in response.";
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly description: "A reason that matches the reason property of #notification.";
                            };
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly priority: {
                            readonly type: "boolean";
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly seenAt: {
                            readonly type: "string";
                            readonly format: "datetime";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["notifications"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly notifications: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.notification.listNotifications#notification";
                                };
                            };
                            readonly priority: {
                                readonly type: "boolean";
                            };
                            readonly seenAt: {
                                readonly type: "string";
                                readonly format: "datetime";
                            };
                        };
                    };
                };
            };
            readonly notification: {
                readonly type: "object";
                readonly required: ["uri", "cid", "author", "reason", "record", "isRead", "indexedAt"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly author: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileView";
                    };
                    readonly reason: {
                        readonly type: "string";
                        readonly description: "The reason why this notification was delivered - e.g. your post was liked, or you received a new follower.";
                        readonly knownValues: ["like", "repost", "follow", "mention", "reply", "quote", "starterpack-joined", "verified", "unverified", "like-via-repost", "repost-via-repost", "subscribed-post", "contact-match"];
                    };
                    readonly reasonSubject: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly record: {
                        readonly type: "unknown";
                    };
                    readonly isRead: {
                        readonly type: "boolean";
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationPutActivitySubscription: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.putActivitySubscription";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Puts an activity subscription entry. The key should be omitted for creation and provided for updates. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject", "activitySubscription"];
                        readonly properties: {
                            readonly subject: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly activitySubscription: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#activitySubscription";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject"];
                        readonly properties: {
                            readonly subject: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly activitySubscription: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#activitySubscription";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationPutPreferences: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.putPreferences";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Set notification-related preferences for an account. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["priority"];
                        readonly properties: {
                            readonly priority: {
                                readonly type: "boolean";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationPutPreferencesV2: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.putPreferencesV2";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Set notification-related preferences for an account. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly chat: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#chatPreference";
                            };
                            readonly follow: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                            };
                            readonly like: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                            };
                            readonly likeViaRepost: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                            };
                            readonly mention: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                            };
                            readonly quote: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                            };
                            readonly reply: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                            };
                            readonly repost: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                            };
                            readonly repostViaRepost: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#filterablePreference";
                            };
                            readonly starterpackJoined: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#preference";
                            };
                            readonly subscribedPost: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#preference";
                            };
                            readonly unverified: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#preference";
                            };
                            readonly verified: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#preference";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["preferences"];
                        readonly properties: {
                            readonly preferences: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.notification.defs#preferences";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationRegisterPush: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.registerPush";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Register to receive push notifications, via a specified service, for the requesting account. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["serviceDid", "token", "platform", "appId"];
                        readonly properties: {
                            readonly serviceDid: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly token: {
                                readonly type: "string";
                            };
                            readonly platform: {
                                readonly type: "string";
                                readonly knownValues: ["ios", "android", "web"];
                            };
                            readonly appId: {
                                readonly type: "string";
                            };
                            readonly ageRestricted: {
                                readonly type: "boolean";
                                readonly description: "Set to true when the actor is age restricted";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationUnregisterPush: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.unregisterPush";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "The inverse of registerPush - inform a specified service that push notifications should no longer be sent to the given token for the requesting account. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["serviceDid", "token", "platform", "appId"];
                        readonly properties: {
                            readonly serviceDid: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly token: {
                                readonly type: "string";
                            };
                            readonly platform: {
                                readonly type: "string";
                                readonly knownValues: ["ios", "android", "web"];
                            };
                            readonly appId: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyNotificationUpdateSeen: {
        readonly lexicon: 1;
        readonly id: "app.bsky.notification.updateSeen";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Notify server that the requesting account has seen notifications. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["seenAt"];
                        readonly properties: {
                            readonly seenAt: {
                                readonly type: "string";
                                readonly format: "datetime";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyRichtextFacet: {
        readonly lexicon: 1;
        readonly id: "app.bsky.richtext.facet";
        readonly defs: {
            readonly main: {
                readonly type: "object";
                readonly description: "Annotation of a sub-string within rich text.";
                readonly required: ["index", "features"];
                readonly properties: {
                    readonly index: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.richtext.facet#byteSlice";
                    };
                    readonly features: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "union";
                            readonly refs: ["lex:app.bsky.richtext.facet#mention", "lex:app.bsky.richtext.facet#link", "lex:app.bsky.richtext.facet#tag"];
                        };
                    };
                };
            };
            readonly mention: {
                readonly type: "object";
                readonly description: "Facet feature for mention of another account. The text is usually a handle, including a '@' prefix, but the facet reference is a DID.";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
            readonly link: {
                readonly type: "object";
                readonly description: "Facet feature for a URL. The text URL may have been simplified or truncated, but the facet reference should be a complete URL.";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                };
            };
            readonly tag: {
                readonly type: "object";
                readonly description: "Facet feature for a hashtag. The text usually includes a '#' prefix, but the facet reference should not (except in the case of 'double hash tags').";
                readonly required: ["tag"];
                readonly properties: {
                    readonly tag: {
                        readonly type: "string";
                        readonly maxLength: 640;
                        readonly maxGraphemes: 64;
                    };
                };
            };
            readonly byteSlice: {
                readonly type: "object";
                readonly description: "Specifies the sub-string range a facet feature applies to. Start index is inclusive, end index is exclusive. Indices are zero-indexed, counting bytes of the UTF-8 encoded text. NOTE: some languages, like Javascript, use UTF-16 or Unicode codepoints for string slice indexing; in these languages, convert to byte arrays before working with facets.";
                readonly required: ["byteStart", "byteEnd"];
                readonly properties: {
                    readonly byteStart: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                    readonly byteEnd: {
                        readonly type: "integer";
                        readonly minimum: 0;
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.defs";
        readonly defs: {
            readonly skeletonSearchPost: {
                readonly type: "object";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly skeletonSearchActor: {
                readonly type: "object";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
            readonly skeletonSearchStarterPack: {
                readonly type: "object";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly trendingTopic: {
                readonly type: "object";
                readonly required: ["topic", "link"];
                readonly properties: {
                    readonly topic: {
                        readonly type: "string";
                    };
                    readonly displayName: {
                        readonly type: "string";
                    };
                    readonly description: {
                        readonly type: "string";
                    };
                    readonly link: {
                        readonly type: "string";
                    };
                };
            };
            readonly skeletonTrend: {
                readonly type: "object";
                readonly required: ["topic", "displayName", "link", "startedAt", "postCount", "dids"];
                readonly properties: {
                    readonly topic: {
                        readonly type: "string";
                    };
                    readonly displayName: {
                        readonly type: "string";
                    };
                    readonly link: {
                        readonly type: "string";
                    };
                    readonly startedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly postCount: {
                        readonly type: "integer";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly knownValues: ["hot"];
                    };
                    readonly category: {
                        readonly type: "string";
                    };
                    readonly dids: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                    };
                };
            };
            readonly trendView: {
                readonly type: "object";
                readonly required: ["topic", "displayName", "link", "startedAt", "postCount", "actors"];
                readonly properties: {
                    readonly topic: {
                        readonly type: "string";
                    };
                    readonly displayName: {
                        readonly type: "string";
                    };
                    readonly link: {
                        readonly type: "string";
                    };
                    readonly startedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly postCount: {
                        readonly type: "integer";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly knownValues: ["hot"];
                    };
                    readonly category: {
                        readonly type: "string";
                    };
                    readonly actors: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                        };
                    };
                };
            };
            readonly threadItemPost: {
                readonly type: "object";
                readonly required: ["post", "moreParents", "moreReplies", "opThread", "hiddenByThreadgate", "mutedByViewer"];
                readonly properties: {
                    readonly post: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#postView";
                    };
                    readonly moreParents: {
                        readonly type: "boolean";
                        readonly description: "This post has more parents that were not present in the response. This is just a boolean, without the number of parents.";
                    };
                    readonly moreReplies: {
                        readonly type: "integer";
                        readonly description: "This post has more replies that were not present in the response. This is a numeric value, which is best-effort and might not be accurate.";
                    };
                    readonly opThread: {
                        readonly type: "boolean";
                        readonly description: "This post is part of a contiguous thread by the OP from the thread root. Many different OP threads can happen in the same thread.";
                    };
                    readonly hiddenByThreadgate: {
                        readonly type: "boolean";
                        readonly description: "The threadgate created by the author indicates this post as a reply to be hidden for everyone consuming the thread.";
                    };
                    readonly mutedByViewer: {
                        readonly type: "boolean";
                        readonly description: "This is by an account muted by the viewer requesting it.";
                    };
                };
            };
            readonly threadItemNoUnauthenticated: {
                readonly type: "object";
                readonly properties: {};
            };
            readonly threadItemNotFound: {
                readonly type: "object";
                readonly properties: {};
            };
            readonly threadItemBlocked: {
                readonly type: "object";
                readonly required: ["author"];
                readonly properties: {
                    readonly author: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.feed.defs#blockedAuthor";
                    };
                };
            };
            readonly ageAssuranceState: {
                readonly type: "object";
                readonly description: "The computed state of the age assurance process, returned to the user in question on certain authenticated requests.";
                readonly required: ["status"];
                readonly properties: {
                    readonly lastInitiatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The timestamp when this state was last updated.";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly description: "The status of the age assurance process.";
                        readonly knownValues: ["unknown", "pending", "assured", "blocked"];
                    };
                };
            };
            readonly ageAssuranceEvent: {
                readonly type: "object";
                readonly description: "Object used to store age assurance data in stash.";
                readonly required: ["createdAt", "status", "attemptId"];
                readonly properties: {
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The date and time of this write operation.";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly description: "The status of the age assurance process.";
                        readonly knownValues: ["unknown", "pending", "assured"];
                    };
                    readonly attemptId: {
                        readonly type: "string";
                        readonly description: "The unique identifier for this instance of the age assurance flow, in UUID format.";
                    };
                    readonly email: {
                        readonly type: "string";
                        readonly description: "The email used for AA.";
                    };
                    readonly initIp: {
                        readonly type: "string";
                        readonly description: "The IP address used when initiating the AA flow.";
                    };
                    readonly initUa: {
                        readonly type: "string";
                        readonly description: "The user agent used when initiating the AA flow.";
                    };
                    readonly completeIp: {
                        readonly type: "string";
                        readonly description: "The IP address used when completing the AA flow.";
                    };
                    readonly completeUa: {
                        readonly type: "string";
                        readonly description: "The user agent used when completing the AA flow.";
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetAgeAssuranceState: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getAgeAssuranceState";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Returns the current state of the age assurance process for an account. This is used to check if the user has completed age assurance or if further action is required.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.unspecced.defs#ageAssuranceState";
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetConfig: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getConfig";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get miscellaneous runtime configuration.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: [];
                        readonly properties: {
                            readonly checkEmailConfirmed: {
                                readonly type: "boolean";
                            };
                            readonly liveNow: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.getConfig#liveNowConfig";
                                };
                            };
                        };
                    };
                };
            };
            readonly liveNowConfig: {
                readonly type: "object";
                readonly required: ["did", "domains"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly domains: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetOnboardingSuggestedStarterPacks: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getOnboardingSuggestedStarterPacks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of suggested starterpacks for onboarding";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacks"];
                        readonly properties: {
                            readonly starterPacks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#starterPackView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetOnboardingSuggestedStarterPacksSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getOnboardingSuggestedStarterPacksSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a skeleton of suggested starterpacks for onboarding. Intended to be called and hydrated by app.bsky.unspecced.getOnboardingSuggestedStarterPacks";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries).";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacks"];
                        readonly properties: {
                            readonly starterPacks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "at-uri";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetPopularFeedGenerators: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getPopularFeedGenerators";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "An unspecced view of globally popular feed generators.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly query: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feeds"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly feeds: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#generatorView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetPostThreadOtherV2: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getPostThreadOtherV2";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "(NOTE: this endpoint is under development and WILL change without notice. Don't use it until it is moved out of `unspecced` or your application WILL break) Get additional posts under a thread e.g. replies hidden by threadgate. Based on an anchor post at any depth of the tree, returns top-level replies below that anchor. It does not include ancestors nor the anchor itself. This should be called after exhausting `app.bsky.unspecced.getPostThreadV2`. Does not require auth, but additional metadata and filtering will be applied for authed requests.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["anchor"];
                    readonly properties: {
                        readonly anchor: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to post record. This is the anchor post.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["thread"];
                        readonly properties: {
                            readonly thread: {
                                readonly type: "array";
                                readonly description: "A flat list of other thread items. The depth of each item is indicated by the depth property inside the item.";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.getPostThreadOtherV2#threadItem";
                                };
                            };
                        };
                    };
                };
            };
            readonly threadItem: {
                readonly type: "object";
                readonly required: ["uri", "depth", "value"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly depth: {
                        readonly type: "integer";
                        readonly description: "The nesting level of this item in the thread. Depth 0 means the anchor item. Items above have negative depths, items below have positive depths.";
                    };
                    readonly value: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.unspecced.defs#threadItemPost"];
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetPostThreadV2: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getPostThreadV2";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "(NOTE: this endpoint is under development and WILL change without notice. Don't use it until it is moved out of `unspecced` or your application WILL break) Get posts in a thread. It is based in an anchor post at any depth of the tree, and returns posts above it (recursively resolving the parent, without further branching to their replies) and below it (recursive replies, with branching to their replies). Does not require auth, but additional metadata and filtering will be applied for authed requests.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["anchor"];
                    readonly properties: {
                        readonly anchor: {
                            readonly type: "string";
                            readonly format: "at-uri";
                            readonly description: "Reference (AT-URI) to post record. This is the anchor post, and the thread will be built around it. It can be any post in the tree, not necessarily a root post.";
                        };
                        readonly above: {
                            readonly type: "boolean";
                            readonly description: "Whether to include parents above the anchor.";
                            readonly default: true;
                        };
                        readonly below: {
                            readonly type: "integer";
                            readonly description: "How many levels of replies to include below the anchor.";
                            readonly default: 6;
                            readonly minimum: 0;
                            readonly maximum: 20;
                        };
                        readonly branchingFactor: {
                            readonly type: "integer";
                            readonly description: "Maximum of replies to include at each level of the thread, except for the direct replies to the anchor, which are (NOTE: currently, during unspecced phase) all returned (NOTE: later they might be paginated).";
                            readonly default: 10;
                            readonly minimum: 0;
                            readonly maximum: 100;
                        };
                        readonly sort: {
                            readonly type: "string";
                            readonly description: "Sorting for the thread replies.";
                            readonly knownValues: ["newest", "oldest", "top"];
                            readonly default: "oldest";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["thread", "hasOtherReplies"];
                        readonly properties: {
                            readonly thread: {
                                readonly type: "array";
                                readonly description: "A flat list of thread items. The depth of each item is indicated by the depth property inside the item.";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.getPostThreadV2#threadItem";
                                };
                            };
                            readonly threadgate: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#threadgateView";
                            };
                            readonly hasOtherReplies: {
                                readonly type: "boolean";
                                readonly description: "Whether this thread has additional replies. If true, a call can be made to the `getPostThreadOtherV2` endpoint to retrieve them.";
                            };
                        };
                    };
                };
            };
            readonly threadItem: {
                readonly type: "object";
                readonly required: ["uri", "depth", "value"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly depth: {
                        readonly type: "integer";
                        readonly description: "The nesting level of this item in the thread. Depth 0 means the anchor item. Items above have negative depths, items below have positive depths.";
                    };
                    readonly value: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.unspecced.defs#threadItemPost", "lex:app.bsky.unspecced.defs#threadItemNoUnauthenticated", "lex:app.bsky.unspecced.defs#threadItemNotFound", "lex:app.bsky.unspecced.defs#threadItemBlocked"];
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetSuggestedFeeds: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getSuggestedFeeds";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of suggested feeds";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feeds"];
                        readonly properties: {
                            readonly feeds: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.feed.defs#generatorView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetSuggestedFeedsSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getSuggestedFeedsSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a skeleton of suggested feeds. Intended to be called and hydrated by app.bsky.unspecced.getSuggestedFeeds";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries).";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["feeds"];
                        readonly properties: {
                            readonly feeds: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "at-uri";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetSuggestedStarterPacks: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getSuggestedStarterPacks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of suggested starterpacks";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacks"];
                        readonly properties: {
                            readonly starterPacks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.graph.defs#starterPackView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetSuggestedStarterPacksSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getSuggestedStarterPacksSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a skeleton of suggested starterpacks. Intended to be called and hydrated by app.bsky.unspecced.getSuggestedStarterpacks";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries).";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacks"];
                        readonly properties: {
                            readonly starterPacks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "at-uri";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetSuggestedUsers: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getSuggestedUsers";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of suggested users";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly category: {
                            readonly type: "string";
                            readonly description: "Category of users to get suggestions for.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 50;
                            readonly default: 25;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actors"];
                        readonly properties: {
                            readonly actors: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetSuggestedUsersSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getSuggestedUsersSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a skeleton of suggested users. Intended to be called and hydrated by app.bsky.unspecced.getSuggestedUsers";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries).";
                        };
                        readonly category: {
                            readonly type: "string";
                            readonly description: "Category of users to get suggestions for.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 50;
                            readonly default: 25;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["dids"];
                        readonly properties: {
                            readonly dids: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "did";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetSuggestionsSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getSuggestionsSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a skeleton of suggested actors. Intended to be called and then hydrated through app.bsky.actor.getSuggestions";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries). Used to boost followed accounts in ranking.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly relativeToDid: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account to get suggestions relative to. If not provided, suggestions will be based on the viewer.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actors"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly actors: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.defs#skeletonSearchActor";
                                };
                            };
                            readonly relativeToDid: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "DID of the account these suggestions are relative to. If this is returned undefined, suggestions are based on the viewer.";
                            };
                            readonly recId: {
                                readonly type: "integer";
                                readonly description: "Snowflake for this recommendation, use when submitting recommendation events.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetTaggedSuggestions: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getTaggedSuggestions";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of suggestions (feeds and users) tagged with categories";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {};
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["suggestions"];
                        readonly properties: {
                            readonly suggestions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.getTaggedSuggestions#suggestion";
                                };
                            };
                        };
                    };
                };
            };
            readonly suggestion: {
                readonly type: "object";
                readonly required: ["tag", "subjectType", "subject"];
                readonly properties: {
                    readonly tag: {
                        readonly type: "string";
                    };
                    readonly subjectType: {
                        readonly type: "string";
                        readonly knownValues: ["actor", "feed"];
                    };
                    readonly subject: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetTrendingTopics: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getTrendingTopics";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a list of trending topics";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries). Used to boost followed accounts in ranking.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["topics", "suggested"];
                        readonly properties: {
                            readonly topics: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.defs#trendingTopic";
                                };
                            };
                            readonly suggested: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.defs#trendingTopic";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetTrends: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getTrends";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get the current trends on the network";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["trends"];
                        readonly properties: {
                            readonly trends: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.defs#trendView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedGetTrendsSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.getTrendsSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get the skeleton of trends on the network. Intended to be called and then hydrated through app.bsky.unspecced.getTrends";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries).";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 25;
                            readonly default: 10;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["trends"];
                        readonly properties: {
                            readonly trends: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.defs#skeletonTrend";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyUnspeccedInitAgeAssurance: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.initAgeAssurance";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Initiate age assurance for an account. This is a one-time action that will start the process of verifying the user's age.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["email", "language", "countryCode"];
                        readonly properties: {
                            readonly email: {
                                readonly type: "string";
                                readonly description: "The user's email address to receive assurance instructions.";
                            };
                            readonly language: {
                                readonly type: "string";
                                readonly description: "The user's preferred language for communication during the assurance process.";
                            };
                            readonly countryCode: {
                                readonly type: "string";
                                readonly description: "An ISO 3166-1 alpha-2 code of the user's location.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.unspecced.defs#ageAssuranceState";
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidEmail";
                }, {
                    readonly name: "DidTooLong";
                }, {
                    readonly name: "InvalidInitiation";
                }];
            };
        };
    };
    readonly AppBskyUnspeccedSearchActorsSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.searchActorsSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Backend Actors (profile) search, returns only skeleton.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["q"];
                    readonly properties: {
                        readonly q: {
                            readonly type: "string";
                            readonly description: "Search query string; syntax, phrase, boolean, and faceting is unspecified, but Lucene query syntax is recommended. For typeahead search, only simple term match is supported, not full syntax.";
                        };
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries). Used to boost followed accounts in ranking.";
                        };
                        readonly typeahead: {
                            readonly type: "boolean";
                            readonly description: "If true, acts as fast/simple 'typeahead' query.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 25;
                        };
                        readonly cursor: {
                            readonly type: "string";
                            readonly description: "Optional pagination mechanism; may not necessarily allow scrolling through entire result set.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actors"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly hitsTotal: {
                                readonly type: "integer";
                                readonly description: "Count of search hits. Optional, may be rounded/truncated, and may not be possible to paginate through all hits.";
                            };
                            readonly actors: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.defs#skeletonSearchActor";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "BadQueryString";
                }];
            };
        };
    };
    readonly AppBskyUnspeccedSearchPostsSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.searchPostsSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Backend Posts search, returns only skeleton";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["q"];
                    readonly properties: {
                        readonly q: {
                            readonly type: "string";
                            readonly description: "Search query string; syntax, phrase, boolean, and faceting is unspecified, but Lucene query syntax is recommended.";
                        };
                        readonly sort: {
                            readonly type: "string";
                            readonly knownValues: ["top", "latest"];
                            readonly default: "latest";
                            readonly description: "Specifies the ranking order of results.";
                        };
                        readonly since: {
                            readonly type: "string";
                            readonly description: "Filter results for posts after the indicated datetime (inclusive). Expected to use 'sortAt' timestamp, which may not match 'createdAt'. Can be a datetime, or just an ISO date (YYYY-MM-DD).";
                        };
                        readonly until: {
                            readonly type: "string";
                            readonly description: "Filter results for posts before the indicated datetime (not inclusive). Expected to use 'sortAt' timestamp, which may not match 'createdAt'. Can be a datetime, or just an ISO date (YYY-MM-DD).";
                        };
                        readonly mentions: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "Filter to posts which mention the given account. Handles are resolved to DID before query-time. Only matches rich-text facet mentions.";
                        };
                        readonly author: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "Filter to posts by the given account. Handles are resolved to DID before query-time.";
                        };
                        readonly lang: {
                            readonly type: "string";
                            readonly format: "language";
                            readonly description: "Filter to posts in the given language. Expected to be based on post language field, though server may override language detection.";
                        };
                        readonly domain: {
                            readonly type: "string";
                            readonly description: "Filter to posts with URLs (facet links or embeds) linking to the given domain (hostname). Server may apply hostname normalization.";
                        };
                        readonly url: {
                            readonly type: "string";
                            readonly format: "uri";
                            readonly description: "Filter to posts with links (facet links or embeds) pointing to this URL. Server may apply URL normalization or fuzzy matching.";
                        };
                        readonly tag: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly maxLength: 640;
                                readonly maxGraphemes: 64;
                            };
                            readonly description: "Filter to posts with the given tag (hashtag), based on rich-text facet or tag field. Do not include the hash (#) prefix. Multiple tags can be specified, with 'AND' matching.";
                        };
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries). Used for 'from:me' queries.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 25;
                        };
                        readonly cursor: {
                            readonly type: "string";
                            readonly description: "Optional pagination mechanism; may not necessarily allow scrolling through entire result set.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["posts"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly hitsTotal: {
                                readonly type: "integer";
                                readonly description: "Count of search hits. Optional, may be rounded/truncated, and may not be possible to paginate through all hits.";
                            };
                            readonly posts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.defs#skeletonSearchPost";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "BadQueryString";
                }];
            };
        };
    };
    readonly AppBskyUnspeccedSearchStarterPacksSkeleton: {
        readonly lexicon: 1;
        readonly id: "app.bsky.unspecced.searchStarterPacksSkeleton";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Backend Starter Pack search, returns only skeleton.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["q"];
                    readonly properties: {
                        readonly q: {
                            readonly type: "string";
                            readonly description: "Search query string; syntax, phrase, boolean, and faceting is unspecified, but Lucene query syntax is recommended.";
                        };
                        readonly viewer: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID of the account making the request (not included for public/unauthenticated queries).";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 25;
                        };
                        readonly cursor: {
                            readonly type: "string";
                            readonly description: "Optional pagination mechanism; may not necessarily allow scrolling through entire result set.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["starterPacks"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly hitsTotal: {
                                readonly type: "integer";
                                readonly description: "Count of search hits. Optional, may be rounded/truncated, and may not be possible to paginate through all hits.";
                            };
                            readonly starterPacks: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:app.bsky.unspecced.defs#skeletonSearchStarterPack";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "BadQueryString";
                }];
            };
        };
    };
    readonly AppBskyVideoDefs: {
        readonly lexicon: 1;
        readonly id: "app.bsky.video.defs";
        readonly defs: {
            readonly jobStatus: {
                readonly type: "object";
                readonly required: ["jobId", "did", "state"];
                readonly properties: {
                    readonly jobId: {
                        readonly type: "string";
                    };
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly state: {
                        readonly type: "string";
                        readonly description: "The state of the video processing job. All values not listed as a known value indicate that the job is in process.";
                        readonly knownValues: ["JOB_STATE_COMPLETED", "JOB_STATE_FAILED"];
                    };
                    readonly progress: {
                        readonly type: "integer";
                        readonly minimum: 0;
                        readonly maximum: 100;
                        readonly description: "Progress within the current processing state.";
                    };
                    readonly blob: {
                        readonly type: "blob";
                    };
                    readonly error: {
                        readonly type: "string";
                    };
                    readonly message: {
                        readonly type: "string";
                    };
                };
            };
        };
    };
    readonly AppBskyVideoGetJobStatus: {
        readonly lexicon: 1;
        readonly id: "app.bsky.video.getJobStatus";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get status details for a video processing job.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["jobId"];
                    readonly properties: {
                        readonly jobId: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["jobStatus"];
                        readonly properties: {
                            readonly jobStatus: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.video.defs#jobStatus";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyVideoGetUploadLimits: {
        readonly lexicon: 1;
        readonly id: "app.bsky.video.getUploadLimits";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get video upload limits for the authenticated user.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["canUpload"];
                        readonly properties: {
                            readonly canUpload: {
                                readonly type: "boolean";
                            };
                            readonly remainingDailyVideos: {
                                readonly type: "integer";
                            };
                            readonly remainingDailyBytes: {
                                readonly type: "integer";
                            };
                            readonly message: {
                                readonly type: "string";
                            };
                            readonly error: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly AppBskyVideoUploadVideo: {
        readonly lexicon: 1;
        readonly id: "app.bsky.video.uploadVideo";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Upload a video to be processed then stored on the PDS.";
                readonly input: {
                    readonly encoding: "video/mp4";
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["jobStatus"];
                        readonly properties: {
                            readonly jobStatus: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.video.defs#jobStatus";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyActorDeclaration: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.actor.declaration";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "A declaration of a Bluesky chat account.";
                readonly key: "literal:self";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["allowIncoming"];
                    readonly properties: {
                        readonly allowIncoming: {
                            readonly type: "string";
                            readonly knownValues: ["all", "none", "following"];
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyActorDefs: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.actor.defs";
        readonly defs: {
            readonly profileViewBasic: {
                readonly type: "object";
                readonly required: ["did", "handle"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly displayName: {
                        readonly type: "string";
                        readonly maxGraphemes: 64;
                        readonly maxLength: 640;
                    };
                    readonly avatar: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly associated: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileAssociated";
                    };
                    readonly viewer: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#viewerState";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly chatDisabled: {
                        readonly type: "boolean";
                        readonly description: "Set to true when the actor cannot actively participate in conversations";
                    };
                    readonly verification: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#verificationState";
                    };
                };
            };
        };
    };
    readonly ChatBskyActorDeleteAccount: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.actor.deleteAccount";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
            };
        };
    };
    readonly ChatBskyActorExportAccountData: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.actor.exportAccountData";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly output: {
                    readonly encoding: "application/jsonl";
                };
            };
        };
    };
    readonly ChatBskyConvoAcceptConvo: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.acceptConvo";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly rev: {
                                readonly description: "Rev when the convo was accepted. If not present, the convo was already accepted.";
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoAddReaction: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.addReaction";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Adds an emoji reaction to a message. Requires authentication. It is idempotent, so multiple calls from the same user with the same emoji result in a single reaction.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId", "messageId", "value"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                            readonly messageId: {
                                readonly type: "string";
                            };
                            readonly value: {
                                readonly type: "string";
                                readonly minLength: 1;
                                readonly maxLength: 64;
                                readonly minGraphemes: 1;
                                readonly maxGraphemes: 1;
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["message"];
                        readonly properties: {
                            readonly message: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#messageView";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "ReactionMessageDeleted";
                    readonly description: "Indicates that the message has been deleted and reactions can no longer be added/removed.";
                }, {
                    readonly name: "ReactionLimitReached";
                    readonly description: "Indicates that the message has the maximum number of reactions allowed for a single user, and the requested reaction wasn't yet present. If it was already present, the request will not fail since it is idempotent.";
                }, {
                    readonly name: "ReactionInvalidValue";
                    readonly description: "Indicates the value for the reaction is not acceptable. In general, this means it is not an emoji.";
                }];
            };
        };
    };
    readonly ChatBskyConvoDefs: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.defs";
        readonly defs: {
            readonly messageRef: {
                readonly type: "object";
                readonly required: ["did", "messageId", "convoId"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                    readonly messageId: {
                        readonly type: "string";
                    };
                };
            };
            readonly messageInput: {
                readonly type: "object";
                readonly required: ["text"];
                readonly properties: {
                    readonly text: {
                        readonly type: "string";
                        readonly maxLength: 10000;
                        readonly maxGraphemes: 1000;
                    };
                    readonly facets: {
                        readonly type: "array";
                        readonly description: "Annotations of text (mentions, URLs, hashtags, etc)";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.richtext.facet";
                        };
                    };
                    readonly embed: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.embed.record"];
                    };
                };
            };
            readonly messageView: {
                readonly type: "object";
                readonly required: ["id", "rev", "text", "sender", "sentAt"];
                readonly properties: {
                    readonly id: {
                        readonly type: "string";
                    };
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly text: {
                        readonly type: "string";
                        readonly maxLength: 10000;
                        readonly maxGraphemes: 1000;
                    };
                    readonly facets: {
                        readonly type: "array";
                        readonly description: "Annotations of text (mentions, URLs, hashtags, etc)";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.richtext.facet";
                        };
                    };
                    readonly embed: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.embed.record#view"];
                    };
                    readonly reactions: {
                        readonly type: "array";
                        readonly description: "Reactions to this message, in ascending order of creation time.";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:chat.bsky.convo.defs#reactionView";
                        };
                    };
                    readonly sender: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#messageViewSender";
                    };
                    readonly sentAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly deletedMessageView: {
                readonly type: "object";
                readonly required: ["id", "rev", "sender", "sentAt"];
                readonly properties: {
                    readonly id: {
                        readonly type: "string";
                    };
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly sender: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#messageViewSender";
                    };
                    readonly sentAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly messageViewSender: {
                readonly type: "object";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
            readonly reactionView: {
                readonly type: "object";
                readonly required: ["value", "sender", "createdAt"];
                readonly properties: {
                    readonly value: {
                        readonly type: "string";
                    };
                    readonly sender: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#reactionViewSender";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly reactionViewSender: {
                readonly type: "object";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
            readonly messageAndReactionView: {
                readonly type: "object";
                readonly required: ["message", "reaction"];
                readonly properties: {
                    readonly message: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#messageView";
                    };
                    readonly reaction: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#reactionView";
                    };
                };
            };
            readonly convoView: {
                readonly type: "object";
                readonly required: ["id", "rev", "members", "muted", "unreadCount"];
                readonly properties: {
                    readonly id: {
                        readonly type: "string";
                    };
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly members: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:chat.bsky.actor.defs#profileViewBasic";
                        };
                    };
                    readonly lastMessage: {
                        readonly type: "union";
                        readonly refs: ["lex:chat.bsky.convo.defs#messageView", "lex:chat.bsky.convo.defs#deletedMessageView"];
                    };
                    readonly lastReaction: {
                        readonly type: "union";
                        readonly refs: ["lex:chat.bsky.convo.defs#messageAndReactionView"];
                    };
                    readonly muted: {
                        readonly type: "boolean";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly knownValues: ["request", "accepted"];
                    };
                    readonly unreadCount: {
                        readonly type: "integer";
                    };
                };
            };
            readonly logBeginConvo: {
                readonly type: "object";
                readonly required: ["rev", "convoId"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                };
            };
            readonly logAcceptConvo: {
                readonly type: "object";
                readonly required: ["rev", "convoId"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                };
            };
            readonly logLeaveConvo: {
                readonly type: "object";
                readonly required: ["rev", "convoId"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                };
            };
            readonly logMuteConvo: {
                readonly type: "object";
                readonly required: ["rev", "convoId"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                };
            };
            readonly logUnmuteConvo: {
                readonly type: "object";
                readonly required: ["rev", "convoId"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                };
            };
            readonly logCreateMessage: {
                readonly type: "object";
                readonly required: ["rev", "convoId", "message"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                    readonly message: {
                        readonly type: "union";
                        readonly refs: ["lex:chat.bsky.convo.defs#messageView", "lex:chat.bsky.convo.defs#deletedMessageView"];
                    };
                };
            };
            readonly logDeleteMessage: {
                readonly type: "object";
                readonly required: ["rev", "convoId", "message"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                    readonly message: {
                        readonly type: "union";
                        readonly refs: ["lex:chat.bsky.convo.defs#messageView", "lex:chat.bsky.convo.defs#deletedMessageView"];
                    };
                };
            };
            readonly logReadMessage: {
                readonly type: "object";
                readonly required: ["rev", "convoId", "message"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                    readonly message: {
                        readonly type: "union";
                        readonly refs: ["lex:chat.bsky.convo.defs#messageView", "lex:chat.bsky.convo.defs#deletedMessageView"];
                    };
                };
            };
            readonly logAddReaction: {
                readonly type: "object";
                readonly required: ["rev", "convoId", "message", "reaction"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                    readonly message: {
                        readonly type: "union";
                        readonly refs: ["lex:chat.bsky.convo.defs#messageView", "lex:chat.bsky.convo.defs#deletedMessageView"];
                    };
                    readonly reaction: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#reactionView";
                    };
                };
            };
            readonly logRemoveReaction: {
                readonly type: "object";
                readonly required: ["rev", "convoId", "message", "reaction"];
                readonly properties: {
                    readonly rev: {
                        readonly type: "string";
                    };
                    readonly convoId: {
                        readonly type: "string";
                    };
                    readonly message: {
                        readonly type: "union";
                        readonly refs: ["lex:chat.bsky.convo.defs#messageView", "lex:chat.bsky.convo.defs#deletedMessageView"];
                    };
                    readonly reaction: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#reactionView";
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoDeleteMessageForSelf: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.deleteMessageForSelf";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId", "messageId"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                            readonly messageId: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#deletedMessageView";
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoGetConvo: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.getConvo";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["convoId"];
                    readonly properties: {
                        readonly convoId: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convo"];
                        readonly properties: {
                            readonly convo: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#convoView";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoGetConvoAvailability: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.getConvoAvailability";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get whether the requester and the other members can chat. If an existing convo is found for these members, it is returned.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["members"];
                    readonly properties: {
                        readonly members: {
                            readonly type: "array";
                            readonly minLength: 1;
                            readonly maxLength: 10;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["canChat"];
                        readonly properties: {
                            readonly canChat: {
                                readonly type: "boolean";
                            };
                            readonly convo: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#convoView";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoGetConvoForMembers: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.getConvoForMembers";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["members"];
                    readonly properties: {
                        readonly members: {
                            readonly type: "array";
                            readonly minLength: 1;
                            readonly maxLength: 10;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convo"];
                        readonly properties: {
                            readonly convo: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#convoView";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoGetLog: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.getLog";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: [];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["logs"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly logs: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:chat.bsky.convo.defs#logBeginConvo", "lex:chat.bsky.convo.defs#logAcceptConvo", "lex:chat.bsky.convo.defs#logLeaveConvo", "lex:chat.bsky.convo.defs#logMuteConvo", "lex:chat.bsky.convo.defs#logUnmuteConvo", "lex:chat.bsky.convo.defs#logCreateMessage", "lex:chat.bsky.convo.defs#logDeleteMessage", "lex:chat.bsky.convo.defs#logReadMessage", "lex:chat.bsky.convo.defs#logAddReaction", "lex:chat.bsky.convo.defs#logRemoveReaction"];
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoGetMessages: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.getMessages";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["convoId"];
                    readonly properties: {
                        readonly convoId: {
                            readonly type: "string";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["messages"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly messages: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:chat.bsky.convo.defs#messageView", "lex:chat.bsky.convo.defs#deletedMessageView"];
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoLeaveConvo: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.leaveConvo";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId", "rev"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                            readonly rev: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoListConvos: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.listConvos";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly readState: {
                            readonly type: "string";
                            readonly knownValues: ["unread"];
                        };
                        readonly status: {
                            readonly type: "string";
                            readonly knownValues: ["request", "accepted"];
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convos"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly convos: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:chat.bsky.convo.defs#convoView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoMuteConvo: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.muteConvo";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convo"];
                        readonly properties: {
                            readonly convo: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#convoView";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoRemoveReaction: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.removeReaction";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Removes an emoji reaction from a message. Requires authentication. It is idempotent, so multiple calls from the same user with the same emoji result in that reaction not being present, even if it already wasn't.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId", "messageId", "value"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                            readonly messageId: {
                                readonly type: "string";
                            };
                            readonly value: {
                                readonly type: "string";
                                readonly minLength: 1;
                                readonly maxLength: 64;
                                readonly minGraphemes: 1;
                                readonly maxGraphemes: 1;
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["message"];
                        readonly properties: {
                            readonly message: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#messageView";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "ReactionMessageDeleted";
                    readonly description: "Indicates that the message has been deleted and reactions can no longer be added/removed.";
                }, {
                    readonly name: "ReactionInvalidValue";
                    readonly description: "Indicates the value for the reaction is not acceptable. In general, this means it is not an emoji.";
                }];
            };
        };
    };
    readonly ChatBskyConvoSendMessage: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.sendMessage";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId", "message"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                            readonly message: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#messageInput";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#messageView";
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoSendMessageBatch: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.sendMessageBatch";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["items"];
                        readonly properties: {
                            readonly items: {
                                readonly type: "array";
                                readonly maxLength: 100;
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:chat.bsky.convo.sendMessageBatch#batchItem";
                                };
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["items"];
                        readonly properties: {
                            readonly items: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:chat.bsky.convo.defs#messageView";
                                };
                            };
                        };
                    };
                };
            };
            readonly batchItem: {
                readonly type: "object";
                readonly required: ["convoId", "message"];
                readonly properties: {
                    readonly convoId: {
                        readonly type: "string";
                    };
                    readonly message: {
                        readonly type: "ref";
                        readonly ref: "lex:chat.bsky.convo.defs#messageInput";
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoUnmuteConvo: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.unmuteConvo";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convo"];
                        readonly properties: {
                            readonly convo: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#convoView";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoUpdateAllRead: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.updateAllRead";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly status: {
                                readonly type: "string";
                                readonly knownValues: ["request", "accepted"];
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["updatedCount"];
                        readonly properties: {
                            readonly updatedCount: {
                                readonly description: "The count of updated convos.";
                                readonly type: "integer";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyConvoUpdateRead: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.convo.updateRead";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convoId"];
                        readonly properties: {
                            readonly convoId: {
                                readonly type: "string";
                            };
                            readonly messageId: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["convo"];
                        readonly properties: {
                            readonly convo: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.convo.defs#convoView";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyModerationGetActorMetadata: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.moderation.getActorMetadata";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["actor"];
                    readonly properties: {
                        readonly actor: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["day", "month", "all"];
                        readonly properties: {
                            readonly day: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.moderation.getActorMetadata#metadata";
                            };
                            readonly month: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.moderation.getActorMetadata#metadata";
                            };
                            readonly all: {
                                readonly type: "ref";
                                readonly ref: "lex:chat.bsky.moderation.getActorMetadata#metadata";
                            };
                        };
                    };
                };
            };
            readonly metadata: {
                readonly type: "object";
                readonly required: ["messagesSent", "messagesReceived", "convos", "convosStarted"];
                readonly properties: {
                    readonly messagesSent: {
                        readonly type: "integer";
                    };
                    readonly messagesReceived: {
                        readonly type: "integer";
                    };
                    readonly convos: {
                        readonly type: "integer";
                    };
                    readonly convosStarted: {
                        readonly type: "integer";
                    };
                };
            };
        };
    };
    readonly ChatBskyModerationGetMessageContext: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.moderation.getMessageContext";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["messageId"];
                    readonly properties: {
                        readonly convoId: {
                            readonly type: "string";
                            readonly description: "Conversation that the message is from. NOTE: this field will eventually be required.";
                        };
                        readonly messageId: {
                            readonly type: "string";
                        };
                        readonly before: {
                            readonly type: "integer";
                            readonly default: 5;
                        };
                        readonly after: {
                            readonly type: "integer";
                            readonly default: 5;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["messages"];
                        readonly properties: {
                            readonly messages: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:chat.bsky.convo.defs#messageView", "lex:chat.bsky.convo.defs#deletedMessageView"];
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ChatBskyModerationUpdateActorAccess: {
        readonly lexicon: 1;
        readonly id: "chat.bsky.moderation.updateActorAccess";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actor", "allowAccess"];
                        readonly properties: {
                            readonly actor: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly allowAccess: {
                                readonly type: "boolean";
                            };
                            readonly ref: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminDefs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.defs";
        readonly defs: {
            readonly statusAttr: {
                readonly type: "object";
                readonly required: ["applied"];
                readonly properties: {
                    readonly applied: {
                        readonly type: "boolean";
                    };
                    readonly ref: {
                        readonly type: "string";
                    };
                };
            };
            readonly accountView: {
                readonly type: "object";
                readonly required: ["did", "handle", "indexedAt"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly email: {
                        readonly type: "string";
                    };
                    readonly relatedRecords: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "unknown";
                        };
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly invitedBy: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.server.defs#inviteCode";
                    };
                    readonly invites: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.server.defs#inviteCode";
                        };
                    };
                    readonly invitesDisabled: {
                        readonly type: "boolean";
                    };
                    readonly emailConfirmedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly inviteNote: {
                        readonly type: "string";
                    };
                    readonly deactivatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly threatSignatures: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.admin.defs#threatSignature";
                        };
                    };
                };
            };
            readonly repoRef: {
                readonly type: "object";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
            readonly repoBlobRef: {
                readonly type: "object";
                readonly required: ["did", "cid"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly recordUri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly threatSignature: {
                readonly type: "object";
                readonly required: ["property", "value"];
                readonly properties: {
                    readonly property: {
                        readonly type: "string";
                    };
                    readonly value: {
                        readonly type: "string";
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminDeleteAccount: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.deleteAccount";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete a user account as an administrator.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminDisableAccountInvites: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.disableAccountInvites";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Disable an account from receiving new invite codes, but does not invalidate existing codes.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["account"];
                        readonly properties: {
                            readonly account: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly note: {
                                readonly type: "string";
                                readonly description: "Optional reason for disabled invites.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminDisableInviteCodes: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.disableInviteCodes";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Disable some set of codes and/or all codes associated with a set of users.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly codes: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                            readonly accounts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminEnableAccountInvites: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.enableAccountInvites";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Re-enable an account's ability to receive invite codes.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["account"];
                        readonly properties: {
                            readonly account: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly note: {
                                readonly type: "string";
                                readonly description: "Optional reason for enabled invites.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminGetAccountInfo: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.getAccountInfo";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about an account.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.admin.defs#accountView";
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminGetAccountInfos: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.getAccountInfos";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about some accounts.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["dids"];
                    readonly properties: {
                        readonly dids: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["infos"];
                        readonly properties: {
                            readonly infos: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.admin.defs#accountView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminGetInviteCodes: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.getInviteCodes";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get an admin view of invite codes.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly sort: {
                            readonly type: "string";
                            readonly knownValues: ["recent", "usage"];
                            readonly default: "recent";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 500;
                            readonly default: 100;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["codes"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly codes: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.server.defs#inviteCode";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminGetSubjectStatus: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.getSubjectStatus";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get the service-specific admin status of a subject (account, record, or blob).";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                        readonly blob: {
                            readonly type: "string";
                            readonly format: "cid";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject"];
                        readonly properties: {
                            readonly subject: {
                                readonly type: "union";
                                readonly refs: ["lex:com.atproto.admin.defs#repoRef", "lex:com.atproto.repo.strongRef", "lex:com.atproto.admin.defs#repoBlobRef"];
                            };
                            readonly takedown: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.admin.defs#statusAttr";
                            };
                            readonly deactivated: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.admin.defs#statusAttr";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminSearchAccounts: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.searchAccounts";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get list of accounts that matches your search query.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly email: {
                            readonly type: "string";
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["accounts"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly accounts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.admin.defs#accountView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminSendEmail: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.sendEmail";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Send email to a user's account email address.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["recipientDid", "content", "senderDid"];
                        readonly properties: {
                            readonly recipientDid: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly content: {
                                readonly type: "string";
                            };
                            readonly subject: {
                                readonly type: "string";
                            };
                            readonly senderDid: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly comment: {
                                readonly type: "string";
                                readonly description: "Additional comment by the sender that won't be used in the email itself but helpful to provide more context for moderators/reviewers";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["sent"];
                        readonly properties: {
                            readonly sent: {
                                readonly type: "boolean";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminUpdateAccountEmail: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.updateAccountEmail";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Administrative action to update an account's email.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["account", "email"];
                        readonly properties: {
                            readonly account: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                                readonly description: "The handle or DID of the repo.";
                            };
                            readonly email: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminUpdateAccountHandle: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.updateAccountHandle";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Administrative action to update an account's handle.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did", "handle"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminUpdateAccountPassword: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.updateAccountPassword";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Update the password for a user account as an administrator.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did", "password"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly password: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminUpdateAccountSigningKey: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.updateAccountSigningKey";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Administrative action to update an account's signing key in their Did document.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did", "signingKey"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly signingKey: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "Did-key formatted public key";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoAdminUpdateSubjectStatus: {
        readonly lexicon: 1;
        readonly id: "com.atproto.admin.updateSubjectStatus";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Update the service-specific admin status of a subject (account, record, or blob).";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject"];
                        readonly properties: {
                            readonly subject: {
                                readonly type: "union";
                                readonly refs: ["lex:com.atproto.admin.defs#repoRef", "lex:com.atproto.repo.strongRef", "lex:com.atproto.admin.defs#repoBlobRef"];
                            };
                            readonly takedown: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.admin.defs#statusAttr";
                            };
                            readonly deactivated: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.admin.defs#statusAttr";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject"];
                        readonly properties: {
                            readonly subject: {
                                readonly type: "union";
                                readonly refs: ["lex:com.atproto.admin.defs#repoRef", "lex:com.atproto.repo.strongRef", "lex:com.atproto.admin.defs#repoBlobRef"];
                            };
                            readonly takedown: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.admin.defs#statusAttr";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoIdentityDefs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.defs";
        readonly defs: {
            readonly identityInfo: {
                readonly type: "object";
                readonly required: ["did", "handle", "didDoc"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                        readonly description: "The validated handle of the account; or 'handle.invalid' if the handle did not bi-directionally match the DID document.";
                    };
                    readonly didDoc: {
                        readonly type: "unknown";
                        readonly description: "The complete DID document for the identity.";
                    };
                };
            };
        };
    };
    readonly ComAtprotoIdentityGetRecommendedDidCredentials: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.getRecommendedDidCredentials";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Describe the credentials that should be included in the DID doc of an account that is migrating to this service.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly rotationKeys: {
                                readonly description: "Recommended rotation keys for PLC dids. Should be undefined (or ignored) for did:webs.";
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                            readonly alsoKnownAs: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                            readonly verificationMethods: {
                                readonly type: "unknown";
                            };
                            readonly services: {
                                readonly type: "unknown";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoIdentityRefreshIdentity: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.refreshIdentity";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Request that the server re-resolve an identity (DID and handle). The server may ignore this request, or require authentication, depending on the role, implementation, and policy of the server.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["identifier"];
                        readonly properties: {
                            readonly identifier: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.identity.defs#identityInfo";
                    };
                };
                readonly errors: [{
                    readonly name: "HandleNotFound";
                    readonly description: "The resolution process confirmed that the handle does not resolve to any DID.";
                }, {
                    readonly name: "DidNotFound";
                    readonly description: "The DID resolution process confirmed that there is no current DID.";
                }, {
                    readonly name: "DidDeactivated";
                    readonly description: "The DID previously existed, but has been deactivated.";
                }];
            };
        };
    };
    readonly ComAtprotoIdentityRequestPlcOperationSignature: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.requestPlcOperationSignature";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Request an email with a code to in order to request a signed PLC operation. Requires Auth.";
            };
        };
    };
    readonly ComAtprotoIdentityResolveDid: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.resolveDid";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Resolves DID to DID document. Does not bi-directionally verify handle.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "DID to resolve.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["didDoc"];
                        readonly properties: {
                            readonly didDoc: {
                                readonly type: "unknown";
                                readonly description: "The complete DID document for the identity.";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "DidNotFound";
                    readonly description: "The DID resolution process confirmed that there is no current DID.";
                }, {
                    readonly name: "DidDeactivated";
                    readonly description: "The DID previously existed, but has been deactivated.";
                }];
            };
        };
    };
    readonly ComAtprotoIdentityResolveHandle: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.resolveHandle";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Resolves an atproto handle (hostname) to a DID. Does not necessarily bi-directionally verify against the the DID document.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["handle"];
                    readonly properties: {
                        readonly handle: {
                            readonly type: "string";
                            readonly format: "handle";
                            readonly description: "The handle to resolve.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "HandleNotFound";
                    readonly description: "The resolution process confirmed that the handle does not resolve to any DID.";
                }];
            };
        };
    };
    readonly ComAtprotoIdentityResolveIdentity: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.resolveIdentity";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Resolves an identity (DID or Handle) to a full identity (DID document and verified handle).";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["identifier"];
                    readonly properties: {
                        readonly identifier: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "Handle or DID to resolve.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.identity.defs#identityInfo";
                    };
                };
                readonly errors: [{
                    readonly name: "HandleNotFound";
                    readonly description: "The resolution process confirmed that the handle does not resolve to any DID.";
                }, {
                    readonly name: "DidNotFound";
                    readonly description: "The DID resolution process confirmed that there is no current DID.";
                }, {
                    readonly name: "DidDeactivated";
                    readonly description: "The DID previously existed, but has been deactivated.";
                }];
            };
        };
    };
    readonly ComAtprotoIdentitySignPlcOperation: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.signPlcOperation";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Signs a PLC operation to update some value(s) in the requesting DID's document.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly token: {
                                readonly description: "A token received through com.atproto.identity.requestPlcOperationSignature";
                                readonly type: "string";
                            };
                            readonly rotationKeys: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                            readonly alsoKnownAs: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                            readonly verificationMethods: {
                                readonly type: "unknown";
                            };
                            readonly services: {
                                readonly type: "unknown";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["operation"];
                        readonly properties: {
                            readonly operation: {
                                readonly type: "unknown";
                                readonly description: "A signed DID PLC operation.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoIdentitySubmitPlcOperation: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.submitPlcOperation";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Validates a PLC operation to ensure that it doesn't violate a service's constraints or get the identity into a bad state, then submits it to the PLC registry";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["operation"];
                        readonly properties: {
                            readonly operation: {
                                readonly type: "unknown";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoIdentityUpdateHandle: {
        readonly lexicon: 1;
        readonly id: "com.atproto.identity.updateHandle";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Updates the current account's handle. Verifies handle validity, and updates did:plc document if necessary. Implemented by PDS, and requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["handle"];
                        readonly properties: {
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                                readonly description: "The new handle.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoLabelDefs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.label.defs";
        readonly defs: {
            readonly label: {
                readonly type: "object";
                readonly description: "Metadata tag on an atproto resource (eg, repo or record).";
                readonly required: ["src", "uri", "val", "cts"];
                readonly properties: {
                    readonly ver: {
                        readonly type: "integer";
                        readonly description: "The AT Protocol version of the label object.";
                    };
                    readonly src: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "DID of the actor who created this label.";
                    };
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "uri";
                        readonly description: "AT URI of the record, repository (account), or other resource that this label applies to.";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                        readonly description: "Optionally, CID specifying the specific version of 'uri' resource this label applies to.";
                    };
                    readonly val: {
                        readonly type: "string";
                        readonly maxLength: 128;
                        readonly description: "The short string name of the value or type of this label.";
                    };
                    readonly neg: {
                        readonly type: "boolean";
                        readonly description: "If true, this is a negation label, overwriting a previous label.";
                    };
                    readonly cts: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp when this label was created.";
                    };
                    readonly exp: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp at which this label expires (no longer applies).";
                    };
                    readonly sig: {
                        readonly type: "bytes";
                        readonly description: "Signature of dag-cbor encoded label.";
                    };
                };
            };
            readonly selfLabels: {
                readonly type: "object";
                readonly description: "Metadata tags on an atproto record, published by the author within the record.";
                readonly required: ["values"];
                readonly properties: {
                    readonly values: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#selfLabel";
                        };
                        readonly maxLength: 10;
                    };
                };
            };
            readonly selfLabel: {
                readonly type: "object";
                readonly description: "Metadata tag on an atproto record, published by the author within the record. Note that schemas should use #selfLabels, not #selfLabel.";
                readonly required: ["val"];
                readonly properties: {
                    readonly val: {
                        readonly type: "string";
                        readonly maxLength: 128;
                        readonly description: "The short string name of the value or type of this label.";
                    };
                };
            };
            readonly labelValueDefinition: {
                readonly type: "object";
                readonly description: "Declares a label value and its expected interpretations and behaviors.";
                readonly required: ["identifier", "severity", "blurs", "locales"];
                readonly properties: {
                    readonly identifier: {
                        readonly type: "string";
                        readonly description: "The value of the label being defined. Must only include lowercase ascii and the '-' character ([a-z-]+).";
                        readonly maxLength: 100;
                        readonly maxGraphemes: 100;
                    };
                    readonly severity: {
                        readonly type: "string";
                        readonly description: "How should a client visually convey this label? 'inform' means neutral and informational; 'alert' means negative and warning; 'none' means show nothing.";
                        readonly knownValues: ["inform", "alert", "none"];
                    };
                    readonly blurs: {
                        readonly type: "string";
                        readonly description: "What should this label hide in the UI, if applied? 'content' hides all of the target; 'media' hides the images/video/audio; 'none' hides nothing.";
                        readonly knownValues: ["content", "media", "none"];
                    };
                    readonly defaultSetting: {
                        readonly type: "string";
                        readonly description: "The default setting for this label.";
                        readonly knownValues: ["ignore", "warn", "hide"];
                        readonly default: "warn";
                    };
                    readonly adultOnly: {
                        readonly type: "boolean";
                        readonly description: "Does the user need to have adult content enabled in order to configure this label?";
                    };
                    readonly locales: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#labelValueDefinitionStrings";
                        };
                    };
                };
            };
            readonly labelValueDefinitionStrings: {
                readonly type: "object";
                readonly description: "Strings which describe the label in the UI, localized into a specific language.";
                readonly required: ["lang", "name", "description"];
                readonly properties: {
                    readonly lang: {
                        readonly type: "string";
                        readonly description: "The code of the language these strings are written in.";
                        readonly format: "language";
                    };
                    readonly name: {
                        readonly type: "string";
                        readonly description: "A short human-readable name for the label.";
                        readonly maxGraphemes: 64;
                        readonly maxLength: 640;
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly description: "A longer description of what the label means and why it might be applied.";
                        readonly maxGraphemes: 10000;
                        readonly maxLength: 100000;
                    };
                };
            };
            readonly labelValue: {
                readonly type: "string";
                readonly knownValues: ["!hide", "!no-promote", "!warn", "!no-unauthenticated", "dmca-violation", "doxxing", "porn", "sexual", "nudity", "nsfl", "gore"];
            };
        };
    };
    readonly ComAtprotoLabelQueryLabels: {
        readonly lexicon: 1;
        readonly id: "com.atproto.label.queryLabels";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Find labels relevant to the provided AT-URI patterns. Public endpoint for moderation services, though may return different or additional results with auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uriPatterns"];
                    readonly properties: {
                        readonly uriPatterns: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly description: "List of AT URI patterns to match (boolean 'OR'). Each may be a prefix (ending with '*'; will match inclusive of the string leading to '*'), or a full URI.";
                        };
                        readonly sources: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly description: "Optional list of label sources (DIDs) to filter on.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 250;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["labels"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly labels: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.label.defs#label";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoLabelSubscribeLabels: {
        readonly lexicon: 1;
        readonly id: "com.atproto.label.subscribeLabels";
        readonly defs: {
            readonly main: {
                readonly type: "subscription";
                readonly description: "Subscribe to stream of labels (and negations). Public endpoint implemented by mod services. Uses same sequencing scheme as repo event stream.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "integer";
                            readonly description: "The last known event seq number to backfill from.";
                        };
                    };
                };
                readonly message: {
                    readonly schema: {
                        readonly type: "union";
                        readonly refs: ["lex:com.atproto.label.subscribeLabels#labels", "lex:com.atproto.label.subscribeLabels#info"];
                    };
                };
                readonly errors: [{
                    readonly name: "FutureCursor";
                }];
            };
            readonly labels: {
                readonly type: "object";
                readonly required: ["seq", "labels"];
                readonly properties: {
                    readonly seq: {
                        readonly type: "integer";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                };
            };
            readonly info: {
                readonly type: "object";
                readonly required: ["name"];
                readonly properties: {
                    readonly name: {
                        readonly type: "string";
                        readonly knownValues: ["OutdatedCursor"];
                    };
                    readonly message: {
                        readonly type: "string";
                    };
                };
            };
        };
    };
    readonly ComAtprotoLexiconResolveLexicon: {
        readonly lexicon: 1;
        readonly id: "com.atproto.lexicon.resolveLexicon";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Resolves an atproto lexicon (NSID) to a schema.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly nsid: {
                            readonly format: "nsid";
                            readonly type: "string";
                            readonly description: "The lexicon NSID to resolve.";
                        };
                    };
                    readonly required: ["nsid"];
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                                readonly description: "The CID of the lexicon schema record.";
                            };
                            readonly schema: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.lexicon.schema#main";
                                readonly description: "The resolved lexicon schema record.";
                            };
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                                readonly description: "The AT-URI of the lexicon schema record.";
                            };
                        };
                        readonly required: ["uri", "cid", "schema"];
                    };
                };
                readonly errors: [{
                    readonly description: "No lexicon was resolved for the NSID.";
                    readonly name: "LexiconNotFound";
                }];
            };
        };
    };
    readonly ComAtprotoLexiconSchema: {
        readonly lexicon: 1;
        readonly id: "com.atproto.lexicon.schema";
        readonly defs: {
            readonly main: {
                readonly type: "record";
                readonly description: "Representation of Lexicon schemas themselves, when published as atproto records. Note that the schema language is not defined in Lexicon; this meta schema currently only includes a single version field ('lexicon'). See the atproto specifications for description of the other expected top-level fields ('id', 'defs', etc).";
                readonly key: "nsid";
                readonly record: {
                    readonly type: "object";
                    readonly required: ["lexicon"];
                    readonly properties: {
                        readonly lexicon: {
                            readonly type: "integer";
                            readonly description: "Indicates the 'version' of the Lexicon language. Must be '1' for the current atproto/Lexicon schema system.";
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoModerationCreateReport: {
        readonly lexicon: 1;
        readonly id: "com.atproto.moderation.createReport";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Submit a moderation report regarding an atproto account or record. Implemented by moderation services (with PDS proxying), and requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["reasonType", "subject"];
                        readonly properties: {
                            readonly reasonType: {
                                readonly type: "ref";
                                readonly description: "Indicates the broad category of violation the report is for.";
                                readonly ref: "lex:com.atproto.moderation.defs#reasonType";
                            };
                            readonly reason: {
                                readonly type: "string";
                                readonly maxGraphemes: 2000;
                                readonly maxLength: 20000;
                                readonly description: "Additional context about the content and violation.";
                            };
                            readonly subject: {
                                readonly type: "union";
                                readonly refs: ["lex:com.atproto.admin.defs#repoRef", "lex:com.atproto.repo.strongRef"];
                            };
                            readonly modTool: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.moderation.createReport#modTool";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["id", "reasonType", "subject", "reportedBy", "createdAt"];
                        readonly properties: {
                            readonly id: {
                                readonly type: "integer";
                            };
                            readonly reasonType: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.moderation.defs#reasonType";
                            };
                            readonly reason: {
                                readonly type: "string";
                                readonly maxGraphemes: 2000;
                                readonly maxLength: 20000;
                            };
                            readonly subject: {
                                readonly type: "union";
                                readonly refs: ["lex:com.atproto.admin.defs#repoRef", "lex:com.atproto.repo.strongRef"];
                            };
                            readonly reportedBy: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly createdAt: {
                                readonly type: "string";
                                readonly format: "datetime";
                            };
                        };
                    };
                };
            };
            readonly modTool: {
                readonly type: "object";
                readonly description: "Moderation tool information for tracing the source of the action";
                readonly required: ["name"];
                readonly properties: {
                    readonly name: {
                        readonly type: "string";
                        readonly description: "Name/identifier of the source (e.g., 'bsky-app/android', 'bsky-web/chrome')";
                    };
                    readonly meta: {
                        readonly type: "unknown";
                        readonly description: "Additional arbitrary metadata about the source";
                    };
                };
            };
        };
    };
    readonly ComAtprotoModerationDefs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.moderation.defs";
        readonly defs: {
            readonly reasonType: {
                readonly type: "string";
                readonly knownValues: ["com.atproto.moderation.defs#reasonSpam", "com.atproto.moderation.defs#reasonViolation", "com.atproto.moderation.defs#reasonMisleading", "com.atproto.moderation.defs#reasonSexual", "com.atproto.moderation.defs#reasonRude", "com.atproto.moderation.defs#reasonOther", "com.atproto.moderation.defs#reasonAppeal", "tools.ozone.report.defs#reasonAppeal", "tools.ozone.report.defs#reasonOther", "tools.ozone.report.defs#reasonViolenceAnimal", "tools.ozone.report.defs#reasonViolenceThreats", "tools.ozone.report.defs#reasonViolenceGraphicContent", "tools.ozone.report.defs#reasonViolenceGlorification", "tools.ozone.report.defs#reasonViolenceExtremistContent", "tools.ozone.report.defs#reasonViolenceTrafficking", "tools.ozone.report.defs#reasonViolenceOther", "tools.ozone.report.defs#reasonSexualAbuseContent", "tools.ozone.report.defs#reasonSexualNCII", "tools.ozone.report.defs#reasonSexualDeepfake", "tools.ozone.report.defs#reasonSexualAnimal", "tools.ozone.report.defs#reasonSexualUnlabeled", "tools.ozone.report.defs#reasonSexualOther", "tools.ozone.report.defs#reasonChildSafetyCSAM", "tools.ozone.report.defs#reasonChildSafetyGroom", "tools.ozone.report.defs#reasonChildSafetyPrivacy", "tools.ozone.report.defs#reasonChildSafetyHarassment", "tools.ozone.report.defs#reasonChildSafetyOther", "tools.ozone.report.defs#reasonHarassmentTroll", "tools.ozone.report.defs#reasonHarassmentTargeted", "tools.ozone.report.defs#reasonHarassmentHateSpeech", "tools.ozone.report.defs#reasonHarassmentDoxxing", "tools.ozone.report.defs#reasonHarassmentOther", "tools.ozone.report.defs#reasonMisleadingBot", "tools.ozone.report.defs#reasonMisleadingImpersonation", "tools.ozone.report.defs#reasonMisleadingSpam", "tools.ozone.report.defs#reasonMisleadingScam", "tools.ozone.report.defs#reasonMisleadingElections", "tools.ozone.report.defs#reasonMisleadingOther", "tools.ozone.report.defs#reasonRuleSiteSecurity", "tools.ozone.report.defs#reasonRuleProhibitedSales", "tools.ozone.report.defs#reasonRuleBanEvasion", "tools.ozone.report.defs#reasonRuleOther", "tools.ozone.report.defs#reasonSelfHarmContent", "tools.ozone.report.defs#reasonSelfHarmED", "tools.ozone.report.defs#reasonSelfHarmStunts", "tools.ozone.report.defs#reasonSelfHarmSubstances", "tools.ozone.report.defs#reasonSelfHarmOther"];
            };
            readonly reasonSpam: {
                readonly type: "token";
                readonly description: "Spam: frequent unwanted promotion, replies, mentions. Prefer new lexicon definition `tools.ozone.report.defs#reasonMisleadingSpam`.";
            };
            readonly reasonViolation: {
                readonly type: "token";
                readonly description: "Direct violation of server rules, laws, terms of service. Prefer new lexicon definition `tools.ozone.report.defs#reasonRuleOther`.";
            };
            readonly reasonMisleading: {
                readonly type: "token";
                readonly description: "Misleading identity, affiliation, or content. Prefer new lexicon definition `tools.ozone.report.defs#reasonMisleadingOther`.";
            };
            readonly reasonSexual: {
                readonly type: "token";
                readonly description: "Unwanted or mislabeled sexual content. Prefer new lexicon definition `tools.ozone.report.defs#reasonSexualUnlabeled`.";
            };
            readonly reasonRude: {
                readonly type: "token";
                readonly description: "Rude, harassing, explicit, or otherwise unwelcoming behavior. Prefer new lexicon definition `tools.ozone.report.defs#reasonHarassmentOther`.";
            };
            readonly reasonOther: {
                readonly type: "token";
                readonly description: "Reports not falling under another report category. Prefer new lexicon definition `tools.ozone.report.defs#reasonOther`.";
            };
            readonly reasonAppeal: {
                readonly type: "token";
                readonly description: "Appeal a previously taken moderation action";
            };
            readonly subjectType: {
                readonly type: "string";
                readonly description: "Tag describing a type of subject that might be reported.";
                readonly knownValues: ["account", "record", "chat"];
            };
        };
    };
    readonly ComAtprotoRepoApplyWrites: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.applyWrites";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Apply a batch transaction of repository creates, updates, and deletes. Requires auth, implemented by PDS.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["repo", "writes"];
                        readonly properties: {
                            readonly repo: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                                readonly description: "The handle or DID of the repo (aka, current account).";
                            };
                            readonly validate: {
                                readonly type: "boolean";
                                readonly description: "Can be set to 'false' to skip Lexicon schema validation of record data across all operations, 'true' to require it, or leave unset to validate only for known Lexicons.";
                            };
                            readonly writes: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:com.atproto.repo.applyWrites#create", "lex:com.atproto.repo.applyWrites#update", "lex:com.atproto.repo.applyWrites#delete"];
                                    readonly closed: true;
                                };
                            };
                            readonly swapCommit: {
                                readonly type: "string";
                                readonly description: "If provided, the entire operation will fail if the current repo commit CID does not match this value. Used to prevent conflicting repo mutations.";
                                readonly format: "cid";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: [];
                        readonly properties: {
                            readonly commit: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.repo.defs#commitMeta";
                            };
                            readonly results: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:com.atproto.repo.applyWrites#createResult", "lex:com.atproto.repo.applyWrites#updateResult", "lex:com.atproto.repo.applyWrites#deleteResult"];
                                    readonly closed: true;
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidSwap";
                    readonly description: "Indicates that the 'swapCommit' parameter did not match current commit.";
                }];
            };
            readonly create: {
                readonly type: "object";
                readonly description: "Operation which creates a new record.";
                readonly required: ["collection", "value"];
                readonly properties: {
                    readonly collection: {
                        readonly type: "string";
                        readonly format: "nsid";
                    };
                    readonly rkey: {
                        readonly type: "string";
                        readonly maxLength: 512;
                        readonly format: "record-key";
                        readonly description: "NOTE: maxLength is redundant with record-key format. Keeping it temporarily to ensure backwards compatibility.";
                    };
                    readonly value: {
                        readonly type: "unknown";
                    };
                };
            };
            readonly update: {
                readonly type: "object";
                readonly description: "Operation which updates an existing record.";
                readonly required: ["collection", "rkey", "value"];
                readonly properties: {
                    readonly collection: {
                        readonly type: "string";
                        readonly format: "nsid";
                    };
                    readonly rkey: {
                        readonly type: "string";
                        readonly format: "record-key";
                    };
                    readonly value: {
                        readonly type: "unknown";
                    };
                };
            };
            readonly delete: {
                readonly type: "object";
                readonly description: "Operation which deletes an existing record.";
                readonly required: ["collection", "rkey"];
                readonly properties: {
                    readonly collection: {
                        readonly type: "string";
                        readonly format: "nsid";
                    };
                    readonly rkey: {
                        readonly type: "string";
                        readonly format: "record-key";
                    };
                };
            };
            readonly createResult: {
                readonly type: "object";
                readonly required: ["uri", "cid"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly validationStatus: {
                        readonly type: "string";
                        readonly knownValues: ["valid", "unknown"];
                    };
                };
            };
            readonly updateResult: {
                readonly type: "object";
                readonly required: ["uri", "cid"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly validationStatus: {
                        readonly type: "string";
                        readonly knownValues: ["valid", "unknown"];
                    };
                };
            };
            readonly deleteResult: {
                readonly type: "object";
                readonly required: [];
                readonly properties: {};
            };
        };
    };
    readonly ComAtprotoRepoCreateRecord: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.createRecord";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Create a single new repository record. Requires auth, implemented by PDS.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["repo", "collection", "record"];
                        readonly properties: {
                            readonly repo: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                                readonly description: "The handle or DID of the repo (aka, current account).";
                            };
                            readonly collection: {
                                readonly type: "string";
                                readonly format: "nsid";
                                readonly description: "The NSID of the record collection.";
                            };
                            readonly rkey: {
                                readonly type: "string";
                                readonly format: "record-key";
                                readonly description: "The Record Key.";
                                readonly maxLength: 512;
                            };
                            readonly validate: {
                                readonly type: "boolean";
                                readonly description: "Can be set to 'false' to skip Lexicon schema validation of record data, 'true' to require it, or leave unset to validate only for known Lexicons.";
                            };
                            readonly record: {
                                readonly type: "unknown";
                                readonly description: "The record itself. Must contain a $type field.";
                            };
                            readonly swapCommit: {
                                readonly type: "string";
                                readonly format: "cid";
                                readonly description: "Compare and swap with the previous commit by CID.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uri", "cid"];
                        readonly properties: {
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                            readonly commit: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.repo.defs#commitMeta";
                            };
                            readonly validationStatus: {
                                readonly type: "string";
                                readonly knownValues: ["valid", "unknown"];
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidSwap";
                    readonly description: "Indicates that 'swapCommit' didn't match current repo commit.";
                }];
            };
        };
    };
    readonly ComAtprotoRepoDefs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.defs";
        readonly defs: {
            readonly commitMeta: {
                readonly type: "object";
                readonly required: ["cid", "rev"];
                readonly properties: {
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly rev: {
                        readonly type: "string";
                        readonly format: "tid";
                    };
                };
            };
        };
    };
    readonly ComAtprotoRepoDeleteRecord: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.deleteRecord";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete a repository record, or ensure it doesn't exist. Requires auth, implemented by PDS.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["repo", "collection", "rkey"];
                        readonly properties: {
                            readonly repo: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                                readonly description: "The handle or DID of the repo (aka, current account).";
                            };
                            readonly collection: {
                                readonly type: "string";
                                readonly format: "nsid";
                                readonly description: "The NSID of the record collection.";
                            };
                            readonly rkey: {
                                readonly type: "string";
                                readonly format: "record-key";
                                readonly description: "The Record Key.";
                            };
                            readonly swapRecord: {
                                readonly type: "string";
                                readonly format: "cid";
                                readonly description: "Compare and swap with the previous record by CID.";
                            };
                            readonly swapCommit: {
                                readonly type: "string";
                                readonly format: "cid";
                                readonly description: "Compare and swap with the previous commit by CID.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly commit: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.repo.defs#commitMeta";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidSwap";
                }];
            };
        };
    };
    readonly ComAtprotoRepoDescribeRepo: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.describeRepo";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get information about an account and repository, including the list of collections. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["repo"];
                    readonly properties: {
                        readonly repo: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "The handle or DID of the repo.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["handle", "did", "didDoc", "collections", "handleIsCorrect"];
                        readonly properties: {
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                            };
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly didDoc: {
                                readonly type: "unknown";
                                readonly description: "The complete DID document for this account.";
                            };
                            readonly collections: {
                                readonly type: "array";
                                readonly description: "List of all the collections (NSIDs) for which this repo contains at least one record.";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "nsid";
                                };
                            };
                            readonly handleIsCorrect: {
                                readonly type: "boolean";
                                readonly description: "Indicates if handle is currently valid (resolves bi-directionally)";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoRepoGetRecord: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.getRecord";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a single record from a repository. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["repo", "collection", "rkey"];
                    readonly properties: {
                        readonly repo: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "The handle or DID of the repo.";
                        };
                        readonly collection: {
                            readonly type: "string";
                            readonly format: "nsid";
                            readonly description: "The NSID of the record collection.";
                        };
                        readonly rkey: {
                            readonly type: "string";
                            readonly description: "The Record Key.";
                            readonly format: "record-key";
                        };
                        readonly cid: {
                            readonly type: "string";
                            readonly format: "cid";
                            readonly description: "The CID of the version of the record. If not specified, then return the most recent version.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uri", "value"];
                        readonly properties: {
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                            readonly value: {
                                readonly type: "unknown";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "RecordNotFound";
                }];
            };
        };
    };
    readonly ComAtprotoRepoImportRepo: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.importRepo";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Import a repo in the form of a CAR file. Requires Content-Length HTTP header to be set.";
                readonly input: {
                    readonly encoding: "application/vnd.ipld.car";
                };
            };
        };
    };
    readonly ComAtprotoRepoListMissingBlobs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.listMissingBlobs";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Returns a list of missing blobs for the requesting account. Intended to be used in the account migration flow.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 1000;
                            readonly default: 500;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["blobs"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly blobs: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.repo.listMissingBlobs#recordBlob";
                                };
                            };
                        };
                    };
                };
            };
            readonly recordBlob: {
                readonly type: "object";
                readonly required: ["cid", "recordUri"];
                readonly properties: {
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly recordUri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
        };
    };
    readonly ComAtprotoRepoListRecords: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.listRecords";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "List a range of records in a repository, matching a specific collection. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["repo", "collection"];
                    readonly properties: {
                        readonly repo: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                            readonly description: "The handle or DID of the repo.";
                        };
                        readonly collection: {
                            readonly type: "string";
                            readonly format: "nsid";
                            readonly description: "The NSID of the record type.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                            readonly description: "The number of records to return.";
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly reverse: {
                            readonly type: "boolean";
                            readonly description: "Flag to reverse the order of the returned records.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["records"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly records: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.repo.listRecords#record";
                                };
                            };
                        };
                    };
                };
            };
            readonly record: {
                readonly type: "object";
                readonly required: ["uri", "cid", "value"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly value: {
                        readonly type: "unknown";
                    };
                };
            };
        };
    };
    readonly ComAtprotoRepoPutRecord: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.putRecord";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Write a repository record, creating or updating it as needed. Requires auth, implemented by PDS.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["repo", "collection", "rkey", "record"];
                        readonly nullable: ["swapRecord"];
                        readonly properties: {
                            readonly repo: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                                readonly description: "The handle or DID of the repo (aka, current account).";
                            };
                            readonly collection: {
                                readonly type: "string";
                                readonly format: "nsid";
                                readonly description: "The NSID of the record collection.";
                            };
                            readonly rkey: {
                                readonly type: "string";
                                readonly format: "record-key";
                                readonly description: "The Record Key.";
                                readonly maxLength: 512;
                            };
                            readonly validate: {
                                readonly type: "boolean";
                                readonly description: "Can be set to 'false' to skip Lexicon schema validation of record data, 'true' to require it, or leave unset to validate only for known Lexicons.";
                            };
                            readonly record: {
                                readonly type: "unknown";
                                readonly description: "The record to write.";
                            };
                            readonly swapRecord: {
                                readonly type: "string";
                                readonly format: "cid";
                                readonly description: "Compare and swap with the previous record by CID. WARNING: nullable and optional field; may cause problems with golang implementation";
                            };
                            readonly swapCommit: {
                                readonly type: "string";
                                readonly format: "cid";
                                readonly description: "Compare and swap with the previous commit by CID.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uri", "cid"];
                        readonly properties: {
                            readonly uri: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                            readonly commit: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.repo.defs#commitMeta";
                            };
                            readonly validationStatus: {
                                readonly type: "string";
                                readonly knownValues: ["valid", "unknown"];
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidSwap";
                }];
            };
        };
    };
    readonly ComAtprotoRepoStrongRef: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.strongRef";
        readonly description: "A URI with a content-hash fingerprint.";
        readonly defs: {
            readonly main: {
                readonly type: "object";
                readonly required: ["uri", "cid"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                };
            };
        };
    };
    readonly ComAtprotoRepoUploadBlob: {
        readonly lexicon: 1;
        readonly id: "com.atproto.repo.uploadBlob";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Upload a new blob, to be referenced from a repository record. The blob will be deleted if it is not referenced within a time window (eg, minutes). Blob restrictions (mimetype, size, etc) are enforced when the reference is created. Requires auth, implemented by PDS.";
                readonly input: {
                    readonly encoding: "*/*";
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["blob"];
                        readonly properties: {
                            readonly blob: {
                                readonly type: "blob";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerActivateAccount: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.activateAccount";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Activates a currently deactivated account. Used to finalize account migration after the account's repo is imported and identity is setup.";
            };
        };
    };
    readonly ComAtprotoServerCheckAccountStatus: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.checkAccountStatus";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Returns the status of an account, especially as pertaining to import or recovery. Can be called many times over the course of an account migration. Requires auth and can only be called pertaining to oneself.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["activated", "validDid", "repoCommit", "repoRev", "repoBlocks", "indexedRecords", "privateStateValues", "expectedBlobs", "importedBlobs"];
                        readonly properties: {
                            readonly activated: {
                                readonly type: "boolean";
                            };
                            readonly validDid: {
                                readonly type: "boolean";
                            };
                            readonly repoCommit: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                            readonly repoRev: {
                                readonly type: "string";
                            };
                            readonly repoBlocks: {
                                readonly type: "integer";
                            };
                            readonly indexedRecords: {
                                readonly type: "integer";
                            };
                            readonly privateStateValues: {
                                readonly type: "integer";
                            };
                            readonly expectedBlobs: {
                                readonly type: "integer";
                            };
                            readonly importedBlobs: {
                                readonly type: "integer";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerConfirmEmail: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.confirmEmail";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Confirm an email using a token from com.atproto.server.requestEmailConfirmation.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["email", "token"];
                        readonly properties: {
                            readonly email: {
                                readonly type: "string";
                            };
                            readonly token: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "AccountNotFound";
                }, {
                    readonly name: "ExpiredToken";
                }, {
                    readonly name: "InvalidToken";
                }, {
                    readonly name: "InvalidEmail";
                }];
            };
        };
    };
    readonly ComAtprotoServerCreateAccount: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.createAccount";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Create an account. Implemented by PDS.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["handle"];
                        readonly properties: {
                            readonly email: {
                                readonly type: "string";
                            };
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                                readonly description: "Requested handle for the account.";
                            };
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "Pre-existing atproto DID, being imported to a new account.";
                            };
                            readonly inviteCode: {
                                readonly type: "string";
                            };
                            readonly verificationCode: {
                                readonly type: "string";
                            };
                            readonly verificationPhone: {
                                readonly type: "string";
                            };
                            readonly password: {
                                readonly type: "string";
                                readonly description: "Initial account password. May need to meet instance-specific password strength requirements.";
                            };
                            readonly recoveryKey: {
                                readonly type: "string";
                                readonly description: "DID PLC rotation key (aka, recovery key) to be included in PLC creation operation.";
                            };
                            readonly plcOp: {
                                readonly type: "unknown";
                                readonly description: "A signed DID PLC operation to be submitted as part of importing an existing account to this instance. NOTE: this optional field may be updated when full account migration is implemented.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly description: "Account login session returned on successful account creation.";
                        readonly required: ["accessJwt", "refreshJwt", "handle", "did"];
                        readonly properties: {
                            readonly accessJwt: {
                                readonly type: "string";
                            };
                            readonly refreshJwt: {
                                readonly type: "string";
                            };
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                            };
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "The DID of the new account.";
                            };
                            readonly didDoc: {
                                readonly type: "unknown";
                                readonly description: "Complete DID document.";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidHandle";
                }, {
                    readonly name: "InvalidPassword";
                }, {
                    readonly name: "InvalidInviteCode";
                }, {
                    readonly name: "HandleNotAvailable";
                }, {
                    readonly name: "UnsupportedDomain";
                }, {
                    readonly name: "UnresolvableDid";
                }, {
                    readonly name: "IncompatibleDidDoc";
                }];
            };
        };
    };
    readonly ComAtprotoServerCreateAppPassword: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.createAppPassword";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Create an App Password.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["name"];
                        readonly properties: {
                            readonly name: {
                                readonly type: "string";
                                readonly description: "A short name for the App Password, to help distinguish them.";
                            };
                            readonly privileged: {
                                readonly type: "boolean";
                                readonly description: "If an app password has 'privileged' access to possibly sensitive account state. Meant for use with trusted clients.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.server.createAppPassword#appPassword";
                    };
                };
                readonly errors: [{
                    readonly name: "AccountTakedown";
                }];
            };
            readonly appPassword: {
                readonly type: "object";
                readonly required: ["name", "password", "createdAt"];
                readonly properties: {
                    readonly name: {
                        readonly type: "string";
                    };
                    readonly password: {
                        readonly type: "string";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly privileged: {
                        readonly type: "boolean";
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerCreateInviteCode: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.createInviteCode";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Create an invite code.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["useCount"];
                        readonly properties: {
                            readonly useCount: {
                                readonly type: "integer";
                            };
                            readonly forAccount: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["code"];
                        readonly properties: {
                            readonly code: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerCreateInviteCodes: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.createInviteCodes";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Create invite codes.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["codeCount", "useCount"];
                        readonly properties: {
                            readonly codeCount: {
                                readonly type: "integer";
                                readonly default: 1;
                            };
                            readonly useCount: {
                                readonly type: "integer";
                            };
                            readonly forAccounts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "did";
                                };
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["codes"];
                        readonly properties: {
                            readonly codes: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.server.createInviteCodes#accountCodes";
                                };
                            };
                        };
                    };
                };
            };
            readonly accountCodes: {
                readonly type: "object";
                readonly required: ["account", "codes"];
                readonly properties: {
                    readonly account: {
                        readonly type: "string";
                    };
                    readonly codes: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerCreateSession: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.createSession";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Create an authentication session.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["identifier", "password"];
                        readonly properties: {
                            readonly identifier: {
                                readonly type: "string";
                                readonly description: "Handle or other identifier supported by the server for the authenticating user.";
                            };
                            readonly password: {
                                readonly type: "string";
                            };
                            readonly authFactorToken: {
                                readonly type: "string";
                            };
                            readonly allowTakendown: {
                                readonly type: "boolean";
                                readonly description: "When true, instead of throwing error for takendown accounts, a valid response with a narrow scoped token will be returned";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["accessJwt", "refreshJwt", "handle", "did"];
                        readonly properties: {
                            readonly accessJwt: {
                                readonly type: "string";
                            };
                            readonly refreshJwt: {
                                readonly type: "string";
                            };
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                            };
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly didDoc: {
                                readonly type: "unknown";
                            };
                            readonly email: {
                                readonly type: "string";
                            };
                            readonly emailConfirmed: {
                                readonly type: "boolean";
                            };
                            readonly emailAuthFactor: {
                                readonly type: "boolean";
                            };
                            readonly active: {
                                readonly type: "boolean";
                            };
                            readonly status: {
                                readonly type: "string";
                                readonly description: "If active=false, this optional field indicates a possible reason for why the account is not active. If active=false and no status is supplied, then the host makes no claim for why the repository is no longer being hosted.";
                                readonly knownValues: ["takendown", "suspended", "deactivated"];
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "AccountTakedown";
                }, {
                    readonly name: "AuthFactorTokenRequired";
                }];
            };
        };
    };
    readonly ComAtprotoServerDeactivateAccount: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.deactivateAccount";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Deactivates a currently active account. Stops serving of repo, and future writes to repo until reactivated. Used to finalize account migration with the old host after the account has been activated on the new host.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly deleteAfter: {
                                readonly type: "string";
                                readonly format: "datetime";
                                readonly description: "A recommendation to server as to how long they should hold onto the deactivated account before deleting.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerDefs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.defs";
        readonly defs: {
            readonly inviteCode: {
                readonly type: "object";
                readonly required: ["code", "available", "disabled", "forAccount", "createdBy", "createdAt", "uses"];
                readonly properties: {
                    readonly code: {
                        readonly type: "string";
                    };
                    readonly available: {
                        readonly type: "integer";
                    };
                    readonly disabled: {
                        readonly type: "boolean";
                    };
                    readonly forAccount: {
                        readonly type: "string";
                    };
                    readonly createdBy: {
                        readonly type: "string";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly uses: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.server.defs#inviteCodeUse";
                        };
                    };
                };
            };
            readonly inviteCodeUse: {
                readonly type: "object";
                readonly required: ["usedBy", "usedAt"];
                readonly properties: {
                    readonly usedBy: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly usedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerDeleteAccount: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.deleteAccount";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete an actor's account with a token and password. Can only be called after requesting a deletion token. Requires auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did", "password", "token"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly password: {
                                readonly type: "string";
                            };
                            readonly token: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "ExpiredToken";
                }, {
                    readonly name: "InvalidToken";
                }];
            };
        };
    };
    readonly ComAtprotoServerDeleteSession: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.deleteSession";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete the current session. Requires auth.";
            };
        };
    };
    readonly ComAtprotoServerDescribeServer: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.describeServer";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Describes the server's account creation requirements and capabilities. Implemented by PDS.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did", "availableUserDomains"];
                        readonly properties: {
                            readonly inviteCodeRequired: {
                                readonly type: "boolean";
                                readonly description: "If true, an invite code must be supplied to create an account on this instance.";
                            };
                            readonly phoneVerificationRequired: {
                                readonly type: "boolean";
                                readonly description: "If true, a phone verification token must be supplied to create an account on this instance.";
                            };
                            readonly availableUserDomains: {
                                readonly type: "array";
                                readonly description: "List of domain suffixes that can be used in account handles.";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                            readonly links: {
                                readonly type: "ref";
                                readonly description: "URLs of service policy documents.";
                                readonly ref: "lex:com.atproto.server.describeServer#links";
                            };
                            readonly contact: {
                                readonly type: "ref";
                                readonly description: "Contact information";
                                readonly ref: "lex:com.atproto.server.describeServer#contact";
                            };
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
            };
            readonly links: {
                readonly type: "object";
                readonly properties: {
                    readonly privacyPolicy: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly termsOfService: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                };
            };
            readonly contact: {
                readonly type: "object";
                readonly properties: {
                    readonly email: {
                        readonly type: "string";
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerGetAccountInviteCodes: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.getAccountInviteCodes";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get all invite codes for the current account. Requires auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly includeUsed: {
                            readonly type: "boolean";
                            readonly default: true;
                        };
                        readonly createAvailable: {
                            readonly type: "boolean";
                            readonly default: true;
                            readonly description: "Controls whether any new 'earned' but not 'created' invites should be created.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["codes"];
                        readonly properties: {
                            readonly codes: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.server.defs#inviteCode";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "DuplicateCreate";
                }];
            };
        };
    };
    readonly ComAtprotoServerGetServiceAuth: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.getServiceAuth";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a signed token on behalf of the requesting DID for the requested service.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["aud"];
                    readonly properties: {
                        readonly aud: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the service that the token will be used to authenticate with";
                        };
                        readonly exp: {
                            readonly type: "integer";
                            readonly description: "The time in Unix Epoch seconds that the JWT expires. Defaults to 60 seconds in the future. The service may enforce certain time bounds on tokens depending on the requested scope.";
                        };
                        readonly lxm: {
                            readonly type: "string";
                            readonly format: "nsid";
                            readonly description: "Lexicon (XRPC) method to bind the requested token to";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["token"];
                        readonly properties: {
                            readonly token: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "BadExpiration";
                    readonly description: "Indicates that the requested expiration date is not a valid. May be in the past or may be reliant on the requested scopes.";
                }];
            };
        };
    };
    readonly ComAtprotoServerGetSession: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.getSession";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get information about the current auth session. Requires auth.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["handle", "did"];
                        readonly properties: {
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                            };
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly email: {
                                readonly type: "string";
                            };
                            readonly emailConfirmed: {
                                readonly type: "boolean";
                            };
                            readonly emailAuthFactor: {
                                readonly type: "boolean";
                            };
                            readonly didDoc: {
                                readonly type: "unknown";
                            };
                            readonly active: {
                                readonly type: "boolean";
                            };
                            readonly status: {
                                readonly type: "string";
                                readonly description: "If active=false, this optional field indicates a possible reason for why the account is not active. If active=false and no status is supplied, then the host makes no claim for why the repository is no longer being hosted.";
                                readonly knownValues: ["takendown", "suspended", "deactivated"];
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerListAppPasswords: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.listAppPasswords";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "List all App Passwords.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["passwords"];
                        readonly properties: {
                            readonly passwords: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.server.listAppPasswords#appPassword";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "AccountTakedown";
                }];
            };
            readonly appPassword: {
                readonly type: "object";
                readonly required: ["name", "createdAt"];
                readonly properties: {
                    readonly name: {
                        readonly type: "string";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly privileged: {
                        readonly type: "boolean";
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerRefreshSession: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.refreshSession";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Refresh an authentication session. Requires auth using the 'refreshJwt' (not the 'accessJwt').";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["accessJwt", "refreshJwt", "handle", "did"];
                        readonly properties: {
                            readonly accessJwt: {
                                readonly type: "string";
                            };
                            readonly refreshJwt: {
                                readonly type: "string";
                            };
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                            };
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly didDoc: {
                                readonly type: "unknown";
                            };
                            readonly active: {
                                readonly type: "boolean";
                            };
                            readonly status: {
                                readonly type: "string";
                                readonly description: "Hosting status of the account. If not specified, then assume 'active'.";
                                readonly knownValues: ["takendown", "suspended", "deactivated"];
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "AccountTakedown";
                }];
            };
        };
    };
    readonly ComAtprotoServerRequestAccountDelete: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.requestAccountDelete";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Initiate a user account deletion via email.";
            };
        };
    };
    readonly ComAtprotoServerRequestEmailConfirmation: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.requestEmailConfirmation";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Request an email with a code to confirm ownership of email.";
            };
        };
    };
    readonly ComAtprotoServerRequestEmailUpdate: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.requestEmailUpdate";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Request a token in order to update email.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["tokenRequired"];
                        readonly properties: {
                            readonly tokenRequired: {
                                readonly type: "boolean";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerRequestPasswordReset: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.requestPasswordReset";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Initiate a user account password reset via email.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["email"];
                        readonly properties: {
                            readonly email: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerReserveSigningKey: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.reserveSigningKey";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Reserve a repo signing key, for use with account creation. Necessary so that a DID PLC update operation can be constructed during an account migraiton. Public and does not require auth; implemented by PDS. NOTE: this endpoint may change when full account migration is implemented.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "The DID to reserve a key for.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["signingKey"];
                        readonly properties: {
                            readonly signingKey: {
                                readonly type: "string";
                                readonly description: "The public key for the reserved signing key, in did:key serialization.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerResetPassword: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.resetPassword";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Reset a user account password using a token.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["token", "password"];
                        readonly properties: {
                            readonly token: {
                                readonly type: "string";
                            };
                            readonly password: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "ExpiredToken";
                }, {
                    readonly name: "InvalidToken";
                }];
            };
        };
    };
    readonly ComAtprotoServerRevokeAppPassword: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.revokeAppPassword";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Revoke an App Password by name.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["name"];
                        readonly properties: {
                            readonly name: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoServerUpdateEmail: {
        readonly lexicon: 1;
        readonly id: "com.atproto.server.updateEmail";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Update an account's email.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["email"];
                        readonly properties: {
                            readonly email: {
                                readonly type: "string";
                            };
                            readonly emailAuthFactor: {
                                readonly type: "boolean";
                            };
                            readonly token: {
                                readonly type: "string";
                                readonly description: "Requires a token from com.atproto.sever.requestEmailUpdate if the account's email has been confirmed.";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "ExpiredToken";
                }, {
                    readonly name: "InvalidToken";
                }, {
                    readonly name: "TokenRequired";
                }];
            };
        };
    };
    readonly ComAtprotoSyncDefs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.defs";
        readonly defs: {
            readonly hostStatus: {
                readonly type: "string";
                readonly knownValues: ["active", "idle", "offline", "throttled", "banned"];
            };
        };
    };
    readonly ComAtprotoSyncGetBlob: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getBlob";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a blob associated with a given account. Returns the full blob as originally uploaded. Does not require auth; implemented by PDS.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did", "cid"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the account.";
                        };
                        readonly cid: {
                            readonly type: "string";
                            readonly format: "cid";
                            readonly description: "The CID of the blob to fetch";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "*/*";
                };
                readonly errors: [{
                    readonly name: "BlobNotFound";
                }, {
                    readonly name: "RepoNotFound";
                }, {
                    readonly name: "RepoTakendown";
                }, {
                    readonly name: "RepoSuspended";
                }, {
                    readonly name: "RepoDeactivated";
                }];
            };
        };
    };
    readonly ComAtprotoSyncGetBlocks: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getBlocks";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get data blocks from a given repo, by CID. For example, intermediate MST nodes, or records. Does not require auth; implemented by PDS.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did", "cids"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the repo.";
                        };
                        readonly cids: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/vnd.ipld.car";
                };
                readonly errors: [{
                    readonly name: "BlockNotFound";
                }, {
                    readonly name: "RepoNotFound";
                }, {
                    readonly name: "RepoTakendown";
                }, {
                    readonly name: "RepoSuspended";
                }, {
                    readonly name: "RepoDeactivated";
                }];
            };
        };
    };
    readonly ComAtprotoSyncGetCheckout: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getCheckout";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "DEPRECATED - please use com.atproto.sync.getRepo instead";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the repo.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/vnd.ipld.car";
                };
            };
        };
    };
    readonly ComAtprotoSyncGetHead: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getHead";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "DEPRECATED - please use com.atproto.sync.getLatestCommit instead";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the repo.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["root"];
                        readonly properties: {
                            readonly root: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "HeadNotFound";
                }];
            };
        };
    };
    readonly ComAtprotoSyncGetHostStatus: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getHostStatus";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Returns information about a specified upstream host, as consumed by the server. Implemented by relays.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["hostname"];
                    readonly properties: {
                        readonly hostname: {
                            readonly type: "string";
                            readonly description: "Hostname of the host (eg, PDS or relay) being queried.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["hostname"];
                        readonly properties: {
                            readonly hostname: {
                                readonly type: "string";
                            };
                            readonly seq: {
                                readonly type: "integer";
                                readonly description: "Recent repo stream event sequence number. May be delayed from actual stream processing (eg, persisted cursor not in-memory cursor).";
                            };
                            readonly accountCount: {
                                readonly type: "integer";
                                readonly description: "Number of accounts on the server which are associated with the upstream host. Note that the upstream may actually have more accounts.";
                            };
                            readonly status: {
                                readonly type: "ref";
                                readonly ref: "lex:com.atproto.sync.defs#hostStatus";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "HostNotFound";
                }];
            };
        };
    };
    readonly ComAtprotoSyncGetLatestCommit: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getLatestCommit";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get the current commit CID & revision of the specified repo. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the repo.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["cid", "rev"];
                        readonly properties: {
                            readonly cid: {
                                readonly type: "string";
                                readonly format: "cid";
                            };
                            readonly rev: {
                                readonly type: "string";
                                readonly format: "tid";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "RepoNotFound";
                }, {
                    readonly name: "RepoTakendown";
                }, {
                    readonly name: "RepoSuspended";
                }, {
                    readonly name: "RepoDeactivated";
                }];
            };
        };
    };
    readonly ComAtprotoSyncGetRecord: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getRecord";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get data blocks needed to prove the existence or non-existence of record in the current version of repo. Does not require auth.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did", "collection", "rkey"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the repo.";
                        };
                        readonly collection: {
                            readonly type: "string";
                            readonly format: "nsid";
                        };
                        readonly rkey: {
                            readonly type: "string";
                            readonly description: "Record Key";
                            readonly format: "record-key";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/vnd.ipld.car";
                };
                readonly errors: [{
                    readonly name: "RecordNotFound";
                }, {
                    readonly name: "RepoNotFound";
                }, {
                    readonly name: "RepoTakendown";
                }, {
                    readonly name: "RepoSuspended";
                }, {
                    readonly name: "RepoDeactivated";
                }];
            };
        };
    };
    readonly ComAtprotoSyncGetRepo: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getRepo";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Download a repository export as CAR file. Optionally only a 'diff' since a previous revision. Does not require auth; implemented by PDS.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the repo.";
                        };
                        readonly since: {
                            readonly type: "string";
                            readonly format: "tid";
                            readonly description: "The revision ('rev') of the repo to create a diff from.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/vnd.ipld.car";
                };
                readonly errors: [{
                    readonly name: "RepoNotFound";
                }, {
                    readonly name: "RepoTakendown";
                }, {
                    readonly name: "RepoSuspended";
                }, {
                    readonly name: "RepoDeactivated";
                }];
            };
        };
    };
    readonly ComAtprotoSyncGetRepoStatus: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.getRepoStatus";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get the hosting status for a repository, on this server. Expected to be implemented by PDS and Relay.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the repo.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did", "active"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly active: {
                                readonly type: "boolean";
                            };
                            readonly status: {
                                readonly type: "string";
                                readonly description: "If active=false, this optional field indicates a possible reason for why the account is not active. If active=false and no status is supplied, then the host makes no claim for why the repository is no longer being hosted.";
                                readonly knownValues: ["takendown", "suspended", "deleted", "deactivated", "desynchronized", "throttled"];
                            };
                            readonly rev: {
                                readonly type: "string";
                                readonly format: "tid";
                                readonly description: "Optional field, the current rev of the repo, if active=true";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "RepoNotFound";
                }];
            };
        };
    };
    readonly ComAtprotoSyncListBlobs: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.listBlobs";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "List blob CIDs for an account, since some repo revision. Does not require auth; implemented by PDS.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "The DID of the repo.";
                        };
                        readonly since: {
                            readonly type: "string";
                            readonly format: "tid";
                            readonly description: "Optional revision of the repo to list blobs since.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 1000;
                            readonly default: 500;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["cids"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly cids: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "cid";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "RepoNotFound";
                }, {
                    readonly name: "RepoTakendown";
                }, {
                    readonly name: "RepoSuspended";
                }, {
                    readonly name: "RepoDeactivated";
                }];
            };
        };
    };
    readonly ComAtprotoSyncListHosts: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.listHosts";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates upstream hosts (eg, PDS or relay instances) that this service consumes from. Implemented by relays.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 1000;
                            readonly default: 200;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["hosts"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly hosts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.sync.listHosts#host";
                                };
                                readonly description: "Sort order is not formally specified. Recommended order is by time host was first seen by the server, with oldest first.";
                            };
                        };
                    };
                };
            };
            readonly host: {
                readonly type: "object";
                readonly required: ["hostname"];
                readonly properties: {
                    readonly hostname: {
                        readonly type: "string";
                        readonly description: "hostname of server; not a URL (no scheme)";
                    };
                    readonly seq: {
                        readonly type: "integer";
                        readonly description: "Recent repo stream event sequence number. May be delayed from actual stream processing (eg, persisted cursor not in-memory cursor).";
                    };
                    readonly accountCount: {
                        readonly type: "integer";
                    };
                    readonly status: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.sync.defs#hostStatus";
                    };
                };
            };
        };
    };
    readonly ComAtprotoSyncListRepos: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.listRepos";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates all the DID, rev, and commit CID for all repos hosted by this service. Does not require auth; implemented by PDS and Relay.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 1000;
                            readonly default: 500;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["repos"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly repos: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.sync.listRepos#repo";
                                };
                            };
                        };
                    };
                };
            };
            readonly repo: {
                readonly type: "object";
                readonly required: ["did", "head", "rev"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly head: {
                        readonly type: "string";
                        readonly format: "cid";
                        readonly description: "Current repo commit CID";
                    };
                    readonly rev: {
                        readonly type: "string";
                        readonly format: "tid";
                    };
                    readonly active: {
                        readonly type: "boolean";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly description: "If active=false, this optional field indicates a possible reason for why the account is not active. If active=false and no status is supplied, then the host makes no claim for why the repository is no longer being hosted.";
                        readonly knownValues: ["takendown", "suspended", "deleted", "deactivated", "desynchronized", "throttled"];
                    };
                };
            };
        };
    };
    readonly ComAtprotoSyncListReposByCollection: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.listReposByCollection";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Enumerates all the DIDs which have records with the given collection NSID.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["collection"];
                    readonly properties: {
                        readonly collection: {
                            readonly type: "string";
                            readonly format: "nsid";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly description: "Maximum size of response set. Recommend setting a large maximum (1000+) when enumerating large DID lists.";
                            readonly minimum: 1;
                            readonly maximum: 2000;
                            readonly default: 500;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["repos"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly repos: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.sync.listReposByCollection#repo";
                                };
                            };
                        };
                    };
                };
            };
            readonly repo: {
                readonly type: "object";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
        };
    };
    readonly ComAtprotoSyncNotifyOfUpdate: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.notifyOfUpdate";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Notify a crawling service of a recent update, and that crawling should resume. Intended use is after a gap between repo stream events caused the crawling service to disconnect. Does not require auth; implemented by Relay. DEPRECATED: just use com.atproto.sync.requestCrawl";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["hostname"];
                        readonly properties: {
                            readonly hostname: {
                                readonly type: "string";
                                readonly description: "Hostname of the current service (usually a PDS) that is notifying of update.";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoSyncRequestCrawl: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.requestCrawl";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Request a service to persistently crawl hosted repos. Expected use is new PDS instances declaring their existence to Relays. Does not require auth.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["hostname"];
                        readonly properties: {
                            readonly hostname: {
                                readonly type: "string";
                                readonly description: "Hostname of the current service (eg, PDS) that is requesting to be crawled.";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "HostBanned";
                }];
            };
        };
    };
    readonly ComAtprotoSyncSubscribeRepos: {
        readonly lexicon: 1;
        readonly id: "com.atproto.sync.subscribeRepos";
        readonly defs: {
            readonly main: {
                readonly type: "subscription";
                readonly description: "Repository event stream, aka Firehose endpoint. Outputs repo commits with diff data, and identity update events, for all repositories on the current server. See the atproto specifications for details around stream sequencing, repo versioning, CAR diff format, and more. Public and does not require auth; implemented by PDS and Relay.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "integer";
                            readonly description: "The last known event seq number to backfill from.";
                        };
                    };
                };
                readonly message: {
                    readonly schema: {
                        readonly type: "union";
                        readonly refs: ["lex:com.atproto.sync.subscribeRepos#commit", "lex:com.atproto.sync.subscribeRepos#sync", "lex:com.atproto.sync.subscribeRepos#identity", "lex:com.atproto.sync.subscribeRepos#account", "lex:com.atproto.sync.subscribeRepos#info"];
                    };
                };
                readonly errors: [{
                    readonly name: "FutureCursor";
                }, {
                    readonly name: "ConsumerTooSlow";
                    readonly description: "If the consumer of the stream can not keep up with events, and a backlog gets too large, the server will drop the connection.";
                }];
            };
            readonly commit: {
                readonly type: "object";
                readonly description: "Represents an update of repository state. Note that empty commits are allowed, which include no repo data changes, but an update to rev and signature.";
                readonly required: ["seq", "rebase", "tooBig", "repo", "commit", "rev", "since", "blocks", "ops", "blobs", "time"];
                readonly nullable: ["since"];
                readonly properties: {
                    readonly seq: {
                        readonly type: "integer";
                        readonly description: "The stream sequence number of this message.";
                    };
                    readonly rebase: {
                        readonly type: "boolean";
                        readonly description: "DEPRECATED -- unused";
                    };
                    readonly tooBig: {
                        readonly type: "boolean";
                        readonly description: "DEPRECATED -- replaced by #sync event and data limits. Indicates that this commit contained too many ops, or data size was too large. Consumers will need to make a separate request to get missing data.";
                    };
                    readonly repo: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "The repo this event comes from. Note that all other message types name this field 'did'.";
                    };
                    readonly commit: {
                        readonly type: "cid-link";
                        readonly description: "Repo commit object CID.";
                    };
                    readonly rev: {
                        readonly type: "string";
                        readonly format: "tid";
                        readonly description: "The rev of the emitted commit. Note that this information is also in the commit object included in blocks, unless this is a tooBig event.";
                    };
                    readonly since: {
                        readonly type: "string";
                        readonly format: "tid";
                        readonly description: "The rev of the last emitted commit from this repo (if any).";
                    };
                    readonly blocks: {
                        readonly type: "bytes";
                        readonly description: "CAR file containing relevant blocks, as a diff since the previous repo state. The commit must be included as a block, and the commit block CID must be the first entry in the CAR header 'roots' list.";
                        readonly maxLength: 2000000;
                    };
                    readonly ops: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.sync.subscribeRepos#repoOp";
                            readonly description: "List of repo mutation operations in this commit (eg, records created, updated, or deleted).";
                        };
                        readonly maxLength: 200;
                    };
                    readonly blobs: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "cid-link";
                            readonly description: "DEPRECATED -- will soon always be empty. List of new blobs (by CID) referenced by records in this commit.";
                        };
                    };
                    readonly prevData: {
                        readonly type: "cid-link";
                        readonly description: "The root CID of the MST tree for the previous commit from this repo (indicated by the 'since' revision field in this message). Corresponds to the 'data' field in the repo commit object. NOTE: this field is effectively required for the 'inductive' version of firehose.";
                    };
                    readonly time: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp of when this message was originally broadcast.";
                    };
                };
            };
            readonly sync: {
                readonly type: "object";
                readonly description: "Updates the repo to a new state, without necessarily including that state on the firehose. Used to recover from broken commit streams, data loss incidents, or in situations where upstream host does not know recent state of the repository.";
                readonly required: ["seq", "did", "blocks", "rev", "time"];
                readonly properties: {
                    readonly seq: {
                        readonly type: "integer";
                        readonly description: "The stream sequence number of this message.";
                    };
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "The account this repo event corresponds to. Must match that in the commit object.";
                    };
                    readonly blocks: {
                        readonly type: "bytes";
                        readonly description: "CAR file containing the commit, as a block. The CAR header must include the commit block CID as the first 'root'.";
                        readonly maxLength: 10000;
                    };
                    readonly rev: {
                        readonly type: "string";
                        readonly description: "The rev of the commit. This value must match that in the commit object.";
                    };
                    readonly time: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp of when this message was originally broadcast.";
                    };
                };
            };
            readonly identity: {
                readonly type: "object";
                readonly description: "Represents a change to an account's identity. Could be an updated handle, signing key, or pds hosting endpoint. Serves as a prod to all downstream services to refresh their identity cache.";
                readonly required: ["seq", "did", "time"];
                readonly properties: {
                    readonly seq: {
                        readonly type: "integer";
                    };
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly time: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                        readonly description: "The current handle for the account, or 'handle.invalid' if validation fails. This field is optional, might have been validated or passed-through from an upstream source. Semantics and behaviors for PDS vs Relay may evolve in the future; see atproto specs for more details.";
                    };
                };
            };
            readonly account: {
                readonly type: "object";
                readonly description: "Represents a change to an account's status on a host (eg, PDS or Relay). The semantics of this event are that the status is at the host which emitted the event, not necessarily that at the currently active PDS. Eg, a Relay takedown would emit a takedown with active=false, even if the PDS is still active.";
                readonly required: ["seq", "did", "time", "active"];
                readonly properties: {
                    readonly seq: {
                        readonly type: "integer";
                    };
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly time: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly active: {
                        readonly type: "boolean";
                        readonly description: "Indicates that the account has a repository which can be fetched from the host that emitted this event.";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly description: "If active=false, this optional field indicates a reason for why the account is not active.";
                        readonly knownValues: ["takendown", "suspended", "deleted", "deactivated", "desynchronized", "throttled"];
                    };
                };
            };
            readonly info: {
                readonly type: "object";
                readonly required: ["name"];
                readonly properties: {
                    readonly name: {
                        readonly type: "string";
                        readonly knownValues: ["OutdatedCursor"];
                    };
                    readonly message: {
                        readonly type: "string";
                    };
                };
            };
            readonly repoOp: {
                readonly type: "object";
                readonly description: "A repo operation, ie a mutation of a single record.";
                readonly required: ["action", "path", "cid"];
                readonly nullable: ["cid"];
                readonly properties: {
                    readonly action: {
                        readonly type: "string";
                        readonly knownValues: ["create", "update", "delete"];
                    };
                    readonly path: {
                        readonly type: "string";
                    };
                    readonly cid: {
                        readonly type: "cid-link";
                        readonly description: "For creates and updates, the new record CID. For deletions, null.";
                    };
                    readonly prev: {
                        readonly type: "cid-link";
                        readonly description: "For updates and deletes, the previous record CID (required for inductive firehose). For creations, field should not be defined.";
                    };
                };
            };
        };
    };
    readonly ComAtprotoTempAddReservedHandle: {
        readonly lexicon: 1;
        readonly id: "com.atproto.temp.addReservedHandle";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Add a handle to the set of reserved handles.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["handle"];
                        readonly properties: {
                            readonly handle: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
            };
        };
    };
    readonly ComAtprotoTempCheckHandleAvailability: {
        readonly lexicon: 1;
        readonly id: "com.atproto.temp.checkHandleAvailability";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Checks whether the provided handle is available. If the handle is not available, available suggestions will be returned. Optional inputs will be used to generate suggestions.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["handle"];
                    readonly properties: {
                        readonly handle: {
                            readonly type: "string";
                            readonly format: "handle";
                            readonly description: "Tentative handle. Will be checked for availability or used to build handle suggestions.";
                        };
                        readonly email: {
                            readonly type: "string";
                            readonly description: "User-provided email. Might be used to build handle suggestions.";
                        };
                        readonly birthDate: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "User-provided birth date. Might be used to build handle suggestions.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["handle", "result"];
                        readonly properties: {
                            readonly handle: {
                                readonly type: "string";
                                readonly format: "handle";
                                readonly description: "Echo of the input handle.";
                            };
                            readonly result: {
                                readonly type: "union";
                                readonly refs: ["lex:com.atproto.temp.checkHandleAvailability#resultAvailable", "lex:com.atproto.temp.checkHandleAvailability#resultUnavailable"];
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidEmail";
                    readonly description: "An invalid email was provided.";
                }];
            };
            readonly resultAvailable: {
                readonly type: "object";
                readonly description: "Indicates the provided handle is available.";
                readonly properties: {};
            };
            readonly resultUnavailable: {
                readonly type: "object";
                readonly description: "Indicates the provided handle is unavailable and gives suggestions of available handles.";
                readonly required: ["suggestions"];
                readonly properties: {
                    readonly suggestions: {
                        readonly type: "array";
                        readonly description: "List of suggested handles based on the provided inputs.";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.temp.checkHandleAvailability#suggestion";
                        };
                    };
                };
            };
            readonly suggestion: {
                readonly type: "object";
                readonly required: ["handle", "method"];
                readonly properties: {
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly method: {
                        readonly type: "string";
                        readonly description: "Method used to build this suggestion. Should be considered opaque to clients. Can be used for metrics.";
                    };
                };
            };
        };
    };
    readonly ComAtprotoTempCheckSignupQueue: {
        readonly lexicon: 1;
        readonly id: "com.atproto.temp.checkSignupQueue";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Check accounts location in signup queue.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["activated"];
                        readonly properties: {
                            readonly activated: {
                                readonly type: "boolean";
                            };
                            readonly placeInQueue: {
                                readonly type: "integer";
                            };
                            readonly estimatedTimeMs: {
                                readonly type: "integer";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoTempDereferenceScope: {
        readonly lexicon: 1;
        readonly id: "com.atproto.temp.dereferenceScope";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Allows finding the oauth permission scope from a reference";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["scope"];
                    readonly properties: {
                        readonly scope: {
                            readonly type: "string";
                            readonly description: "The scope reference (starts with 'ref:')";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["scope"];
                        readonly properties: {
                            readonly scope: {
                                readonly type: "string";
                                readonly description: "The full oauth permission scope";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidScopeReference";
                    readonly description: "An invalid scope reference was provided.";
                }];
            };
        };
    };
    readonly ComAtprotoTempFetchLabels: {
        readonly lexicon: 1;
        readonly id: "com.atproto.temp.fetchLabels";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "DEPRECATED: use queryLabels or subscribeLabels instead -- Fetch all labels from a labeler created after a certain date.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly since: {
                            readonly type: "integer";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 250;
                            readonly default: 50;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["labels"];
                        readonly properties: {
                            readonly labels: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.label.defs#label";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoTempRequestPhoneVerification: {
        readonly lexicon: 1;
        readonly id: "com.atproto.temp.requestPhoneVerification";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Request a verification code to be sent to the supplied phone number";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["phoneNumber"];
                        readonly properties: {
                            readonly phoneNumber: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ComAtprotoTempRevokeAccountCredentials: {
        readonly lexicon: 1;
        readonly id: "com.atproto.temp.revokeAccountCredentials";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Revoke sessions, password, and app passwords associated with account. May be resolved by a password reset.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["account"];
                        readonly properties: {
                            readonly account: {
                                readonly type: "string";
                                readonly format: "at-identifier";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneCommunicationCreateTemplate: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.communication.createTemplate";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Administrative action to create a new, re-usable communication (email for now) template.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subject", "contentMarkdown", "name"];
                        readonly properties: {
                            readonly name: {
                                readonly type: "string";
                                readonly description: "Name of the template.";
                            };
                            readonly contentMarkdown: {
                                readonly type: "string";
                                readonly description: "Content of the template, markdown supported, can contain variable placeholders.";
                            };
                            readonly subject: {
                                readonly type: "string";
                                readonly description: "Subject of the message, used in emails.";
                            };
                            readonly lang: {
                                readonly type: "string";
                                readonly format: "language";
                                readonly description: "Message language.";
                            };
                            readonly createdBy: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "DID of the user who is creating the template.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.communication.defs#templateView";
                    };
                };
                readonly errors: [{
                    readonly name: "DuplicateTemplateName";
                }];
            };
        };
    };
    readonly ToolsOzoneCommunicationDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.communication.defs";
        readonly defs: {
            readonly templateView: {
                readonly type: "object";
                readonly required: ["id", "name", "contentMarkdown", "disabled", "lastUpdatedBy", "createdAt", "updatedAt"];
                readonly properties: {
                    readonly id: {
                        readonly type: "string";
                    };
                    readonly name: {
                        readonly type: "string";
                        readonly description: "Name of the template.";
                    };
                    readonly subject: {
                        readonly type: "string";
                        readonly description: "Content of the template, can contain markdown and variable placeholders.";
                    };
                    readonly contentMarkdown: {
                        readonly type: "string";
                        readonly description: "Subject of the message, used in emails.";
                    };
                    readonly disabled: {
                        readonly type: "boolean";
                    };
                    readonly lang: {
                        readonly type: "string";
                        readonly format: "language";
                        readonly description: "Message language.";
                    };
                    readonly lastUpdatedBy: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "DID of the user who last updated the template.";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneCommunicationDeleteTemplate: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.communication.deleteTemplate";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete a communication template.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["id"];
                        readonly properties: {
                            readonly id: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneCommunicationListTemplates: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.communication.listTemplates";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get list of all communication templates.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["communicationTemplates"];
                        readonly properties: {
                            readonly communicationTemplates: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.communication.defs#templateView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneCommunicationUpdateTemplate: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.communication.updateTemplate";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Administrative action to update an existing communication template. Allows passing partial fields to patch specific fields only.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["id"];
                        readonly properties: {
                            readonly id: {
                                readonly type: "string";
                                readonly description: "ID of the template to be updated.";
                            };
                            readonly name: {
                                readonly type: "string";
                                readonly description: "Name of the template.";
                            };
                            readonly lang: {
                                readonly type: "string";
                                readonly format: "language";
                                readonly description: "Message language.";
                            };
                            readonly contentMarkdown: {
                                readonly type: "string";
                                readonly description: "Content of the template, markdown supported, can contain variable placeholders.";
                            };
                            readonly subject: {
                                readonly type: "string";
                                readonly description: "Subject of the message, used in emails.";
                            };
                            readonly updatedBy: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "DID of the user who is updating the template.";
                            };
                            readonly disabled: {
                                readonly type: "boolean";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.communication.defs#templateView";
                    };
                };
                readonly errors: [{
                    readonly name: "DuplicateTemplateName";
                }];
            };
        };
    };
    readonly ToolsOzoneHostingGetAccountHistory: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.hosting.getAccountHistory";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get account history, e.g. log of updated email addresses or other identity information.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly events: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly knownValues: ["accountCreated", "emailUpdated", "emailConfirmed", "passwordUpdated", "handleUpdated"];
                            };
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["events"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly events: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.hosting.getAccountHistory#event";
                                };
                            };
                        };
                    };
                };
            };
            readonly event: {
                readonly type: "object";
                readonly required: ["details", "createdBy", "createdAt"];
                readonly properties: {
                    readonly details: {
                        readonly type: "union";
                        readonly refs: ["lex:tools.ozone.hosting.getAccountHistory#accountCreated", "lex:tools.ozone.hosting.getAccountHistory#emailUpdated", "lex:tools.ozone.hosting.getAccountHistory#emailConfirmed", "lex:tools.ozone.hosting.getAccountHistory#passwordUpdated", "lex:tools.ozone.hosting.getAccountHistory#handleUpdated"];
                    };
                    readonly createdBy: {
                        readonly type: "string";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly accountCreated: {
                readonly type: "object";
                readonly required: [];
                readonly properties: {
                    readonly email: {
                        readonly type: "string";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                };
            };
            readonly emailUpdated: {
                readonly type: "object";
                readonly required: ["email"];
                readonly properties: {
                    readonly email: {
                        readonly type: "string";
                    };
                };
            };
            readonly emailConfirmed: {
                readonly type: "object";
                readonly required: ["email"];
                readonly properties: {
                    readonly email: {
                        readonly type: "string";
                    };
                };
            };
            readonly passwordUpdated: {
                readonly type: "object";
                readonly required: [];
                readonly properties: {};
            };
            readonly handleUpdated: {
                readonly type: "object";
                readonly required: ["handle"];
                readonly properties: {
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationCancelScheduledActions: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.cancelScheduledActions";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Cancel all pending scheduled moderation actions for specified subjects";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subjects"];
                        readonly properties: {
                            readonly subjects: {
                                readonly type: "array";
                                readonly maxLength: 100;
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "did";
                                };
                                readonly description: "Array of DID subjects to cancel scheduled actions for";
                            };
                            readonly comment: {
                                readonly type: "string";
                                readonly description: "Optional comment describing the reason for cancellation";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.cancelScheduledActions#cancellationResults";
                    };
                };
            };
            readonly cancellationResults: {
                readonly type: "object";
                readonly required: ["succeeded", "failed"];
                readonly properties: {
                    readonly succeeded: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly description: "DIDs for which all pending scheduled actions were successfully cancelled";
                    };
                    readonly failed: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:tools.ozone.moderation.cancelScheduledActions#failedCancellation";
                        };
                        readonly description: "DIDs for which cancellation failed with error details";
                    };
                };
            };
            readonly failedCancellation: {
                readonly type: "object";
                readonly required: ["did", "error"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly error: {
                        readonly type: "string";
                    };
                    readonly errorCode: {
                        readonly type: "string";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.defs";
        readonly defs: {
            readonly modEventView: {
                readonly type: "object";
                readonly required: ["id", "event", "subject", "subjectBlobCids", "createdBy", "createdAt"];
                readonly properties: {
                    readonly id: {
                        readonly type: "integer";
                    };
                    readonly event: {
                        readonly type: "union";
                        readonly refs: ["lex:tools.ozone.moderation.defs#modEventTakedown", "lex:tools.ozone.moderation.defs#modEventReverseTakedown", "lex:tools.ozone.moderation.defs#modEventComment", "lex:tools.ozone.moderation.defs#modEventReport", "lex:tools.ozone.moderation.defs#modEventLabel", "lex:tools.ozone.moderation.defs#modEventAcknowledge", "lex:tools.ozone.moderation.defs#modEventEscalate", "lex:tools.ozone.moderation.defs#modEventMute", "lex:tools.ozone.moderation.defs#modEventUnmute", "lex:tools.ozone.moderation.defs#modEventMuteReporter", "lex:tools.ozone.moderation.defs#modEventUnmuteReporter", "lex:tools.ozone.moderation.defs#modEventEmail", "lex:tools.ozone.moderation.defs#modEventResolveAppeal", "lex:tools.ozone.moderation.defs#modEventDivert", "lex:tools.ozone.moderation.defs#modEventTag", "lex:tools.ozone.moderation.defs#accountEvent", "lex:tools.ozone.moderation.defs#identityEvent", "lex:tools.ozone.moderation.defs#recordEvent", "lex:tools.ozone.moderation.defs#modEventPriorityScore", "lex:tools.ozone.moderation.defs#ageAssuranceEvent", "lex:tools.ozone.moderation.defs#ageAssuranceOverrideEvent", "lex:tools.ozone.moderation.defs#revokeAccountCredentialsEvent", "lex:tools.ozone.moderation.defs#scheduleTakedownEvent", "lex:tools.ozone.moderation.defs#cancelScheduledTakedownEvent"];
                    };
                    readonly subject: {
                        readonly type: "union";
                        readonly refs: ["lex:com.atproto.admin.defs#repoRef", "lex:com.atproto.repo.strongRef", "lex:chat.bsky.convo.defs#messageRef"];
                    };
                    readonly subjectBlobCids: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                        };
                    };
                    readonly createdBy: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly creatorHandle: {
                        readonly type: "string";
                    };
                    readonly subjectHandle: {
                        readonly type: "string";
                    };
                    readonly modTool: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#modTool";
                    };
                };
            };
            readonly modEventViewDetail: {
                readonly type: "object";
                readonly required: ["id", "event", "subject", "subjectBlobs", "createdBy", "createdAt"];
                readonly properties: {
                    readonly id: {
                        readonly type: "integer";
                    };
                    readonly event: {
                        readonly type: "union";
                        readonly refs: ["lex:tools.ozone.moderation.defs#modEventTakedown", "lex:tools.ozone.moderation.defs#modEventReverseTakedown", "lex:tools.ozone.moderation.defs#modEventComment", "lex:tools.ozone.moderation.defs#modEventReport", "lex:tools.ozone.moderation.defs#modEventLabel", "lex:tools.ozone.moderation.defs#modEventAcknowledge", "lex:tools.ozone.moderation.defs#modEventEscalate", "lex:tools.ozone.moderation.defs#modEventMute", "lex:tools.ozone.moderation.defs#modEventUnmute", "lex:tools.ozone.moderation.defs#modEventMuteReporter", "lex:tools.ozone.moderation.defs#modEventUnmuteReporter", "lex:tools.ozone.moderation.defs#modEventEmail", "lex:tools.ozone.moderation.defs#modEventResolveAppeal", "lex:tools.ozone.moderation.defs#modEventDivert", "lex:tools.ozone.moderation.defs#modEventTag", "lex:tools.ozone.moderation.defs#accountEvent", "lex:tools.ozone.moderation.defs#identityEvent", "lex:tools.ozone.moderation.defs#recordEvent", "lex:tools.ozone.moderation.defs#modEventPriorityScore", "lex:tools.ozone.moderation.defs#ageAssuranceEvent", "lex:tools.ozone.moderation.defs#ageAssuranceOverrideEvent", "lex:tools.ozone.moderation.defs#revokeAccountCredentialsEvent", "lex:tools.ozone.moderation.defs#scheduleTakedownEvent", "lex:tools.ozone.moderation.defs#cancelScheduledTakedownEvent"];
                    };
                    readonly subject: {
                        readonly type: "union";
                        readonly refs: ["lex:tools.ozone.moderation.defs#repoView", "lex:tools.ozone.moderation.defs#repoViewNotFound", "lex:tools.ozone.moderation.defs#recordView", "lex:tools.ozone.moderation.defs#recordViewNotFound"];
                    };
                    readonly subjectBlobs: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:tools.ozone.moderation.defs#blobView";
                        };
                    };
                    readonly createdBy: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly modTool: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#modTool";
                    };
                };
            };
            readonly subjectStatusView: {
                readonly type: "object";
                readonly required: ["id", "subject", "createdAt", "updatedAt", "reviewState"];
                readonly properties: {
                    readonly id: {
                        readonly type: "integer";
                    };
                    readonly subject: {
                        readonly type: "union";
                        readonly refs: ["lex:com.atproto.admin.defs#repoRef", "lex:com.atproto.repo.strongRef", "lex:chat.bsky.convo.defs#messageRef"];
                    };
                    readonly hosting: {
                        readonly type: "union";
                        readonly refs: ["lex:tools.ozone.moderation.defs#accountHosting", "lex:tools.ozone.moderation.defs#recordHosting"];
                    };
                    readonly subjectBlobCids: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "cid";
                        };
                    };
                    readonly subjectRepoHandle: {
                        readonly type: "string";
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp referencing when the last update was made to the moderation status of the subject";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp referencing the first moderation status impacting event was emitted on the subject";
                    };
                    readonly reviewState: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#subjectReviewState";
                    };
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Sticky comment on the subject.";
                    };
                    readonly priorityScore: {
                        readonly type: "integer";
                        readonly description: "Numeric value representing the level of priority. Higher score means higher priority.";
                        readonly minimum: 0;
                        readonly maximum: 100;
                    };
                    readonly muteUntil: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly muteReportingUntil: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly lastReviewedBy: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly lastReviewedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly lastReportedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly lastAppealedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp referencing when the author of the subject appealed a moderation action";
                    };
                    readonly takendown: {
                        readonly type: "boolean";
                    };
                    readonly appealed: {
                        readonly type: "boolean";
                        readonly description: "True indicates that the a previously taken moderator action was appealed against, by the author of the content. False indicates last appeal was resolved by moderators.";
                    };
                    readonly suspendUntil: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly tags: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                        };
                    };
                    readonly accountStats: {
                        readonly description: "Statistics related to the account subject";
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#accountStats";
                    };
                    readonly recordsStats: {
                        readonly description: "Statistics related to the record subjects authored by the subject's account";
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#recordsStats";
                    };
                    readonly accountStrike: {
                        readonly description: "Strike information for the account (account-level only)";
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#accountStrike";
                    };
                    readonly ageAssuranceState: {
                        readonly type: "string";
                        readonly description: "Current age assurance state of the subject.";
                        readonly knownValues: ["pending", "assured", "unknown", "reset", "blocked"];
                    };
                    readonly ageAssuranceUpdatedBy: {
                        readonly type: "string";
                        readonly description: "Whether or not the last successful update to age assurance was made by the user or admin.";
                        readonly knownValues: ["admin", "user"];
                    };
                };
            };
            readonly subjectView: {
                readonly description: "Detailed view of a subject. For record subjects, the author's repo and profile will be returned.";
                readonly type: "object";
                readonly required: ["type", "subject"];
                readonly properties: {
                    readonly type: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.moderation.defs#subjectType";
                    };
                    readonly subject: {
                        readonly type: "string";
                    };
                    readonly status: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#subjectStatusView";
                    };
                    readonly repo: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#repoViewDetail";
                    };
                    readonly profile: {
                        readonly type: "union";
                        readonly refs: [];
                    };
                    readonly record: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#recordViewDetail";
                    };
                };
            };
            readonly accountStats: {
                readonly description: "Statistics about a particular account subject";
                readonly type: "object";
                readonly properties: {
                    readonly reportCount: {
                        readonly description: "Total number of reports on the account";
                        readonly type: "integer";
                    };
                    readonly appealCount: {
                        readonly description: "Total number of appeals against a moderation action on the account";
                        readonly type: "integer";
                    };
                    readonly suspendCount: {
                        readonly description: "Number of times the account was suspended";
                        readonly type: "integer";
                    };
                    readonly escalateCount: {
                        readonly description: "Number of times the account was escalated";
                        readonly type: "integer";
                    };
                    readonly takedownCount: {
                        readonly description: "Number of times the account was taken down";
                        readonly type: "integer";
                    };
                };
            };
            readonly recordsStats: {
                readonly description: "Statistics about a set of record subject items";
                readonly type: "object";
                readonly properties: {
                    readonly totalReports: {
                        readonly description: "Cumulative sum of the number of reports on the items in the set";
                        readonly type: "integer";
                    };
                    readonly reportedCount: {
                        readonly description: "Number of items that were reported at least once";
                        readonly type: "integer";
                    };
                    readonly escalatedCount: {
                        readonly description: "Number of items that were escalated at least once";
                        readonly type: "integer";
                    };
                    readonly appealedCount: {
                        readonly description: "Number of items that were appealed at least once";
                        readonly type: "integer";
                    };
                    readonly subjectCount: {
                        readonly description: "Total number of item in the set";
                        readonly type: "integer";
                    };
                    readonly pendingCount: {
                        readonly description: "Number of item currently in \"reviewOpen\" or \"reviewEscalated\" state";
                        readonly type: "integer";
                    };
                    readonly processedCount: {
                        readonly description: "Number of item currently in \"reviewNone\" or \"reviewClosed\" state";
                        readonly type: "integer";
                    };
                    readonly takendownCount: {
                        readonly description: "Number of item currently taken down";
                        readonly type: "integer";
                    };
                };
            };
            readonly accountStrike: {
                readonly description: "Strike information for an account";
                readonly type: "object";
                readonly properties: {
                    readonly activeStrikeCount: {
                        readonly description: "Current number of active strikes (excluding expired strikes)";
                        readonly type: "integer";
                    };
                    readonly totalStrikeCount: {
                        readonly description: "Total number of strikes ever received (including expired strikes)";
                        readonly type: "integer";
                    };
                    readonly firstStrikeAt: {
                        readonly description: "Timestamp of the first strike received";
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly lastStrikeAt: {
                        readonly description: "Timestamp of the most recent strike received";
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly subjectReviewState: {
                readonly type: "string";
                readonly knownValues: ["tools.ozone.moderation.defs#reviewOpen", "tools.ozone.moderation.defs#reviewEscalated", "tools.ozone.moderation.defs#reviewClosed", "tools.ozone.moderation.defs#reviewNone"];
            };
            readonly reviewOpen: {
                readonly type: "token";
                readonly description: "Moderator review status of a subject: Open. Indicates that the subject needs to be reviewed by a moderator";
            };
            readonly reviewEscalated: {
                readonly type: "token";
                readonly description: "Moderator review status of a subject: Escalated. Indicates that the subject was escalated for review by a moderator";
            };
            readonly reviewClosed: {
                readonly type: "token";
                readonly description: "Moderator review status of a subject: Closed. Indicates that the subject was already reviewed and resolved by a moderator";
            };
            readonly reviewNone: {
                readonly type: "token";
                readonly description: "Moderator review status of a subject: Unnecessary. Indicates that the subject does not need a review at the moment but there is probably some moderation related metadata available for it";
            };
            readonly modEventTakedown: {
                readonly type: "object";
                readonly description: "Take down a subject permanently or temporarily";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly durationInHours: {
                        readonly type: "integer";
                        readonly description: "Indicates how long the takedown should be in effect before automatically expiring.";
                    };
                    readonly acknowledgeAccountSubjects: {
                        readonly type: "boolean";
                        readonly description: "If true, all other reports on content authored by this account will be resolved (acknowledged).";
                    };
                    readonly policies: {
                        readonly type: "array";
                        readonly maxLength: 5;
                        readonly items: {
                            readonly type: "string";
                        };
                        readonly description: "Names/Keywords of the policies that drove the decision.";
                    };
                    readonly severityLevel: {
                        readonly type: "string";
                        readonly description: "Severity level of the violation (e.g., 'sev-0', 'sev-1', 'sev-2', etc.).";
                    };
                    readonly targetServices: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly knownValues: ["appview", "pds"];
                        };
                        readonly description: "List of services where the takedown should be applied. If empty or not provided, takedown is applied on all configured services.";
                    };
                    readonly strikeCount: {
                        readonly type: "integer";
                        readonly description: "Number of strikes to assign to the user for this violation.";
                    };
                    readonly strikeExpiresAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "When the strike should expire. If not provided, the strike never expires.";
                    };
                };
            };
            readonly modEventReverseTakedown: {
                readonly type: "object";
                readonly description: "Revert take down action on a subject";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Describe reasoning behind the reversal.";
                    };
                    readonly policies: {
                        readonly type: "array";
                        readonly maxLength: 5;
                        readonly items: {
                            readonly type: "string";
                        };
                        readonly description: "Names/Keywords of the policy infraction for which takedown is being reversed.";
                    };
                    readonly severityLevel: {
                        readonly type: "string";
                        readonly description: "Severity level of the violation. Usually set from the last policy infraction's severity.";
                    };
                    readonly strikeCount: {
                        readonly type: "integer";
                        readonly description: "Number of strikes to subtract from the user's strike count. Usually set from the last policy infraction's severity.";
                    };
                };
            };
            readonly modEventResolveAppeal: {
                readonly type: "object";
                readonly description: "Resolve appeal on a subject";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Describe resolution.";
                    };
                };
            };
            readonly modEventComment: {
                readonly type: "object";
                readonly description: "Add a comment to a subject. An empty comment will clear any previously set sticky comment.";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly sticky: {
                        readonly type: "boolean";
                        readonly description: "Make the comment persistent on the subject";
                    };
                };
            };
            readonly modEventReport: {
                readonly type: "object";
                readonly description: "Report a subject";
                readonly required: ["reportType"];
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly isReporterMuted: {
                        readonly type: "boolean";
                        readonly description: "Set to true if the reporter was muted from reporting at the time of the event. These reports won't impact the reviewState of the subject.";
                    };
                    readonly reportType: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.moderation.defs#reasonType";
                    };
                };
            };
            readonly modEventLabel: {
                readonly type: "object";
                readonly description: "Apply/Negate labels on a subject";
                readonly required: ["createLabelVals", "negateLabelVals"];
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly createLabelVals: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                        };
                    };
                    readonly negateLabelVals: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                        };
                    };
                    readonly durationInHours: {
                        readonly type: "integer";
                        readonly description: "Indicates how long the label will remain on the subject. Only applies on labels that are being added.";
                    };
                };
            };
            readonly modEventPriorityScore: {
                readonly type: "object";
                readonly description: "Set priority score of the subject. Higher score means higher priority.";
                readonly required: ["score"];
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly score: {
                        readonly type: "integer";
                        readonly minimum: 0;
                        readonly maximum: 100;
                    };
                };
            };
            readonly ageAssuranceEvent: {
                readonly type: "object";
                readonly description: "Age assurance info coming directly from users. Only works on DID subjects.";
                readonly required: ["createdAt", "status", "attemptId"];
                readonly properties: {
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "The date and time of this write operation.";
                    };
                    readonly attemptId: {
                        readonly type: "string";
                        readonly description: "The unique identifier for this instance of the age assurance flow, in UUID format.";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly description: "The status of the Age Assurance process.";
                        readonly knownValues: ["unknown", "pending", "assured"];
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                    readonly countryCode: {
                        readonly type: "string";
                        readonly description: "The ISO 3166-1 alpha-2 country code provided when beginning the Age Assurance flow.";
                    };
                    readonly regionCode: {
                        readonly type: "string";
                        readonly description: "The ISO 3166-2 region code provided when beginning the Age Assurance flow.";
                    };
                    readonly initIp: {
                        readonly type: "string";
                        readonly description: "The IP address used when initiating the AA flow.";
                    };
                    readonly initUa: {
                        readonly type: "string";
                        readonly description: "The user agent used when initiating the AA flow.";
                    };
                    readonly completeIp: {
                        readonly type: "string";
                        readonly description: "The IP address used when completing the AA flow.";
                    };
                    readonly completeUa: {
                        readonly type: "string";
                        readonly description: "The user agent used when completing the AA flow.";
                    };
                };
            };
            readonly ageAssuranceOverrideEvent: {
                readonly type: "object";
                readonly description: "Age assurance status override by moderators. Only works on DID subjects.";
                readonly required: ["comment", "status"];
                readonly properties: {
                    readonly status: {
                        readonly type: "string";
                        readonly description: "The status to be set for the user decided by a moderator, overriding whatever value the user had previously. Use reset to default to original state.";
                        readonly knownValues: ["assured", "reset", "blocked"];
                    };
                    readonly access: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#access";
                    };
                    readonly comment: {
                        readonly type: "string";
                        readonly minLength: 1;
                        readonly description: "Comment describing the reason for the override.";
                    };
                };
            };
            readonly revokeAccountCredentialsEvent: {
                readonly type: "object";
                readonly description: "Account credentials revocation by moderators. Only works on DID subjects.";
                readonly required: ["comment"];
                readonly properties: {
                    readonly comment: {
                        readonly minLength: 1;
                        readonly type: "string";
                        readonly description: "Comment describing the reason for the revocation.";
                    };
                };
            };
            readonly modEventAcknowledge: {
                readonly type: "object";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly acknowledgeAccountSubjects: {
                        readonly type: "boolean";
                        readonly description: "If true, all other reports on content authored by this account will be resolved (acknowledged).";
                    };
                };
            };
            readonly modEventEscalate: {
                readonly type: "object";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                };
            };
            readonly modEventMute: {
                readonly type: "object";
                readonly description: "Mute incoming reports on a subject";
                readonly required: ["durationInHours"];
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly durationInHours: {
                        readonly type: "integer";
                        readonly description: "Indicates how long the subject should remain muted.";
                    };
                };
            };
            readonly modEventUnmute: {
                readonly type: "object";
                readonly description: "Unmute action on a subject";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Describe reasoning behind the reversal.";
                    };
                };
            };
            readonly modEventMuteReporter: {
                readonly type: "object";
                readonly description: "Mute incoming reports from an account";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly durationInHours: {
                        readonly type: "integer";
                        readonly description: "Indicates how long the account should remain muted. Falsy value here means a permanent mute.";
                    };
                };
            };
            readonly modEventUnmuteReporter: {
                readonly type: "object";
                readonly description: "Unmute incoming reports from an account";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Describe reasoning behind the reversal.";
                    };
                };
            };
            readonly modEventEmail: {
                readonly type: "object";
                readonly description: "Keep a log of outgoing email to a user";
                readonly required: ["subjectLine"];
                readonly properties: {
                    readonly subjectLine: {
                        readonly type: "string";
                        readonly description: "The subject line of the email sent to the user.";
                    };
                    readonly content: {
                        readonly type: "string";
                        readonly description: "The content of the email sent to the user.";
                    };
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Additional comment about the outgoing comm.";
                    };
                    readonly policies: {
                        readonly type: "array";
                        readonly maxLength: 5;
                        readonly items: {
                            readonly type: "string";
                        };
                        readonly description: "Names/Keywords of the policies that necessitated the email.";
                    };
                    readonly severityLevel: {
                        readonly type: "string";
                        readonly description: "Severity level of the violation. Normally 'sev-1' that adds strike on repeat offense";
                    };
                    readonly strikeCount: {
                        readonly type: "integer";
                        readonly description: "Number of strikes to assign to the user for this violation. Normally 0 as an indicator of a warning and only added as a strike on a repeat offense.";
                    };
                    readonly strikeExpiresAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "When the strike should expire. If not provided, the strike never expires.";
                    };
                    readonly isDelivered: {
                        readonly type: "boolean";
                        readonly description: "Indicates whether the email was successfully delivered to the user's inbox.";
                    };
                };
            };
            readonly modEventDivert: {
                readonly type: "object";
                readonly description: "Divert a record's blobs to a 3rd party service for further scanning/tagging";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                };
            };
            readonly modEventTag: {
                readonly type: "object";
                readonly description: "Add/Remove a tag on a subject";
                readonly required: ["add", "remove"];
                readonly properties: {
                    readonly add: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                        };
                        readonly description: "Tags to be added to the subject. If already exists, won't be duplicated.";
                    };
                    readonly remove: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                        };
                        readonly description: "Tags to be removed to the subject. Ignores a tag If it doesn't exist, won't be duplicated.";
                    };
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Additional comment about added/removed tags.";
                    };
                };
            };
            readonly accountEvent: {
                readonly type: "object";
                readonly description: "Logs account status related events on a repo subject. Normally captured by automod from the firehose and emitted to ozone for historical tracking.";
                readonly required: ["timestamp", "active"];
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly active: {
                        readonly type: "boolean";
                        readonly description: "Indicates that the account has a repository which can be fetched from the host that emitted this event.";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly knownValues: ["unknown", "deactivated", "deleted", "takendown", "suspended", "tombstoned"];
                    };
                    readonly timestamp: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly identityEvent: {
                readonly type: "object";
                readonly description: "Logs identity related events on a repo subject. Normally captured by automod from the firehose and emitted to ozone for historical tracking.";
                readonly required: ["timestamp"];
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly pdsHost: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly tombstone: {
                        readonly type: "boolean";
                    };
                    readonly timestamp: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly recordEvent: {
                readonly type: "object";
                readonly description: "Logs lifecycle event on a record subject. Normally captured by automod from the firehose and emitted to ozone for historical tracking.";
                readonly required: ["timestamp", "op"];
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly op: {
                        readonly type: "string";
                        readonly knownValues: ["create", "update", "delete"];
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly timestamp: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly scheduleTakedownEvent: {
                readonly type: "object";
                readonly description: "Logs a scheduled takedown action for an account.";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly executeAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly executeAfter: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly executeUntil: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly cancelScheduledTakedownEvent: {
                readonly type: "object";
                readonly description: "Logs cancellation of a scheduled takedown action for an account.";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                };
            };
            readonly repoView: {
                readonly type: "object";
                readonly required: ["did", "handle", "relatedRecords", "indexedAt", "moderation"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly email: {
                        readonly type: "string";
                    };
                    readonly relatedRecords: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "unknown";
                        };
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly moderation: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#moderation";
                    };
                    readonly invitedBy: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.server.defs#inviteCode";
                    };
                    readonly invitesDisabled: {
                        readonly type: "boolean";
                    };
                    readonly inviteNote: {
                        readonly type: "string";
                    };
                    readonly deactivatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly threatSignatures: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.admin.defs#threatSignature";
                        };
                    };
                };
            };
            readonly repoViewDetail: {
                readonly type: "object";
                readonly required: ["did", "handle", "relatedRecords", "indexedAt", "moderation"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly format: "handle";
                    };
                    readonly email: {
                        readonly type: "string";
                    };
                    readonly relatedRecords: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "unknown";
                        };
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly moderation: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#moderationDetail";
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly invitedBy: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.server.defs#inviteCode";
                    };
                    readonly invites: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.server.defs#inviteCode";
                        };
                    };
                    readonly invitesDisabled: {
                        readonly type: "boolean";
                    };
                    readonly inviteNote: {
                        readonly type: "string";
                    };
                    readonly emailConfirmedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly deactivatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly threatSignatures: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.admin.defs#threatSignature";
                        };
                    };
                };
            };
            readonly repoViewNotFound: {
                readonly type: "object";
                readonly required: ["did"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
            readonly recordView: {
                readonly type: "object";
                readonly required: ["uri", "cid", "value", "blobCids", "indexedAt", "moderation", "repo"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly value: {
                        readonly type: "unknown";
                    };
                    readonly blobCids: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "cid";
                        };
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly moderation: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#moderation";
                    };
                    readonly repo: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#repoView";
                    };
                };
            };
            readonly recordViewDetail: {
                readonly type: "object";
                readonly required: ["uri", "cid", "value", "blobs", "indexedAt", "moderation", "repo"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly value: {
                        readonly type: "unknown";
                    };
                    readonly blobs: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:tools.ozone.moderation.defs#blobView";
                        };
                    };
                    readonly labels: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:com.atproto.label.defs#label";
                        };
                    };
                    readonly indexedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly moderation: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#moderationDetail";
                    };
                    readonly repo: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#repoView";
                    };
                };
            };
            readonly recordViewNotFound: {
                readonly type: "object";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
            };
            readonly moderation: {
                readonly type: "object";
                readonly properties: {
                    readonly subjectStatus: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#subjectStatusView";
                    };
                };
            };
            readonly moderationDetail: {
                readonly type: "object";
                readonly properties: {
                    readonly subjectStatus: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#subjectStatusView";
                    };
                };
            };
            readonly blobView: {
                readonly type: "object";
                readonly required: ["cid", "mimeType", "size", "createdAt"];
                readonly properties: {
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                    };
                    readonly mimeType: {
                        readonly type: "string";
                    };
                    readonly size: {
                        readonly type: "integer";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly details: {
                        readonly type: "union";
                        readonly refs: ["lex:tools.ozone.moderation.defs#imageDetails", "lex:tools.ozone.moderation.defs#videoDetails"];
                    };
                    readonly moderation: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#moderation";
                    };
                };
            };
            readonly imageDetails: {
                readonly type: "object";
                readonly required: ["width", "height"];
                readonly properties: {
                    readonly width: {
                        readonly type: "integer";
                    };
                    readonly height: {
                        readonly type: "integer";
                    };
                };
            };
            readonly videoDetails: {
                readonly type: "object";
                readonly required: ["width", "height", "length"];
                readonly properties: {
                    readonly width: {
                        readonly type: "integer";
                    };
                    readonly height: {
                        readonly type: "integer";
                    };
                    readonly length: {
                        readonly type: "integer";
                    };
                };
            };
            readonly accountHosting: {
                readonly type: "object";
                readonly required: ["status"];
                readonly properties: {
                    readonly status: {
                        readonly type: "string";
                        readonly knownValues: ["takendown", "suspended", "deleted", "deactivated", "unknown"];
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly deletedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly deactivatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly reactivatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly recordHosting: {
                readonly type: "object";
                readonly required: ["status"];
                readonly properties: {
                    readonly status: {
                        readonly type: "string";
                        readonly knownValues: ["deleted", "unknown"];
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly deletedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
            readonly reporterStats: {
                readonly type: "object";
                readonly required: ["did", "accountReportCount", "recordReportCount", "reportedAccountCount", "reportedRecordCount", "takendownAccountCount", "takendownRecordCount", "labeledAccountCount", "labeledRecordCount"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly accountReportCount: {
                        readonly type: "integer";
                        readonly description: "The total number of reports made by the user on accounts.";
                    };
                    readonly recordReportCount: {
                        readonly type: "integer";
                        readonly description: "The total number of reports made by the user on records.";
                    };
                    readonly reportedAccountCount: {
                        readonly type: "integer";
                        readonly description: "The total number of accounts reported by the user.";
                    };
                    readonly reportedRecordCount: {
                        readonly type: "integer";
                        readonly description: "The total number of records reported by the user.";
                    };
                    readonly takendownAccountCount: {
                        readonly type: "integer";
                        readonly description: "The total number of accounts taken down as a result of the user's reports.";
                    };
                    readonly takendownRecordCount: {
                        readonly type: "integer";
                        readonly description: "The total number of records taken down as a result of the user's reports.";
                    };
                    readonly labeledAccountCount: {
                        readonly type: "integer";
                        readonly description: "The total number of accounts labeled as a result of the user's reports.";
                    };
                    readonly labeledRecordCount: {
                        readonly type: "integer";
                        readonly description: "The total number of records labeled as a result of the user's reports.";
                    };
                };
            };
            readonly modTool: {
                readonly type: "object";
                readonly description: "Moderation tool information for tracing the source of the action";
                readonly required: ["name"];
                readonly properties: {
                    readonly name: {
                        readonly type: "string";
                        readonly description: "Name/identifier of the source (e.g., 'automod', 'ozone/workspace')";
                    };
                    readonly meta: {
                        readonly type: "unknown";
                        readonly description: "Additional arbitrary metadata about the source";
                    };
                };
            };
            readonly timelineEventPlcCreate: {
                readonly type: "token";
                readonly description: "Moderation event timeline event for a PLC create operation";
            };
            readonly timelineEventPlcOperation: {
                readonly type: "token";
                readonly description: "Moderation event timeline event for generic PLC operation";
            };
            readonly timelineEventPlcTombstone: {
                readonly type: "token";
                readonly description: "Moderation event timeline event for a PLC tombstone operation";
            };
            readonly scheduledActionView: {
                readonly type: "object";
                readonly description: "View of a scheduled moderation action";
                readonly required: ["id", "action", "did", "createdBy", "createdAt", "status"];
                readonly properties: {
                    readonly id: {
                        readonly type: "integer";
                        readonly description: "Auto-incrementing row ID";
                    };
                    readonly action: {
                        readonly type: "string";
                        readonly knownValues: ["takedown"];
                        readonly description: "Type of action to be executed";
                    };
                    readonly eventData: {
                        readonly type: "unknown";
                        readonly description: "Serialized event object that will be propagated to the event when performed";
                    };
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "Subject DID for the action";
                    };
                    readonly executeAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Exact time to execute the action";
                    };
                    readonly executeAfter: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Earliest time to execute the action (for randomized scheduling)";
                    };
                    readonly executeUntil: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Latest time to execute the action (for randomized scheduling)";
                    };
                    readonly randomizeExecution: {
                        readonly type: "boolean";
                        readonly description: "Whether execution time should be randomized within the specified range";
                    };
                    readonly createdBy: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "DID of the user who created this scheduled action";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "When the scheduled action was created";
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "When the scheduled action was last updated";
                    };
                    readonly status: {
                        readonly type: "string";
                        readonly knownValues: ["pending", "executed", "cancelled", "failed"];
                        readonly description: "Current status of the scheduled action";
                    };
                    readonly lastExecutedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "When the action was last attempted to be executed";
                    };
                    readonly lastFailureReason: {
                        readonly type: "string";
                        readonly description: "Reason for the last execution failure";
                    };
                    readonly executionEventId: {
                        readonly type: "integer";
                        readonly description: "ID of the moderation event created when action was successfully executed";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationEmitEvent: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.emitEvent";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Take a moderation action on an actor.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["event", "subject", "createdBy"];
                        readonly properties: {
                            readonly event: {
                                readonly type: "union";
                                readonly refs: ["lex:tools.ozone.moderation.defs#modEventTakedown", "lex:tools.ozone.moderation.defs#modEventAcknowledge", "lex:tools.ozone.moderation.defs#modEventEscalate", "lex:tools.ozone.moderation.defs#modEventComment", "lex:tools.ozone.moderation.defs#modEventLabel", "lex:tools.ozone.moderation.defs#modEventReport", "lex:tools.ozone.moderation.defs#modEventMute", "lex:tools.ozone.moderation.defs#modEventUnmute", "lex:tools.ozone.moderation.defs#modEventMuteReporter", "lex:tools.ozone.moderation.defs#modEventUnmuteReporter", "lex:tools.ozone.moderation.defs#modEventReverseTakedown", "lex:tools.ozone.moderation.defs#modEventResolveAppeal", "lex:tools.ozone.moderation.defs#modEventEmail", "lex:tools.ozone.moderation.defs#modEventDivert", "lex:tools.ozone.moderation.defs#modEventTag", "lex:tools.ozone.moderation.defs#accountEvent", "lex:tools.ozone.moderation.defs#identityEvent", "lex:tools.ozone.moderation.defs#recordEvent", "lex:tools.ozone.moderation.defs#modEventPriorityScore", "lex:tools.ozone.moderation.defs#ageAssuranceEvent", "lex:tools.ozone.moderation.defs#ageAssuranceOverrideEvent", "lex:tools.ozone.moderation.defs#revokeAccountCredentialsEvent", "lex:tools.ozone.moderation.defs#scheduleTakedownEvent", "lex:tools.ozone.moderation.defs#cancelScheduledTakedownEvent"];
                            };
                            readonly subject: {
                                readonly type: "union";
                                readonly refs: ["lex:com.atproto.admin.defs#repoRef", "lex:com.atproto.repo.strongRef"];
                            };
                            readonly subjectBlobCids: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "cid";
                                };
                            };
                            readonly createdBy: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly modTool: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.moderation.defs#modTool";
                            };
                            readonly externalId: {
                                readonly type: "string";
                                readonly description: "An optional external ID for the event, used to deduplicate events from external systems. Fails when an event of same type with the same external ID exists for the same subject.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#modEventView";
                    };
                };
                readonly errors: [{
                    readonly name: "SubjectHasAction";
                }, {
                    readonly name: "DuplicateExternalId";
                    readonly description: "An event with the same external ID already exists for the subject.";
                }];
            };
        };
    };
    readonly ToolsOzoneModerationGetAccountTimeline: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.getAccountTimeline";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get timeline of all available events of an account. This includes moderation events, account history and did history.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["timeline"];
                        readonly properties: {
                            readonly timeline: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.moderation.getAccountTimeline#timelineItem";
                                };
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "RepoNotFound";
                }];
            };
            readonly timelineItem: {
                readonly type: "object";
                readonly required: ["day", "summary"];
                readonly properties: {
                    readonly day: {
                        readonly type: "string";
                    };
                    readonly summary: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:tools.ozone.moderation.getAccountTimeline#timelineItemSummary";
                        };
                    };
                };
            };
            readonly timelineItemSummary: {
                readonly type: "object";
                readonly required: ["eventSubjectType", "eventType", "count"];
                readonly properties: {
                    readonly eventSubjectType: {
                        readonly type: "string";
                        readonly knownValues: ["account", "record", "chat"];
                    };
                    readonly eventType: {
                        readonly type: "string";
                        readonly knownValues: ["tools.ozone.moderation.defs#modEventTakedown", "tools.ozone.moderation.defs#modEventReverseTakedown", "tools.ozone.moderation.defs#modEventComment", "tools.ozone.moderation.defs#modEventReport", "tools.ozone.moderation.defs#modEventLabel", "tools.ozone.moderation.defs#modEventAcknowledge", "tools.ozone.moderation.defs#modEventEscalate", "tools.ozone.moderation.defs#modEventMute", "tools.ozone.moderation.defs#modEventUnmute", "tools.ozone.moderation.defs#modEventMuteReporter", "tools.ozone.moderation.defs#modEventUnmuteReporter", "tools.ozone.moderation.defs#modEventEmail", "tools.ozone.moderation.defs#modEventResolveAppeal", "tools.ozone.moderation.defs#modEventDivert", "tools.ozone.moderation.defs#modEventTag", "tools.ozone.moderation.defs#accountEvent", "tools.ozone.moderation.defs#identityEvent", "tools.ozone.moderation.defs#recordEvent", "tools.ozone.moderation.defs#modEventPriorityScore", "tools.ozone.moderation.defs#revokeAccountCredentialsEvent", "tools.ozone.moderation.defs#ageAssuranceEvent", "tools.ozone.moderation.defs#ageAssuranceOverrideEvent", "tools.ozone.moderation.defs#timelineEventPlcCreate", "tools.ozone.moderation.defs#timelineEventPlcOperation", "tools.ozone.moderation.defs#timelineEventPlcTombstone", "tools.ozone.hosting.getAccountHistory#accountCreated", "tools.ozone.hosting.getAccountHistory#emailConfirmed", "tools.ozone.hosting.getAccountHistory#passwordUpdated", "tools.ozone.hosting.getAccountHistory#handleUpdated", "tools.ozone.moderation.defs#scheduleTakedownEvent", "tools.ozone.moderation.defs#cancelScheduledTakedownEvent"];
                    };
                    readonly count: {
                        readonly type: "integer";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationGetEvent: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.getEvent";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about a moderation event.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["id"];
                    readonly properties: {
                        readonly id: {
                            readonly type: "integer";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#modEventViewDetail";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationGetRecord: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.getRecord";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about a record.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uri"];
                    readonly properties: {
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                        readonly cid: {
                            readonly type: "string";
                            readonly format: "cid";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#recordViewDetail";
                    };
                };
                readonly errors: [{
                    readonly name: "RecordNotFound";
                }];
            };
        };
    };
    readonly ToolsOzoneModerationGetRecords: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.getRecords";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about some records.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["uris"];
                    readonly properties: {
                        readonly uris: {
                            readonly type: "array";
                            readonly maxLength: 100;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "at-uri";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["records"];
                        readonly properties: {
                            readonly records: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:tools.ozone.moderation.defs#recordViewDetail", "lex:tools.ozone.moderation.defs#recordViewNotFound"];
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationGetRepo: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.getRepo";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about a repository.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.defs#repoViewDetail";
                    };
                };
                readonly errors: [{
                    readonly name: "RepoNotFound";
                }];
            };
        };
    };
    readonly ToolsOzoneModerationGetReporterStats: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.getReporterStats";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get reporter stats for a list of users.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["dids"];
                    readonly properties: {
                        readonly dids: {
                            readonly type: "array";
                            readonly maxLength: 100;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["stats"];
                        readonly properties: {
                            readonly stats: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.moderation.defs#reporterStats";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationGetRepos: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.getRepos";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about some repositories.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["dids"];
                    readonly properties: {
                        readonly dids: {
                            readonly type: "array";
                            readonly maxLength: 100;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["repos"];
                        readonly properties: {
                            readonly repos: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "union";
                                    readonly refs: ["lex:tools.ozone.moderation.defs#repoViewDetail", "lex:tools.ozone.moderation.defs#repoViewNotFound"];
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationGetSubjects: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.getSubjects";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about subjects.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["subjects"];
                    readonly properties: {
                        readonly subjects: {
                            readonly type: "array";
                            readonly maxLength: 100;
                            readonly minLength: 1;
                            readonly items: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subjects"];
                        readonly properties: {
                            readonly subjects: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.moderation.defs#subjectView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationListScheduledActions: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.listScheduledActions";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "List scheduled moderation actions with optional filtering";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["statuses"];
                        readonly properties: {
                            readonly startsAfter: {
                                readonly type: "string";
                                readonly format: "datetime";
                                readonly description: "Filter actions scheduled to execute after this time";
                            };
                            readonly endsBefore: {
                                readonly type: "string";
                                readonly format: "datetime";
                                readonly description: "Filter actions scheduled to execute before this time";
                            };
                            readonly subjects: {
                                readonly type: "array";
                                readonly maxLength: 100;
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "did";
                                };
                                readonly description: "Filter actions for specific DID subjects";
                            };
                            readonly statuses: {
                                readonly type: "array";
                                readonly minLength: 1;
                                readonly items: {
                                    readonly type: "string";
                                    readonly knownValues: ["pending", "executed", "cancelled", "failed"];
                                };
                                readonly description: "Filter actions by status";
                            };
                            readonly limit: {
                                readonly type: "integer";
                                readonly minimum: 1;
                                readonly maximum: 100;
                                readonly default: 50;
                                readonly description: "Maximum number of results to return";
                            };
                            readonly cursor: {
                                readonly type: "string";
                                readonly description: "Cursor for pagination";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["actions"];
                        readonly properties: {
                            readonly actions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.moderation.defs#scheduledActionView";
                                };
                            };
                            readonly cursor: {
                                readonly type: "string";
                                readonly description: "Cursor for next page of results";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationQueryEvents: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.queryEvents";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "List moderation events related to a subject.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly types: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly description: "The types of events (fully qualified string in the format of tools.ozone.moderation.defs#modEvent<name>) to filter by. If not specified, all events are returned.";
                        };
                        readonly createdBy: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly sortDirection: {
                            readonly type: "string";
                            readonly default: "desc";
                            readonly enum: ["asc", "desc"];
                            readonly description: "Sort direction for the events. Defaults to descending order of created at timestamp.";
                        };
                        readonly createdAfter: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Retrieve events created after a given timestamp";
                        };
                        readonly createdBefore: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Retrieve events created before a given timestamp";
                        };
                        readonly subject: {
                            readonly type: "string";
                            readonly format: "uri";
                        };
                        readonly collections: {
                            readonly type: "array";
                            readonly maxLength: 20;
                            readonly description: "If specified, only events where the subject belongs to the given collections will be returned. When subjectType is set to 'account', this will be ignored.";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "nsid";
                            };
                        };
                        readonly subjectType: {
                            readonly type: "string";
                            readonly description: "If specified, only events where the subject is of the given type (account or record) will be returned. When this is set to 'account' the 'collections' parameter will be ignored. When includeAllUserRecords or subject is set, this will be ignored.";
                            readonly knownValues: ["account", "record"];
                        };
                        readonly includeAllUserRecords: {
                            readonly type: "boolean";
                            readonly default: false;
                            readonly description: "If true, events on all record types (posts, lists, profile etc.) or records from given 'collections' param, owned by the did are returned.";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly hasComment: {
                            readonly type: "boolean";
                            readonly description: "If true, only events with comments are returned";
                        };
                        readonly comment: {
                            readonly type: "string";
                            readonly description: "If specified, only events with comments containing the keyword are returned. Apply || separator to use multiple keywords and match using OR condition.";
                        };
                        readonly addedLabels: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly description: "If specified, only events where all of these labels were added are returned";
                        };
                        readonly removedLabels: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly description: "If specified, only events where all of these labels were removed are returned";
                        };
                        readonly addedTags: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly description: "If specified, only events where all of these tags were added are returned";
                        };
                        readonly removedTags: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly description: "If specified, only events where all of these tags were removed are returned";
                        };
                        readonly reportTypes: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                        };
                        readonly policies: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly description: "If specified, only events where the action policies match any of the given policies are returned";
                            };
                        };
                        readonly modTool: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly description: "If specified, only events where the modTool name matches any of the given values are returned";
                        };
                        readonly batchId: {
                            readonly type: "string";
                            readonly description: "If specified, only events where the batchId matches the given value are returned";
                        };
                        readonly ageAssuranceState: {
                            readonly type: "string";
                            readonly description: "If specified, only events where the age assurance state matches the given value are returned";
                            readonly knownValues: ["pending", "assured", "unknown", "reset", "blocked"];
                        };
                        readonly withStrike: {
                            readonly type: "boolean";
                            readonly description: "If specified, only events where strikeCount value is set are returned.";
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["events"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly events: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.moderation.defs#modEventView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationQueryStatuses: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.queryStatuses";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "View moderation statuses of subjects (record or repo).";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly queueCount: {
                            readonly type: "integer";
                            readonly description: "Number of queues being used by moderators. Subjects will be split among all queues.";
                        };
                        readonly queueIndex: {
                            readonly type: "integer";
                            readonly description: "Index of the queue to fetch subjects from. Works only when queueCount value is specified.";
                        };
                        readonly queueSeed: {
                            readonly type: "string";
                            readonly description: "A seeder to shuffle/balance the queue items.";
                        };
                        readonly includeAllUserRecords: {
                            readonly type: "boolean";
                            readonly description: "All subjects, or subjects from given 'collections' param, belonging to the account specified in the 'subject' param will be returned.";
                        };
                        readonly subject: {
                            readonly type: "string";
                            readonly format: "uri";
                            readonly description: "The subject to get the status for.";
                        };
                        readonly comment: {
                            readonly type: "string";
                            readonly description: "Search subjects by keyword from comments";
                        };
                        readonly reportedAfter: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Search subjects reported after a given timestamp";
                        };
                        readonly reportedBefore: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Search subjects reported before a given timestamp";
                        };
                        readonly reviewedAfter: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Search subjects reviewed after a given timestamp";
                        };
                        readonly hostingDeletedAfter: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Search subjects where the associated record/account was deleted after a given timestamp";
                        };
                        readonly hostingDeletedBefore: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Search subjects where the associated record/account was deleted before a given timestamp";
                        };
                        readonly hostingUpdatedAfter: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Search subjects where the associated record/account was updated after a given timestamp";
                        };
                        readonly hostingUpdatedBefore: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Search subjects where the associated record/account was updated before a given timestamp";
                        };
                        readonly hostingStatuses: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly description: "Search subjects by the status of the associated record/account";
                        };
                        readonly reviewedBefore: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Search subjects reviewed before a given timestamp";
                        };
                        readonly includeMuted: {
                            readonly type: "boolean";
                            readonly description: "By default, we don't include muted subjects in the results. Set this to true to include them.";
                        };
                        readonly onlyMuted: {
                            readonly type: "boolean";
                            readonly description: "When set to true, only muted subjects and reporters will be returned.";
                        };
                        readonly reviewState: {
                            readonly type: "string";
                            readonly description: "Specify when fetching subjects in a certain state";
                            readonly knownValues: ["tools.ozone.moderation.defs#reviewOpen", "tools.ozone.moderation.defs#reviewClosed", "tools.ozone.moderation.defs#reviewEscalated", "tools.ozone.moderation.defs#reviewNone"];
                        };
                        readonly ignoreSubjects: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "uri";
                            };
                        };
                        readonly lastReviewedBy: {
                            readonly type: "string";
                            readonly format: "did";
                            readonly description: "Get all subject statuses that were reviewed by a specific moderator";
                        };
                        readonly sortField: {
                            readonly type: "string";
                            readonly default: "lastReportedAt";
                            readonly enum: ["lastReviewedAt", "lastReportedAt", "reportedRecordsCount", "takendownRecordsCount", "priorityScore"];
                        };
                        readonly sortDirection: {
                            readonly type: "string";
                            readonly default: "desc";
                            readonly enum: ["asc", "desc"];
                        };
                        readonly takendown: {
                            readonly type: "boolean";
                            readonly description: "Get subjects that were taken down";
                        };
                        readonly appealed: {
                            readonly type: "boolean";
                            readonly description: "Get subjects in unresolved appealed status";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly tags: {
                            readonly type: "array";
                            readonly maxLength: 25;
                            readonly items: {
                                readonly type: "string";
                                readonly description: "Items in this array are applied with OR filters. To apply AND filter, put all tags in the same string and separate using && characters";
                            };
                        };
                        readonly excludeTags: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly collections: {
                            readonly type: "array";
                            readonly maxLength: 20;
                            readonly description: "If specified, subjects belonging to the given collections will be returned. When subjectType is set to 'account', this will be ignored.";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "nsid";
                            };
                        };
                        readonly subjectType: {
                            readonly type: "string";
                            readonly description: "If specified, subjects of the given type (account or record) will be returned. When this is set to 'account' the 'collections' parameter will be ignored. When includeAllUserRecords or subject is set, this will be ignored.";
                            readonly knownValues: ["account", "record"];
                        };
                        readonly minAccountSuspendCount: {
                            readonly type: "integer";
                            readonly description: "If specified, only subjects that belong to an account that has at least this many suspensions will be returned.";
                        };
                        readonly minReportedRecordsCount: {
                            readonly type: "integer";
                            readonly description: "If specified, only subjects that belong to an account that has at least this many reported records will be returned.";
                        };
                        readonly minTakendownRecordsCount: {
                            readonly type: "integer";
                            readonly description: "If specified, only subjects that belong to an account that has at least this many taken down records will be returned.";
                        };
                        readonly minPriorityScore: {
                            readonly minimum: 0;
                            readonly maximum: 100;
                            readonly type: "integer";
                            readonly description: "If specified, only subjects that have priority score value above the given value will be returned.";
                        };
                        readonly minStrikeCount: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly description: "If specified, only subjects that belong to an account that has at least this many active strikes will be returned.";
                        };
                        readonly ageAssuranceState: {
                            readonly type: "string";
                            readonly description: "If specified, only subjects with the given age assurance state will be returned.";
                            readonly knownValues: ["pending", "assured", "unknown", "reset", "blocked"];
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["subjectStatuses"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly subjectStatuses: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.moderation.defs#subjectStatusView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationScheduleAction: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.scheduleAction";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Schedule a moderation action to be executed at a future time";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["action", "subjects", "createdBy", "scheduling"];
                        readonly properties: {
                            readonly action: {
                                readonly type: "union";
                                readonly refs: ["lex:tools.ozone.moderation.scheduleAction#takedown"];
                            };
                            readonly subjects: {
                                readonly type: "array";
                                readonly maxLength: 100;
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "did";
                                };
                                readonly description: "Array of DID subjects to schedule the action for";
                            };
                            readonly createdBy: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly scheduling: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.moderation.scheduleAction#schedulingConfig";
                            };
                            readonly modTool: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.moderation.defs#modTool";
                                readonly description: "This will be propagated to the moderation event when it is applied";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.moderation.scheduleAction#scheduledActionResults";
                    };
                };
            };
            readonly takedown: {
                readonly type: "object";
                readonly description: "Schedule a takedown action";
                readonly properties: {
                    readonly comment: {
                        readonly type: "string";
                    };
                    readonly durationInHours: {
                        readonly type: "integer";
                        readonly description: "Indicates how long the takedown should be in effect before automatically expiring.";
                    };
                    readonly acknowledgeAccountSubjects: {
                        readonly type: "boolean";
                        readonly description: "If true, all other reports on content authored by this account will be resolved (acknowledged).";
                    };
                    readonly policies: {
                        readonly type: "array";
                        readonly maxLength: 5;
                        readonly items: {
                            readonly type: "string";
                        };
                        readonly description: "Names/Keywords of the policies that drove the decision.";
                    };
                    readonly severityLevel: {
                        readonly type: "string";
                        readonly description: "Severity level of the violation (e.g., 'sev-0', 'sev-1', 'sev-2', etc.).";
                    };
                    readonly strikeCount: {
                        readonly type: "integer";
                        readonly description: "Number of strikes to assign to the user when takedown is applied.";
                    };
                    readonly strikeExpiresAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "When the strike should expire. If not provided, the strike never expires.";
                    };
                    readonly emailContent: {
                        readonly type: "string";
                        readonly description: "Email content to be sent to the user upon takedown.";
                    };
                    readonly emailSubject: {
                        readonly type: "string";
                        readonly description: "Subject of the email to be sent to the user upon takedown.";
                    };
                };
            };
            readonly schedulingConfig: {
                readonly type: "object";
                readonly description: "Configuration for when the action should be executed";
                readonly properties: {
                    readonly executeAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Exact time to execute the action";
                    };
                    readonly executeAfter: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Earliest time to execute the action (for randomized scheduling)";
                    };
                    readonly executeUntil: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Latest time to execute the action (for randomized scheduling)";
                    };
                };
            };
            readonly scheduledActionResults: {
                readonly type: "object";
                readonly required: ["succeeded", "failed"];
                readonly properties: {
                    readonly succeeded: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                    };
                    readonly failed: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:tools.ozone.moderation.scheduleAction#failedScheduling";
                        };
                    };
                };
            };
            readonly failedScheduling: {
                readonly type: "object";
                readonly required: ["subject", "error"];
                readonly properties: {
                    readonly subject: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly error: {
                        readonly type: "string";
                    };
                    readonly errorCode: {
                        readonly type: "string";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneModerationSearchRepos: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.moderation.searchRepos";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Find repositories based on a search term.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly term: {
                            readonly type: "string";
                            readonly description: "DEPRECATED: use 'q' instead";
                        };
                        readonly q: {
                            readonly type: "string";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["repos"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly repos: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.moderation.defs#repoView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneReportDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.report.defs";
        readonly defs: {
            readonly reasonType: {
                readonly type: "string";
                readonly knownValues: ["tools.ozone.report.defs#reasonAppeal", "tools.ozone.report.defs#reasonOther", "tools.ozone.report.defs#reasonViolenceAnimal", "tools.ozone.report.defs#reasonViolenceThreats", "tools.ozone.report.defs#reasonViolenceGraphicContent", "tools.ozone.report.defs#reasonViolenceGlorification", "tools.ozone.report.defs#reasonViolenceExtremistContent", "tools.ozone.report.defs#reasonViolenceTrafficking", "tools.ozone.report.defs#reasonViolenceOther", "tools.ozone.report.defs#reasonSexualAbuseContent", "tools.ozone.report.defs#reasonSexualNCII", "tools.ozone.report.defs#reasonSexualDeepfake", "tools.ozone.report.defs#reasonSexualAnimal", "tools.ozone.report.defs#reasonSexualUnlabeled", "tools.ozone.report.defs#reasonSexualOther", "tools.ozone.report.defs#reasonChildSafetyCSAM", "tools.ozone.report.defs#reasonChildSafetyGroom", "tools.ozone.report.defs#reasonChildSafetyPrivacy", "tools.ozone.report.defs#reasonChildSafetyHarassment", "tools.ozone.report.defs#reasonChildSafetyOther", "tools.ozone.report.defs#reasonHarassmentTroll", "tools.ozone.report.defs#reasonHarassmentTargeted", "tools.ozone.report.defs#reasonHarassmentHateSpeech", "tools.ozone.report.defs#reasonHarassmentDoxxing", "tools.ozone.report.defs#reasonHarassmentOther", "tools.ozone.report.defs#reasonMisleadingBot", "tools.ozone.report.defs#reasonMisleadingImpersonation", "tools.ozone.report.defs#reasonMisleadingSpam", "tools.ozone.report.defs#reasonMisleadingScam", "tools.ozone.report.defs#reasonMisleadingElections", "tools.ozone.report.defs#reasonMisleadingOther", "tools.ozone.report.defs#reasonRuleSiteSecurity", "tools.ozone.report.defs#reasonRuleProhibitedSales", "tools.ozone.report.defs#reasonRuleBanEvasion", "tools.ozone.report.defs#reasonRuleOther", "tools.ozone.report.defs#reasonSelfHarmContent", "tools.ozone.report.defs#reasonSelfHarmED", "tools.ozone.report.defs#reasonSelfHarmStunts", "tools.ozone.report.defs#reasonSelfHarmSubstances", "tools.ozone.report.defs#reasonSelfHarmOther"];
            };
            readonly reasonAppeal: {
                readonly type: "token";
                readonly description: "Appeal a previously taken moderation action";
            };
            readonly reasonOther: {
                readonly type: "token";
                readonly description: "An issue not included in these options";
            };
            readonly reasonViolenceAnimal: {
                readonly type: "token";
                readonly description: "Animal welfare violations";
            };
            readonly reasonViolenceThreats: {
                readonly type: "token";
                readonly description: "Threats or incitement";
            };
            readonly reasonViolenceGraphicContent: {
                readonly type: "token";
                readonly description: "Graphic violent content";
            };
            readonly reasonViolenceGlorification: {
                readonly type: "token";
                readonly description: "Glorification of violence";
            };
            readonly reasonViolenceExtremistContent: {
                readonly type: "token";
                readonly description: "Extremist content. These reports will be sent only be sent to the application's Moderation Authority.";
            };
            readonly reasonViolenceTrafficking: {
                readonly type: "token";
                readonly description: "Human trafficking";
            };
            readonly reasonViolenceOther: {
                readonly type: "token";
                readonly description: "Other violent content";
            };
            readonly reasonSexualAbuseContent: {
                readonly type: "token";
                readonly description: "Adult sexual abuse content";
            };
            readonly reasonSexualNCII: {
                readonly type: "token";
                readonly description: "Non-consensual intimate imagery";
            };
            readonly reasonSexualDeepfake: {
                readonly type: "token";
                readonly description: "Deepfake adult content";
            };
            readonly reasonSexualAnimal: {
                readonly type: "token";
                readonly description: "Animal sexual abuse";
            };
            readonly reasonSexualUnlabeled: {
                readonly type: "token";
                readonly description: "Unlabelled adult content";
            };
            readonly reasonSexualOther: {
                readonly type: "token";
                readonly description: "Other sexual violence content";
            };
            readonly reasonChildSafetyCSAM: {
                readonly type: "token";
                readonly description: "Child sexual abuse material (CSAM). These reports will be sent only be sent to the application's Moderation Authority.";
            };
            readonly reasonChildSafetyGroom: {
                readonly type: "token";
                readonly description: "Grooming or predatory behavior. These reports will be sent only be sent to the application's Moderation Authority.";
            };
            readonly reasonChildSafetyPrivacy: {
                readonly type: "token";
                readonly description: "Privacy violation involving a minor";
            };
            readonly reasonChildSafetyHarassment: {
                readonly type: "token";
                readonly description: "Harassment or bullying of minors";
            };
            readonly reasonChildSafetyOther: {
                readonly type: "token";
                readonly description: "Other child safety. These reports will be sent only be sent to the application's Moderation Authority.";
            };
            readonly reasonHarassmentTroll: {
                readonly type: "token";
                readonly description: "Trolling";
            };
            readonly reasonHarassmentTargeted: {
                readonly type: "token";
                readonly description: "Targeted harassment";
            };
            readonly reasonHarassmentHateSpeech: {
                readonly type: "token";
                readonly description: "Hate speech";
            };
            readonly reasonHarassmentDoxxing: {
                readonly type: "token";
                readonly description: "Doxxing";
            };
            readonly reasonHarassmentOther: {
                readonly type: "token";
                readonly description: "Other harassing or hateful content";
            };
            readonly reasonMisleadingBot: {
                readonly type: "token";
                readonly description: "Fake account or bot";
            };
            readonly reasonMisleadingImpersonation: {
                readonly type: "token";
                readonly description: "Impersonation";
            };
            readonly reasonMisleadingSpam: {
                readonly type: "token";
                readonly description: "Spam";
            };
            readonly reasonMisleadingScam: {
                readonly type: "token";
                readonly description: "Scam";
            };
            readonly reasonMisleadingElections: {
                readonly type: "token";
                readonly description: "False information about elections";
            };
            readonly reasonMisleadingOther: {
                readonly type: "token";
                readonly description: "Other misleading content";
            };
            readonly reasonRuleSiteSecurity: {
                readonly type: "token";
                readonly description: "Hacking or system attacks";
            };
            readonly reasonRuleProhibitedSales: {
                readonly type: "token";
                readonly description: "Promoting or selling prohibited items or services";
            };
            readonly reasonRuleBanEvasion: {
                readonly type: "token";
                readonly description: "Banned user returning";
            };
            readonly reasonRuleOther: {
                readonly type: "token";
                readonly description: "Other";
            };
            readonly reasonSelfHarmContent: {
                readonly type: "token";
                readonly description: "Content promoting or depicting self-harm";
            };
            readonly reasonSelfHarmED: {
                readonly type: "token";
                readonly description: "Eating disorders";
            };
            readonly reasonSelfHarmStunts: {
                readonly type: "token";
                readonly description: "Dangerous challenges or activities";
            };
            readonly reasonSelfHarmSubstances: {
                readonly type: "token";
                readonly description: "Dangerous substances or drug abuse";
            };
            readonly reasonSelfHarmOther: {
                readonly type: "token";
                readonly description: "Other dangerous content";
            };
        };
    };
    readonly ToolsOzoneSafelinkAddRule: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.safelink.addRule";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Add a new URL safety rule";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["url", "pattern", "action", "reason"];
                        readonly properties: {
                            readonly url: {
                                readonly type: "string";
                                readonly description: "The URL or domain to apply the rule to";
                            };
                            readonly pattern: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.safelink.defs#patternType";
                            };
                            readonly action: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.safelink.defs#actionType";
                            };
                            readonly reason: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.safelink.defs#reasonType";
                            };
                            readonly comment: {
                                readonly type: "string";
                                readonly description: "Optional comment about the decision";
                            };
                            readonly createdBy: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "Author DID. Only respected when using admin auth";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#event";
                    };
                };
                readonly errors: [{
                    readonly name: "InvalidUrl";
                    readonly description: "The provided URL is invalid";
                }, {
                    readonly name: "RuleAlreadyExists";
                    readonly description: "A rule for this URL/domain already exists";
                }];
            };
        };
    };
    readonly ToolsOzoneSafelinkDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.safelink.defs";
        readonly defs: {
            readonly event: {
                readonly type: "object";
                readonly description: "An event for URL safety decisions";
                readonly required: ["id", "eventType", "url", "pattern", "action", "reason", "createdBy", "createdAt"];
                readonly properties: {
                    readonly id: {
                        readonly type: "integer";
                        readonly description: "Auto-incrementing row ID";
                    };
                    readonly eventType: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#eventType";
                    };
                    readonly url: {
                        readonly type: "string";
                        readonly description: "The URL that this rule applies to";
                    };
                    readonly pattern: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#patternType";
                    };
                    readonly action: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#actionType";
                    };
                    readonly reason: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#reasonType";
                    };
                    readonly createdBy: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "DID of the user who created this rule";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Optional comment about the decision";
                    };
                };
            };
            readonly eventType: {
                readonly type: "string";
                readonly knownValues: ["addRule", "updateRule", "removeRule"];
            };
            readonly patternType: {
                readonly type: "string";
                readonly knownValues: ["domain", "url"];
            };
            readonly actionType: {
                readonly type: "string";
                readonly knownValues: ["block", "warn", "whitelist"];
            };
            readonly reasonType: {
                readonly type: "string";
                readonly knownValues: ["csam", "spam", "phishing", "none"];
            };
            readonly urlRule: {
                readonly type: "object";
                readonly description: "Input for creating a URL safety rule";
                readonly required: ["url", "pattern", "action", "reason", "createdBy", "createdAt", "updatedAt"];
                readonly properties: {
                    readonly url: {
                        readonly type: "string";
                        readonly description: "The URL or domain to apply the rule to";
                    };
                    readonly pattern: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#patternType";
                    };
                    readonly action: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#actionType";
                    };
                    readonly reason: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#reasonType";
                    };
                    readonly comment: {
                        readonly type: "string";
                        readonly description: "Optional comment about the decision";
                    };
                    readonly createdBy: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "DID of the user added the rule.";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp when the rule was created";
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp when the rule was last updated";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSafelinkQueryEvents: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.safelink.queryEvents";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Query URL safety audit events";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                                readonly description: "Cursor for pagination";
                            };
                            readonly limit: {
                                readonly type: "integer";
                                readonly minimum: 1;
                                readonly maximum: 100;
                                readonly default: 50;
                                readonly description: "Maximum number of results to return";
                            };
                            readonly urls: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                                readonly description: "Filter by specific URLs or domains";
                            };
                            readonly patternType: {
                                readonly type: "string";
                                readonly description: "Filter by pattern type";
                            };
                            readonly sortDirection: {
                                readonly type: "string";
                                readonly knownValues: ["asc", "desc"];
                                readonly default: "desc";
                                readonly description: "Sort direction";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["events"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                                readonly description: "Next cursor for pagination. Only present if there are more results.";
                            };
                            readonly events: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.safelink.defs#event";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSafelinkQueryRules: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.safelink.queryRules";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Query URL safety rules";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                                readonly description: "Cursor for pagination";
                            };
                            readonly limit: {
                                readonly type: "integer";
                                readonly minimum: 1;
                                readonly maximum: 100;
                                readonly default: 50;
                                readonly description: "Maximum number of results to return";
                            };
                            readonly urls: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                                readonly description: "Filter by specific URLs or domains";
                            };
                            readonly patternType: {
                                readonly type: "string";
                                readonly description: "Filter by pattern type";
                            };
                            readonly actions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                                readonly description: "Filter by action types";
                            };
                            readonly reason: {
                                readonly type: "string";
                                readonly description: "Filter by reason type";
                            };
                            readonly createdBy: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "Filter by rule creator";
                            };
                            readonly sortDirection: {
                                readonly type: "string";
                                readonly knownValues: ["asc", "desc"];
                                readonly default: "desc";
                                readonly description: "Sort direction";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["rules"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                                readonly description: "Next cursor for pagination. Only present if there are more results.";
                            };
                            readonly rules: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.safelink.defs#urlRule";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSafelinkRemoveRule: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.safelink.removeRule";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Remove an existing URL safety rule";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["url", "pattern"];
                        readonly properties: {
                            readonly url: {
                                readonly type: "string";
                                readonly description: "The URL or domain to remove the rule for";
                            };
                            readonly pattern: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.safelink.defs#patternType";
                            };
                            readonly comment: {
                                readonly type: "string";
                                readonly description: "Optional comment about why the rule is being removed";
                            };
                            readonly createdBy: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "Optional DID of the user. Only respected when using admin auth.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#event";
                    };
                };
                readonly errors: [{
                    readonly name: "RuleNotFound";
                    readonly description: "No active rule found for this URL/domain";
                }];
            };
        };
    };
    readonly ToolsOzoneSafelinkUpdateRule: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.safelink.updateRule";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Update an existing URL safety rule";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["url", "pattern", "action", "reason"];
                        readonly properties: {
                            readonly url: {
                                readonly type: "string";
                                readonly description: "The URL or domain to update the rule for";
                            };
                            readonly pattern: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.safelink.defs#patternType";
                            };
                            readonly action: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.safelink.defs#actionType";
                            };
                            readonly reason: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.safelink.defs#reasonType";
                            };
                            readonly comment: {
                                readonly type: "string";
                                readonly description: "Optional comment about the update";
                            };
                            readonly createdBy: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "Optional DID to credit as the creator. Only respected for admin_token authentication.";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.safelink.defs#event";
                    };
                };
                readonly errors: [{
                    readonly name: "RuleNotFound";
                    readonly description: "No active rule found for this URL/domain";
                }];
            };
        };
    };
    readonly ToolsOzoneServerGetConfig: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.server.getConfig";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get details about ozone's server configuration.";
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {
                            readonly appview: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.server.getConfig#serviceConfig";
                            };
                            readonly pds: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.server.getConfig#serviceConfig";
                            };
                            readonly blobDivert: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.server.getConfig#serviceConfig";
                            };
                            readonly chat: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.server.getConfig#serviceConfig";
                            };
                            readonly viewer: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.server.getConfig#viewerConfig";
                            };
                            readonly verifierDid: {
                                readonly type: "string";
                                readonly format: "did";
                                readonly description: "The did of the verifier used for verification.";
                            };
                        };
                    };
                };
            };
            readonly serviceConfig: {
                readonly type: "object";
                readonly properties: {
                    readonly url: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                };
            };
            readonly viewerConfig: {
                readonly type: "object";
                readonly properties: {
                    readonly role: {
                        readonly type: "string";
                        readonly knownValues: ["tools.ozone.team.defs#roleAdmin", "tools.ozone.team.defs#roleModerator", "tools.ozone.team.defs#roleTriage", "tools.ozone.team.defs#roleVerifier"];
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSetAddValues: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.set.addValues";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Add values to a specific set. Attempting to add values to a set that does not exist will result in an error.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["name", "values"];
                        readonly properties: {
                            readonly name: {
                                readonly type: "string";
                                readonly description: "Name of the set to add values to";
                            };
                            readonly values: {
                                readonly type: "array";
                                readonly minLength: 1;
                                readonly maxLength: 1000;
                                readonly items: {
                                    readonly type: "string";
                                };
                                readonly description: "Array of string values to add to the set";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSetDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.set.defs";
        readonly defs: {
            readonly set: {
                readonly type: "object";
                readonly required: ["name"];
                readonly properties: {
                    readonly name: {
                        readonly type: "string";
                        readonly minLength: 3;
                        readonly maxLength: 128;
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly maxGraphemes: 1024;
                        readonly maxLength: 10240;
                    };
                };
            };
            readonly setView: {
                readonly type: "object";
                readonly required: ["name", "setSize", "createdAt", "updatedAt"];
                readonly properties: {
                    readonly name: {
                        readonly type: "string";
                        readonly minLength: 3;
                        readonly maxLength: 128;
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly maxGraphemes: 1024;
                        readonly maxLength: 10240;
                    };
                    readonly setSize: {
                        readonly type: "integer";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSetDeleteSet: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.set.deleteSet";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete an entire set. Attempting to delete a set that does not exist will result in an error.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["name"];
                        readonly properties: {
                            readonly name: {
                                readonly type: "string";
                                readonly description: "Name of the set to delete";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
                readonly errors: [{
                    readonly name: "SetNotFound";
                    readonly description: "set with the given name does not exist";
                }];
            };
        };
    };
    readonly ToolsOzoneSetDeleteValues: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.set.deleteValues";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete values from a specific set. Attempting to delete values that are not in the set will not result in an error";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["name", "values"];
                        readonly properties: {
                            readonly name: {
                                readonly type: "string";
                                readonly description: "Name of the set to delete values from";
                            };
                            readonly values: {
                                readonly type: "array";
                                readonly minLength: 1;
                                readonly items: {
                                    readonly type: "string";
                                };
                                readonly description: "Array of string values to delete from the set";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "SetNotFound";
                    readonly description: "set with the given name does not exist";
                }];
            };
        };
    };
    readonly ToolsOzoneSetGetValues: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.set.getValues";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get a specific set and its values";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["name"];
                    readonly properties: {
                        readonly name: {
                            readonly type: "string";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 1000;
                            readonly default: 100;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["set", "values"];
                        readonly properties: {
                            readonly set: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.set.defs#setView";
                            };
                            readonly values: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                            readonly cursor: {
                                readonly type: "string";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "SetNotFound";
                    readonly description: "set with the given name does not exist";
                }];
            };
        };
    };
    readonly ToolsOzoneSetQuerySets: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.set.querySets";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Query available sets";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly namePrefix: {
                            readonly type: "string";
                        };
                        readonly sortBy: {
                            readonly type: "string";
                            readonly enum: ["name", "createdAt", "updatedAt"];
                            readonly default: "name";
                        };
                        readonly sortDirection: {
                            readonly type: "string";
                            readonly default: "asc";
                            readonly enum: ["asc", "desc"];
                            readonly description: "Defaults to ascending order of name field.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["sets"];
                        readonly properties: {
                            readonly sets: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.set.defs#setView";
                                };
                            };
                            readonly cursor: {
                                readonly type: "string";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSetUpsertSet: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.set.upsertSet";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Create or update set metadata";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.set.defs#set";
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.set.defs#setView";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSettingDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.setting.defs";
        readonly defs: {
            readonly option: {
                readonly type: "object";
                readonly required: ["key", "value", "did", "scope", "createdBy", "lastUpdatedBy"];
                readonly properties: {
                    readonly key: {
                        readonly type: "string";
                        readonly format: "nsid";
                    };
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly value: {
                        readonly type: "unknown";
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly maxGraphemes: 1024;
                        readonly maxLength: 10240;
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly managerRole: {
                        readonly type: "string";
                        readonly knownValues: ["tools.ozone.team.defs#roleModerator", "tools.ozone.team.defs#roleTriage", "tools.ozone.team.defs#roleAdmin", "tools.ozone.team.defs#roleVerifier"];
                    };
                    readonly scope: {
                        readonly type: "string";
                        readonly knownValues: ["instance", "personal"];
                    };
                    readonly createdBy: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly lastUpdatedBy: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSettingListOptions: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.setting.listOptions";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "List settings with optional filtering";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly scope: {
                            readonly type: "string";
                            readonly knownValues: ["instance", "personal"];
                            readonly default: "instance";
                        };
                        readonly prefix: {
                            readonly type: "string";
                            readonly description: "Filter keys by prefix";
                        };
                        readonly keys: {
                            readonly type: "array";
                            readonly maxLength: 100;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "nsid";
                            };
                            readonly description: "Filter for only the specified keys. Ignored if prefix is provided";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["options"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly options: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.setting.defs#option";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSettingRemoveOptions: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.setting.removeOptions";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete settings by key";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["keys", "scope"];
                        readonly properties: {
                            readonly keys: {
                                readonly type: "array";
                                readonly minLength: 1;
                                readonly maxLength: 200;
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "nsid";
                                };
                            };
                            readonly scope: {
                                readonly type: "string";
                                readonly knownValues: ["instance", "personal"];
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly properties: {};
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSettingUpsertOption: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.setting.upsertOption";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Create or update setting option";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["key", "scope", "value"];
                        readonly properties: {
                            readonly key: {
                                readonly type: "string";
                                readonly format: "nsid";
                            };
                            readonly scope: {
                                readonly type: "string";
                                readonly knownValues: ["instance", "personal"];
                            };
                            readonly value: {
                                readonly type: "unknown";
                            };
                            readonly description: {
                                readonly type: "string";
                                readonly maxLength: 2000;
                            };
                            readonly managerRole: {
                                readonly type: "string";
                                readonly knownValues: ["tools.ozone.team.defs#roleModerator", "tools.ozone.team.defs#roleTriage", "tools.ozone.team.defs#roleVerifier", "tools.ozone.team.defs#roleAdmin"];
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["option"];
                        readonly properties: {
                            readonly option: {
                                readonly type: "ref";
                                readonly ref: "lex:tools.ozone.setting.defs#option";
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSignatureDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.signature.defs";
        readonly defs: {
            readonly sigDetail: {
                readonly type: "object";
                readonly required: ["property", "value"];
                readonly properties: {
                    readonly property: {
                        readonly type: "string";
                    };
                    readonly value: {
                        readonly type: "string";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSignatureFindCorrelation: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.signature.findCorrelation";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Find all correlated threat signatures between 2 or more accounts.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["dids"];
                    readonly properties: {
                        readonly dids: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["details"];
                        readonly properties: {
                            readonly details: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.signature.defs#sigDetail";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSignatureFindRelatedAccounts: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.signature.findRelatedAccounts";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Get accounts that share some matching threat signatures with the root account.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["did"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["accounts"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly accounts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.signature.findRelatedAccounts#relatedAccount";
                                };
                            };
                        };
                    };
                };
            };
            readonly relatedAccount: {
                readonly type: "object";
                readonly required: ["account"];
                readonly properties: {
                    readonly account: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.admin.defs#accountView";
                    };
                    readonly similarities: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:tools.ozone.signature.defs#sigDetail";
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneSignatureSearchAccounts: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.signature.searchAccounts";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "Search for accounts that match one or more threat signature values.";
                readonly parameters: {
                    readonly type: "params";
                    readonly required: ["values"];
                    readonly properties: {
                        readonly values: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["accounts"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly accounts: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:com.atproto.admin.defs#accountView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneTeamAddMember: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.team.addMember";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Add a member to the ozone team. Requires admin role.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did", "role"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly role: {
                                readonly type: "string";
                                readonly knownValues: ["tools.ozone.team.defs#roleAdmin", "tools.ozone.team.defs#roleModerator", "tools.ozone.team.defs#roleVerifier", "tools.ozone.team.defs#roleTriage"];
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.team.defs#member";
                    };
                };
                readonly errors: [{
                    readonly name: "MemberAlreadyExists";
                    readonly description: "Member already exists in the team.";
                }];
            };
        };
    };
    readonly ToolsOzoneTeamDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.team.defs";
        readonly defs: {
            readonly member: {
                readonly type: "object";
                readonly required: ["did", "role"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly disabled: {
                        readonly type: "boolean";
                    };
                    readonly profile: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewDetailed";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly updatedAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                    readonly lastUpdatedBy: {
                        readonly type: "string";
                    };
                    readonly role: {
                        readonly type: "string";
                        readonly knownValues: ["tools.ozone.team.defs#roleAdmin", "tools.ozone.team.defs#roleModerator", "tools.ozone.team.defs#roleTriage", "tools.ozone.team.defs#roleVerifier"];
                    };
                };
            };
            readonly roleAdmin: {
                readonly type: "token";
                readonly description: "Admin role. Highest level of access, can perform all actions.";
            };
            readonly roleModerator: {
                readonly type: "token";
                readonly description: "Moderator role. Can perform most actions.";
            };
            readonly roleTriage: {
                readonly type: "token";
                readonly description: "Triage role. Mostly intended for monitoring and escalating issues.";
            };
            readonly roleVerifier: {
                readonly type: "token";
                readonly description: "Verifier role. Only allowed to issue verifications.";
            };
        };
    };
    readonly ToolsOzoneTeamDeleteMember: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.team.deleteMember";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Delete a member from ozone team. Requires admin role.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                    };
                };
                readonly errors: [{
                    readonly name: "MemberNotFound";
                    readonly description: "The member being deleted does not exist";
                }, {
                    readonly name: "CannotDeleteSelf";
                    readonly description: "You can not delete yourself from the team";
                }];
            };
        };
    };
    readonly ToolsOzoneTeamListMembers: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.team.listMembers";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "List all members with access to the ozone service.";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly q: {
                            readonly type: "string";
                        };
                        readonly disabled: {
                            readonly type: "boolean";
                        };
                        readonly roles: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["members"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly members: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.team.defs#member";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneTeamUpdateMember: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.team.updateMember";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Update a member in the ozone service. Requires admin role.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["did"];
                        readonly properties: {
                            readonly did: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                            readonly disabled: {
                                readonly type: "boolean";
                            };
                            readonly role: {
                                readonly type: "string";
                                readonly knownValues: ["tools.ozone.team.defs#roleAdmin", "tools.ozone.team.defs#roleModerator", "tools.ozone.team.defs#roleVerifier", "tools.ozone.team.defs#roleTriage"];
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "ref";
                        readonly ref: "lex:tools.ozone.team.defs#member";
                    };
                };
                readonly errors: [{
                    readonly name: "MemberNotFound";
                    readonly description: "The member being updated does not exist in the team";
                }];
            };
        };
    };
    readonly ToolsOzoneVerificationDefs: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.verification.defs";
        readonly defs: {
            readonly verificationView: {
                readonly type: "object";
                readonly description: "Verification data for the associated subject.";
                readonly required: ["issuer", "uri", "subject", "handle", "displayName", "createdAt"];
                readonly properties: {
                    readonly issuer: {
                        readonly type: "string";
                        readonly description: "The user who issued this verification.";
                        readonly format: "did";
                    };
                    readonly uri: {
                        readonly type: "string";
                        readonly description: "The AT-URI of the verification record.";
                        readonly format: "at-uri";
                    };
                    readonly subject: {
                        readonly type: "string";
                        readonly format: "did";
                        readonly description: "The subject of the verification.";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly description: "Handle of the subject the verification applies to at the moment of verifying, which might not be the same at the time of viewing. The verification is only valid if the current handle matches the one at the time of verifying.";
                        readonly format: "handle";
                    };
                    readonly displayName: {
                        readonly type: "string";
                        readonly description: "Display name of the subject the verification applies to at the moment of verifying, which might not be the same at the time of viewing. The verification is only valid if the current displayName matches the one at the time of verifying.";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly description: "Timestamp when the verification was created.";
                        readonly format: "datetime";
                    };
                    readonly revokeReason: {
                        readonly type: "string";
                        readonly description: "Describes the reason for revocation, also indicating that the verification is no longer valid.";
                    };
                    readonly revokedAt: {
                        readonly type: "string";
                        readonly description: "Timestamp when the verification was revoked.";
                        readonly format: "datetime";
                    };
                    readonly revokedBy: {
                        readonly type: "string";
                        readonly description: "The user who revoked this verification.";
                        readonly format: "did";
                    };
                    readonly subjectProfile: {
                        readonly type: "union";
                        readonly refs: [];
                    };
                    readonly issuerProfile: {
                        readonly type: "union";
                        readonly refs: [];
                    };
                    readonly subjectRepo: {
                        readonly type: "union";
                        readonly refs: ["lex:tools.ozone.moderation.defs#repoViewDetail", "lex:tools.ozone.moderation.defs#repoViewNotFound"];
                    };
                    readonly issuerRepo: {
                        readonly type: "union";
                        readonly refs: ["lex:tools.ozone.moderation.defs#repoViewDetail", "lex:tools.ozone.moderation.defs#repoViewNotFound"];
                    };
                };
            };
        };
    };
    readonly ToolsOzoneVerificationGrantVerifications: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.verification.grantVerifications";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Grant verifications to multiple subjects. Allows batch processing of up to 100 verifications at once.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["verifications"];
                        readonly properties: {
                            readonly verifications: {
                                readonly type: "array";
                                readonly description: "Array of verification requests to process";
                                readonly maxLength: 100;
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.verification.grantVerifications#verificationInput";
                                };
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["verifications", "failedVerifications"];
                        readonly properties: {
                            readonly verifications: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.verification.defs#verificationView";
                                };
                            };
                            readonly failedVerifications: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.verification.grantVerifications#grantError";
                                };
                            };
                        };
                    };
                };
            };
            readonly verificationInput: {
                readonly type: "object";
                readonly required: ["subject", "handle", "displayName"];
                readonly properties: {
                    readonly subject: {
                        readonly type: "string";
                        readonly description: "The did of the subject being verified";
                        readonly format: "did";
                    };
                    readonly handle: {
                        readonly type: "string";
                        readonly description: "Handle of the subject the verification applies to at the moment of verifying.";
                        readonly format: "handle";
                    };
                    readonly displayName: {
                        readonly type: "string";
                        readonly description: "Display name of the subject the verification applies to at the moment of verifying.";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                        readonly description: "Timestamp for verification record. Defaults to current time when not specified.";
                    };
                };
            };
            readonly grantError: {
                readonly type: "object";
                readonly description: "Error object for failed verifications.";
                readonly required: ["error", "subject"];
                readonly properties: {
                    readonly error: {
                        readonly type: "string";
                        readonly description: "Error message describing the reason for failure.";
                    };
                    readonly subject: {
                        readonly type: "string";
                        readonly description: "The did of the subject being verified";
                        readonly format: "did";
                    };
                };
            };
        };
    };
    readonly ToolsOzoneVerificationListVerifications: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.verification.listVerifications";
        readonly defs: {
            readonly main: {
                readonly type: "query";
                readonly description: "List verifications";
                readonly parameters: {
                    readonly type: "params";
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                            readonly description: "Pagination cursor";
                        };
                        readonly limit: {
                            readonly type: "integer";
                            readonly description: "Maximum number of results to return";
                            readonly minimum: 1;
                            readonly maximum: 100;
                            readonly default: 50;
                        };
                        readonly createdAfter: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Filter to verifications created after this timestamp";
                        };
                        readonly createdBefore: {
                            readonly type: "string";
                            readonly format: "datetime";
                            readonly description: "Filter to verifications created before this timestamp";
                        };
                        readonly issuers: {
                            readonly type: "array";
                            readonly maxLength: 100;
                            readonly description: "Filter to verifications from specific issuers";
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                        readonly subjects: {
                            readonly type: "array";
                            readonly description: "Filter to specific verified DIDs";
                            readonly maxLength: 100;
                            readonly items: {
                                readonly type: "string";
                                readonly format: "did";
                            };
                        };
                        readonly sortDirection: {
                            readonly type: "string";
                            readonly description: "Sort direction for creation date";
                            readonly enum: ["asc", "desc"];
                            readonly default: "desc";
                        };
                        readonly isRevoked: {
                            readonly type: "boolean";
                            readonly description: "Filter to verifications that are revoked or not. By default, includes both.";
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["verifications"];
                        readonly properties: {
                            readonly cursor: {
                                readonly type: "string";
                            };
                            readonly verifications: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.verification.defs#verificationView";
                                };
                            };
                        };
                    };
                };
            };
        };
    };
    readonly ToolsOzoneVerificationRevokeVerifications: {
        readonly lexicon: 1;
        readonly id: "tools.ozone.verification.revokeVerifications";
        readonly defs: {
            readonly main: {
                readonly type: "procedure";
                readonly description: "Revoke previously granted verifications in batches of up to 100.";
                readonly input: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["uris"];
                        readonly properties: {
                            readonly uris: {
                                readonly type: "array";
                                readonly description: "Array of verification record uris to revoke";
                                readonly maxLength: 100;
                                readonly items: {
                                    readonly type: "string";
                                    readonly description: "The AT-URI of the verification record to revoke.";
                                    readonly format: "at-uri";
                                };
                            };
                            readonly revokeReason: {
                                readonly type: "string";
                                readonly description: "Reason for revoking the verification. This is optional and can be omitted if not needed.";
                                readonly maxLength: 1000;
                            };
                        };
                    };
                };
                readonly output: {
                    readonly encoding: "application/json";
                    readonly schema: {
                        readonly type: "object";
                        readonly required: ["revokedVerifications", "failedRevocations"];
                        readonly properties: {
                            readonly revokedVerifications: {
                                readonly type: "array";
                                readonly description: "List of verification uris successfully revoked";
                                readonly items: {
                                    readonly type: "string";
                                    readonly format: "at-uri";
                                };
                            };
                            readonly failedRevocations: {
                                readonly type: "array";
                                readonly description: "List of verification uris that couldn't be revoked, including failure reasons";
                                readonly items: {
                                    readonly type: "ref";
                                    readonly ref: "lex:tools.ozone.verification.revokeVerifications#revokeError";
                                };
                            };
                        };
                    };
                };
            };
            readonly revokeError: {
                readonly type: "object";
                readonly description: "Error object for failed revocations";
                readonly required: ["uri", "error"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly description: "The AT-URI of the verification record that failed to revoke.";
                        readonly format: "at-uri";
                    };
                    readonly error: {
                        readonly type: "string";
                        readonly description: "Description of the error that occurred during revocation.";
                    };
                };
            };
        };
    };
};
export declare const schemas: ({
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.defs";
    readonly defs: {
        readonly profileViewBasic: {
            readonly type: "object";
            readonly required: ["did", "handle"];
            readonly properties: {
                readonly did: {
                    readonly type: "string";
                    readonly format: "did";
                };
                readonly handle: {
                    readonly type: "string";
                    readonly format: "handle";
                };
                readonly displayName: {
                    readonly type: "string";
                    readonly maxGraphemes: 64;
                    readonly maxLength: 640;
                };
                readonly pronouns: {
                    readonly type: "string";
                };
                readonly avatar: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly associated: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileAssociated";
                };
                readonly viewer: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#viewerState";
                };
                readonly labels: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.label.defs#label";
                    };
                };
                readonly createdAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly verification: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#verificationState";
                };
                readonly status: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#statusView";
                };
                readonly debug: {
                    readonly type: "unknown";
                    readonly description: "Debug information for internal development";
                };
            };
        };
        readonly profileView: {
            readonly type: "object";
            readonly required: ["did", "handle"];
            readonly properties: {
                readonly did: {
                    readonly type: "string";
                    readonly format: "did";
                };
                readonly handle: {
                    readonly type: "string";
                    readonly format: "handle";
                };
                readonly displayName: {
                    readonly type: "string";
                    readonly maxGraphemes: 64;
                    readonly maxLength: 640;
                };
                readonly pronouns: {
                    readonly type: "string";
                };
                readonly description: {
                    readonly type: "string";
                    readonly maxGraphemes: 256;
                    readonly maxLength: 2560;
                };
                readonly avatar: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly associated: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileAssociated";
                };
                readonly indexedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly createdAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly viewer: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#viewerState";
                };
                readonly labels: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.label.defs#label";
                    };
                };
                readonly verification: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#verificationState";
                };
                readonly status: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#statusView";
                };
                readonly debug: {
                    readonly type: "unknown";
                    readonly description: "Debug information for internal development";
                };
            };
        };
        readonly profileViewDetailed: {
            readonly type: "object";
            readonly required: ["did", "handle"];
            readonly properties: {
                readonly did: {
                    readonly type: "string";
                    readonly format: "did";
                };
                readonly handle: {
                    readonly type: "string";
                    readonly format: "handle";
                };
                readonly displayName: {
                    readonly type: "string";
                    readonly maxGraphemes: 64;
                    readonly maxLength: 640;
                };
                readonly description: {
                    readonly type: "string";
                    readonly maxGraphemes: 256;
                    readonly maxLength: 2560;
                };
                readonly pronouns: {
                    readonly type: "string";
                };
                readonly website: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly avatar: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly banner: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly followersCount: {
                    readonly type: "integer";
                };
                readonly followsCount: {
                    readonly type: "integer";
                };
                readonly postsCount: {
                    readonly type: "integer";
                };
                readonly associated: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileAssociated";
                };
                readonly joinedViaStarterPack: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.graph.defs#starterPackViewBasic";
                };
                readonly indexedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly createdAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly viewer: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#viewerState";
                };
                readonly labels: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.label.defs#label";
                    };
                };
                readonly pinnedPost: {
                    readonly type: "ref";
                    readonly ref: "lex:com.atproto.repo.strongRef";
                };
                readonly verification: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#verificationState";
                };
                readonly status: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#statusView";
                };
                readonly debug: {
                    readonly type: "unknown";
                    readonly description: "Debug information for internal development";
                };
            };
        };
        readonly profileAssociated: {
            readonly type: "object";
            readonly properties: {
                readonly lists: {
                    readonly type: "integer";
                };
                readonly feedgens: {
                    readonly type: "integer";
                };
                readonly starterPacks: {
                    readonly type: "integer";
                };
                readonly labeler: {
                    readonly type: "boolean";
                };
                readonly chat: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileAssociatedChat";
                };
                readonly activitySubscription: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileAssociatedActivitySubscription";
                };
            };
        };
        readonly profileAssociatedChat: {
            readonly type: "object";
            readonly required: ["allowIncoming"];
            readonly properties: {
                readonly allowIncoming: {
                    readonly type: "string";
                    readonly knownValues: ["all", "none", "following"];
                };
            };
        };
        readonly profileAssociatedActivitySubscription: {
            readonly type: "object";
            readonly required: ["allowSubscriptions"];
            readonly properties: {
                readonly allowSubscriptions: {
                    readonly type: "string";
                    readonly knownValues: ["followers", "mutuals", "none"];
                };
            };
        };
        readonly viewerState: {
            readonly type: "object";
            readonly description: "Metadata about the requesting account's relationship with the subject account. Only has meaningful content for authed requests.";
            readonly properties: {
                readonly muted: {
                    readonly type: "boolean";
                };
                readonly mutedByList: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.graph.defs#listViewBasic";
                };
                readonly blockedBy: {
                    readonly type: "boolean";
                };
                readonly blocking: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly blockingByList: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.graph.defs#listViewBasic";
                };
                readonly following: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly followedBy: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly knownFollowers: {
                    readonly description: "This property is present only in selected cases, as an optimization.";
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#knownFollowers";
                };
                readonly activitySubscription: {
                    readonly description: "This property is present only in selected cases, as an optimization.";
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.notification.defs#activitySubscription";
                };
            };
        };
        readonly knownFollowers: {
            readonly type: "object";
            readonly description: "The subject's followers whom you also follow";
            readonly required: ["count", "followers"];
            readonly properties: {
                readonly count: {
                    readonly type: "integer";
                };
                readonly followers: {
                    readonly type: "array";
                    readonly minLength: 0;
                    readonly maxLength: 5;
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                    };
                };
            };
        };
        readonly verificationState: {
            readonly type: "object";
            readonly description: "Represents the verification information about the user this object is attached to.";
            readonly required: ["verifications", "verifiedStatus", "trustedVerifierStatus"];
            readonly properties: {
                readonly verifications: {
                    readonly type: "array";
                    readonly description: "All verifications issued by trusted verifiers on behalf of this user. Verifications by untrusted verifiers are not included.";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#verificationView";
                    };
                };
                readonly verifiedStatus: {
                    readonly type: "string";
                    readonly description: "The user's status as a verified account.";
                    readonly knownValues: ["valid", "invalid", "none"];
                };
                readonly trustedVerifierStatus: {
                    readonly type: "string";
                    readonly description: "The user's status as a trusted verifier.";
                    readonly knownValues: ["valid", "invalid", "none"];
                };
            };
        };
        readonly verificationView: {
            readonly type: "object";
            readonly description: "An individual verification for an associated subject.";
            readonly required: ["issuer", "uri", "isValid", "createdAt"];
            readonly properties: {
                readonly issuer: {
                    readonly type: "string";
                    readonly description: "The user who issued this verification.";
                    readonly format: "did";
                };
                readonly uri: {
                    readonly type: "string";
                    readonly description: "The AT-URI of the verification record.";
                    readonly format: "at-uri";
                };
                readonly isValid: {
                    readonly type: "boolean";
                    readonly description: "True if the verification passes validation, otherwise false.";
                };
                readonly createdAt: {
                    readonly type: "string";
                    readonly description: "Timestamp when the verification was created.";
                    readonly format: "datetime";
                };
            };
        };
        readonly preferences: {
            readonly type: "array";
            readonly items: {
                readonly type: "union";
                readonly refs: ["lex:app.bsky.actor.defs#adultContentPref", "lex:app.bsky.actor.defs#contentLabelPref", "lex:app.bsky.actor.defs#savedFeedsPref", "lex:app.bsky.actor.defs#savedFeedsPrefV2", "lex:app.bsky.actor.defs#personalDetailsPref", "lex:app.bsky.actor.defs#declaredAgePref", "lex:app.bsky.actor.defs#feedViewPref", "lex:app.bsky.actor.defs#threadViewPref", "lex:app.bsky.actor.defs#interestsPref", "lex:app.bsky.actor.defs#mutedWordsPref", "lex:app.bsky.actor.defs#hiddenPostsPref", "lex:app.bsky.actor.defs#bskyAppStatePref", "lex:app.bsky.actor.defs#labelersPref", "lex:app.bsky.actor.defs#postInteractionSettingsPref", "lex:app.bsky.actor.defs#verificationPrefs"];
            };
        };
        readonly adultContentPref: {
            readonly type: "object";
            readonly required: ["enabled"];
            readonly properties: {
                readonly enabled: {
                    readonly type: "boolean";
                    readonly default: false;
                };
            };
        };
        readonly contentLabelPref: {
            readonly type: "object";
            readonly required: ["label", "visibility"];
            readonly properties: {
                readonly labelerDid: {
                    readonly type: "string";
                    readonly description: "Which labeler does this preference apply to? If undefined, applies globally.";
                    readonly format: "did";
                };
                readonly label: {
                    readonly type: "string";
                };
                readonly visibility: {
                    readonly type: "string";
                    readonly knownValues: ["ignore", "show", "warn", "hide"];
                };
            };
        };
        readonly savedFeed: {
            readonly type: "object";
            readonly required: ["id", "type", "value", "pinned"];
            readonly properties: {
                readonly id: {
                    readonly type: "string";
                };
                readonly type: {
                    readonly type: "string";
                    readonly knownValues: ["feed", "list", "timeline"];
                };
                readonly value: {
                    readonly type: "string";
                };
                readonly pinned: {
                    readonly type: "boolean";
                };
            };
        };
        readonly savedFeedsPrefV2: {
            readonly type: "object";
            readonly required: ["items"];
            readonly properties: {
                readonly items: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#savedFeed";
                    };
                };
            };
        };
        readonly savedFeedsPref: {
            readonly type: "object";
            readonly required: ["pinned", "saved"];
            readonly properties: {
                readonly pinned: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
                readonly saved: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                };
                readonly timelineIndex: {
                    readonly type: "integer";
                };
            };
        };
        readonly personalDetailsPref: {
            readonly type: "object";
            readonly properties: {
                readonly birthDate: {
                    readonly type: "string";
                    readonly format: "datetime";
                    readonly description: "The birth date of account owner.";
                };
            };
        };
        readonly declaredAgePref: {
            readonly type: "object";
            readonly description: "Read-only preference containing value(s) inferred from the user's declared birthdate. Absence of this preference object in the response indicates that the user has not made a declaration.";
            readonly properties: {
                readonly isOverAge13: {
                    readonly type: "boolean";
                    readonly description: "Indicates if the user has declared that they are over 13 years of age.";
                };
                readonly isOverAge16: {
                    readonly type: "boolean";
                    readonly description: "Indicates if the user has declared that they are over 16 years of age.";
                };
                readonly isOverAge18: {
                    readonly type: "boolean";
                    readonly description: "Indicates if the user has declared that they are over 18 years of age.";
                };
            };
        };
        readonly feedViewPref: {
            readonly type: "object";
            readonly required: ["feed"];
            readonly properties: {
                readonly feed: {
                    readonly type: "string";
                    readonly description: "The URI of the feed, or an identifier which describes the feed.";
                };
                readonly hideReplies: {
                    readonly type: "boolean";
                    readonly description: "Hide replies in the feed.";
                };
                readonly hideRepliesByUnfollowed: {
                    readonly type: "boolean";
                    readonly description: "Hide replies in the feed if they are not by followed users.";
                    readonly default: true;
                };
                readonly hideRepliesByLikeCount: {
                    readonly type: "integer";
                    readonly description: "Hide replies in the feed if they do not have this number of likes.";
                };
                readonly hideReposts: {
                    readonly type: "boolean";
                    readonly description: "Hide reposts in the feed.";
                };
                readonly hideQuotePosts: {
                    readonly type: "boolean";
                    readonly description: "Hide quote posts in the feed.";
                };
            };
        };
        readonly threadViewPref: {
            readonly type: "object";
            readonly properties: {
                readonly sort: {
                    readonly type: "string";
                    readonly description: "Sorting mode for threads.";
                    readonly knownValues: ["oldest", "newest", "most-likes", "random", "hotness"];
                };
            };
        };
        readonly interestsPref: {
            readonly type: "object";
            readonly required: ["tags"];
            readonly properties: {
                readonly tags: {
                    readonly type: "array";
                    readonly maxLength: 100;
                    readonly items: {
                        readonly type: "string";
                        readonly maxLength: 640;
                        readonly maxGraphemes: 64;
                    };
                    readonly description: "A list of tags which describe the account owner's interests gathered during onboarding.";
                };
            };
        };
        readonly mutedWordTarget: {
            readonly type: "string";
            readonly knownValues: ["content", "tag"];
            readonly maxLength: 640;
            readonly maxGraphemes: 64;
        };
        readonly mutedWord: {
            readonly type: "object";
            readonly description: "A word that the account owner has muted.";
            readonly required: ["value", "targets"];
            readonly properties: {
                readonly id: {
                    readonly type: "string";
                };
                readonly value: {
                    readonly type: "string";
                    readonly description: "The muted word itself.";
                    readonly maxLength: 10000;
                    readonly maxGraphemes: 1000;
                };
                readonly targets: {
                    readonly type: "array";
                    readonly description: "The intended targets of the muted word.";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#mutedWordTarget";
                    };
                };
                readonly actorTarget: {
                    readonly type: "string";
                    readonly description: "Groups of users to apply the muted word to. If undefined, applies to all users.";
                    readonly knownValues: ["all", "exclude-following"];
                    readonly default: "all";
                };
                readonly expiresAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                    readonly description: "The date and time at which the muted word will expire and no longer be applied.";
                };
            };
        };
        readonly mutedWordsPref: {
            readonly type: "object";
            readonly required: ["items"];
            readonly properties: {
                readonly items: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#mutedWord";
                    };
                    readonly description: "A list of words the account owner has muted.";
                };
            };
        };
        readonly hiddenPostsPref: {
            readonly type: "object";
            readonly required: ["items"];
            readonly properties: {
                readonly items: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly description: "A list of URIs of posts the account owner has hidden.";
                };
            };
        };
        readonly labelersPref: {
            readonly type: "object";
            readonly required: ["labelers"];
            readonly properties: {
                readonly labelers: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#labelerPrefItem";
                    };
                };
            };
        };
        readonly labelerPrefItem: {
            readonly type: "object";
            readonly required: ["did"];
            readonly properties: {
                readonly did: {
                    readonly type: "string";
                    readonly format: "did";
                };
            };
        };
        readonly bskyAppStatePref: {
            readonly description: "A grab bag of state that's specific to the bsky.app program. Third-party apps shouldn't use this.";
            readonly type: "object";
            readonly properties: {
                readonly activeProgressGuide: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#bskyAppProgressGuide";
                };
                readonly queuedNudges: {
                    readonly description: "An array of tokens which identify nudges (modals, popups, tours, highlight dots) that should be shown to the user.";
                    readonly type: "array";
                    readonly maxLength: 1000;
                    readonly items: {
                        readonly type: "string";
                        readonly maxLength: 100;
                    };
                };
                readonly nuxs: {
                    readonly description: "Storage for NUXs the user has encountered.";
                    readonly type: "array";
                    readonly maxLength: 100;
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.actor.defs#nux";
                    };
                };
            };
        };
        readonly bskyAppProgressGuide: {
            readonly description: "If set, an active progress guide. Once completed, can be set to undefined. Should have unspecced fields tracking progress.";
            readonly type: "object";
            readonly required: ["guide"];
            readonly properties: {
                readonly guide: {
                    readonly type: "string";
                    readonly maxLength: 100;
                };
            };
        };
        readonly nux: {
            readonly type: "object";
            readonly description: "A new user experiences (NUX) storage object";
            readonly required: ["id", "completed"];
            readonly properties: {
                readonly id: {
                    readonly type: "string";
                    readonly maxLength: 100;
                };
                readonly completed: {
                    readonly type: "boolean";
                    readonly default: false;
                };
                readonly data: {
                    readonly description: "Arbitrary data for the NUX. The structure is defined by the NUX itself. Limited to 300 characters.";
                    readonly type: "string";
                    readonly maxLength: 3000;
                    readonly maxGraphemes: 300;
                };
                readonly expiresAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                    readonly description: "The date and time at which the NUX will expire and should be considered completed.";
                };
            };
        };
        readonly verificationPrefs: {
            readonly type: "object";
            readonly description: "Preferences for how verified accounts appear in the app.";
            readonly required: [];
            readonly properties: {
                readonly hideBadges: {
                    readonly description: "Hide the blue check badges for verified accounts and trusted verifiers.";
                    readonly type: "boolean";
                    readonly default: false;
                };
            };
        };
        readonly postInteractionSettingsPref: {
            readonly type: "object";
            readonly description: "Default post interaction settings for the account. These values should be applied as default values when creating new posts. These refs should mirror the threadgate and postgate records exactly.";
            readonly required: [];
            readonly properties: {
                readonly threadgateAllowRules: {
                    readonly description: "Matches threadgate record. List of rules defining who can reply to this users posts. If value is an empty array, no one can reply. If value is undefined, anyone can reply.";
                    readonly type: "array";
                    readonly maxLength: 5;
                    readonly items: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.threadgate#mentionRule", "lex:app.bsky.feed.threadgate#followerRule", "lex:app.bsky.feed.threadgate#followingRule", "lex:app.bsky.feed.threadgate#listRule"];
                    };
                };
                readonly postgateEmbeddingRules: {
                    readonly description: "Matches postgate record. List of rules defining who can embed this users posts. If value is an empty array or is undefined, no particular rules apply and anyone can embed.";
                    readonly type: "array";
                    readonly maxLength: 5;
                    readonly items: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.postgate#disableRule"];
                    };
                };
            };
        };
        readonly statusView: {
            readonly type: "object";
            readonly required: ["status", "record"];
            readonly properties: {
                readonly status: {
                    readonly type: "string";
                    readonly description: "The status for the account.";
                    readonly knownValues: ["app.bsky.actor.status#live"];
                };
                readonly record: {
                    readonly type: "unknown";
                };
                readonly embed: {
                    readonly type: "union";
                    readonly description: "An optional embed associated with the status.";
                    readonly refs: ["lex:app.bsky.embed.external#view"];
                };
                readonly expiresAt: {
                    readonly type: "string";
                    readonly description: "The date when this status will expire. The application might choose to no longer return the status after expiration.";
                    readonly format: "datetime";
                };
                readonly isActive: {
                    readonly type: "boolean";
                    readonly description: "True if the status is not expired, false if it is expired. Only present if expiration was set.";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.getPreferences";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get private preferences attached to the current account. Expected use is synchronization between multiple devices, and import/export during account migration. Requires auth.";
            readonly parameters: {
                readonly type: "params";
                readonly properties: {};
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["preferences"];
                    readonly properties: {
                        readonly preferences: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#preferences";
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.getProfile";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get detailed profile view of an actor. Does not require auth, but contains relevant metadata with auth.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["actor"];
                readonly properties: {
                    readonly actor: {
                        readonly type: "string";
                        readonly format: "at-identifier";
                        readonly description: "Handle or DID of account to fetch profile of.";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileViewDetailed";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.getProfiles";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get detailed profile views of multiple actors.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["actors"];
                readonly properties: {
                    readonly actors: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "at-identifier";
                        };
                        readonly maxLength: 25;
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["profiles"];
                    readonly properties: {
                        readonly profiles: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#profileViewDetailed";
                            };
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.getSuggestions";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get a list of suggested actors. Expected use is discovery of accounts to follow during new account onboarding.";
            readonly parameters: {
                readonly type: "params";
                readonly properties: {
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["actors"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly actors: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#profileView";
                            };
                        };
                        readonly recId: {
                            readonly type: "integer";
                            readonly description: "Snowflake for this recommendation, use when submitting recommendation events.";
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.profile";
    readonly defs: {
        readonly main: {
            readonly type: "record";
            readonly description: "A declaration of a Bluesky account profile.";
            readonly key: "literal:self";
            readonly record: {
                readonly type: "object";
                readonly properties: {
                    readonly displayName: {
                        readonly type: "string";
                        readonly maxGraphemes: 64;
                        readonly maxLength: 640;
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly description: "Free-form profile description text.";
                        readonly maxGraphemes: 256;
                        readonly maxLength: 2560;
                    };
                    readonly pronouns: {
                        readonly type: "string";
                        readonly description: "Free-form pronouns text.";
                        readonly maxGraphemes: 20;
                        readonly maxLength: 200;
                    };
                    readonly website: {
                        readonly type: "string";
                        readonly format: "uri";
                    };
                    readonly avatar: {
                        readonly type: "blob";
                        readonly description: "Small image to be displayed next to posts from account. AKA, 'profile picture'";
                        readonly accept: ["image/png", "image/jpeg"];
                        readonly maxSize: 1000000;
                    };
                    readonly banner: {
                        readonly type: "blob";
                        readonly description: "Larger horizontal image to display behind profile view.";
                        readonly accept: ["image/png", "image/jpeg"];
                        readonly maxSize: 1000000;
                    };
                    readonly labels: {
                        readonly type: "union";
                        readonly description: "Self-label values, specific to the Bluesky application, on the overall account.";
                        readonly refs: ["lex:com.atproto.label.defs#selfLabels"];
                    };
                    readonly joinedViaStarterPack: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.repo.strongRef";
                    };
                    readonly pinnedPost: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.repo.strongRef";
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.putPreferences";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Set the private preferences attached to the account.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["preferences"];
                    readonly properties: {
                        readonly preferences: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.actor.defs#preferences";
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.searchActors";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Find actors (profiles) matching search criteria. Does not require auth.";
            readonly parameters: {
                readonly type: "params";
                readonly properties: {
                    readonly term: {
                        readonly type: "string";
                        readonly description: "DEPRECATED: use 'q' instead.";
                    };
                    readonly q: {
                        readonly type: "string";
                        readonly description: "Search query string. Syntax, phrase, boolean, and faceting is unspecified, but Lucene query syntax is recommended.";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 25;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["actors"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly actors: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#profileView";
                            };
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.searchActorsTypeahead";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Find actor suggestions for a prefix search term. Expected use is for auto-completion during text field entry. Does not require auth.";
            readonly parameters: {
                readonly type: "params";
                readonly properties: {
                    readonly term: {
                        readonly type: "string";
                        readonly description: "DEPRECATED: use 'q' instead.";
                    };
                    readonly q: {
                        readonly type: "string";
                        readonly description: "Search query prefix; not a full query string.";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 10;
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["actors"];
                    readonly properties: {
                        readonly actors: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                            };
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.actor.status";
    readonly defs: {
        readonly main: {
            readonly type: "record";
            readonly description: "A declaration of a Bluesky account status.";
            readonly key: "literal:self";
            readonly record: {
                readonly type: "object";
                readonly required: ["status", "createdAt"];
                readonly properties: {
                    readonly status: {
                        readonly type: "string";
                        readonly description: "The status for the account.";
                        readonly knownValues: ["app.bsky.actor.status#live"];
                    };
                    readonly embed: {
                        readonly type: "union";
                        readonly description: "An optional embed associated with the status.";
                        readonly refs: ["lex:app.bsky.embed.external"];
                    };
                    readonly durationMinutes: {
                        readonly type: "integer";
                        readonly description: "The duration of the status in minutes. Applications can choose to impose minimum and maximum limits.";
                        readonly minimum: 1;
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
        };
        readonly live: {
            readonly type: "token";
            readonly description: "Advertises an account as currently offering live content.";
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.ageassurance.begin";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Initiate Age Assurance for an account.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["email", "language", "countryCode"];
                    readonly properties: {
                        readonly email: {
                            readonly type: "string";
                            readonly description: "The user's email address to receive Age Assurance instructions.";
                        };
                        readonly language: {
                            readonly type: "string";
                            readonly description: "The user's preferred language for communication during the Age Assurance process.";
                        };
                        readonly countryCode: {
                            readonly type: "string";
                            readonly description: "An ISO 3166-1 alpha-2 code of the user's location.";
                        };
                        readonly regionCode: {
                            readonly type: "string";
                            readonly description: "An optional ISO 3166-2 code of the user's region or state within the country.";
                        };
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#state";
                };
            };
            readonly errors: [{
                readonly name: "InvalidEmail";
            }, {
                readonly name: "DidTooLong";
            }, {
                readonly name: "InvalidInitiation";
            }, {
                readonly name: "RegionNotSupported";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.ageassurance.defs";
    readonly defs: {
        readonly access: {
            readonly description: "The access level granted based on Age Assurance data we've processed.";
            readonly type: "string";
            readonly knownValues: ["unknown", "none", "safe", "full"];
        };
        readonly status: {
            readonly type: "string";
            readonly description: "The status of the Age Assurance process.";
            readonly knownValues: ["unknown", "pending", "assured", "blocked"];
        };
        readonly state: {
            readonly type: "object";
            readonly description: "The user's computed Age Assurance state.";
            readonly required: ["status", "access"];
            readonly properties: {
                readonly lastInitiatedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                    readonly description: "The timestamp when this state was last updated.";
                };
                readonly status: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#status";
                };
                readonly access: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#access";
                };
            };
        };
        readonly stateMetadata: {
            readonly type: "object";
            readonly description: "Additional metadata needed to compute Age Assurance state client-side.";
            readonly required: [];
            readonly properties: {
                readonly accountCreatedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                    readonly description: "The account creation timestamp.";
                };
            };
        };
        readonly config: {
            readonly type: "object";
            readonly description: "";
            readonly required: ["regions"];
            readonly properties: {
                readonly regions: {
                    readonly type: "array";
                    readonly description: "The per-region Age Assurance configuration.";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.ageassurance.defs#configRegion";
                    };
                };
            };
        };
        readonly configRegion: {
            readonly type: "object";
            readonly description: "The Age Assurance configuration for a specific region.";
            readonly required: ["countryCode", "rules"];
            readonly properties: {
                readonly countryCode: {
                    readonly type: "string";
                    readonly description: "The ISO 3166-1 alpha-2 country code this configuration applies to.";
                };
                readonly regionCode: {
                    readonly type: "string";
                    readonly description: "The ISO 3166-2 region code this configuration applies to. If omitted, the configuration applies to the entire country.";
                };
                readonly rules: {
                    readonly type: "array";
                    readonly description: "The ordered list of Age Assurance rules that apply to this region. Rules should be applied in order, and the first matching rule determines the access level granted. The rules array should always include a default rule as the last item.";
                    readonly items: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.ageassurance.defs#configRegionRuleDefault", "lex:app.bsky.ageassurance.defs#configRegionRuleIfDeclaredOverAge", "lex:app.bsky.ageassurance.defs#configRegionRuleIfDeclaredUnderAge", "lex:app.bsky.ageassurance.defs#configRegionRuleIfAssuredOverAge", "lex:app.bsky.ageassurance.defs#configRegionRuleIfAssuredUnderAge", "lex:app.bsky.ageassurance.defs#configRegionRuleIfAccountNewerThan", "lex:app.bsky.ageassurance.defs#configRegionRuleIfAccountOlderThan"];
                    };
                };
            };
        };
        readonly configRegionRuleDefault: {
            readonly type: "object";
            readonly description: "Age Assurance rule that applies by default.";
            readonly required: ["access"];
            readonly properties: {
                readonly access: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#access";
                };
            };
        };
        readonly configRegionRuleIfDeclaredOverAge: {
            readonly type: "object";
            readonly description: "Age Assurance rule that applies if the user has declared themselves equal-to or over a certain age.";
            readonly required: ["age", "access"];
            readonly properties: {
                readonly age: {
                    readonly type: "integer";
                    readonly description: "The age threshold as a whole integer.";
                };
                readonly access: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#access";
                };
            };
        };
        readonly configRegionRuleIfDeclaredUnderAge: {
            readonly type: "object";
            readonly description: "Age Assurance rule that applies if the user has declared themselves under a certain age.";
            readonly required: ["age", "access"];
            readonly properties: {
                readonly age: {
                    readonly type: "integer";
                    readonly description: "The age threshold as a whole integer.";
                };
                readonly access: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#access";
                };
            };
        };
        readonly configRegionRuleIfAssuredOverAge: {
            readonly type: "object";
            readonly description: "Age Assurance rule that applies if the user has been assured to be equal-to or over a certain age.";
            readonly required: ["age", "access"];
            readonly properties: {
                readonly age: {
                    readonly type: "integer";
                    readonly description: "The age threshold as a whole integer.";
                };
                readonly access: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#access";
                };
            };
        };
        readonly configRegionRuleIfAssuredUnderAge: {
            readonly type: "object";
            readonly description: "Age Assurance rule that applies if the user has been assured to be under a certain age.";
            readonly required: ["age", "access"];
            readonly properties: {
                readonly age: {
                    readonly type: "integer";
                    readonly description: "The age threshold as a whole integer.";
                };
                readonly access: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#access";
                };
            };
        };
        readonly configRegionRuleIfAccountNewerThan: {
            readonly type: "object";
            readonly description: "Age Assurance rule that applies if the account is equal-to or newer than a certain date.";
            readonly required: ["date", "access"];
            readonly properties: {
                readonly date: {
                    readonly type: "string";
                    readonly format: "datetime";
                    readonly description: "The date threshold as a datetime string.";
                };
                readonly access: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#access";
                };
            };
        };
        readonly configRegionRuleIfAccountOlderThan: {
            readonly type: "object";
            readonly description: "Age Assurance rule that applies if the account is older than a certain date.";
            readonly required: ["date", "access"];
            readonly properties: {
                readonly date: {
                    readonly type: "string";
                    readonly format: "datetime";
                    readonly description: "The date threshold as a datetime string.";
                };
                readonly access: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#access";
                };
            };
        };
        readonly event: {
            readonly type: "object";
            readonly description: "Object used to store Age Assurance data in stash.";
            readonly required: ["createdAt", "status", "access", "attemptId", "countryCode"];
            readonly properties: {
                readonly createdAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                    readonly description: "The date and time of this write operation.";
                };
                readonly attemptId: {
                    readonly type: "string";
                    readonly description: "The unique identifier for this instance of the Age Assurance flow, in UUID format.";
                };
                readonly status: {
                    readonly type: "string";
                    readonly description: "The status of the Age Assurance process.";
                    readonly knownValues: ["unknown", "pending", "assured", "blocked"];
                };
                readonly access: {
                    readonly description: "The access level granted based on Age Assurance data we've processed.";
                    readonly type: "string";
                    readonly knownValues: ["unknown", "none", "safe", "full"];
                };
                readonly countryCode: {
                    readonly type: "string";
                    readonly description: "The ISO 3166-1 alpha-2 country code provided when beginning the Age Assurance flow.";
                };
                readonly regionCode: {
                    readonly type: "string";
                    readonly description: "The ISO 3166-2 region code provided when beginning the Age Assurance flow.";
                };
                readonly email: {
                    readonly type: "string";
                    readonly description: "The email used for Age Assurance.";
                };
                readonly initIp: {
                    readonly type: "string";
                    readonly description: "The IP address used when initiating the Age Assurance flow.";
                };
                readonly initUa: {
                    readonly type: "string";
                    readonly description: "The user agent used when initiating the Age Assurance flow.";
                };
                readonly completeIp: {
                    readonly type: "string";
                    readonly description: "The IP address used when completing the Age Assurance flow.";
                };
                readonly completeUa: {
                    readonly type: "string";
                    readonly description: "The user agent used when completing the Age Assurance flow.";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.ageassurance.getConfig";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Returns Age Assurance configuration for use on the client.";
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.ageassurance.defs#config";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.ageassurance.getState";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Returns server-computed Age Assurance state, if available, and any additional metadata needed to compute Age Assurance state client-side.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["countryCode"];
                readonly properties: {
                    readonly countryCode: {
                        readonly type: "string";
                    };
                    readonly regionCode: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["state", "metadata"];
                    readonly properties: {
                        readonly state: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.ageassurance.defs#state";
                        };
                        readonly metadata: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.ageassurance.defs#stateMetadata";
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.bookmark.createBookmark";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Creates a private bookmark for the specified record. Currently, only `app.bsky.feed.post` records are supported. Requires authentication.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["uri", "cid"];
                    readonly properties: {
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                        readonly cid: {
                            readonly type: "string";
                            readonly format: "cid";
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "UnsupportedCollection";
                readonly description: "The URI to be bookmarked is for an unsupported collection.";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.bookmark.defs";
    readonly defs: {
        readonly bookmark: {
            readonly description: "Object used to store bookmark data in stash.";
            readonly type: "object";
            readonly required: ["subject"];
            readonly properties: {
                readonly subject: {
                    readonly description: "A strong ref to the record to be bookmarked. Currently, only `app.bsky.feed.post` records are supported.";
                    readonly type: "ref";
                    readonly ref: "lex:com.atproto.repo.strongRef";
                };
            };
        };
        readonly bookmarkView: {
            readonly type: "object";
            readonly required: ["subject", "item"];
            readonly properties: {
                readonly subject: {
                    readonly description: "A strong ref to the bookmarked record.";
                    readonly type: "ref";
                    readonly ref: "lex:com.atproto.repo.strongRef";
                };
                readonly createdAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly item: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.feed.defs#blockedPost", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#postView"];
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.bookmark.deleteBookmark";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Deletes a private bookmark for the specified record. Currently, only `app.bsky.feed.post` records are supported. Requires authentication.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["uri"];
                    readonly properties: {
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "UnsupportedCollection";
                readonly description: "The URI to be bookmarked is for an unsupported collection.";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.bookmark.getBookmarks";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Gets views of records bookmarked by the authenticated user. Requires authentication.";
            readonly parameters: {
                readonly type: "params";
                readonly properties: {
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["bookmarks"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly bookmarks: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.bookmark.defs#bookmarkView";
                            };
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.defs";
    readonly defs: {
        readonly matchAndContactIndex: {
            readonly description: "Associates a profile with the positional index of the contact import input in the call to `app.bsky.contact.importContacts`, so clients can know which phone caused a particular match.";
            readonly type: "object";
            readonly required: ["match", "contactIndex"];
            readonly properties: {
                readonly match: {
                    readonly description: "Profile of the matched user.";
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                };
                readonly contactIndex: {
                    readonly description: "The index of this match in the import contact input.";
                    readonly type: "integer";
                    readonly minimum: 0;
                    readonly maximum: 999;
                };
            };
        };
        readonly syncStatus: {
            readonly type: "object";
            readonly required: ["syncedAt", "matchesCount"];
            readonly properties: {
                readonly syncedAt: {
                    readonly description: "Last date when contacts where imported.";
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly matchesCount: {
                    readonly description: "Number of existing contact matches resulting of the user imports and of their imported contacts having imported the user. Matches stop being counted when the user either follows the matched contact or dismisses the match.";
                    readonly type: "integer";
                    readonly minimum: 0;
                };
            };
        };
        readonly notification: {
            readonly description: "A stash object to be sent via bsync representing a notification to be created.";
            readonly type: "object";
            readonly required: ["from", "to"];
            readonly properties: {
                readonly from: {
                    readonly description: "The DID of who this notification comes from.";
                    readonly type: "string";
                    readonly format: "did";
                };
                readonly to: {
                    readonly description: "The DID of who this notification should go to.";
                    readonly type: "string";
                    readonly format: "did";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.dismissMatch";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Removes a match that was found via contact import. It shouldn't appear again if the same contact is re-imported. Requires authentication.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["subject"];
                    readonly properties: {
                        readonly subject: {
                            readonly description: "The subject's DID to dismiss the match with.";
                            readonly type: "string";
                            readonly format: "did";
                        };
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly properties: {};
                };
            };
            readonly errors: [{
                readonly name: "InvalidDid";
            }, {
                readonly name: "InternalError";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.getMatches";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Returns the matched contacts (contacts that were mutually imported). Excludes dismissed matches. Requires authentication.";
            readonly parameters: {
                readonly type: "params";
                readonly properties: {
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["matches"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly matches: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.actor.defs#profileView";
                            };
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "InvalidDid";
            }, {
                readonly name: "InvalidLimit";
            }, {
                readonly name: "InvalidCursor";
            }, {
                readonly name: "InternalError";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.getSyncStatus";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Gets the user's current contact import status. Requires authentication.";
            readonly parameters: {
                readonly type: "params";
                readonly properties: {};
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly properties: {
                        readonly syncStatus: {
                            readonly description: "If present, indicates the user has imported their contacts. If not present, indicates the user never used the feature or called `app.bsky.contact.removeData` and didn't import again since.";
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.contact.defs#syncStatus";
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "InvalidDid";
            }, {
                readonly name: "InternalError";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.importContacts";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Import contacts for securely matching with other users. This follows the protocol explained in https://docs.bsky.app/blog/contact-import-rfc. Requires authentication.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["token", "contacts"];
                    readonly properties: {
                        readonly token: {
                            readonly description: "JWT to authenticate the call. Use the JWT received as a response to the call to `app.bsky.contact.verifyPhone`.";
                            readonly type: "string";
                        };
                        readonly contacts: {
                            readonly description: "List of phone numbers in global E.164 format (e.g., '+12125550123'). Phone numbers that cannot be normalized into a valid phone number will be discarded. Should not repeat the 'phone' input used in `app.bsky.contact.verifyPhone`.";
                            readonly type: "array";
                            readonly items: {
                                readonly type: "string";
                            };
                            readonly minLength: 1;
                            readonly maxLength: 1000;
                        };
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["matchesAndContactIndexes"];
                    readonly properties: {
                        readonly matchesAndContactIndexes: {
                            readonly description: "The users that matched during import and their indexes on the input contacts, so the client can correlate with its local list.";
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.contact.defs#matchAndContactIndex";
                            };
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "InvalidDid";
            }, {
                readonly name: "InvalidContacts";
            }, {
                readonly name: "TooManyContacts";
            }, {
                readonly name: "InvalidToken";
            }, {
                readonly name: "InternalError";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.removeData";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Removes all stored hashes used for contact matching, existing matches, and sync status. Requires authentication.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly properties: {};
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly properties: {};
                };
            };
            readonly errors: [{
                readonly name: "InvalidDid";
            }, {
                readonly name: "InternalError";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.sendNotification";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "System endpoint to send notifications related to contact imports. Requires role authentication.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["from", "to"];
                    readonly properties: {
                        readonly from: {
                            readonly description: "The DID of who this notification comes from.";
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly to: {
                            readonly description: "The DID of who this notification should go to.";
                            readonly type: "string";
                            readonly format: "did";
                        };
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly properties: {};
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.startPhoneVerification";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Starts a phone verification flow. The phone passed will receive a code via SMS that should be passed to `app.bsky.contact.verifyPhone`. Requires authentication.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["phone"];
                    readonly properties: {
                        readonly phone: {
                            readonly description: "The phone number to receive the code via SMS.";
                            readonly type: "string";
                        };
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly properties: {};
                };
            };
            readonly errors: [{
                readonly name: "RateLimitExceeded";
            }, {
                readonly name: "InvalidDid";
            }, {
                readonly name: "InvalidPhone";
            }, {
                readonly name: "InternalError";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.contact.verifyPhone";
    readonly defs: {
        readonly main: {
            readonly type: "procedure";
            readonly description: "Verifies control over a phone number with a code received via SMS and starts a contact import session. Requires authentication.";
            readonly input: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["phone", "code"];
                    readonly properties: {
                        readonly phone: {
                            readonly description: "The phone number to verify. Should be the same as the one passed to `app.bsky.contact.startPhoneVerification`.";
                            readonly type: "string";
                        };
                        readonly code: {
                            readonly description: "The code received via SMS as a result of the call to `app.bsky.contact.startPhoneVerification`.";
                            readonly type: "string";
                        };
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["token"];
                    readonly properties: {
                        readonly token: {
                            readonly description: "JWT to be used in a call to `app.bsky.contact.importContacts`. It is only valid for a single call.";
                            readonly type: "string";
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "RateLimitExceeded";
            }, {
                readonly name: "InvalidDid";
            }, {
                readonly name: "InvalidPhone";
            }, {
                readonly name: "InvalidCode";
            }, {
                readonly name: "InternalError";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.embed.defs";
    readonly defs: {
        readonly aspectRatio: {
            readonly type: "object";
            readonly description: "width:height represents an aspect ratio. It may be approximate, and may not correspond to absolute dimensions in any given unit.";
            readonly required: ["width", "height"];
            readonly properties: {
                readonly width: {
                    readonly type: "integer";
                    readonly minimum: 1;
                };
                readonly height: {
                    readonly type: "integer";
                    readonly minimum: 1;
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.embed.external";
    readonly defs: {
        readonly main: {
            readonly type: "object";
            readonly description: "A representation of some externally linked content (eg, a URL and 'card'), embedded in a Bluesky record (eg, a post).";
            readonly required: ["external"];
            readonly properties: {
                readonly external: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.embed.external#external";
                };
            };
        };
        readonly external: {
            readonly type: "object";
            readonly required: ["uri", "title", "description"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly title: {
                    readonly type: "string";
                };
                readonly description: {
                    readonly type: "string";
                };
                readonly thumb: {
                    readonly type: "blob";
                    readonly accept: ["image/*"];
                    readonly maxSize: 1000000;
                };
            };
        };
        readonly view: {
            readonly type: "object";
            readonly required: ["external"];
            readonly properties: {
                readonly external: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.embed.external#viewExternal";
                };
            };
        };
        readonly viewExternal: {
            readonly type: "object";
            readonly required: ["uri", "title", "description"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly title: {
                    readonly type: "string";
                };
                readonly description: {
                    readonly type: "string";
                };
                readonly thumb: {
                    readonly type: "string";
                    readonly format: "uri";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.embed.images";
    readonly description: "A set of images embedded in a Bluesky record (eg, a post).";
    readonly defs: {
        readonly main: {
            readonly type: "object";
            readonly required: ["images"];
            readonly properties: {
                readonly images: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.images#image";
                    };
                    readonly maxLength: 4;
                };
            };
        };
        readonly image: {
            readonly type: "object";
            readonly required: ["image", "alt"];
            readonly properties: {
                readonly image: {
                    readonly type: "blob";
                    readonly accept: ["image/*"];
                    readonly maxSize: 1000000;
                };
                readonly alt: {
                    readonly type: "string";
                    readonly description: "Alt text description of the image, for accessibility.";
                };
                readonly aspectRatio: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.embed.defs#aspectRatio";
                };
            };
        };
        readonly view: {
            readonly type: "object";
            readonly required: ["images"];
            readonly properties: {
                readonly images: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.images#viewImage";
                    };
                    readonly maxLength: 4;
                };
            };
        };
        readonly viewImage: {
            readonly type: "object";
            readonly required: ["thumb", "fullsize", "alt"];
            readonly properties: {
                readonly thumb: {
                    readonly type: "string";
                    readonly format: "uri";
                    readonly description: "Fully-qualified URL where a thumbnail of the image can be fetched. For example, CDN location provided by the App View.";
                };
                readonly fullsize: {
                    readonly type: "string";
                    readonly format: "uri";
                    readonly description: "Fully-qualified URL where a large version of the image can be fetched. May or may not be the exact original blob. For example, CDN location provided by the App View.";
                };
                readonly alt: {
                    readonly type: "string";
                    readonly description: "Alt text description of the image, for accessibility.";
                };
                readonly aspectRatio: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.embed.defs#aspectRatio";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.embed.record";
    readonly description: "A representation of a record embedded in a Bluesky record (eg, a post). For example, a quote-post, or sharing a feed generator record.";
    readonly defs: {
        readonly main: {
            readonly type: "object";
            readonly required: ["record"];
            readonly properties: {
                readonly record: {
                    readonly type: "ref";
                    readonly ref: "lex:com.atproto.repo.strongRef";
                };
            };
        };
        readonly view: {
            readonly type: "object";
            readonly required: ["record"];
            readonly properties: {
                readonly record: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.embed.record#viewRecord", "lex:app.bsky.embed.record#viewNotFound", "lex:app.bsky.embed.record#viewBlocked", "lex:app.bsky.embed.record#viewDetached", "lex:app.bsky.feed.defs#generatorView", "lex:app.bsky.graph.defs#listView", "lex:app.bsky.labeler.defs#labelerView", "lex:app.bsky.graph.defs#starterPackViewBasic"];
                };
            };
        };
        readonly viewRecord: {
            readonly type: "object";
            readonly required: ["uri", "cid", "author", "value", "indexedAt"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly cid: {
                    readonly type: "string";
                    readonly format: "cid";
                };
                readonly author: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                };
                readonly value: {
                    readonly type: "unknown";
                    readonly description: "The record data itself.";
                };
                readonly labels: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.label.defs#label";
                    };
                };
                readonly replyCount: {
                    readonly type: "integer";
                };
                readonly repostCount: {
                    readonly type: "integer";
                };
                readonly likeCount: {
                    readonly type: "integer";
                };
                readonly quoteCount: {
                    readonly type: "integer";
                };
                readonly embeds: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.embed.images#view", "lex:app.bsky.embed.video#view", "lex:app.bsky.embed.external#view", "lex:app.bsky.embed.record#view", "lex:app.bsky.embed.recordWithMedia#view"];
                    };
                };
                readonly indexedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
            };
        };
        readonly viewNotFound: {
            readonly type: "object";
            readonly required: ["uri", "notFound"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly notFound: {
                    readonly type: "boolean";
                    readonly const: true;
                };
            };
        };
        readonly viewBlocked: {
            readonly type: "object";
            readonly required: ["uri", "blocked", "author"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly blocked: {
                    readonly type: "boolean";
                    readonly const: true;
                };
                readonly author: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#blockedAuthor";
                };
            };
        };
        readonly viewDetached: {
            readonly type: "object";
            readonly required: ["uri", "detached"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly detached: {
                    readonly type: "boolean";
                    readonly const: true;
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.embed.recordWithMedia";
    readonly description: "A representation of a record embedded in a Bluesky record (eg, a post), alongside other compatible embeds. For example, a quote post and image, or a quote post and external URL card.";
    readonly defs: {
        readonly main: {
            readonly type: "object";
            readonly required: ["record", "media"];
            readonly properties: {
                readonly record: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.embed.record";
                };
                readonly media: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.embed.images", "lex:app.bsky.embed.video", "lex:app.bsky.embed.external"];
                };
            };
        };
        readonly view: {
            readonly type: "object";
            readonly required: ["record", "media"];
            readonly properties: {
                readonly record: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.embed.record#view";
                };
                readonly media: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.embed.images#view", "lex:app.bsky.embed.video#view", "lex:app.bsky.embed.external#view"];
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.embed.video";
    readonly description: "A video embedded in a Bluesky record (eg, a post).";
    readonly defs: {
        readonly main: {
            readonly type: "object";
            readonly required: ["video"];
            readonly properties: {
                readonly video: {
                    readonly type: "blob";
                    readonly description: "The mp4 video file. May be up to 100mb, formerly limited to 50mb.";
                    readonly accept: ["video/mp4"];
                    readonly maxSize: 100000000;
                };
                readonly captions: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.embed.video#caption";
                    };
                    readonly maxLength: 20;
                };
                readonly alt: {
                    readonly type: "string";
                    readonly description: "Alt text description of the video, for accessibility.";
                    readonly maxGraphemes: 1000;
                    readonly maxLength: 10000;
                };
                readonly aspectRatio: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.embed.defs#aspectRatio";
                };
            };
        };
        readonly caption: {
            readonly type: "object";
            readonly required: ["lang", "file"];
            readonly properties: {
                readonly lang: {
                    readonly type: "string";
                    readonly format: "language";
                };
                readonly file: {
                    readonly type: "blob";
                    readonly accept: ["text/vtt"];
                    readonly maxSize: 20000;
                };
            };
        };
        readonly view: {
            readonly type: "object";
            readonly required: ["cid", "playlist"];
            readonly properties: {
                readonly cid: {
                    readonly type: "string";
                    readonly format: "cid";
                };
                readonly playlist: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly thumbnail: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly alt: {
                    readonly type: "string";
                    readonly maxGraphemes: 1000;
                    readonly maxLength: 10000;
                };
                readonly aspectRatio: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.embed.defs#aspectRatio";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.defs";
    readonly defs: {
        readonly postView: {
            readonly type: "object";
            readonly required: ["uri", "cid", "author", "record", "indexedAt"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly cid: {
                    readonly type: "string";
                    readonly format: "cid";
                };
                readonly author: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                };
                readonly record: {
                    readonly type: "unknown";
                };
                readonly embed: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.embed.images#view", "lex:app.bsky.embed.video#view", "lex:app.bsky.embed.external#view", "lex:app.bsky.embed.record#view", "lex:app.bsky.embed.recordWithMedia#view"];
                };
                readonly bookmarkCount: {
                    readonly type: "integer";
                };
                readonly replyCount: {
                    readonly type: "integer";
                };
                readonly repostCount: {
                    readonly type: "integer";
                };
                readonly likeCount: {
                    readonly type: "integer";
                };
                readonly quoteCount: {
                    readonly type: "integer";
                };
                readonly indexedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly viewer: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#viewerState";
                };
                readonly labels: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.label.defs#label";
                    };
                };
                readonly threadgate: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#threadgateView";
                };
                readonly debug: {
                    readonly type: "unknown";
                    readonly description: "Debug information for internal development";
                };
            };
        };
        readonly viewerState: {
            readonly type: "object";
            readonly description: "Metadata about the requesting account's relationship with the subject content. Only has meaningful content for authed requests.";
            readonly properties: {
                readonly repost: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly like: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly bookmarked: {
                    readonly type: "boolean";
                };
                readonly threadMuted: {
                    readonly type: "boolean";
                };
                readonly replyDisabled: {
                    readonly type: "boolean";
                };
                readonly embeddingDisabled: {
                    readonly type: "boolean";
                };
                readonly pinned: {
                    readonly type: "boolean";
                };
            };
        };
        readonly threadContext: {
            readonly type: "object";
            readonly description: "Metadata about this post within the context of the thread it is in.";
            readonly properties: {
                readonly rootAuthorLike: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
            };
        };
        readonly feedViewPost: {
            readonly type: "object";
            readonly required: ["post"];
            readonly properties: {
                readonly post: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#postView";
                };
                readonly reply: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#replyRef";
                };
                readonly reason: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.feed.defs#reasonRepost", "lex:app.bsky.feed.defs#reasonPin"];
                };
                readonly feedContext: {
                    readonly type: "string";
                    readonly description: "Context provided by feed generator that may be passed back alongside interactions.";
                    readonly maxLength: 2000;
                };
                readonly reqId: {
                    readonly type: "string";
                    readonly description: "Unique identifier per request that may be passed back alongside interactions.";
                    readonly maxLength: 100;
                };
            };
        };
        readonly replyRef: {
            readonly type: "object";
            readonly required: ["root", "parent"];
            readonly properties: {
                readonly root: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.feed.defs#postView", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                };
                readonly parent: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.feed.defs#postView", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                };
                readonly grandparentAuthor: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                    readonly description: "When parent is a reply to another post, this is the author of that post.";
                };
            };
        };
        readonly reasonRepost: {
            readonly type: "object";
            readonly required: ["by", "indexedAt"];
            readonly properties: {
                readonly by: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileViewBasic";
                };
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly cid: {
                    readonly type: "string";
                    readonly format: "cid";
                };
                readonly indexedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
            };
        };
        readonly reasonPin: {
            readonly type: "object";
            readonly properties: {};
        };
        readonly threadViewPost: {
            readonly type: "object";
            readonly required: ["post"];
            readonly properties: {
                readonly post: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#postView";
                };
                readonly parent: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.feed.defs#threadViewPost", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                };
                readonly replies: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "union";
                        readonly refs: ["lex:app.bsky.feed.defs#threadViewPost", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                    };
                };
                readonly threadContext: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#threadContext";
                };
            };
        };
        readonly notFoundPost: {
            readonly type: "object";
            readonly required: ["uri", "notFound"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly notFound: {
                    readonly type: "boolean";
                    readonly const: true;
                };
            };
        };
        readonly blockedPost: {
            readonly type: "object";
            readonly required: ["uri", "blocked", "author"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly blocked: {
                    readonly type: "boolean";
                    readonly const: true;
                };
                readonly author: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#blockedAuthor";
                };
            };
        };
        readonly blockedAuthor: {
            readonly type: "object";
            readonly required: ["did"];
            readonly properties: {
                readonly did: {
                    readonly type: "string";
                    readonly format: "did";
                };
                readonly viewer: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#viewerState";
                };
            };
        };
        readonly generatorView: {
            readonly type: "object";
            readonly required: ["uri", "cid", "did", "creator", "displayName", "indexedAt"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly cid: {
                    readonly type: "string";
                    readonly format: "cid";
                };
                readonly did: {
                    readonly type: "string";
                    readonly format: "did";
                };
                readonly creator: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                };
                readonly displayName: {
                    readonly type: "string";
                };
                readonly description: {
                    readonly type: "string";
                    readonly maxGraphemes: 300;
                    readonly maxLength: 3000;
                };
                readonly descriptionFacets: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.richtext.facet";
                    };
                };
                readonly avatar: {
                    readonly type: "string";
                    readonly format: "uri";
                };
                readonly likeCount: {
                    readonly type: "integer";
                    readonly minimum: 0;
                };
                readonly acceptsInteractions: {
                    readonly type: "boolean";
                };
                readonly labels: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:com.atproto.label.defs#label";
                    };
                };
                readonly viewer: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.feed.defs#generatorViewerState";
                };
                readonly contentMode: {
                    readonly type: "string";
                    readonly knownValues: ["app.bsky.feed.defs#contentModeUnspecified", "app.bsky.feed.defs#contentModeVideo"];
                };
                readonly indexedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
            };
        };
        readonly generatorViewerState: {
            readonly type: "object";
            readonly properties: {
                readonly like: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
            };
        };
        readonly skeletonFeedPost: {
            readonly type: "object";
            readonly required: ["post"];
            readonly properties: {
                readonly post: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly reason: {
                    readonly type: "union";
                    readonly refs: ["lex:app.bsky.feed.defs#skeletonReasonRepost", "lex:app.bsky.feed.defs#skeletonReasonPin"];
                };
                readonly feedContext: {
                    readonly type: "string";
                    readonly description: "Context that will be passed through to client and may be passed to feed generator back alongside interactions.";
                    readonly maxLength: 2000;
                };
            };
        };
        readonly skeletonReasonRepost: {
            readonly type: "object";
            readonly required: ["repost"];
            readonly properties: {
                readonly repost: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
            };
        };
        readonly skeletonReasonPin: {
            readonly type: "object";
            readonly properties: {};
        };
        readonly threadgateView: {
            readonly type: "object";
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly cid: {
                    readonly type: "string";
                    readonly format: "cid";
                };
                readonly record: {
                    readonly type: "unknown";
                };
                readonly lists: {
                    readonly type: "array";
                    readonly items: {
                        readonly type: "ref";
                        readonly ref: "lex:app.bsky.graph.defs#listViewBasic";
                    };
                };
            };
        };
        readonly interaction: {
            readonly type: "object";
            readonly properties: {
                readonly item: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
                readonly event: {
                    readonly type: "string";
                    readonly knownValues: ["app.bsky.feed.defs#requestLess", "app.bsky.feed.defs#requestMore", "app.bsky.feed.defs#clickthroughItem", "app.bsky.feed.defs#clickthroughAuthor", "app.bsky.feed.defs#clickthroughReposter", "app.bsky.feed.defs#clickthroughEmbed", "app.bsky.feed.defs#interactionSeen", "app.bsky.feed.defs#interactionLike", "app.bsky.feed.defs#interactionRepost", "app.bsky.feed.defs#interactionReply", "app.bsky.feed.defs#interactionQuote", "app.bsky.feed.defs#interactionShare"];
                };
                readonly feedContext: {
                    readonly type: "string";
                    readonly description: "Context on a feed item that was originally supplied by the feed generator on getFeedSkeleton.";
                    readonly maxLength: 2000;
                };
                readonly reqId: {
                    readonly type: "string";
                    readonly description: "Unique identifier per request that may be passed back alongside interactions.";
                    readonly maxLength: 100;
                };
            };
        };
        readonly requestLess: {
            readonly type: "token";
            readonly description: "Request that less content like the given feed item be shown in the feed";
        };
        readonly requestMore: {
            readonly type: "token";
            readonly description: "Request that more content like the given feed item be shown in the feed";
        };
        readonly clickthroughItem: {
            readonly type: "token";
            readonly description: "User clicked through to the feed item";
        };
        readonly clickthroughAuthor: {
            readonly type: "token";
            readonly description: "User clicked through to the author of the feed item";
        };
        readonly clickthroughReposter: {
            readonly type: "token";
            readonly description: "User clicked through to the reposter of the feed item";
        };
        readonly clickthroughEmbed: {
            readonly type: "token";
            readonly description: "User clicked through to the embedded content of the feed item";
        };
        readonly contentModeUnspecified: {
            readonly type: "token";
            readonly description: "Declares the feed generator returns any types of posts.";
        };
        readonly contentModeVideo: {
            readonly type: "token";
            readonly description: "Declares the feed generator returns posts containing app.bsky.embed.video embeds.";
        };
        readonly interactionSeen: {
            readonly type: "token";
            readonly description: "Feed item was seen by user";
        };
        readonly interactionLike: {
            readonly type: "token";
            readonly description: "User liked the feed item";
        };
        readonly interactionRepost: {
            readonly type: "token";
            readonly description: "User reposted the feed item";
        };
        readonly interactionReply: {
            readonly type: "token";
            readonly description: "User replied to the feed item";
        };
        readonly interactionQuote: {
            readonly type: "token";
            readonly description: "User quoted the feed item";
        };
        readonly interactionShare: {
            readonly type: "token";
            readonly description: "User shared the feed item";
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.describeFeedGenerator";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get information about a feed generator, including policies and offered feed URIs. Does not require auth; implemented by Feed Generator services (not App View).";
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["did", "feeds"];
                    readonly properties: {
                        readonly did: {
                            readonly type: "string";
                            readonly format: "did";
                        };
                        readonly feeds: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.describeFeedGenerator#feed";
                            };
                        };
                        readonly links: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.feed.describeFeedGenerator#links";
                        };
                    };
                };
            };
        };
        readonly feed: {
            readonly type: "object";
            readonly required: ["uri"];
            readonly properties: {
                readonly uri: {
                    readonly type: "string";
                    readonly format: "at-uri";
                };
            };
        };
        readonly links: {
            readonly type: "object";
            readonly properties: {
                readonly privacyPolicy: {
                    readonly type: "string";
                };
                readonly termsOfService: {
                    readonly type: "string";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.generator";
    readonly defs: {
        readonly main: {
            readonly type: "record";
            readonly description: "Record declaring of the existence of a feed generator, and containing metadata about it. The record can exist in any repository.";
            readonly key: "any";
            readonly record: {
                readonly type: "object";
                readonly required: ["did", "displayName", "createdAt"];
                readonly properties: {
                    readonly did: {
                        readonly type: "string";
                        readonly format: "did";
                    };
                    readonly displayName: {
                        readonly type: "string";
                        readonly maxGraphemes: 24;
                        readonly maxLength: 240;
                    };
                    readonly description: {
                        readonly type: "string";
                        readonly maxGraphemes: 300;
                        readonly maxLength: 3000;
                    };
                    readonly descriptionFacets: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.richtext.facet";
                        };
                    };
                    readonly avatar: {
                        readonly type: "blob";
                        readonly accept: ["image/png", "image/jpeg"];
                        readonly maxSize: 1000000;
                    };
                    readonly acceptsInteractions: {
                        readonly type: "boolean";
                        readonly description: "Declaration that a feed accepts feedback interactions from a client through app.bsky.feed.sendInteractions";
                    };
                    readonly labels: {
                        readonly type: "union";
                        readonly description: "Self-label values";
                        readonly refs: ["lex:com.atproto.label.defs#selfLabels"];
                    };
                    readonly contentMode: {
                        readonly type: "string";
                        readonly knownValues: ["app.bsky.feed.defs#contentModeUnspecified", "app.bsky.feed.defs#contentModeVideo"];
                    };
                    readonly createdAt: {
                        readonly type: "string";
                        readonly format: "datetime";
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getActorFeeds";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get a list of feeds (feed generator records) created by the actor (in the actor's repo).";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["actor"];
                readonly properties: {
                    readonly actor: {
                        readonly type: "string";
                        readonly format: "at-identifier";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["feeds"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly feeds: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#generatorView";
                            };
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getActorLikes";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get a list of posts liked by an actor. Requires auth, actor must be the requesting account.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["actor"];
                readonly properties: {
                    readonly actor: {
                        readonly type: "string";
                        readonly format: "at-identifier";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["feed"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly feed: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                            };
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "BlockedActor";
            }, {
                readonly name: "BlockedByActor";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getAuthorFeed";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get a view of an actor's 'author feed' (post and reposts by the author). Does not require auth.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["actor"];
                readonly properties: {
                    readonly actor: {
                        readonly type: "string";
                        readonly format: "at-identifier";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                    readonly filter: {
                        readonly type: "string";
                        readonly description: "Combinations of post/repost types to include in response.";
                        readonly knownValues: ["posts_with_replies", "posts_no_replies", "posts_with_media", "posts_and_author_threads", "posts_with_video"];
                        readonly default: "posts_with_replies";
                    };
                    readonly includePins: {
                        readonly type: "boolean";
                        readonly default: false;
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["feed"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly feed: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                            };
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "BlockedActor";
            }, {
                readonly name: "BlockedByActor";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getFeed";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get a hydrated feed from an actor's selected feed generator. Implemented by App View.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["feed"];
                readonly properties: {
                    readonly feed: {
                        readonly type: "string";
                        readonly format: "at-uri";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["feed"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly feed: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                            };
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "UnknownFeed";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getFeedGenerator";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get information about a feed generator. Implemented by AppView.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["feed"];
                readonly properties: {
                    readonly feed: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "AT-URI of the feed generator record.";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["view", "isOnline", "isValid"];
                    readonly properties: {
                        readonly view: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.feed.defs#generatorView";
                        };
                        readonly isOnline: {
                            readonly type: "boolean";
                            readonly description: "Indicates whether the feed generator service has been online recently, or else seems to be inactive.";
                        };
                        readonly isValid: {
                            readonly type: "boolean";
                            readonly description: "Indicates whether the feed generator service is compatible with the record declaration.";
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getFeedGenerators";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get information about a list of feed generators.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["feeds"];
                readonly properties: {
                    readonly feeds: {
                        readonly type: "array";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["feeds"];
                    readonly properties: {
                        readonly feeds: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#generatorView";
                            };
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getFeedSkeleton";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get a skeleton of a feed provided by a feed generator. Auth is optional, depending on provider requirements, and provides the DID of the requester. Implemented by Feed Generator Service.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["feed"];
                readonly properties: {
                    readonly feed: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "Reference to feed generator record describing the specific feed being requested.";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["feed"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly feed: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#skeletonFeedPost";
                            };
                        };
                        readonly reqId: {
                            readonly type: "string";
                            readonly description: "Unique identifier per request that may be passed back alongside interactions.";
                            readonly maxLength: 100;
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "UnknownFeed";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getLikes";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get like records which reference a subject (by AT-URI and CID).";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "AT-URI of the subject (eg, a post record).";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                        readonly description: "CID of the subject record (aka, specific version of record), to filter likes.";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["uri", "likes"];
                    readonly properties: {
                        readonly uri: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                        readonly cid: {
                            readonly type: "string";
                            readonly format: "cid";
                        };
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly likes: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.getLikes#like";
                            };
                        };
                    };
                };
            };
        };
        readonly like: {
            readonly type: "object";
            readonly required: ["indexedAt", "createdAt", "actor"];
            readonly properties: {
                readonly indexedAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly createdAt: {
                    readonly type: "string";
                    readonly format: "datetime";
                };
                readonly actor: {
                    readonly type: "ref";
                    readonly ref: "lex:app.bsky.actor.defs#profileView";
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getListFeed";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get a feed of recent posts from a list (posts and reposts from any actors on the list). Does not require auth.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["list"];
                readonly properties: {
                    readonly list: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "Reference (AT-URI) to the list record.";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                        readonly type: "string";
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["feed"];
                    readonly properties: {
                        readonly cursor: {
                            readonly type: "string";
                        };
                        readonly feed: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#feedViewPost";
                            };
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "UnknownList";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getPostThread";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get posts in a thread. Does not require auth, but additional metadata and filtering will be applied for authed requests.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "Reference (AT-URI) to post record.";
                    };
                    readonly depth: {
                        readonly type: "integer";
                        readonly description: "How many levels of reply depth should be included in response.";
                        readonly default: 6;
                        readonly minimum: 0;
                        readonly maximum: 1000;
                    };
                    readonly parentHeight: {
                        readonly type: "integer";
                        readonly description: "How many levels of parent (and grandparent, etc) post to include.";
                        readonly default: 80;
                        readonly minimum: 0;
                        readonly maximum: 1000;
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["thread"];
                    readonly properties: {
                        readonly thread: {
                            readonly type: "union";
                            readonly refs: ["lex:app.bsky.feed.defs#threadViewPost", "lex:app.bsky.feed.defs#notFoundPost", "lex:app.bsky.feed.defs#blockedPost"];
                        };
                        readonly threadgate: {
                            readonly type: "ref";
                            readonly ref: "lex:app.bsky.feed.defs#threadgateView";
                        };
                    };
                };
            };
            readonly errors: [{
                readonly name: "NotFound";
            }];
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getPosts";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Gets post views for a specified list of posts (by AT-URI). This is sometimes referred to as 'hydrating' a 'feed skeleton'.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["uris"];
                readonly properties: {
                    readonly uris: {
                        readonly type: "array";
                        readonly description: "List of post AT-URIs to return hydrated views for.";
                        readonly items: {
                            readonly type: "string";
                            readonly format: "at-uri";
                        };
                        readonly maxLength: 25;
                    };
                };
            };
            readonly output: {
                readonly encoding: "application/json";
                readonly schema: {
                    readonly type: "object";
                    readonly required: ["posts"];
                    readonly properties: {
                        readonly posts: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "ref";
                                readonly ref: "lex:app.bsky.feed.defs#postView";
                            };
                        };
                    };
                };
            };
        };
    };
} | {
    readonly lexicon: 1;
    readonly id: "app.bsky.feed.getQuotes";
    readonly defs: {
        readonly main: {
            readonly type: "query";
            readonly description: "Get a list of quotes for a given post.";
            readonly parameters: {
                readonly type: "params";
                readonly required: ["uri"];
                readonly properties: {
                    readonly uri: {
                        readonly type: "string";
                        readonly format: "at-uri";
                        readonly description: "Reference (AT-URI) of post record";
                    };
                    readonly cid: {
                        readonly type: "string";
                        readonly format: "cid";
                        readonly description: "If supplied, filters to quotes of specific version (by CID) of the post record.";
                    };
                    readonly limit: {
                        readonly type: "integer";
                        readonly minimum: 1;
                        readonly maximum: 100;
                        readonly default: 50;
                    };
                    readonly cursor: {
                   