import * as React from 'react';
import Svg, { G, Circle, Rect, Path } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 0 345 345"
			{...props}
		>
			<G data-name="Layer 4">
				<G fill="#ffd133">
					<Circle cx={172.5} cy={172.5} r={111.34} />
					<Rect
						width={19.45}
						height={41.4}
						x={162.78}
						y={303.6}
						rx={9.72}
						transform="rotate(180 172.5 324.3)"
					/>
					<Rect
						width={19.45}
						height={41.4}
						x={162.78}
						rx={9.72}
						transform="rotate(180 172.5 20.7)"
					/>
					<Rect
						width={19.45}
						height={41.4}
						x={10.98}
						y={151.8}
						rx={9.72}
						transform="rotate(-90 20.7 172.5)"
					/>
					<Rect
						width={19.45}
						height={41.4}
						x={314.58}
						y={151.8}
						rx={9.72}
						transform="rotate(-90 324.3 172.5)"
					/>
					<Rect
						width={19.45}
						height={41.4}
						x={270.12}
						y={44.46}
						rx={9.72}
						transform="rotate(-135 279.858 65.173)"
					/>
					<Rect
						width={19.45}
						height={41.4}
						x={55.44}
						y={259.14}
						rx={9.72}
						transform="rotate(-135 65.157 279.862)"
					/>
					<Rect
						width={19.45}
						height={41.4}
						x={55.44}
						y={44.46}
						rx={9.72}
						transform="rotate(135 65.167 65.163)"
					/>
					<Rect
						width={19.45}
						height={41.4}
						x={270.12}
						y={259.14}
						rx={9.72}
						transform="rotate(135 279.868 279.852)"
					/>
				</G>
				<Path
					fill="#fec200"
					d="M283.84 172.5A111.34 111.34 0 0 1 172.5 283.84q-4.11 0-8.15-.29a111.35 111.35 0 0 0 0-222.09q4-.29 8.15-.29A111.34 111.34 0 0 1 283.84 172.5zM182.22 313.32v22a9.72 9.72 0 0 1-9.72 9.68 9.62 9.62 0 0 1-3.14-.52 9.72 9.72 0 0 0 6.59-9.2v-22a9.72 9.72 0 0 0-6.59-9.2 9.62 9.62 0 0 1 3.14-.52 9.72 9.72 0 0 1 9.72 9.76zM182.22 9.72v22a9.72 9.72 0 0 1-9.72 9.72 9.62 9.62 0 0 1-3.14-.52 9.72 9.72 0 0 0 6.59-9.2v-22a9.72 9.72 0 0 0-6.59-9.2A9.62 9.62 0 0 1 172.5 0a9.72 9.72 0 0 1 9.72 9.72zM345 172.5a9.72 9.72 0 0 1-9.72 9.72H329a9.72 9.72 0 0 0 0-19.45h6.27a9.72 9.72 0 0 1 9.73 9.73zM294.47 64.28 279 79.8a9.72 9.72 0 0 1-10 2.33 9.67 9.67 0 0 0 3.74-2.33l15.46-15.52a9.73 9.73 0 0 0-3.74-16.08 9.73 9.73 0 0 1 10 16.08zM294.47 294.47a9.71 9.71 0 0 1-10 2.33 9.73 9.73 0 0 0 3.74-16.08l-15.53-15.52a9.67 9.67 0 0 0-3.74-2.33 9.72 9.72 0 0 1 10 2.33l15.52 15.52a9.71 9.71 0 0 1 .01 13.75z"
				/>
			</G>
			<Path d="M114.24 208.83c-3.08-8.69 10.88-14.51 27.09-14.51s30.16 5.82 27.09 14.51c-2.61 7.36-.81 9.18-27.09 9.18s-24.49-1.82-27.09-9.18z" />
			<Path
				fill="#f8c09d"
				d="M141.32 210.87c-5.2 0-14 1.08-21.1 5.78 3.47 1 9.59 1.36 21.1 1.36s17.63-.35 21.09-1.36c-7.09-4.7-15.88-5.78-21.09-5.78z"
			/>
			<Path d="M74.48 159.27a3.47 3.47 0 0 1-.83-6.85c8.26-2 16.81-3.94 25.37-5.62a168.1 168.1 0 0 0-24.63-1.31 3.47 3.47 0 1 1-.19-6.95c16.23-.45 32.09 2 46.94 4.59a3.47 3.47 0 0 1-.07 6.86 523.154 523.154 0 0 0-45.76 9.17 3.46 3.46 0 0 1-.83.11zM204.34 111.37a3.46 3.46 0 0 1-2.44-1 21.59 21.59 0 0 0-19.43-5.43 3.47 3.47 0 1 1-1.67-6.74 28.47 28.47 0 0 1 26 7.23 3.47 3.47 0 0 1-2.44 5.94zM208.16 159.27a3.47 3.47 0 0 1-.84-.1 521.68 521.68 0 0 0-45.76-9.17 3.47 3.47 0 0 1-.07-6.86c14.85-2.57 30.71-5 46.94-4.59a3.47 3.47 0 0 1-.19 6.95 168.6 168.6 0 0 0-24.63 1.31c8.56 1.68 17.11 3.57 25.37 5.62a3.47 3.47 0 0 1-.83 6.85zM78.31 111.37a3.47 3.47 0 0 1-2.44-5.94 28.47 28.47 0 0 1 26-7.23 3.47 3.47 0 1 1-1.67 6.74 21.59 21.59 0 0 0-19.43 5.43 3.46 3.46 0 0 1-2.46 1z" />
		</Svg>
	);
}
export default SvgComponent;
