import * as React from 'react';
import Svg, { G, Path, Rect, Circle } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			{...props}
		>
			<G scale={scale} data-name="Santa Claus Ride Sleigh">
				<Path
					fill="#d3d3d3"
					d="M112.005 511.52a8 8 0 0 1-5-14.248l79-63.2a8 8 0 0 1 10 12.494l-79 63.2a7.97 7.97 0 0 1-5 1.754zM192.005 511.52a8 8 0 0 1-5-14.248l79-63.2a8 8 0 0 1 10 12.494l-79 63.2a7.97 7.97 0 0 1-5 1.754zM272.005 511.52a8 8 0 0 1-5-14.248l79-63.2a8 8 0 0 1 10 12.494l-79 63.2a7.97 7.97 0 0 1-5 1.754z"
				/>
				<Path
					fill="#f2bb88"
					d="M504 352c-60.252 0-109.105-96.322-111.155-100.422a8 8 0 0 1 14.31-7.156C407.686 245.479 453.646 336 504 336a8 8 0 0 1 0 16z"
				/>
				<Path
					fill="#ffe4c2"
					d="M504 400c-26.415 0-52.007-22.961-76.064-68.247-17.153-32.286-34.79-80.03-35.207-81.365A8 8 0 0 1 408 245.614C418.652 279.655 462.93 384 504 384a8 8 0 0 1 0 16z"
				/>
				<Rect width={120} height={48} x={240} y={208} fill="#d65858" rx={8} />
				<Path
					fill="#e56161"
					d="M45.657 164.284A8 8 0 0 1 40 161.941L23.029 144.97a24 24 0 1 1 33.942-33.94L73.941 128a8 8 0 0 1 0 11.313l-22.627 22.628a8 8 0 0 1-5.657 2.343zM400 256h-16.367a8 8 0 0 1-8-8v-32a8 8 0 0 1 8-8H400a24 24 0 0 1 0 48z"
				/>
				<Rect
					width={48}
					height={64}
					x={343.633}
					y={200}
					fill="#ededed"
					rx={8}
				/>
				<Path
					fill="#e56161"
					d="M280 368H112a8 8 0 0 1-8-8v-48a8 8 0 0 1 1.054-3.969l29-50.744-71.477-72.769a8 8 0 0 1 .05-11.263l22.626-22.631a8 8 0 0 1 10.625-.615l45.008 35.655L170.667 208H256a8 8 0 0 1 5.5 2.195C284.539 232.037 304 274.994 304 304a112.729 112.729 0 0 1-17.233 60.269A8 8 0 0 1 280 368z"
				/>
				<Rect width={160} height={48} x={168} y={352} fill="#bf4b4b" rx={8} />
				<Path d="M352 400h-32a8 8 0 0 1-8-8v-32a40.045 40.045 0 0 1 40-40 8 8 0 0 1 8 8v64a8 8 0 0 1-8 8z" />
				<Path
					fill="#ededed"
					d="M240 256c-27.739 0-55.9-7.74-77.271-21.236C140.658 220.825 128 202.322 128 184c0-14.595 5.777-28.839 8-33.778V88a8 8 0 0 1 8-8h128a8 8 0 0 1 8 8v62.222c2.223 4.939 8 19.183 8 33.778 0 14.72-10.433 24.035-20.521 33.042C257.461 225.986 248 234.433 248 248a8 8 0 0 1-8 8z"
				/>
				<Path
					fill="#e56161"
					d="M320 64H160a8 8 0 0 1-6.146-13.122l15.54-18.647a89.578 89.578 0 0 1 132.157-5.994l24.106 24.106A8 8 0 0 1 320 64z"
				/>
				<Path
					fill="#bf4b4b"
					d="M256 64a8 8 0 0 1-8-8V40a8 8 0 0 1 16 0v16a8 8 0 0 1-8 8z"
				/>
				<Circle cx={344} cy={72} r={8} fill="#ededed" />
				<Path
					fill="#d65858"
					d="M325.656 50.343 301.55 26.237A88.892 88.892 0 0 0 247.875.528 83.878 83.878 0 0 1 213.291 64H320a8 8 0 0 0 5.656-13.657z"
				/>
				<Path
					fill="#ffe4c2"
					d="M160 80h96v56a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16V80z"
				/>
				<Path
					fill="#e2e2e2"
					d="M280 137.634A112.089 112.089 0 0 1 130.572 198.4c4.74 13.335 15.886 26.091 32.156 36.367C184.1 248.26 212.261 256 240 256a8 8 0 0 0 8-8c0-13.567 9.461-22.014 19.478-30.958C277.567 208.035 288 198.72 288 184c0-14.595-5.778-28.839-8-33.778z"
				/>
				<Path
					fill="#ffd9b0"
					d="M244.85 80H160v56a15.988 15.988 0 0 0 14.858 15.942A120.34 120.34 0 0 1 244.85 80z"
				/>
				<Path fill="#fff" d="M200 160h-16a8 8 0 0 1 0-16h16a8 8 0 0 1 0 16z" />
				<Path fill="#fff" d="M232 160h-16a8 8 0 0 1 0-16h16a8 8 0 0 1 0 16z" />
				<Path
					fill="#e2e2e2"
					d="M272 96H144a8 8 0 0 1-8-8V72a24.027 24.027 0 0 1 24-24h96a24.027 24.027 0 0 1 24 24v16a8 8 0 0 1-8 8z"
				/>
				<Circle cx={160} cy={68} r={12} fill="#fff" />
				<Circle cx={192} cy={72} r={8} fill="#fff" />
				<Path
					fill="#d3d3d3"
					d="M256 48h-24.516a64.013 64.013 0 0 1-32.5 48H272a8 8 0 0 0 8-8V72a24.027 24.027 0 0 0-24-24z"
				/>
				<Circle cx={184} cy={120} r={8} fill="#3f3f3f" />
				<Circle cx={232} cy={120} r={8} fill="#525252" />
				<Path
					fill="#ededed"
					d="M62.627 192.568a8 8 0 0 1-5.657-2.343L34.343 167.6a8 8 0 0 1 0-11.314l33.941-33.941A8 8 0 0 1 73.941 120a8 8 0 0 1 5.658 2.343l22.627 22.628a8 8 0 0 1 0 11.313l-33.942 33.941a8 8 0 0 1-5.657 2.343z"
				/>
				<Path
					fill="#525252"
					d="m125.643 272-20.589 36.031A8 8 0 0 0 104 312v8h189.792v-48z"
				/>
				<Path
					fill="#e2e2e2"
					d="M272 320h30.892A115.712 115.712 0 0 0 304 304c0-9.568-2.128-20.655-5.792-32H272a8 8 0 0 0-8 8v32a8 8 0 0 0 8 8z"
				/>
				<Path
					fill="#d3d3d3"
					d="M268 304a36.431 36.431 0 0 1-4-.226V312a8 8 0 0 0 8 8h30.892A115.712 115.712 0 0 0 304 304a94.333 94.333 0 0 0-2.918-21.79A36.005 36.005 0 0 1 268 304z"
				/>
				<G fill="#e2e2e2">
					<Path d="M112 512a8 8 0 0 1-8-8v-64a8 8 0 0 1 16 0v64a8 8 0 0 1-8 8zM192 512a8 8 0 0 1-8-8v-64a8 8 0 0 1 16 0v64a8 8 0 0 1-8 8zM272 512a8 8 0 0 1-8-8v-64a8 8 0 0 1 16 0v64a8 8 0 0 1-8 8zM352 512a8 8 0 0 1-8-8v-64a8 8 0 0 1 16 0v64a8 8 0 0 1-8 8z" />
				</G>
				<Path
					fill="#e56161"
					d="M375.406 448H96c-32.946 0-65.16-24.343-71.81-54.265L.178 281.676A8 8 0 0 1 8 272h88.2a102.223 102.223 0 0 1 98.406 75.162l5.049 18.513C204.214 379.2 210.605 384 224 384h122.335c8.629-19.379 33.376-32 53.665-32h16a8 8 0 0 1 7.845 9.569l-11.177 55.883A38.1 38.1 0 0 1 375.406 448z"
				/>
				<Path
					fill="#d65858"
					d="M422.187 354.928A8 8 0 0 0 416 352h-16c-20.289 0-45.036 12.621-53.665 32h-14.376a233.163 233.163 0 0 1-70.344 64h113.791a38.1 38.1 0 0 0 37.262-30.548l11.177-55.883a8 8 0 0 0-1.658-6.641z"
				/>
				<Circle cx={172} cy={388} r={12} fill="#f29c9c" />
				<Path
					fill="#ffd740"
					d="M128.721 400.667a8.007 8.007 0 0 1-3.616-.864L104 389.108 82.9 399.8a8 8 0 0 1-11.5-8.535L75.364 369l-16.842-15.825a8 8 0 0 1 4.369-13.754l23.522-3.294 10.466-20.439a8 8 0 0 1 14.242 0l10.466 20.439 23.522 3.294a8 8 0 0 1 4.369 13.754L132.636 369l3.962 22.267a8 8 0 0 1-7.877 9.4z"
				/>
				<Circle cx={44} cy={308} r={12} fill="#f29c9c" />
				<Circle cx={84} cy={348} r={8} fill="#ffe7a4" />
				<Path
					fill="#ffc400"
					d="M151.625 344.922a8 8 0 0 0-6.516-5.5l-21.367-2.992a72.131 72.131 0 0 1-50.682 45.52l-1.66 9.315a8 8 0 0 0 11.5 8.535l21.1-10.692 21.105 10.692a8 8 0 0 0 11.493-8.538L132.636 369l16.842-15.823a8 8 0 0 0 2.147-8.255z"
				/>
				<Path
					fill="#e2e2e2"
					d="m102.226 144.971-15.714-15.714a60.058 60.058 0 0 1-45.255 45.255l15.713 15.713a8 8 0 0 0 11.314 0l33.942-33.941a8 8 0 0 0 0-11.313zM343.633 239.88V256a8 8 0 0 0 8 8h32a8 8 0 0 0 8-8v-45.443a59.969 59.969 0 0 1-48 29.323z"
				/>
				<Path
					fill="#ededed"
					d="M464 512H8a8 8 0 0 1 0-16h456a32 32 0 0 0 0-64h-24a8 8 0 0 1 0-16h24a48 48 0 0 1 0 96z"
				/>
			</G>
		</Svg>
	);
}
export default SvgComponent;
