// @ts-nocheck
import * as React from 'react';
import Svg, { Circle, Path } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			xmlSpace="preserve"
			style={{
				enableBackground: 'new 0 0 512 512',
			}}
			viewBox="0 0 512 512"
			{...props}
		>
			<Circle
				cx={138.214}
				cy={393.612}
				r={46.712}
				style={{
					fill: '#ffb357',
				}}
			/>
			<Path
				d="M249.957 178.569c54.217 28.173 75.33 94.964 47.157 149.181L262.6 394.171 66.262 292.147l34.515-66.421c28.173-54.217 94.963-75.33 149.18-47.157z"
				style={{
					fill: '#ffb357',
				}}
			/>
			<Path
				d="m25.242 330.152 218.065 113.314 30.349-58.405L55.591 271.747c-16.128-8.381-35.996-2.1-44.377 14.028s-2.1 35.996 14.028 44.377z"
				style={{
					fill: '#ff7f5a',
				}}
			/>
			<Circle
				cx={373.786}
				cy={393.612}
				r={46.712}
				style={{
					fill: '#ffce71',
				}}
			/>
			<Path
				d="m445.74 292.151-49.87 25.91c-72.4 3.961-146.008-67.874-112.01-165.42 26.49 2.17 55.54 14.41 75.6 23.66 21.5 9.92 40 26.79 51.76 49.43l34.52 66.42z"
				style={{
					fill: '#fce3a0',
				}}
			/>
			<Path
				d="m395.87 318.061-146.47 76.11-34.51-66.42c-14.79-28.45-16-60.36-5.98-88.34 9.07-25.34 13.15-67.64 38.91-81.03 10.46-5.43 22.94-6.82 36.04-5.74-5.15 84.9 56.64 150.84 112.01 165.42z"
				style={{
					fill: '#ffce71',
				}}
			/>
			<Path
				d="M504.5 300.921c0 11.89-6.46 23.37-17.74 29.23l-123.71 64.29c-22.776 11.823-47.732 9.889-55.886-6.233a32.777 32.777 0 0 1-3.71-15.15c0-11.86 10.369-26.167 29.156-36.977.03-.02.06-.03.09-.05l123.71-64.28c16.13-8.38 36-2.1 44.38 14.02a32.777 32.777 0 0 1 3.71 15.15z"
				style={{
					fill: '#ffa187',
				}}
			/>
			<Path
				d="m362.14 394.901-105.22 54.68c-16.13 8.38-35.99 2.1-44.37-14.03a32.75 32.75 0 0 1-3.72-15.14c0-11.89 6.47-23.37 17.74-29.23l106.04-55.1c-11.22 5.87-17.65 17.32-17.65 29.18 0 5.11 1.19 10.3 3.71 15.15 8.22 15.83 27.51 22.17 43.47 14.49z"
				style={{
					fill: '#ff8f71',
				}}
			/>
			<Path
				d="m364.784 250.259-28.439-14.99-10.145 30.506c-3.361 10.106-17.495 10.539-21.469.658l-49.14-122.202 76-30.561 49.14 122.202c3.974 9.881-6.525 19.353-15.947 14.387z"
				style={{
					fill: '#fd5c6f',
				}}
			/>
			<Path
				d="m147.216 250.259 28.439-14.99 10.145 30.505c3.361 10.106 17.495 10.539 21.469.658l49.14-122.202-76-30.561-49.14 122.202c-3.974 9.882 6.525 19.354 15.947 14.388z"
				style={{
					fill: '#f9475e',
				}}
			/>
			<Path
				d="M196.654 130.321c0 19.5 4.346 36.852 4.336 50.61l-27.17 15.69c-26.21 15.12-58.96-3.79-58.96-34.04v-64.52c0-30.25 32.75-49.16 58.96-34.03L201 79.721c0 11.862-4.346 31.1-4.346 50.6z"
				style={{
					fill: '#ff6e80',
				}}
			/>
			<Path
				d="m288.64 130.321-87.65 50.61c-12.27-13.32-19.77-31.11-19.77-50.61s7.5-37.28 19.78-50.6l87.64 50.6z"
				style={{
					fill: '#fd5c6f',
				}}
			/>
			<Path
				d="M397.14 98.061v64.52c0 30.25-32.75 49.16-58.96 34.04l-27.07-15.63c3.366-17.184 6.426-31.38 6.426-50.67 0-19.29-3.978-32.311-6.426-50.66l27.07-15.63c26.21-15.13 58.96 3.78 58.96 34.03z"
				style={{
					fill: '#ff8a98',
				}}
			/>
			<Path
				d="M330.78 130.321c0 19.29-7.24 37.18-19.67 50.67l-87.75-50.67 87.75-50.66c12.43 13.48 19.67 31.37 19.67 50.66z"
				style={{
					fill: '#ff6e80',
				}}
			/>
			<Path
				d="M300.78 130.321c0 18.9-11.71 35.07-28.26 41.64-26.408-3.644-36.023-22.73-36.023-41.64 0-18.9 11.705-38.926 36.023-41.63 16.55 6.57 28.26 22.73 28.26 41.63z"
				style={{
					fill: '#ff8a98',
				}}
			/>
			<Path
				d="M272.52 171.961a44.674 44.674 0 0 1-16.52 3.15c-24.73 0-44.78-20.05-44.78-44.79 0-24.73 20.05-44.78 44.78-44.78 5.83 0 11.41 1.12 16.52 3.15-16.56 6.56-28.27 22.73-28.27 41.63 0 18.91 11.71 35.08 28.27 41.64z"
				style={{
					fill: '#ff6e80',
				}}
			/>
			<Path
				d="M233.943 364.424 55.591 271.746c-16.128-8.381-35.996-2.1-44.377 14.028s-2.1 35.996 14.028 44.377l184.042 95.635M127.949 191.861c-10.898 9.108-20.214 20.474-27.172 33.865L72.34 280.449M202.506 272.034c-.814 18.718 3.12 37.896 12.38 55.715l28.437 54.724M439.66 280.449l-28.437-54.724a110.256 110.256 0 0 0-27.185-33.852"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Circle
				cx={256}
				cy={130.322}
				r={44.784}
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Path
				d="m287.597 359.466-61.024 31.71c-16.128 8.381-22.409 28.249-14.028 44.377 8.381 16.128 28.249 22.409 44.377 14.028L486.757 330.15c16.128-8.381 22.409-28.249 14.028-44.377-8.381-16.128-28.249-22.409-44.377-14.028l-137.754 71.582M330.567 411.314c10.2 25.291 40.618 36.458 64.758 23.747 24.277-12.447 32.622-43.76 17.789-66.641M98.886 368.419c-14.833 22.883-6.488 54.194 17.789 66.641 24.139 12.712 54.559 1.543 64.758-23.747M114.863 139.183v23.397c0 30.254 32.751 49.164 58.953 34.036l54.237-31.314M228.052 95.342l-54.237-31.313c-26.201-15.127-58.953 3.782-58.953 34.036v6.118M283.948 165.302l54.237 31.314c26.201 15.127 58.953-3.782 58.953-34.036V98.065c0-30.255-32.751-49.164-58.953-34.036l-54.237 31.313"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Path
				d="m145.335 200.89-14.067 34.981c-3.973 9.881 6.526 19.354 15.948 14.388l28.439-14.99 10.145 30.505c3.361 10.106 17.495 10.539 21.469.658l37.317-92.8M267.415 173.633l37.317 92.8c3.974 9.881 18.108 9.448 21.469-.658l10.145-30.505 28.439 14.99c9.422 4.966 19.921-4.507 15.948-14.388l-14.067-34.981"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
		</Svg>
	);
}
export default SvgComponent;
