import { View, StyleSheet, ViewStyle, StyleProp } from 'react-native';
import { appDimensions } from '#/styles/dimensions';
import { useAppTheme } from '#/states/global/hooks';
import Animated from 'react-native-reanimated';
import BackNavigationButton from '#/features/navbar/components/BackNavigationButton';
import { NativeTextBold } from '#/ui/NativeText';

type Props = {
	label: string;
	menu?: { iconId: string; onPress: () => void }[];
	animatedStyle?: StyleProp<ViewStyle>;
};

/**
 * Simple navigation bar which
 * can
 *
 * - show a label
 * - has a back button on the left
 * - can have an array of buttons on the right
 * - (optionally) auto-hides on the content scroll
 * @constructor
 */
function NavBar_Simple({ label, animatedStyle }: Props) {
	const { theme } = useAppTheme();

	function onLayout(event: any) {
		console.log('height', event.nativeEvent.layout.height);
	}

	return (
		<Animated.View
			onLayout={onLayout}
			style={[
				{
					position: 'absolute',
					zIndex: 1,
				},
				animatedStyle,
			]}
		>
			<View
				style={[styles.subHeader, { backgroundColor: theme.background.a10 }]}
			>
				<BackNavigationButton />
				<View style={styles.navbarTitleContainer}>
					<NativeTextBold
						style={{
							fontSize: 18,
							color: theme.secondary.a10,
						}}
					>
						{label}
					</NativeTextBold>
				</View>
				<View style={{ width: 36 }}></View>
			</View>
		</Animated.View>
	);
}

export default NavBar_Simple;

const styles = StyleSheet.create({
	subHeader: {
		width: '100%',
		flexDirection: 'row',
		justifyContent: 'space-between',
		alignItems: 'center',
		height: appDimensions.topNavbar.simpleVariantHeight,
	},
	navbarTitleContainer: {
		flexDirection: 'row',
		alignItems: 'center',
	},
	navbarTitle: {
		fontSize: 16,
	},
});
