// @ts-nocheck
import * as React from 'react';
import Svg, { Defs, ClipPath, Path, G } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 682.667;
	const scale = size / 682.667;
	const color = props.color ?? 'white';

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={682.667 * scale}
			height={682.667 * scale}
			{...props}
		>
			<Defs>
				<ClipPath id="a" clipPathUnits="userSpaceOnUse">
					<Path d="M0 512h512V0H0Z" />
				</ClipPath>
			</Defs>
			<G clipPath="url(#a)" transform="matrix(1.33333 0 0 -1.33333 0 682.667)">
				<Path
					d="M0 0c0-141.38-114.62-256-256-256-70.69 0-134.69 28.66-181.02 74.98C-483.34-134.69-512-70.69-512 0c0 141.38 114.62 256 256 256 70.69 0 134.69-28.66 181.02-74.98C-28.66 134.69 0 70.69 0 0"
					style={{
						fill: '#665e66',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(512 256)"
				/>
				<Path
					d="M0 0c0-27.52-4.35-54.04-12.38-78.88a254.83 254.83 0 0 0-21.6-48.64C-59.01-171.01-96.44-206.44-141.45-229c-14-7.02-28.73-12.79-44.05-17.17-22.39-6.4-46.05-9.83-70.5-9.83-20.06 0-39.58 2.31-58.31 6.67a254.2 254.2 0 0 0-64.82 24.84 256.607 256.607 0 0 0-57.89 43.47l362.04 362.04C-28.66 134.69 0 70.69 0 0"
					style={{
						fill: '#b1e4f9',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(512 256)"
				/>
				<Path
					d="M0 0a254.83 254.83 0 0 0-21.6-48.64c-25.03-43.49-62.46-78.92-107.47-101.48-14-7.02-28.73-12.79-44.05-17.17l-5.82 21.88-55.93-15.04 15.04 55.93-55.96 14.9 41.04 40.88-41.04 40.89 55.96 14.9-15.04 55.92 55.93-15.03 14.9 55.96 40.88-41.04 40.89 41.04 14.9-55.96 55.93 15.03-15.04-55.92z"
					style={{
						fill: '#f6e7c6',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(499.62 177.12)"
				/>
				<Path
					d="M0 0c-25.03-43.49-62.46-78.92-107.47-101.48C-160.8-98.42-203.11-54.2-203.11-.1c0 56.09 45.47 101.56 101.55 101.56C-45.5 101.46-.05 56.04 0 0"
					style={{
						fill: '#f4dd45',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(478.02 128.48)"
				/>
				<Path
					d="M0 0c-2.22-1.2-4.46-2.37-6.72-3.5-53.33 3.06-95.64 47.28-95.64 101.38 0 56.09 45.47 101.56 101.55 101.56 4.74 0 9.4-.32 13.97-.96-49.48-6.8-87.59-49.25-87.59-100.6C-74.43 51.19-42.92 11.86 0 0"
					style={{
						fill: '#fbb031',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(377.27 30.5)"
				/>
				<Path
					d="M0 0c10.825-2.775 11.082-18.128.344-21.224a124.881 124.881 0 0 0-34.645-4.873c-68.33 0-123.842 54.917-124.788 123.031-.956 68.836 55.847 126.515 124.689 126.569a124.86 124.86 0 0 0 34.676-4.854c10.779-3.102 10.6-18.461-.266-21.246-17.095-4.382-33.276-13.265-46.659-26.648-39.797-39.797-39.797-104.316 0-144.113C-33.27 13.263-17.092 4.381 0 0"
					style={{
						fill: '#f4dd45',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(183.951 269.013)"
				/>
				<Path
					d="M0 0c-6.32-.99-12.79-1.5-19.38-1.5-68.33 0-123.84 54.91-124.79 123.03-.95 68.83 55.85 126.51 124.69 126.57 6.67 0 13.21-.52 19.6-1.53-59.88-9.56-106.36-62.73-105.49-125.04C-104.51 60-59.13 9.24 0 0"
					style={{
						fill: '#fbb031',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(169.033 244.417)"
				/>
				<Path
					d="m0 0 23.84 5.222c7.379 1.616 7.379 12.139 0 13.756L0 24.2a7.038 7.038 0 0 0-5.371 5.371l-5.222 23.84c-1.616 7.379-12.139 7.379-13.756 0l-5.221-23.84a7.04 7.04 0 0 0-5.372-5.371l-23.84-5.222c-7.379-1.617-7.379-12.14 0-13.756L-34.942 0a7.042 7.042 0 0 0 5.372-5.371l5.221-23.84c1.617-7.379 12.14-7.379 13.756 0l5.222 23.84A7.04 7.04 0 0 0 0 0"
					style={{
						fill: '#f4dd45',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(286.397 434.222)"
				/>
				<Path
					d="m0 0 18.982 4.158c5.876 1.287 5.876 9.666 0 10.953L0 19.269a5.607 5.607 0 0 0-4.277 4.276l-4.158 18.983c-1.287 5.875-9.665 5.875-10.952 0l-4.158-18.983a5.607 5.607 0 0 0-4.277-4.276l-18.982-4.158c-5.876-1.287-5.876-9.666 0-10.953L-27.822 0a5.607 5.607 0 0 0 4.277-4.276l4.158-18.983c1.287-5.875 9.665-5.875 10.952 0l4.158 18.983A5.607 5.607 0 0 0 0 0"
					style={{
						fill: '#f4dd45',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(78.397 190.233)"
				/>
				<Path
					d="m0 0 18.982 4.158c5.875 1.287 5.875 9.666 0 10.953L0 19.269a5.604 5.604 0 0 0-4.277 4.276l-4.158 18.983c-1.287 5.875-9.666 5.875-10.953 0l-4.157-18.983a5.607 5.607 0 0 0-4.277-4.276l-18.983-4.158c-5.875-1.287-5.875-9.666 0-10.953L-27.822 0a5.606 5.606 0 0 0 4.277-4.277l4.157-18.982c1.287-5.875 9.666-5.875 10.953 0l4.158 18.982A5.604 5.604 0 0 0 0 0"
					style={{
						fill: '#f4dd45',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(248.39 294.94)"
				/>
				<Path
					d="M0 0h-61.853c-8.264 0-14.964-6.7-14.964-14.964 0-8.265 6.7-14.965 14.964-14.965H0c8.265 0 14.964 6.7 14.964 14.965C14.964-6.7 8.265 0 0 0"
					style={{
						fill: '#fff',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(444.303 339.88)"
				/>
				<Path
					d="M0 0h-61.853c-8.264 0-14.964-6.7-14.964-14.964 0-8.265 6.7-14.965 14.964-14.965H0c8.265 0 14.964 6.7 14.964 14.965C14.964-6.7 8.265 0 0 0"
					style={{
						fill: '#fff',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(238.793 66.53)"
				/>
				<Path
					d="M0 0c0-8.27-6.7-14.97-14.96-14.97h-8.28A254.2 254.2 0 0 0-88.06 9.87c2.74 3.12 6.76 5.09 11.24 5.09h61.86c4.13 0 7.87-1.68 10.58-4.38A14.91 14.91 0 0 0 0 0"
					style={{
						fill: '#fff',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(220.93 21.64)"
				/>
				<Path
					d="M0 0h-61.853c-8.264 0-14.964-6.7-14.964-14.964 0-8.265 6.7-14.965 14.964-14.965H0c8.265 0 14.964 6.7 14.964 14.965C14.964-6.7 8.265 0 0 0"
					style={{
						fill: '#fff',
						fillOpacity: 1,
						fillRule: 'nonzero',
						stroke: 'none',
					}}
					transform="translate(489.196 369.808)"
				/>
			</G>
		</Svg>
	);
}
export default SvgComponent;
