import * as React from 'react';
import Svg, { Path } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	const color = props.color ?? 'white';

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 -15 512.002 512"
			{...props}
		>
			<Path
				fill="#e4f5f7"
				d="M405.004 42.766H106.992c-18.445 0-33.398 14.953-33.398 33.398v163.719h364.808V76.164c0-18.445-14.953-33.398-33.398-33.398zm0 0"
			/>
			<Path
				fill="#bfdadd"
				d="M420.41 84.047H91.586c-20.352 0-36.852 16.496-36.852 36.848v180.652h402.528V120.895c0-20.352-16.5-36.848-36.852-36.848zm0 0"
			/>
			<Path
				fill="#e4f5f7"
				d="M479.281 173.355v225.766H32.715V173.355c0-22.582 18.3-40.89 40.879-40.89h364.808c22.578 0 40.88 18.308 40.88 40.89zm0 0"
			/>
			<Path
				fill="#bfdadd"
				d="M479.281 228.723V399.12H32.715V228.723a33.918 33.918 0 0 1 8.433-1.067h94.434c13.262 0 24.625 9.469 27.02 22.508l3.89 21.25c2.383 13.04 13.75 22.508 27.012 22.508h124.988c13.262 0 24.625-9.469 27.02-22.508l3.89-21.25c2.395-13.039 13.758-22.508 27.02-22.508h94.433c2.91 0 5.727.364 8.426 1.067zm0 0"
			/>
			<Path
				fill="#ffc217"
				d="m349.402 272.594-3.89 21.246c-2.39 13.043-13.758 22.515-27.016 22.515H193.504c-13.258 0-24.625-9.472-27.016-22.515l-3.89-21.246c-2.391-13.043-13.758-22.516-27.016-22.516H41.148c-18.527 0-33.543 15.02-33.543 33.543v143.57c0 26.344 21.352 47.696 47.696 47.696h401.402c26.34 0 47.695-21.352 47.695-47.696v-143.57c0-18.523-15.02-33.539-33.543-33.539h-94.433c-13.262-.004-24.629 9.469-27.02 22.512zm0 0"
			/>
			<Path
				fill="#e5a505"
				d="M45.621 427.191v-143.57c0-18.523 15.02-33.539 33.543-33.539H41.148c-18.527 0-33.543 15.016-33.543 33.54v143.573c0 26.34 21.352 47.692 47.696 47.692h38.015c-26.34 0-47.695-21.352-47.695-47.696zm0 0"
			/>
			<Path
				fill="#6ce7f3"
				d="M305.633 160.441V7.605h-99.27v152.836h-66.457l116.09 116.09 116.094-116.09zm0 0"
			/>
			<Path d="M486.89 245.73v-72.375c0-16.562-8.331-31.73-22.023-40.628v-11.829c0-14.52-7.137-28.039-18.867-36.316v-8.418c0-22.605-18.39-41-41-41h-91.762V7.605c0-4.199-3.406-7.605-7.605-7.605h-99.27a7.604 7.604 0 0 0-7.605 7.605v27.56h-91.762c-22.613 0-41.012 18.394-41.012 41v8.42C54.262 92.86 47.13 106.38 47.13 120.899v11.829c-13.691 8.898-22.024 24.066-22.024 40.628v72.38C10.363 251.995 0 266.62 0 283.62v143.57c0 30.493 24.809 55.301 55.3 55.301h299.134c4.199 0 7.601-3.406 7.601-7.605s-3.402-7.602-7.601-7.602H55.3c-22.11 0-40.094-17.988-40.094-40.094v-143.57c0-14.3 11.637-25.937 25.938-25.937h94.437c9.59 0 17.805 6.847 19.535 16.28l3.895 21.247c3.05 16.656 17.558 28.746 34.492 28.746h124.992c16.938 0 31.441-12.09 34.492-28.746l3.895-21.246a19.86 19.86 0 0 1 19.539-16.281h94.433c14.301 0 25.938 11.636 25.938 25.937v143.57c0 22.106-17.984 40.094-40.09 40.094h-71.851a7.604 7.604 0 1 0 0 15.207h71.851c30.492 0 55.3-24.808 55.3-55.3v-143.57c-.003-17-10.37-31.626-25.112-37.892zm-37.23-119.527a48.728 48.728 0 0 0-11.262-1.332h-125.16V91.656H420.41c5.008 0 9.942 1.285 14.27 3.715 9.242 5.176 14.98 14.957 14.98 25.524zM405 50.371c14.223 0 25.793 11.57 25.793 25.793V77.7a44.524 44.524 0 0 0-10.383-1.25H313.234V50.375H405zM298.027 15.207v145.234c0 4.2 3.407 7.602 7.606 7.602h48.097l-97.734 97.734-97.734-97.734h48.101a7.6 7.6 0 0 0 7.602-7.602V15.207zM77.305 95.371a29.292 29.292 0 0 1 14.28-3.715H117.2a7.604 7.604 0 1 0 0-15.207H91.586c-3.512 0-7 .438-10.395 1.25v-1.535c0-14.223 11.579-25.793 25.805-25.793h91.762V76.45h-51.14a7.604 7.604 0 0 0-7.602 7.606 7.6 7.6 0 0 0 7.601 7.601h51.14v33.215H73.59c-3.797 0-7.578.457-11.254 1.332v-5.305c0-10.57 5.738-20.351 14.969-25.527zm299.113 147.106c-16.934 0-31.441 12.09-34.492 28.746l-3.895 21.246c-1.726 9.433-9.945 16.281-19.535 16.281H193.504c-9.59 0-17.805-6.848-19.535-16.285l-3.89-21.242c-3.056-16.657-17.563-28.746-34.497-28.746H41.145c-.278 0-.555.015-.833.02v-69.145c0-12.457 6.872-23.774 17.934-29.532 4.762-2.484 9.922-3.742 15.344-3.742h125.168v12.758h-58.852a7.607 7.607 0 0 0-7.027 4.691 7.615 7.615 0 0 0 1.648 8.29l116.094 116.09a7.602 7.602 0 0 0 10.754 0l116.09-116.09a7.603 7.603 0 0 0-5.379-12.98h-58.852v-12.759h125.164c5.418 0 10.582 1.258 15.356 3.746 11.058 5.754 17.93 17.07 17.93 29.528v69.144c-.278-.004-.551-.02-.832-.02zm0 0" />
		</Svg>
	);
}
export default SvgComponent;
