// @ts-nocheck
import * as React from 'react';
import Svg, { Path, Circle } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			xmlSpace="preserve"
			style={{
				enableBackground: 'new 0 0 512 512',
			}}
			viewBox="0 0 512 512"
			height={size}
			width={size}
			{...props}
		>
			<Path
				d="M308.18 52.13v29.82h-50V52.13c0-5.53 2.24-10.53 5.86-14.14 3.62-3.62 8.62-5.86 14.14-5.86 11.05 0 30 8.95 30 20z"
				style={{
					fill: '#f99b8c',
				}}
			/>
			<Path
				d="m224.74 71.95 16.007 28.124-16.007 23.286H111.4V71.95zM485.31 81.95v41.41H344.93V71.95h130.38c5.52 0 10 4.47 10 10z"
				style={{
					fill: '#947df6',
				}}
			/>
			<Path
				d="M224.74 71.95h120.19v51.41H224.74z"
				style={{
					fill: '#8769ef',
				}}
			/>
			<Path
				d="m134.018 101.62-.518-36.094c0-8.837-7.163-16-16-16l-21.035-2.215H23.81c-9.008 0-16.31 7.302-16.31 16.31v399.94c0 9.008 7.302 16.31 16.31 16.31H460.5l22.948-2.13c9.008 0 16.31-7.302 16.31-16.31l-.188-330.071c0-8.837-7.163-16-16-16l-21.459-4.409h-314.23a9.99 9.99 0 0 1-2.668-.36c-4.228-1.167-11.195-4.372-11.195-8.971z"
				style={{
					fill: '#fceca9',
				}}
			/>
			<Path
				d="M147.88 110.95h-30c-5.52 0-10-4.48-10-10V63.31c0-8.84-7.16-16-16-16h30c8.84 0 16 7.16 16 16v37.64c0 5.52 4.48 10 10 10zM504.5 126.95v336.61c0 9.01-7.3 16.31-16.31 16.31h-30c9.01 0 16.31-7.3 16.31-16.31V126.95c0-8.84-7.16-16-16-16h30c8.84 0 16 7.16 16 16z"
				style={{
					fill: '#f9de91',
				}}
			/>
			<Path
				d="M287.94 430.871v-84.215a5 5 0 0 1 5-5H430.5l19.979 5.67a5 5 0 0 1 5 5v74.341a5 5 0 0 1-5 5l-19.979 4.204H292.94a5 5 0 0 1-5-5z"
				style={{
					fill: '#947df6',
				}}
			/>
			<Path
				d="M460.5 346.657v84.21c0 2.77-2.24 5-5 5h-25v-94.21h25c2.76 0 5 2.24 5 5z"
				style={{
					fill: '#8769ef',
				}}
			/>
			<Path
				d="m365.076 369.576 24.506 13.573c4.411 2.443 4.411 8.786 0 11.229l-24.506 13.573c-4.278 2.369-9.528-.724-9.528-5.614V375.19c.001-4.889 5.251-7.983 9.528-5.614z"
				style={{
					fill: '#f5f8f9',
				}}
			/>
			<Path
				d="m437.547 63.361-1.553 198.353c0 7.64-8.23 12.46-14.9 8.71l-3.603-.496-46.191-25.966a4 4 0 0 0-3.92 0l-54.3 30.518c-6.66 3.75-14.9-1.07-14.9-8.71V52.13c0-11.05-8.95-20-20-20h114.755l14.612 1.231c16.568 0 30 13.432 30 30zM217.161 294.043l1.318 89.819 5.581 7.589c-9.73 1.73-17.611 9.98-24.781 9.74-43.94-1.46-60.48-26.98-111.81-30.38-13.04-.86-25.259-8.251-35.969-6.851v-75.45a5 5 0 0 1 5-5h137.8l17.861 5.532a5 5 0 0 1 5 5.001z"
				style={{
					fill: '#feb3a7',
				}}
			/>
			<Path
				d="m224.06 391.451-7.464 33.038a5 5 0 0 1-5 5l-17.296 6.382H56.5a5 5 0 0 1-5-5v-66.91c10.71-1.4 22.36-1.88 35.4-1.02 51.33 3.4 67.87 28.92 111.81 30.38 7.17.24 15.62-.14 25.35-1.87z"
				style={{
					fill: '#bae2a6',
				}}
			/>
			<Path
				d="M224.06 288.508v102.94c-9.73 1.73-17.611 9.984-24.781 9.744-1.5-.05-3.539-8.004-4.979-8.114v-109.57h24.76c2.76 0 5 2.24 5 5z"
				style={{
					fill: '#f99b8c',
				}}
			/>
			<Path
				d="M224.06 391.448v39.42c0 2.76-2.24 5-5 5H194.3v-42.79c1.44.11 2.91.19 4.41.24 7.17.24 15.62-.14 25.35-1.87z"
				style={{
					fill: '#7acaa6',
				}}
			/>
			<Circle
				cx={177.164}
				cy={327.383}
				r={17.136}
				style={{
					fill: '#fceca9',
				}}
			/>
			<Path
				d="M440.49 62.13v203.64c0 7.64-8.23 12.46-14.9 8.71l-8.1-4.55V62.13c0-16.57-13.43-30-30-30h23c16.57 0 30 13.43 30 30z"
				style={{
					fill: '#f99b8c',
				}}
			/>
			<Path
				d="m372.864 102.185 9.566 17.851a4.002 4.002 0 0 0 2.818 2.048l19.933 3.582c3.142.565 4.389 4.402 2.179 6.706l-14.021 14.614a3.997 3.997 0 0 0-1.076 3.313l2.753 20.064c.434 3.163-2.83 5.535-5.705 4.145l-18.232-8.819a4.002 4.002 0 0 0-3.484 0l-18.232 8.819c-2.874 1.39-6.139-.982-5.705-4.145l2.753-20.064a3.998 3.998 0 0 0-1.077-3.313l-14.021-14.614c-2.21-2.304-.964-6.142 2.179-6.706l19.933-3.582a3.997 3.997 0 0 0 2.818-2.048l9.566-17.851c1.511-2.814 5.547-2.814 7.055 0z"
				style={{
					fill: '#fceca9',
				}}
			/>
			<Path
				d="M441.92 110.95h46.58c8.84 0 16 7.16 16 16v336.61c0 9.01-7.3 16.31-16.31 16.31H23.81c-9.01 0-16.31-7.3-16.31-16.31V63.62c0-9.01 7.3-16.31 16.31-16.31h98.07c8.84 0 16 7.16 16 16v37.64c0 5.52 4.48 10 10 10h16.26m129.31 0h-94.31M441.923 71.947h33.389c5.523 0 10 4.477 10 10V109.6M141.404 71.947H295.1M93.881 79.129H51.5"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Path
				d="M460.5 409.33v21.54c0 2.77-2.24 5-5 5H292.94c-2.76 0-5-2.23-5-5v-84.21c0-2.76 2.24-5 5-5H455.5c2.76 0 5 2.24 5 5v27.67"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Path
				d="m365.076 369.58 24.506 13.573c4.411 2.443 4.411 8.786 0 11.229l-24.506 13.573c-4.278 2.369-9.528-.724-9.528-5.614v-27.146c.001-4.89 5.251-7.984 9.528-5.615zM224.739 74.811V109.6M440.49 223.19v42.58c0 7.64-8.23 12.46-14.9 8.71l-56.25-31.62-56.26 31.62c-6.66 3.75-14.9-1.07-14.9-8.71V72.13M278.18 32.13h132.31c16.57 0 30 13.43 30 30v126.06"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Path
				d="M298.182 70.279V52.13c0-11.046-8.954-20-20-20h0c-11.046 0-20 8.954-20 20v17.584M51.5 359.96v-71.45c0-2.76 2.24-5 5-5h162.56c2.76 0 5 2.24 5 5v98.94"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Path
				d="M224.06 387.45c-9.73 1.73-18.18 2.11-25.35 1.87-43.94-1.46-60.48-26.98-111.81-30.38-13.04-.86-24.69-.38-35.4 1.02M51.5 359.96v70.91c0 2.76 2.24 5 5 5h63.78M224.06 387.45v43.42c0 2.76-2.24 5-5 5h-63.78"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Circle
				cx={177.164}
				cy={329.383}
				r={17.136}
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
			<Path
				d="m372.864 102.185 9.566 17.851a4.002 4.002 0 0 0 2.818 2.048l19.933 3.582c3.142.565 4.389 4.402 2.179 6.706l-14.021 14.614a3.997 3.997 0 0 0-1.076 3.313l2.753 20.064c.434 3.163-2.83 5.535-5.705 4.145l-18.232-8.819a4.002 4.002 0 0 0-3.484 0l-18.232 8.819c-2.874 1.39-6.139-.982-5.705-4.145l2.753-20.064a3.998 3.998 0 0 0-1.077-3.313l-14.021-14.614c-2.21-2.304-.964-6.142 2.179-6.706l19.933-3.582a3.997 3.997 0 0 0 2.818-2.048l9.566-17.851c1.511-2.814 5.547-2.814 7.055 0zM224.74 153.96h-25.6M164.14 153.96H51.5M194.3 197.62h-71.4M87.9 197.62H51.5M224.74 241.28h-58.06M131.68 241.28H51.5"
				style={{
					fill: 'none',
					stroke: '#000',
					strokeWidth: 15,
					strokeLinecap: 'round',
					strokeLinejoin: 'round',
					strokeMiterlimit: 10,
				}}
			/>
		</Svg>
	);
}
export default SvgComponent;
