import * as React from 'react';
import Svg, { Path } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	const color = props.color ?? 'white';
	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 0 256 256"
			{...props}
		>
			<Path
				fill="#478cf7"
				d="m191.282 196.422-50.205 39.946a18.993 18.993 0 0 1-23.444.163l-51.717-39.985c-23.487-18.159-36.84-43.682-36.84-70.418V74.395c0-7.251 4.129-13.87 10.642-17.059l81.492-39.9a18.995 18.995 0 0 1 16.939.117l78.365 39.719a18.994 18.994 0 0 1 10.407 16.942v52.73c.002 26.258-12.88 51.369-35.639 69.478z"
			/>
			<Path
				fill="#377de2"
				d="m216.516 57.272-1.147-.581a18.967 18.967 0 0 1 1.554 7.523v52.73c0 26.258-12.881 51.369-35.641 69.478l-50.205 39.946a18.993 18.993 0 0 1-23.444.163l-51.717-39.984a108.375 108.375 0 0 1-4.928-4.047c4.38 5.04 9.37 9.75 14.928 14.047l51.717 39.984a18.995 18.995 0 0 0 23.444-.163l50.205-39.946c22.759-18.109 35.641-43.219 35.641-69.478v-52.73a18.994 18.994 0 0 0-10.407-16.942z"
			/>
			<Path
				fill="#2266d3"
				d="M218.624 58.518a18.978 18.978 0 0 1 3.298 10.696v52.73c0 26.258-12.881 51.369-35.641 69.478l-50.205 39.946a18.993 18.993 0 0 1-23.444.163l-51.717-39.984a107.056 107.056 0 0 1-7.587-6.446 105.026 105.026 0 0 0 12.587 11.446l51.717 39.984a18.995 18.995 0 0 0 23.444-.163l50.205-39.946c22.759-18.109 35.641-43.219 35.641-69.478v-52.73a18.992 18.992 0 0 0-8.298-15.696z"
			/>
			<Path
				fill="#5e9cf7"
				d="M35.08 128.13c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm0-8c-1.1 0-2-.9-2-2V74.4c0-5.68 3.3-10.97 8.4-13.47l81.49-39.9c.97-.48 2.2-.05 2.68.92a2 2 0 0 1-.92 2.67l-81.49 39.9c-3.75 1.83-6.17 5.7-6.16 9.88v43.73c0 1.1-.9 2-2 2z"
			/>
			<Path
				fill="#ffa91a"
				d="M167.586 185.532H88.414a5.195 5.195 0 0 1-5.195-5.195v-66.405a5.195 5.195 0 0 1 5.195-5.195h79.171a5.195 5.195 0 0 1 5.195 5.195v66.405a5.194 5.194 0 0 1-5.194 5.195z"
			/>
			<Path
				fill="#f79219"
				d="M167.586 108.738h-4.805v61.599a5.195 5.195 0 0 1-5.195 5.195H83.22v4.805a5.195 5.195 0 0 0 5.195 5.195h79.171a5.195 5.195 0 0 0 5.195-5.195v-66.405a5.196 5.196 0 0 0-5.195-5.194z"
			/>
			<Path
				fill="#e6e7e8"
				d="M165.971 108.738h-12.987V85.859c0-13.776-11.208-24.984-24.984-24.984s-24.984 11.208-24.984 24.984v22.879H90.029V85.859c0-20.937 17.033-37.971 37.971-37.971s37.971 17.033 37.971 37.971z"
			/>
			<Path
				fill="#d1d3d4"
				d="M152.324 56.64c5.462 6.578 8.751 15.021 8.751 24.219v22.879h-7.987v5h12.987V85.859c0-11.739-5.356-22.249-13.751-29.219z"
			/>
			<Path
				fill="#995222"
				d="m140.232 161.921-6.457-18.03a10.432 10.432 0 0 0 4.671-8.701c0-5.769-4.677-10.445-10.445-10.445s-10.445 4.676-10.445 10.445c0 3.633 1.857 6.83 4.671 8.701l-6.457 18.03c-.933 2.606.998 5.349 3.766 5.349h16.932c2.766-.001 4.697-2.744 3.764-5.349z"
			/>
			<Path
				fill="#8c3f0a"
				d="m140.232 161.921-6.457-18.03a10.432 10.432 0 0 0 4.671-8.701 10.44 10.44 0 0 0-5.427-9.161 10.403 10.403 0 0 1 1.277 5.006c0 3.633-1.857 6.83-4.671 8.701l6.457 18.03c.933 2.606-.998 5.349-3.766 5.349h-16.775c-.089 2.186 1.648 4.155 3.993 4.155h16.932c2.768-.001 4.699-2.744 3.766-5.349z"
			/>
		</Svg>
	);
}
export default SvgComponent;
