// @ts-nocheck
import * as React from 'react';
import Svg, { Path, Circle } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 418.034;
	const scale = size / 418.034;
	const color = props.color ?? 'white';

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			xmlSpace="preserve"
			style={{
				enableBackground: 'new 0 0 418.034 418.034',
			}}
			viewBox="0 0 418.034 418.034"
			{...props}
		>
			<Path
				d="M352.119 204.427c15.898-.003 28.787 12.882 28.79 28.78.003 15.898-12.882 28.787-28.78 28.79-15.898.003-28.787-12.882-28.79-28.78v-.01c.005-15.893 12.888-28.775 28.78-28.78z"
				style={{
					fill: '#fedb41',
				}}
			/>
			<Circle
				cx={333.979}
				cy={48.617}
				r={38.38}
				style={{
					fill: '#00efd1',
				}}
			/>
			<Path
				d="M323.339 340.447c18.703-.003 33.867 15.157 33.87 33.86s-15.157 33.867-33.86 33.87-33.867-15.157-33.87-33.86c.001-18.702 15.159-33.864 33.86-33.87z"
				style={{
					fill: '#00efd1',
				}}
			/>
			<Path
				d="M241.739 255.567c-25.126 14.48-57.233 5.85-71.714-19.276-14.48-25.126-5.85-57.233 19.276-71.714 25.126-14.48 57.233-5.85 71.714 19.276a52.504 52.504 0 0 1 7.014 26.214 52.248 52.248 0 0 1-26.29 45.5z"
				style={{
					fill: '#00acea',
				}}
			/>
			<Path
				d="M133.769 329.807c17.173 15.158 18.806 41.367 3.648 58.54-15.158 17.173-41.367 18.806-58.54 3.648s-18.806-41.367-3.648-58.54a41.472 41.472 0 0 1 31.1-14.028 41.381 41.381 0 0 1 27.44 10.38z"
				style={{
					fill: '#00efd1',
				}}
			/>
			<Path
				d="M94.759 97.757c.003 15.898-12.882 28.787-28.78 28.79s-28.787-12.882-28.79-28.78 12.882-28.787 28.78-28.79h.01c15.814-.081 28.699 12.673 28.78 28.487v.293z"
				style={{
					fill: '#fedb41',
				}}
			/>
			<Path
				d="m275.355 228.086 38.068 7.558c1.339 21.382 19.759 37.631 41.141 36.291 21.382-1.339 37.631-19.759 36.291-41.141-1.339-21.382-19.759-37.631-41.141-36.291a38.79 38.79 0 0 0-32.353 21.532l-39.383-7.818a62.158 62.158 0 0 0-16.245-40.21l53.068-74.978c24.579 10.665 53.15-.614 63.815-25.193s-.614-53.15-25.193-63.815-53.15.614-63.815 25.193a48.514 48.514 0 0 0 8.881 52.243l-52.44 74.084c-25.117-14.05-56.581-9.132-76.213 11.912l-68.7-53.352c9.053-19.439.633-42.537-18.806-51.59s-42.537-.633-51.59 18.806c-9.053 19.439-.633 42.537 18.806 51.59a38.828 38.828 0 0 0 38.751-3.454l70.384 54.663c-11.275 24.727-5.285 53.905 14.819 72.191l-42.159 59.611c-24.886-13.87-56.304-4.939-70.174 19.947-13.87 24.886-4.939 56.304 19.947 70.174 24.886 13.87 56.304 4.939 70.174-19.947a51.586 51.586 0 0 0-4.647-57.174l43.632-61.695a62.569 62.569 0 0 0 48 1.052l52.176 77.069c-15.959 18.174-14.163 45.844 4.011 61.803 18.174 15.959 45.844 14.163 61.803-4.011s14.163-45.844-4.011-61.803a43.791 43.791 0 0 0-45.518-7.609l-51.209-75.638a62.873 62.873 0 0 0 19.83-30zm76.764-13.659c10.375-.003 18.787 8.405 18.79 18.78.003 10.375-8.405 18.787-18.78 18.79-10.375.003-18.787-8.405-18.79-18.78v-.01c.015-10.366 8.414-18.766 18.78-18.78zm-18.14-194.19c15.674 0 28.38 12.706 28.38 28.38s-12.706 28.38-28.38 28.38-28.38-12.706-28.38-28.38c.019-15.666 12.714-28.362 28.38-28.38zm-286.79 77.52c-.002-10.374 8.406-18.784 18.78-18.786s18.784 8.406 18.786 18.78c.002 10.372-8.404 18.782-18.776 18.786-10.369-.009-18.775-8.41-18.79-18.78zm59.14 294.64c-17.388.002-31.484-14.092-31.486-31.48-.002-17.388 14.092-31.484 31.48-31.486 17.388-.002 31.484 14.092 31.486 31.48v.006c-.019 17.378-14.102 31.46-31.48 31.48zm86.278-146.552c-19.799-12.67-25.578-38.991-12.908-58.79s38.991-25.578 58.79-12.908 25.578 38.991 12.908 58.79a42.563 42.563 0 0 1-35.858 19.62 42.372 42.372 0 0 1-22.932-6.712zm154.602 128.472c-.003 13.18-10.69 23.863-23.87 23.86-13.18-.003-23.863-10.69-23.86-23.87.003-13.176 10.684-23.857 23.86-23.86 13.178.012 23.858 10.692 23.87 23.87z"
				style={{
					fill: '#083863',
				}}
			/>
		</Svg>
	);
}
export default SvgComponent;
