import * as React from 'react';
import Svg, { Path } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	const color = props.color ?? 'white';

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 0 512.018 512.018"
			{...props}
		>
			<Path
				fill="#a0e5a5"
				d="M406.254 65.894H273.63a40.001 40.001 0 0 0-28.281 11.712L21.791 301.111c-15.624 15.62-15.626 40.95-.003 56.572l132.618 132.618c15.621 15.621 40.948 15.621 56.569 0l223.564-223.564a40.002 40.002 0 0 0 11.716-28.284v-132.56c-.001-22.091-17.909-39.999-40.001-39.999z"
			/>
			<Path d="M511.945 70.834C511.945 31.776 480.17 0 441.112 0c-33.932 0-62.354 23.988-69.233 55.894H273.63c-13.353 0-25.907 5.199-35.352 14.641L14.721 294.039c-9.445 9.443-14.648 22-14.648 35.356-.001 13.357 5.2 25.914 14.645 35.359l132.618 132.618c9.444 9.443 22 14.645 35.355 14.645s25.911-5.201 35.355-14.645l77.344-77.344c3.905-3.905 3.905-10.237 0-14.143-3.906-3.904-10.236-3.904-14.143 0l-77.344 77.344c-11.697 11.697-30.729 11.697-42.426 0L28.859 350.612c-5.667-5.667-8.788-13.201-8.787-21.216 0-8.014 3.121-15.547 8.789-21.213L252.419 84.679c5.666-5.665 13.199-8.785 21.211-8.785h96.847c1.194 17.012 8.37 32.848 20.547 45.025 3.906 3.906 10.237 3.906 14.142.001 3.906-3.905 3.906-10.236.001-14.142-8.398-8.399-13.495-19.219-14.64-30.885h15.728c16.542 0 30 13.458 30 30v132.56c0 8.013-3.12 15.547-8.787 21.213l-82.581 82.581c-3.905 3.905-3.905 10.237 0 14.143 3.906 3.904 10.236 3.904 14.143 0l82.581-82.581c9.443-9.444 14.645-22 14.645-35.355v-98.42c32.247-6.963 55.689-35.418 55.689-69.2zm-55.69 48.549v-13.49c0-27.57-22.43-50-50-50h-13.732C398.92 35.132 418.281 20 441.112 20c28.029 0 50.833 22.804 50.833 50.834 0 22.731-14.78 42.101-35.69 48.549z" />
			<Path d="M137.98 328.854c3.905-3.905 3.905-10.237 0-14.143-3.906-3.904-10.236-3.904-14.143 0l-24.073 24.073c-3.905 3.905-3.905 10.237 0 14.143l59.396 59.397c1.953 1.952 4.512 2.929 7.071 2.929s5.118-.977 7.071-2.929c3.905-3.905 3.905-10.237 0-14.143l-23.19-23.19 15.09-15.09c3.905-3.905 3.905-10.237 0-14.143-3.906-3.904-10.236-3.904-14.143 0l-15.09 15.09-14.994-14.994zM256.021 325.475c5.232 0 9.633-4.068 9.97-9.363.352-5.512-3.831-10.265-9.343-10.616l-33.059-2.108a33.441 33.441 0 0 0 4.53-15.803c.275-8.845-2.92-17.063-8.997-23.141-12.41-12.41-32.995-12.02-45.89.873l-15.784 15.784-.009.01-.01.009c-3.905 3.905-3.905 10.237 0 14.143l59.397 59.396c1.953 1.952 4.512 2.929 7.071 2.929s5.118-.977 7.071-2.929c3.905-3.905 3.905-10.237 0-14.143l-17.751-17.75 42.156 2.688c.219.014.435.021.648.021zm-68.645-46.016c5.008-5.008 13.069-5.408 17.604-.873 2.133 2.133 3.251 5.106 3.149 8.374-.106 3.416-1.573 6.779-4.023 9.229a3042.037 3042.037 0 0 0-8.613 8.673 2921.275 2921.275 0 0 1-8.425-8.364c-1.65-1.649-5.136-5.117-8.384-8.348zM353.413 232.216l25.027-25.027c3.905-3.905 3.905-10.237 0-14.143-3.906-3.904-10.236-3.904-14.143 0l-17.956 17.956-15.556-15.556 16.11-16.111c3.905-3.905 3.905-10.237 0-14.143-3.906-3.904-10.236-3.904-14.143 0l-16.11 16.111-15.557-15.557 17.957-17.956c3.905-3.905 3.905-10.237 0-14.143-3.906-3.904-10.236-3.904-14.143 0l-25.027 25.027c-3.905 3.905-3.905 10.237 0 14.143l29.694 29.694.005.005.005.005 29.693 29.694a10.003 10.003 0 0 0 14.144.001zM288.345 293.142c2.652 0 5.195-1.054 7.071-2.929l25.027-25.027c3.905-3.905 3.905-10.237 0-14.143-3.906-3.904-10.236-3.904-14.143 0l-17.956 17.956-15.556-15.556 16.112-16.111c3.905-3.905 3.905-10.237 0-14.143-3.905-3.902-10.235-3.904-14.143 0L258.646 239.3l-15.556-15.556 17.957-17.956c3.905-3.905 3.905-10.237 0-14.143-3.906-3.904-10.236-3.904-14.143 0l-25.027 25.027c-3.905 3.905-3.905 10.237 0 14.143l59.396 59.397a10 10 0 0 0 7.072 2.93zM320.139 371.139c-2.63 0-5.21 1.07-7.07 2.93-1.859 1.86-2.93 4.44-2.93 7.07s1.07 5.21 2.93 7.07c1.86 1.859 4.44 2.93 7.07 2.93s5.21-1.07 7.07-2.93c1.859-1.86 2.93-4.44 2.93-7.07s-1.07-5.21-2.93-7.07-4.44-2.93-7.07-2.93z" />
		</Svg>
	);
}

export default SvgComponent;
