import { queryOptions } from '@tanstack/react-query';
var UserFeedFetchMode;
(function (UserFeedFetchMode) {
    UserFeedFetchMode["IDLE"] = "idle";
    UserFeedFetchMode["SEARCH"] = "search";
    UserFeedFetchMode["FOLLOWS"] = "follows";
    UserFeedFetchMode["MY_FOLLOWS"] = "my-follows";
    UserFeedFetchMode["FOLLOWERS"] = "followers";
    UserFeedFetchMode["MY_FOLLOWERS"] = "my-followers";
    UserFeedFetchMode["SUGGESTED"] = "suggested";
})(UserFeedFetchMode || (UserFeedFetchMode = {}));
export function unifiedUserFeedQueryOptions(client, driver, server, acctIdentifier, { type, query, opts, maxId, minId, sessionId, limit = 15, }) {
    const _query = {
        ...opts,
        limit: limit,
        sinceId: minId,
        untilId: maxId === null ? undefined : maxId,
        maxId,
        minId,
    };
    return queryOptions({
        queryKey: ['dhaaga/feed/unified/users'],
        enabled: !!client && type !== UserFeedFetchMode.IDLE,
    });
}
//# sourceMappingURL=user-feed.js.map