import { ApiTargetInterface, DhaagaJsTimelineQueryOptions, KNOWN_SOFTWARE } from '@dhaaga/bridge';
import { UserObjectType, ResultPage } from '@dhaaga/bridge';
declare enum UserFeedFetchMode {
    IDLE = "idle",
    SEARCH = "search",
    FOLLOWS = "follows",
    MY_FOLLOWS = "my-follows",
    FOLLOWERS = "followers",
    MY_FOLLOWERS = "my-followers",
    SUGGESTED = "suggested"
}
type UserFeedQueryParams = {
    type: UserFeedFetchMode;
    query?: {
        id: string;
        label: string;
    };
    opts?: DhaagaJsTimelineQueryOptions;
    minId?: string;
    maxId?: string;
    sessionId?: string;
    limit?: number;
};
type UserFeedFetchResultType = ResultPage<UserObjectType>;
export declare function unifiedUserFeedQueryOptions(client: ApiTargetInterface, driver: KNOWN_SOFTWARE, server: string, acctIdentifier: string, { type, query, opts, maxId, minId, sessionId, limit }: UserFeedQueryParams): import("@tanstack/react-query").OmitKeyof<import("@tanstack/react-query").UseQueryOptions<UserFeedFetchResultType, Error, UserFeedFetchResultType, readonly unknown[]>, "queryFn"> & {
    queryFn?: import("@tanstack/react-query").QueryFunction<UserFeedFetchResultType, readonly unknown[], never> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: UserFeedFetchResultType;
        [dataTagErrorSymbol]: Error;
    };
};
export {};
//# sourceMappingURL=user-feed.d.ts.map