import { KNOWN_SOFTWARE } from '@dhaaga/bridge';
import type { PostObjectType, FeedObjectType, ResultPage, ApiTargetInterface } from '@dhaaga/bridge';
type PostResultPage = ResultPage<PostObjectType[]>;
type FeedResultPage = ResultPage<FeedObjectType[]>;
export declare function searchFeedsQueryOpts(client: ApiTargetInterface, q: string, maxId?: string): import("@tanstack/react-query").OmitKeyof<import("@tanstack/react-query").UseQueryOptions<FeedResultPage, Error, FeedResultPage, readonly unknown[]>, "queryFn"> & {
    queryFn?: import("@tanstack/react-query").QueryFunction<FeedResultPage, readonly unknown[], never> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: FeedResultPage;
        [dataTagErrorSymbol]: Error;
    };
};
export declare function searchPostsQueryOpts(client: ApiTargetInterface, driver: KNOWN_SOFTWARE, server: string, q: string, maxId?: string, sort?: 'top' | 'latest'): import("@tanstack/react-query").OmitKeyof<import("@tanstack/react-query").UseQueryOptions<PostResultPage, Error, PostResultPage, readonly unknown[]>, "queryFn"> & {
    queryFn?: import("@tanstack/react-query").QueryFunction<PostResultPage, readonly unknown[], never> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: PostResultPage;
        [dataTagErrorSymbol]: Error;
    };
};
export declare function searchUsersQueryOpts(client: ApiTargetInterface, q: string, maxId?: string): import("@tanstack/react-query").OmitKeyof<import("@tanstack/react-query").UseQueryOptions<ResultPage<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        $type?: "app.bsky.actor.defs#viewerState" | undefined;
        muting: boolean | null;
        blocking: string | boolean | null;
        blockedBy: string | boolean | null;
        following: string | boolean | null;
        followedBy: string | boolean | null;
        showingReblogs: boolean | null;
        notifying: boolean | null;
        languages: string[];
        mutingNotifications: boolean | null;
        requested: boolean | null;
        domainBlocking: boolean | null;
        endorsed: boolean | null;
        note: string | null;
    } | null;
}[]>, Error, ResultPage<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        $type?: "app.bsky.actor.defs#viewerState" | undefined;
        muting: boolean | null;
        blocking: string | boolean | null;
        blockedBy: string | boolean | null;
        following: string | boolean | null;
        followedBy: string | boolean | null;
        showingReblogs: boolean | null;
        notifying: boolean | null;
        languages: string[];
        mutingNotifications: boolean | null;
        requested: boolean | null;
        domainBlocking: boolean | null;
        endorsed: boolean | null;
        note: string | null;
    } | null;
}[]>, readonly unknown[]>, "queryFn"> & {
    queryFn?: import("@tanstack/react-query").QueryFunction<ResultPage<{
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            $type?: "app.bsky.actor.defs#viewerState" | undefined;
            muting: boolean | null;
            blocking: string | boolean | null;
            blockedBy: string | boolean | null;
            following: string | boolean | null;
            followedBy: string | boolean | null;
            showingReblogs: boolean | null;
            notifying: boolean | null;
            languages: string[];
            mutingNotifications: boolean | null;
            requested: boolean | null;
            domainBlocking: boolean | null;
            endorsed: boolean | null;
            note: string | null;
        } | null;
    }[]>, readonly unknown[], never> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: ResultPage<{
            id: string;
            avatarUrl: string;
            displayName: string | null;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
            banner?: string | null | undefined;
            meta: {
                isProfileLocked: boolean;
                isBot: boolean;
                fields: {
                    name?: string | undefined;
                    value?: string | undefined;
                    verifiedAt?: string | null | undefined;
                    cid?: string | undefined;
                    cts?: string | undefined;
                    src?: string | undefined;
                    uri?: string | undefined;
                    val?: string | undefined;
                }[];
            };
            description: string;
            parsedDescription: any[];
            stats: {
                posts: number | null;
                followers: number | null;
                following: number | null;
            };
            calculated: {
                emojis: Map<string, string>;
            };
            relationship: {
                $type?: "app.bsky.actor.defs#viewerState" | undefined;
                muting: boolean | null;
                blocking: string | boolean | null;
                blockedBy: string | boolean | null;
                following: string | boolean | null;
                followedBy: string | boolean | null;
                showingReblogs: boolean | null;
                notifying: boolean | null;
                languages: string[];
                mutingNotifications: boolean | null;
                requested: boolean | null;
                domainBlocking: boolean | null;
                endorsed: boolean | null;
                note: string | null;
            } | null;
        }[]>;
        [dataTagErrorSymbol]: Error;
    };
};
export {};
//# sourceMappingURL=search.d.ts.map