import { DriverService, PostParser, UserParser, } from '@dhaaga/bridge';
import { queryOptions } from '@tanstack/react-query';
export function postGetQueryOpts(client, postId) {
    async function api() {
        const data = await client.posts.getPost(postId);
        const parsed = PostParser.parse(data, client.driver, client.server);
        if (!parsed)
            throw new Error(`failed to parse post ${postId}`);
        return parsed;
    }
    return queryOptions({
        queryKey: ['dhaaga/post/view', postId],
        queryFn: api,
        enabled: client && postId !== undefined,
    });
}
export function postHierarchyQueryOpts(client, postId) {
    async function api() {
        const data = await client.posts.getPostContext(postId);
        if (DriverService.supportsAtProto(client.driver)) {
            const _data = data;
            return {
                ancestors: _data.thread
                    .filter((o) => o.depth < 0)
                    .map((o) => ({
                    depth: o.depth,
                    post: PostParser.rawToInterface(o.value.post, client.driver),
                })),
                descendants: _data.thread
                    .filter((o) => o.depth > 0)
                    .map((o) => ({
                    depth: o.depth,
                    post: PostParser.rawToInterface(o.value.post, client.driver),
                })),
            };
        }
        else {
            return {
                ancestors: data.ancestors.map((o) => ({
                    depth: -1,
                    post: PostParser.rawToInterface(data.ancestors, client.driver),
                })),
                descendants: data.ancestors.map((o) => ({
                    depth: 1,
                    post: PostParser.rawToInterface(data.descendants, client.driver),
                })),
            };
        }
    }
    return queryOptions({
        queryKey: ['dhaaga/post/context', postId],
        queryFn: api,
        enabled: !!client && postId !== undefined,
    });
}
export function postLikesQueryOpts(client, postId) {
    async function api() {
        const data = await client.posts.getLikedBy(postId);
        return {
            data: UserParser.parse(data.data, client.driver, client.server),
            maxId: data.maxId,
        };
    }
    return queryOptions({
        queryKey: ['dhaaga/post/likes', postId],
        queryFn: api,
        enabled: !!client && postId !== undefined,
    });
}
//# sourceMappingURL=post.js.map