import { jsx as _jsx } from "react/jsx-runtime";
import { produce } from 'immer';
import { MediaAttachmentViewer } from '@dhaaga/bridge';
import { createContext, useContext, useReducer, } from 'react';
const DEFAULT = {
    bundles: [],
    numColumns: 0,
    posts: [],
    seen: new Set(),
    splits: [],
    items: [],
};
var ACTION;
(function (ACTION) {
    ACTION[ACTION["INIT"] = 0] = "INIT";
    ACTION[ACTION["RESET"] = 1] = "RESET";
    ACTION[ACTION["APPEND"] = 2] = "APPEND";
    ACTION[ACTION["REQUEST_LOAD_MORE"] = 3] = "REQUEST_LOAD_MORE";
})(ACTION || (ACTION = {}));
function reducer(state, action) {
    switch (action.type) {
        case ACTION.INIT:
        case ACTION.RESET: {
            return produce(state, (draft) => {
                draft.posts = [];
                draft.items = [];
                draft.maxId = null;
                draft.splits = [];
                draft.numColumns = 2;
                draft.seen = new Set();
                draft.bundles = [];
            });
        }
        case ACTION.APPEND: {
            const copy = Array.from(state.posts);
            const bundleCopy = Array.from(state.bundles);
            return produce(state, (draft) => {
                for (const item of action.payload.data) {
                    if (draft.seen.has(item.id))
                        continue;
                    draft.seen.add(item.id);
                    copy.push(item);
                    for (const media of item.content.media) {
                        if (!MediaAttachmentViewer.isImage(media)) {
                            console.log('skipping media item in masonry view', media);
                            continue;
                        }
                        bundleCopy.push({ media, post: item });
                    }
                }
                let nextSplits = [];
                let nextLeftPage = [];
                let nextRightPage = [];
                let counter = 0;
                let leftHeight = 0, rightHeight = 0;
                for (const tuple of bundleCopy) {
                    if (rightHeight >= leftHeight) {
                        nextLeftPage.push(tuple);
                        leftHeight += tuple.media.height ?? 1;
                    }
                    else {
                        nextRightPage.push(tuple);
                        rightHeight += tuple.media.height ?? 1;
                    }
                    counter++;
                    if (counter >= 10) {
                        nextSplits.push({ left: nextLeftPage, right: nextRightPage });
                        nextLeftPage = [];
                        nextRightPage = [];
                        counter = 0;
                    }
                }
                if (nextLeftPage.length > 0)
                    nextSplits.push({ left: nextLeftPage, right: nextRightPage });
                draft.items = nextSplits;
            });
        }
        case ACTION.REQUEST_LOAD_MORE: {
            return produce(state, (draft) => {
                draft.appliedMaxId = state.maxId;
            });
        }
    }
}
const StateCtx = createContext(null);
const DispatchCtx = createContext(null);
const useUserMasonryGalleryState = () => useContext(StateCtx);
const useUserMasonryGalleryDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as UserMasonryGalleryCtx, useUserMasonryGalleryState, useUserMasonryGalleryDispatch, ACTION as UserMasonryGalleryStateAction, };
//# sourceMappingURL=user-gallery-masonry.js.map