import type { PostMediaAttachmentType, PostObjectType, ResultPage } from '@dhaaga/bridge';
import { type Dispatch, type ReactNode } from 'react';
type MediaPostTuple = {
    media: PostMediaAttachmentType;
    post: PostObjectType;
};
type Page = {
    left: MediaPostTuple[];
    right: MediaPostTuple[];
};
type State = {
    posts: any[];
    bundles: MediaPostTuple[];
    items: Page[];
    maxId?: string | null;
    appliedMaxId?: string | null;
    splits: MediaPostTuple[][][];
    numColumns: number;
    seen: Set<string>;
};
declare enum ACTION {
    INIT = 0,
    RESET = 1,
    APPEND = 2,
    REQUEST_LOAD_MORE = 3
}
type Actions = {
    type: ACTION.INIT;
} | {
    type: ACTION.RESET;
} | {
    type: ACTION.APPEND;
    payload: ResultPage<PostObjectType[]>;
} | {
    type: ACTION.REQUEST_LOAD_MORE;
};
type DispatchType = Dispatch<Actions>;
declare const useUserMasonryGalleryState: () => State | null;
declare const useUserMasonryGalleryDispatch: () => DispatchType | null;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as UserMasonryGalleryCtx, useUserMasonryGalleryState, useUserMasonryGalleryDispatch, ACTION as UserMasonryGalleryStateAction, };
export type { State as UserMasonryGalleryStateType, DispatchType as UserMasonryGalleryDispatchType, };
//# sourceMappingURL=user-gallery-masonry.d.ts.map