import { jsx as _jsx } from "react/jsx-runtime";
import { produce } from 'immer';
import { createContext, useContext, useReducer, } from 'react';
const DEFAULT = {
    seen: new Set(),
    data: [],
    users: [],
    items: [],
    userSet: new Set(),
    userSelection: new Set(),
    allSelected: true,
    noneSelected: false,
    maxId: null,
    appliedMaxId: null,
    endOfPage: false,
};
var ACTION;
(function (ACTION) {
    ACTION["RESET"] = "init";
    ACTION["APPEND"] = "append";
    ACTION["SELECT_ALL"] = "selectAll";
    ACTION["SELECT_NONE"] = "deselectAll";
    ACTION["LOAD_NEXT_PAGE"] = "loadNextPage";
})(ACTION || (ACTION = {}));
function reducer(state, action) {
    switch (action.type) {
        case ACTION.RESET: {
            return DEFAULT;
        }
        case ACTION.APPEND: {
            const dataCopy = Array.from(state.data);
            const usersCopy = Array.from(state.users);
            return produce(state, (draft) => {
                for (const item of action.payload.data) {
                    if (!item.user)
                        continue;
                    if (!draft.userSet.has(item.user.id)) {
                        draft.userSet.add(item.user.id);
                        draft.userSelection.add(item.user.id);
                        usersCopy.push(item.user);
                    }
                    if (draft.seen.has(item.id))
                        continue;
                    draft.seen.add(item.id);
                    dataCopy.push(item);
                }
                draft.maxId = action.payload.maxId;
                if (!draft.maxId)
                    draft.endOfPage = true;
                draft.data = dataCopy;
                draft.users = usersCopy;
                draft.items = dataCopy.filter((o) => draft.userSelection.has(o.user?.id ?? 'N/A'));
            });
        }
        case ACTION.LOAD_NEXT_PAGE: {
            return produce(state, (draft) => {
                draft.appliedMaxId = state.maxId;
            });
        }
        case ACTION.SELECT_ALL: {
            return produce(state, (draft) => {
                draft.allSelected = true;
                draft.userSelection = new Set(state.userSet);
                draft.items = Array.from(state.data);
            });
        }
        case ACTION.SELECT_NONE: {
            return produce(state, (draft) => {
                draft.allSelected = false;
                draft.userSelection = new Set();
                draft.items = [];
            });
        }
    }
}
const StateCtx = createContext(null);
const DispatchCtx = createContext(null);
const useSubscriptionGalleryState = () => useContext(StateCtx);
const useSubscriptionGalleryDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as SubscriptionGalleryCtx, useSubscriptionGalleryState, useSubscriptionGalleryDispatch, ACTION as SubscriptionGalleryStateAction, };
//# sourceMappingURL=subscription-gallery.js.map