import { jsx as _jsx } from "react/jsx-runtime";
import { produce } from 'immer';
import { createContext, useContext, useReducer, } from 'react';
const DEFAULT = {
    items: [],
    participants: [],
    seen: new Set(),
};
var ACTION;
(function (ACTION) {
    ACTION["RESET"] = "init";
    ACTION["SET_PARTICIPANTS"] = "setParticipants";
    ACTION["APPEND_PAGE"] = "append_PAGE";
})(ACTION || (ACTION = {}));
function reducer(state, action) {
    switch (action.type) {
        case ACTION.RESET: {
            return DEFAULT;
        }
        case ACTION.SET_PARTICIPANTS: {
            return {
                ...state,
                participants: action.payload.participants,
                seen: new Set(),
            };
        }
        case ACTION.APPEND_PAGE: {
            const copy = Array.from(state.items);
            return produce(state, (draft) => {
                for (const item of action.payload.data) {
                    if (state.seen.has(item.id))
                        continue;
                    copy.push(item);
                    draft.seen.add(item.id);
                }
                draft.items = copy;
                draft.minId = action.payload.minId;
                draft.maxId = action.payload.maxId;
            });
        }
        default:
            return state;
    }
}
const StateCtx = createContext(null);
const DispatchCtx = createContext(null);
const useChatroomState = () => useContext(StateCtx);
const useChatroomDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as ChatroomCtx, useChatroomState, useChatroomDispatch, ACTION as ChatroomStateAction, };
//# sourceMappingURL=chatroom.js.map