import { MessageObjectType, ResultPage, UserObjectType } from '@dhaaga/bridge';
import { Dispatch, ReactNode } from 'react';
type State = {
    items: MessageObjectType[];
    participants: UserObjectType[];
    minId?: string | null;
    maxId?: string | null;
    seen: Set<string>;
};
declare enum ACTION {
    RESET = "init",
    SET_PARTICIPANTS = "setParticipants",
    APPEND_PAGE = "append_PAGE"
}
type Actions = {
    type: ACTION.RESET;
} | {
    type: ACTION.SET_PARTICIPANTS;
    payload: {
        participants: UserObjectType[];
    };
} | {
    type: ACTION.APPEND_PAGE;
    payload: ResultPage<MessageObjectType[]>;
};
type DispatchType = Dispatch<Actions>;
declare const useChatroomState: () => State;
declare const useChatroomDispatch: () => DispatchType;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as ChatroomCtx, useChatroomState, useChatroomDispatch, ACTION as ChatroomStateAction, };
export type { State as PostTimelineStateType, DispatchType as PostTimelineDispatchType, };
//# sourceMappingURL=chatroom.d.ts.map