import { useState, useRef } from 'react';
import { generateDhaagaAuthStrategy } from '@dhaaga/bridge/auth';
function useDhaagaAuthGate(strategy = 'activitypub', placeholder = 'mastodon.social') {
    const [Instance, setInstance] = useState(placeholder);
    const [IsLoading, setIsLoading] = useState(false);
    const [ErrorMessage, setErrorMessage] = useState(null);
    const cachedClientTokens = useRef(null);
    async function processAuth() {
        setIsLoading(true);
        try {
            const signInStrategy = await generateDhaagaAuthStrategy(Instance, {
                appName: 'Dhaaga',
                appWebsite: 'https://suvam.io/dhaaga',
                appCallback: 'https://suvam.io/dhaaga',
            }, cachedClientTokens.current);
            switch (strategy) {
                case 'activitypub': {
                    return {
                        strategy: 'activitypub',
                        params: {
                            signInUrl: signInStrategy?.loginUrl,
                            instance: Instance,
                            software: signInStrategy?.software,
                            clientId: signInStrategy?.clientId,
                            clientSecret: signInStrategy?.clientSecret,
                        },
                    };
                }
                case 'miauth': {
                    return {
                        strategy: 'miauth',
                        params: {
                            signInUrl: signInStrategy?.loginUrl,
                            instance: Instance,
                            software: signInStrategy?.software,
                        },
                    };
                }
                default: {
                    throw new Error('invalid strategy');
                }
            }
        }
        catch (e) {
            return {
                strategy: 'error',
                params: {
                    code: 'E_Failed_To_Generate_Strategy',
                    message: 'Something went wrong',
                },
            };
        }
        finally {
            setIsLoading(false);
        }
    }
    return {
        resolve: processAuth,
        Instance,
        setInstance,
        isLoading: IsLoading,
        cachedClientTokens,
    };
}
export default useDhaagaAuthGate;
//# sourceMappingURL=useDhaagaAuthGate.js.map