import { useState } from 'react';
import { exchangeCodeForAccessToken, verifyCredentialsActivitypub, } from '@dhaaga/bridge/auth';
function useActivityPubAuth(instance, _clientId, _clientSecret) {
    const [Code, setCode] = useState(null);
    const [IsLoading, setIsLoading] = useState(false);
    const [Error, setError] = useState(null);
    const [UserData, setUserData] = useState();
    function reset() {
        setIsLoading(false);
        setCode(null);
        setError(null);
        setUserData(null);
    }
    function RNWebviewStateChangeCallback(state) {
        const regex = /^https:\/\/(.*?)\/oauth\/authorize\/native\?code=(.*?)$/;
        if (regex.test(state.url)) {
            const code = state.url.match(regex)[2];
            setCode(code);
        }
        else {
            setCode(null);
        }
    }
    async function authenticate() {
        if (!_clientId || !_clientSecret) {
            setError('E_Missing_Client_Credentials');
            return null;
        }
        setIsLoading(true);
        try {
            const token = await exchangeCodeForAccessToken(instance, Code, _clientId, _clientSecret);
            const data = await verifyCredentialsActivitypub(instance, token || Code);
            setUserData(data);
            return { userData: data, accessToken: token ?? Code };
        }
        catch (e) {
            return null;
        }
        finally {
            setIsLoading(false);
        }
    }
    return {
        RNWebviewStateChangeCallback,
        userData: UserData,
        code: Code,
        setCode,
        loading: IsLoading,
        authenticate,
        error: Error,
        reset,
    };
}
export default useActivityPubAuth;
//# sourceMappingURL=useActivityPubAuth.js.map