import { SQLiteBindValue, SQLiteDatabase } from 'expo-sqlite';
type BaseType = {
    id: number;
    createdAt: Date;
    updatedAt: Date;
};
/**
 * ------ Typescript Sorcery ------
 */
type ClassPropList<T> = {
    [K in keyof T]: T[K] extends Function ? never : K;
}[keyof T];
type OnlyClassProps<T> = Pick<T, ClassPropList<T>>;
/**
 * --------------------------------
 */
/**
 * ------ Decorator Sorcery ------
 */
type BaseEntityInternalPropList = '_name' | 'db' | 'sql' | 'params' | 'debug' | 'whereClauses' | 'selectColumns';
export declare function Entity(name: string): (target: Function) => void;
export declare class BaseEntity<T extends BaseType> {
    _name: string;
    db: SQLiteDatabase;
    sql: string | null;
    params: SQLiteBindValue[];
    debug: boolean;
    whereClauses: string[];
    selectColumns: string[];
    id: number;
    createdAt: Date;
    updatedAt: Date;
    constructor(db: SQLiteDatabase, debug?: boolean);
    getEntityName(): string | undefined;
    static get<T extends BaseType>(db: SQLiteDatabase, debug?: boolean): BaseEntity<T>;
    /**
     * Find multiple records matching query
     */
    find(data?: OnlyClassProps<Partial<T>>): T[];
    /**
     * Find first record matching query
     */
    findOne(data: OnlyClassProps<Partial<T>>): T | null;
    update(where: OnlyClassProps<Partial<T>>, update: OnlyClassProps<Partial<T>>): import("expo-sqlite").SQLiteRunResult | undefined;
    getOne(): void;
    clearPreviousQuery(): void;
    getMany(): void;
    where(clause: string): this;
    andWhere(clause: string): this;
    /**
     *	add a new database record
     */
    insert(data: Omit<OnlyClassProps<Partial<T>>, 'id' | 'createdAt' | 'updatedAt' | BaseEntityInternalPropList>): void;
    /**
     * Update an entity by id
     * @param id numeric id, or entity instance
     * @param update
     */
    updateById(id: string | number | T, update: Omit<OnlyClassProps<Partial<T>>, 'id' | 'createdAt' | 'updatedAt' | BaseEntityInternalPropList>): import("expo-sqlite").SQLiteRunResult | undefined;
    /**
     * 	updates a record (when id provided)
     *
     *	inserts a record (when id not provided)
     */
    save(data: Omit<OnlyClassProps<Partial<T>>, 'createdAt' | 'updatedAt' | BaseEntityInternalPropList>): this;
}
export {};
