import { DataSource } from '../dataSource.js';
import { Account, Profile } from '../_schema.js';
declare class Repo {
}
declare class Service {
    static getShownProfiles(db: DataSource): Profile[];
    static renameProfileById(db: DataSource, id: number | string, newName: string): void;
    static isDefaultProfile(db: DataSource, profile: Profile): boolean;
    static getById(db: DataSource, id: number | string): Profile | null;
    static getForAccount(db: DataSource, acct: Account): Profile[];
    static getAllShown(db: DataSource): Profile[];
    static deselectAll(db: DataSource): void;
    static hideProfile(db: DataSource, id: number): void;
    static unhideProfile(db: DataSource, id: number): void;
    static removeProfile(db: DataSource, id: number): void;
    static getDefaultProfile(db: DataSource, acct: Account): Profile | null;
    static getActiveProfile(db: DataSource, acct: Account): Profile;
    static setupDefaultProfile(db: DataSource, acct: Account): void;
    static selectDefaultProfile(db: DataSource, acct: Account): void;
    static getOwnerAccount(db: DataSource, profile: Profile): Account | null;
    static addProfile(db: DataSource, acct: Account, name: string): Profile | null;
    static _postInsert(db: DataSource, profile: Profile): void;
    static _postSelect(db: DataSource, profile: Profile): void;
}
export { Repo as ProfileRepo, Service as ProfileService };
//# sourceMappingURL=profile.d.ts.map