var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { DbErrorHandler } from './_base.repo.js';
import { DataSource } from '../dataSource.js';
import { Account, Profile, ProfilePinnedUser } from '../_schema.js';
import { AccountService } from './account.js';
import { z } from 'zod';
import { RandomUtil } from '@dhaaga/bridge';
import { APP_PINNED_OBJECT_TYPE } from '../types/db.types.js';
const profileUserPinCreateSchema = z.object({
    server: z.string(),
    driver: z.string(),
    required: z.boolean(),
    category: z.enum([
        APP_PINNED_OBJECT_TYPE.AP_PROTO_MICROBLOG_USER_LOCAL,
        APP_PINNED_OBJECT_TYPE.AP_PROTO_MICROBLOG_USER_REMOTE,
    ]),
    identifier: z.string(),
    username: z.string(),
    avatarUrl: z.string().optional().nullable(),
    displayName: z.string().nullable().optional(),
});
let Repo = class Repo {
    static addLocalPin(db, profile, acct, user) {
        const _uuid = RandomUtil.nanoId();
        db.profilePinnedUser.insert({
            uuid: RandomUtil.nanoId(),
            server: acct.server,
            category: APP_PINNED_OBJECT_TYPE.AP_PROTO_MICROBLOG_USER_LOCAL,
            driver: acct.driver,
            required: false,
            itemOrder: 0,
            page: 0, // optional
            avatarUrl: user.avatarUrl,
            displayName: user.displayName, // fk
            profileId: profile.id,
            identifier: user.id,
            username: user.handle,
        });
        return db.profilePinnedUser.findOne({
            uuid: _uuid,
        });
    }
};
Repo = __decorate([
    DbErrorHandler()
], Repo);
export class Service {
    static toggle(db, pinnedUser) {
        const match = db.profilePinnedUser.findOne({
            id: pinnedUser.id,
        });
        if (!match)
            return;
        db.profilePinnedUser.updateById(pinnedUser.id, {
            active: !match.active,
        });
        return db.profilePinnedUser.findOne({
            id: pinnedUser.id,
        });
    }
    static listByUserId(db, server, userId) {
        return db.profilePinnedUser.find({
            server,
            identifier: userId,
            active: true,
        });
    }
    static findById(db, id) {
        return db.profilePinnedUser.findOne({ id });
    }
    static getOwnerAccount(db, profile) {
        return AccountService.getById(db, profile.accountId || -1);
    }
    static find(db, profile, server, userId) {
        return db.profilePinnedUser.findOne({
            profileId: profile.id,
            server: server,
            identifier: userId,
        });
    }
    static setActive(db, profile) {
        db.profilePinnedUser.updateById(profile.id, { active: true });
    }
    static isPinnedForProfile(db, profile, server, userId) {
        const match = Service.find(db, profile, server, userId);
        return match && match?.active;
    }
    static addForProfile(db, profile, acct, user) {
        const duplicate = Service.find(db, profile, acct.server, user.id);
        if (duplicate) {
            if (!duplicate.active) {
                Service.setActive(db, duplicate);
            }
            return duplicate;
        }
        return Repo.addLocalPin(db, profile, acct, user);
    }
    static getShownForProfile(db, profile) {
        if (!db || !profile)
            return [];
        try {
            const items = db.profilePinnedUser.find({
                profileId: profile.id,
                active: true,
                show: true,
            });
            return items.sort((a, b) => (a.itemOrder > b.itemOrder ? 1 : -1));
        }
        catch (e) {
            console.log('[ERROR]: could not load pinned user items for profile', profile);
            return [];
        }
    }
    static toggleUserPin(db, profile, acct, user) {
        const matched = Service.find(db, profile, acct.server, user.id);
        if (matched) {
            db.profilePinnedUser.updateById(matched.id, {
                active: !matched.active,
                show: true,
            });
            return Service.find(db, profile, acct.server, user.id);
        }
        return Repo.addLocalPin(db, profile, acct, user);
    }
}
export { Service as ProfilePinnedUserService, Repo as ProfilePinnedUserRepo };
//# sourceMappingURL=profile-pinned-user.js.map