import { DataSource } from '../dataSource.js';
import { Account, Profile, ProfilePinnedTimeline } from '../_schema.js';
import type { FeedObjectType } from '@dhaaga/bridge';
declare class Repo {
    static addFeed(db: DataSource, acct: Account, profile: Profile, feed: FeedObjectType): ProfilePinnedTimeline | null;
}
declare class Service {
    static listByUri(db: DataSource, uri: string): ProfilePinnedTimeline[];
    static findById(db: DataSource, id: number): ProfilePinnedTimeline | null;
    static findByUri(db: DataSource, profile: Profile, server: string, uri: string): ProfilePinnedTimeline | null;
    static isPinnedForProfile(db: DataSource, profile: Profile, server: string, uri: string): boolean;
    static getShownForProfile(db: DataSource, profile: Profile): ProfilePinnedTimeline[];
    private static _fixItemOrder;
    static upsertDefaultTimelines(db: DataSource, profile: Profile): void;
    static getOwnerAccount(db: DataSource, profile: Profile): Account | null;
    static toggleTimelinePin(db: DataSource, acct: Account, profile: Profile, feed: FeedObjectType): ProfilePinnedTimeline | null;
}
export { Service as ProfilePinnedTimelineService, Repo as ProfilePinnedTimelineRepo, };
//# sourceMappingURL=profile-pinned-timeline.d.ts.map