import { DataSource } from '../dataSource.js';
import { Account, Profile, ProfilePinnedTag } from '../_schema.js';
declare class Repo {
}
declare class Service {
    static listByName(db: DataSource, name: string): ProfilePinnedTag[];
    static delete(db: DataSource, id: number): void;
    static add(db: DataSource, acct: Account, profile: Profile, name: string): ProfilePinnedTag | null | undefined;
    static renameById(db: DataSource, id: number, name: string): ProfilePinnedTag | null;
    static findById(db: DataSource, id: number): ProfilePinnedTag | null;
    static getShownForProfile(db: DataSource, profile: Profile): ProfilePinnedTag[];
    static upsertDefaultTags(db: DataSource, profile: Profile): void;
    private static _fixItemOrder;
}
export { Service as ProfilePinnedTagService, Repo as ProfilePinnedTagRepo };
//# sourceMappingURL=profile-pinned-tag.d.ts.map