import { SQLiteDatabase } from 'expo-sqlite';
export class ExpoSqliteInspectorService {
    static dbTableList(db) {
        return db.getAllSync(`SELECT name FROM sqlite_master WHERE type=\'table\';`);
    }
    static getColumnList(db, tableName) {
        return db.getAllSync(`PRAGMA table_info(${tableName});`);
    }
    static foreignKeyList(db, tableName) {
        return db.getAllSync(`PRAGMA foreign_key_list(${tableName});`);
    }
}
//# sourceMappingURL=_inspect.js.map