import { DataSource } from '@dhaaga/db';
import type { UserObjectType, ResultPage } from '@dhaaga/bridge';
import { type Dispatch, type ReactNode } from 'react';
import { type TimelineReducerBaseState } from './_timeline.shared.js';
type State = TimelineReducerBaseState<UserObjectType> & {};
declare enum ACTION {
    INIT = 0,
    RESET = 1,
    APPEND = 2,
    REQUEST_LOAD_MORE = 3,
    SET_QUERY_OPTS = 4
}
type Actions = {
    type: ACTION.INIT;
    payload: {
        db: DataSource;
    };
} | {
    type: ACTION.RESET;
} | {
    type: ACTION.REQUEST_LOAD_MORE;
} | {
    type: ACTION.APPEND;
    payload: ResultPage<UserObjectType[]>;
} | {
    type: ACTION.SET_QUERY_OPTS;
    payload: {
        limit: number;
        q?: string;
    };
};
type DispatchType = Dispatch<Actions>;
declare const useUserTimelineState: () => TimelineReducerBaseState<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        $type?: "app.bsky.actor.defs#viewerState" | undefined;
        muting: boolean | null;
        blocking: string | boolean | null;
        blockedBy: string | boolean | null;
        following: string | boolean | null;
        followedBy: string | boolean | null;
        showingReblogs: boolean | null;
        notifying: boolean | null;
        languages: string[];
        mutingNotifications: boolean | null;
        requested: boolean | null;
        domainBlocking: boolean | null;
        endorsed: boolean | null;
        note: string | null;
    } | null;
}> | null;
declare const useUserTimelineDispatch: () => DispatchType | null;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as UserTimelineCtx, useUserTimelineState, useUserTimelineDispatch, ACTION as UserTimelineStateAction, };
export type { State as UserTimelineStateType, DispatchType as UserTimelineDispatchType, };
//# sourceMappingURL=user-timeline.d.ts.map