class Service {
    static isImage(mimeType) {
        return [
            'image',
            'image/avif',
            'image/jpeg',
            'image/png',
            'image/webp',
            'gifv',
            'image/gif',
        ].includes(mimeType);
    }
    static isVideo(mimeType) {
        return ['video', 'video/mp4', 'video/webm', 'video/quicktime'].includes(mimeType);
    }
    static isAnimatedImage(mimeType) {
        return ['gifv', 'image/gif'].includes(mimeType);
    }
    static isAudio(mimeType) {
        return ['audio', 'audio/mpeg'].includes(mimeType);
    }
    static calculateDimensions({ maxW, maxH = 720, W, H, allowCrop = false, }) {
        if (!W || !H)
            return { height: maxH, width: maxW };
        let _H = (maxW / W) * H;
        let _W = maxW;
        if (_H > maxH) {
            _H = maxH;
            _W = (maxH / H) * W;
        }
        return {
            width: _W,
            height: _H,
        };
    }
}
export { Service as MediaService };
//# sourceMappingURL=media.service.js.map