class EventBus {
    subscriptions = {};
    subscribers = {};
    cleanup() {
        for (const event in this.subscriptions) {
            const refs = this.subscriptions[event];
            const cleaned = new Set();
            for (const ref of refs) {
                if (ref.deref()) {
                    cleaned.add(ref);
                }
            }
            this.subscriptions[event] = cleaned;
        }
    }
    cleanupEvent(event) {
        const refs = this.subscriptions[event];
        if (!refs)
            return;
        for (const ref of refs) {
            if (!ref.deref()) {
                refs.delete(ref);
            }
        }
        if (refs.size === 0)
            delete this.subscriptions[event];
    }
    subscribe(uuid, callback) {
        let refs = this.subscriptions[uuid];
        if (!refs)
            refs = this.subscriptions[uuid] = new Set();
        refs.add(new WeakRef(callback));
        this.cleanupEvent(uuid);
    }
    unsubscribe(uuid, callback) {
        const refs = this.subscriptions[uuid];
        if (!refs)
            return;
        for (const ref of refs) {
            if (ref.deref() === callback) {
                refs.delete(ref);
            }
        }
        if (refs.size === 0)
            delete this.subscriptions[uuid];
    }
    prune() {
        for (const event in this.subscriptions) {
            if (this.subscriptions[event].size === 0) {
                delete this.subscriptions[event];
            }
        }
    }
    publish(uuid) {
        const refs = this.subscriptions[uuid];
        if (!refs)
            return;
        for (const ref of refs) {
            const callback = ref.deref();
            if (callback)
                callback({ uuid });
        }
        this.cleanupEvent(uuid);
    }
}
export { EventBus };
//# sourceMappingURL=event-bus.js.map