import z from 'zod';
const appRelationObjectSchema = z.object({
    $type: z.literal('app.bsky.actor.defs#viewerState').optional(),
    muting: z.boolean().nullable(),
    blocking: z.union([z.boolean(), z.string()]).nullable(),
    blockedBy: z.union([z.boolean(), z.string()]).nullable(),
    following: z.union([z.boolean(), z.string()]).nullable(),
    followedBy: z.union([z.boolean(), z.string()]).nullable(),
    showingReblogs: z.boolean().nullable(),
    notifying: z.boolean().nullable(),
    languages: z.array(z.string()),
    mutingNotifications: z.boolean().nullable(),
    requested: z.boolean().nullable(),
    domainBlocking: z.boolean().nullable(),
    endorsed: z.boolean().nullable(),
    note: z.string().nullable(),
});
export { appRelationObjectSchema };
//# sourceMappingURL=relationship.js.map