import { z } from 'zod';
import { PostTargetInterface } from '#/implementors/index.js';
declare const ActivityPubReactionStateSchema: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    count: z.ZodNumber;
    me: z.ZodBoolean;
    accounts: z.ZodArray<z.ZodString>;
    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>>;
type ActivityPubReactionStateType = z.infer<typeof ActivityPubReactionStateSchema>;
declare const ActivityPubBoostedByDto: z.ZodObject<{
    id: z.ZodString;
    avatarUrl: z.ZodString;
    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    parsedDisplayName: z.ZodArray<z.ZodAny>;
    handle: z.ZodString;
    instance: z.ZodString;
}, z.core.$strip>;
type PostAuthorType = z.infer<typeof ActivityPubBoostedByDto>;
declare const AppActivityPubMediaDto: z.ZodObject<{
    url: z.ZodString;
    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
    alt: z.ZodNullable<z.ZodString>;
    type: z.ZodString;
    blurhash: z.ZodNullable<z.ZodString>;
}, z.core.$strip>;
type PostMediaAttachmentType = z.infer<typeof AppActivityPubMediaDto>;
declare const AppPostStatsDto: z.ZodObject<{
    replyCount: z.ZodNumber;
    boostCount: z.ZodNumber;
    likeCount: z.ZodNumber;
    reactions: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        count: z.ZodNumber;
        me: z.ZodBoolean;
        accounts: z.ZodArray<z.ZodString>;
        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>>;
}, z.core.$strip>;
type PostStatsType = z.infer<typeof AppPostStatsDto>;
export declare const ActivityPubStatusItemDto: z.ZodObject<{
    uuid: z.ZodString;
    id: z.ZodString;
    visibility: z.ZodString;
    createdAt: z.ZodString;
    postedBy: z.ZodObject<{
        id: z.ZodString;
        avatarUrl: z.ZodString;
        displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        parsedDisplayName: z.ZodArray<z.ZodAny>;
        handle: z.ZodString;
        instance: z.ZodString;
    }, z.core.$strip>;
    content: z.ZodObject<{
        raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        parsed: z.ZodArray<z.ZodAny>;
        media: z.ZodArray<z.ZodObject<{
            url: z.ZodString;
            previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
            height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
            alt: z.ZodNullable<z.ZodString>;
            type: z.ZodString;
            blurhash: z.ZodNullable<z.ZodString>;
        }, z.core.$strip>>;
        links: z.ZodArray<z.ZodObject<{
            url: z.ZodString;
            title: z.ZodString;
            description: z.ZodString;
            bannerImageUrl: z.ZodNullable<z.ZodString>;
            bannerWidth: z.ZodOptional<z.ZodNumber>;
            bannerHeight: z.ZodOptional<z.ZodNumber>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
    interaction: z.ZodObject<{
        boosted: z.ZodBoolean;
        liked: z.ZodBoolean;
        bookmarked: z.ZodBoolean;
    }, z.core.$strip>;
    stats: z.ZodObject<{
        replyCount: z.ZodNumber;
        boostCount: z.ZodNumber;
        likeCount: z.ZodNumber;
        reactions: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            count: z.ZodNumber;
            me: z.ZodBoolean;
            accounts: z.ZodArray<z.ZodString>;
            url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
    calculated: z.ZodObject<{
        mediaContainerHeight: z.ZodNumber;
        emojis: z.ZodMap<z.ZodString, z.ZodString>;
        translationOutput: z.ZodOptional<z.ZodString>;
        translationType: z.ZodOptional<z.ZodString>;
        reactionEmojis: z.ZodArray<z.ZodObject<{
            height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
            width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>>;
        mentions: z.ZodArray<z.ZodObject<{
            id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            text: z.ZodOptional<z.ZodString>;
            url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, z.core.$strip>>;
        customEmojiCount: z.ZodOptional<z.ZodNumber>;
    }, z.core.$strip>;
    meta: z.ZodObject<{
        sensitive: z.ZodBoolean;
        cw: z.ZodNullable<z.ZodString>;
        isBoost: z.ZodBoolean;
        isReply: z.ZodBoolean;
        mentions: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            handle: z.ZodOptional<z.ZodString>;
            url: z.ZodOptional<z.ZodString>;
            acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, z.core.$strip>>;
        cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>;
    state: z.ZodObject<{
        isBookmarkStateFinal: z.ZodBoolean;
    }, z.core.$strip>;
    atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        viewer: z.ZodOptional<z.ZodObject<{
            like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
            pinned: z.ZodOptional<z.ZodAny>;
            repost: z.ZodOptional<z.ZodAny>;
            replyDisabled: z.ZodOptional<z.ZodBoolean>;
            threadMuted: z.ZodOptional<z.ZodBoolean>;
        }, z.core.$strip>>;
    }, z.core.$strip>>>;
}, z.core.$strip>;
declare const postObjectSchema: z.ZodObject<{
    uuid: z.ZodString;
    id: z.ZodString;
    visibility: z.ZodString;
    createdAt: z.ZodString;
    postedBy: z.ZodObject<{
        id: z.ZodString;
        avatarUrl: z.ZodString;
        displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        parsedDisplayName: z.ZodArray<z.ZodAny>;
        handle: z.ZodString;
        instance: z.ZodString;
    }, z.core.$strip>;
    content: z.ZodObject<{
        raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        parsed: z.ZodArray<z.ZodAny>;
        media: z.ZodArray<z.ZodObject<{
            url: z.ZodString;
            previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
            height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
            alt: z.ZodNullable<z.ZodString>;
            type: z.ZodString;
            blurhash: z.ZodNullable<z.ZodString>;
        }, z.core.$strip>>;
        links: z.ZodArray<z.ZodObject<{
            url: z.ZodString;
            title: z.ZodString;
            description: z.ZodString;
            bannerImageUrl: z.ZodNullable<z.ZodString>;
            bannerWidth: z.ZodOptional<z.ZodNumber>;
            bannerHeight: z.ZodOptional<z.ZodNumber>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
    interaction: z.ZodObject<{
        boosted: z.ZodBoolean;
        liked: z.ZodBoolean;
        bookmarked: z.ZodBoolean;
    }, z.core.$strip>;
    stats: z.ZodObject<{
        replyCount: z.ZodNumber;
        boostCount: z.ZodNumber;
        likeCount: z.ZodNumber;
        reactions: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            count: z.ZodNumber;
            me: z.ZodBoolean;
            accounts: z.ZodArray<z.ZodString>;
            url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
    calculated: z.ZodObject<{
        mediaContainerHeight: z.ZodNumber;
        emojis: z.ZodMap<z.ZodString, z.ZodString>;
        translationOutput: z.ZodOptional<z.ZodString>;
        translationType: z.ZodOptional<z.ZodString>;
        reactionEmojis: z.ZodArray<z.ZodObject<{
            height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
            width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>>;
        mentions: z.ZodArray<z.ZodObject<{
            id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            text: z.ZodOptional<z.ZodString>;
            url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, z.core.$strip>>;
        customEmojiCount: z.ZodOptional<z.ZodNumber>;
    }, z.core.$strip>;
    meta: z.ZodObject<{
        sensitive: z.ZodBoolean;
        cw: z.ZodNullable<z.ZodString>;
        isBoost: z.ZodBoolean;
        isReply: z.ZodBoolean;
        mentions: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            handle: z.ZodOptional<z.ZodString>;
            url: z.ZodOptional<z.ZodString>;
            acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, z.core.$strip>>;
        cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>;
    state: z.ZodObject<{
        isBookmarkStateFinal: z.ZodBoolean;
    }, z.core.$strip>;
    atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        viewer: z.ZodOptional<z.ZodObject<{
            like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
            pinned: z.ZodOptional<z.ZodAny>;
            repost: z.ZodOptional<z.ZodAny>;
            replyDisabled: z.ZodOptional<z.ZodBoolean>;
            threadMuted: z.ZodOptional<z.ZodBoolean>;
        }, z.core.$strip>>;
    }, z.core.$strip>>>;
    replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        uuid: z.ZodString;
        id: z.ZodString;
        visibility: z.ZodString;
        createdAt: z.ZodString;
        postedBy: z.ZodObject<{
            id: z.ZodString;
            avatarUrl: z.ZodString;
            displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsedDisplayName: z.ZodArray<z.ZodAny>;
            handle: z.ZodString;
            instance: z.ZodString;
        }, z.core.$strip>;
        content: z.ZodObject<{
            raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsed: z.ZodArray<z.ZodAny>;
            media: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                alt: z.ZodNullable<z.ZodString>;
                type: z.ZodString;
                blurhash: z.ZodNullable<z.ZodString>;
            }, z.core.$strip>>;
            links: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                title: z.ZodString;
                description: z.ZodString;
                bannerImageUrl: z.ZodNullable<z.ZodString>;
                bannerWidth: z.ZodOptional<z.ZodNumber>;
                bannerHeight: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        interaction: z.ZodObject<{
            boosted: z.ZodBoolean;
            liked: z.ZodBoolean;
            bookmarked: z.ZodBoolean;
        }, z.core.$strip>;
        stats: z.ZodObject<{
            replyCount: z.ZodNumber;
            boostCount: z.ZodNumber;
            likeCount: z.ZodNumber;
            reactions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                count: z.ZodNumber;
                me: z.ZodBoolean;
                accounts: z.ZodArray<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            mediaContainerHeight: z.ZodNumber;
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
            translationOutput: z.ZodOptional<z.ZodString>;
            translationType: z.ZodOptional<z.ZodString>;
            reactionEmojis: z.ZodArray<z.ZodObject<{
                height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                name: z.ZodString;
                url: z.ZodString;
            }, z.core.$strip>>;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                text: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            customEmojiCount: z.ZodOptional<z.ZodNumber>;
        }, z.core.$strip>;
        meta: z.ZodObject<{
            sensitive: z.ZodBoolean;
            cw: z.ZodNullable<z.ZodString>;
            isBoost: z.ZodBoolean;
            isReply: z.ZodBoolean;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                handle: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodString>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
        state: z.ZodObject<{
            isBookmarkStateFinal: z.ZodBoolean;
        }, z.core.$strip>;
        atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            viewer: z.ZodOptional<z.ZodObject<{
                like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                pinned: z.ZodOptional<z.ZodAny>;
                repost: z.ZodOptional<z.ZodAny>;
                replyDisabled: z.ZodOptional<z.ZodBoolean>;
                threadMuted: z.ZodOptional<z.ZodBoolean>;
            }, z.core.$strip>>;
        }, z.core.$strip>>>;
        replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
    }, z.core.$strip>>>;
    boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        uuid: z.ZodString;
        id: z.ZodString;
        visibility: z.ZodString;
        createdAt: z.ZodString;
        postedBy: z.ZodObject<{
            id: z.ZodString;
            avatarUrl: z.ZodString;
            displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsedDisplayName: z.ZodArray<z.ZodAny>;
            handle: z.ZodString;
            instance: z.ZodString;
        }, z.core.$strip>;
        content: z.ZodObject<{
            raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsed: z.ZodArray<z.ZodAny>;
            media: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                alt: z.ZodNullable<z.ZodString>;
                type: z.ZodString;
                blurhash: z.ZodNullable<z.ZodString>;
            }, z.core.$strip>>;
            links: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                title: z.ZodString;
                description: z.ZodString;
                bannerImageUrl: z.ZodNullable<z.ZodString>;
                bannerWidth: z.ZodOptional<z.ZodNumber>;
                bannerHeight: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        interaction: z.ZodObject<{
            boosted: z.ZodBoolean;
            liked: z.ZodBoolean;
            bookmarked: z.ZodBoolean;
        }, z.core.$strip>;
        stats: z.ZodObject<{
            replyCount: z.ZodNumber;
            boostCount: z.ZodNumber;
            likeCount: z.ZodNumber;
            reactions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                count: z.ZodNumber;
                me: z.ZodBoolean;
                accounts: z.ZodArray<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            mediaContainerHeight: z.ZodNumber;
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
            translationOutput: z.ZodOptional<z.ZodString>;
            translationType: z.ZodOptional<z.ZodString>;
            reactionEmojis: z.ZodArray<z.ZodObject<{
                height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                name: z.ZodString;
                url: z.ZodString;
            }, z.core.$strip>>;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                text: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            customEmojiCount: z.ZodOptional<z.ZodNumber>;
        }, z.core.$strip>;
        meta: z.ZodObject<{
            sensitive: z.ZodBoolean;
            cw: z.ZodNullable<z.ZodString>;
            isBoost: z.ZodBoolean;
            isReply: z.ZodBoolean;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                handle: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodString>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
        state: z.ZodObject<{
            isBookmarkStateFinal: z.ZodBoolean;
        }, z.core.$strip>;
        atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            viewer: z.ZodOptional<z.ZodObject<{
                like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                pinned: z.ZodOptional<z.ZodAny>;
                repost: z.ZodOptional<z.ZodAny>;
                replyDisabled: z.ZodOptional<z.ZodBoolean>;
                threadMuted: z.ZodOptional<z.ZodBoolean>;
            }, z.core.$strip>>;
        }, z.core.$strip>>>;
        replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
    }, z.core.$strip>>>;
    quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        uuid: z.ZodString;
        id: z.ZodString;
        visibility: z.ZodString;
        createdAt: z.ZodString;
        postedBy: z.ZodObject<{
            id: z.ZodString;
            avatarUrl: z.ZodString;
            displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsedDisplayName: z.ZodArray<z.ZodAny>;
            handle: z.ZodString;
            instance: z.ZodString;
        }, z.core.$strip>;
        content: z.ZodObject<{
            raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsed: z.ZodArray<z.ZodAny>;
            media: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                alt: z.ZodNullable<z.ZodString>;
                type: z.ZodString;
                blurhash: z.ZodNullable<z.ZodString>;
            }, z.core.$strip>>;
            links: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                title: z.ZodString;
                description: z.ZodString;
                bannerImageUrl: z.ZodNullable<z.ZodString>;
                bannerWidth: z.ZodOptional<z.ZodNumber>;
                bannerHeight: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        interaction: z.ZodObject<{
            boosted: z.ZodBoolean;
            liked: z.ZodBoolean;
            bookmarked: z.ZodBoolean;
        }, z.core.$strip>;
        stats: z.ZodObject<{
            replyCount: z.ZodNumber;
            boostCount: z.ZodNumber;
            likeCount: z.ZodNumber;
            reactions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                count: z.ZodNumber;
                me: z.ZodBoolean;
                accounts: z.ZodArray<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            mediaContainerHeight: z.ZodNumber;
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
            translationOutput: z.ZodOptional<z.ZodString>;
            translationType: z.ZodOptional<z.ZodString>;
            reactionEmojis: z.ZodArray<z.ZodObject<{
                height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                name: z.ZodString;
                url: z.ZodString;
            }, z.core.$strip>>;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                text: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            customEmojiCount: z.ZodOptional<z.ZodNumber>;
        }, z.core.$strip>;
        meta: z.ZodObject<{
            sensitive: z.ZodBoolean;
            cw: z.ZodNullable<z.ZodString>;
            isBoost: z.ZodBoolean;
            isReply: z.ZodBoolean;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                handle: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodString>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
        state: z.ZodObject<{
            isBookmarkStateFinal: z.ZodBoolean;
        }, z.core.$strip>;
        atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            viewer: z.ZodOptional<z.ZodObject<{
                like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                pinned: z.ZodOptional<z.ZodAny>;
                repost: z.ZodOptional<z.ZodAny>;
                replyDisabled: z.ZodOptional<z.ZodBoolean>;
                threadMuted: z.ZodOptional<z.ZodBoolean>;
            }, z.core.$strip>>;
        }, z.core.$strip>>>;
        replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
    }, z.core.$strip>>>;
    rootPost: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        uuid: z.ZodString;
        id: z.ZodString;
        visibility: z.ZodString;
        createdAt: z.ZodString;
        postedBy: z.ZodObject<{
            id: z.ZodString;
            avatarUrl: z.ZodString;
            displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsedDisplayName: z.ZodArray<z.ZodAny>;
            handle: z.ZodString;
            instance: z.ZodString;
        }, z.core.$strip>;
        content: z.ZodObject<{
            raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsed: z.ZodArray<z.ZodAny>;
            media: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                alt: z.ZodNullable<z.ZodString>;
                type: z.ZodString;
                blurhash: z.ZodNullable<z.ZodString>;
            }, z.core.$strip>>;
            links: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                title: z.ZodString;
                description: z.ZodString;
                bannerImageUrl: z.ZodNullable<z.ZodString>;
                bannerWidth: z.ZodOptional<z.ZodNumber>;
                bannerHeight: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        interaction: z.ZodObject<{
            boosted: z.ZodBoolean;
            liked: z.ZodBoolean;
            bookmarked: z.ZodBoolean;
        }, z.core.$strip>;
        stats: z.ZodObject<{
            replyCount: z.ZodNumber;
            boostCount: z.ZodNumber;
            likeCount: z.ZodNumber;
            reactions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                count: z.ZodNumber;
                me: z.ZodBoolean;
                accounts: z.ZodArray<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            mediaContainerHeight: z.ZodNumber;
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
            translationOutput: z.ZodOptional<z.ZodString>;
            translationType: z.ZodOptional<z.ZodString>;
            reactionEmojis: z.ZodArray<z.ZodObject<{
                height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                name: z.ZodString;
                url: z.ZodString;
            }, z.core.$strip>>;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                text: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            customEmojiCount: z.ZodOptional<z.ZodNumber>;
        }, z.core.$strip>;
        meta: z.ZodObject<{
            sensitive: z.ZodBoolean;
            cw: z.ZodNullable<z.ZodString>;
            isBoost: z.ZodBoolean;
            isReply: z.ZodBoolean;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                handle: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodString>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
        state: z.ZodObject<{
            isBookmarkStateFinal: z.ZodBoolean;
        }, z.core.$strip>;
        atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            viewer: z.ZodOptional<z.ZodObject<{
                like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                pinned: z.ZodOptional<z.ZodAny>;
                repost: z.ZodOptional<z.ZodAny>;
                replyDisabled: z.ZodOptional<z.ZodBoolean>;
                threadMuted: z.ZodOptional<z.ZodBoolean>;
            }, z.core.$strip>>;
        }, z.core.$strip>>>;
    }, z.core.$strip>>>;
}, z.core.$strip>;
type PostObjectType = z.infer<typeof postObjectSchema>;
type PostRootObjectType = z.infer<typeof ActivityPubStatusItemDto>;
declare const mentionObjectSchema: z.ZodObject<{
    id: z.ZodString;
    handle: z.ZodOptional<z.ZodString>;
    url: z.ZodOptional<z.ZodString>;
    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
}, z.core.$strip>;
type PostMentionObjectType = z.infer<typeof mentionObjectSchema>;
type DhaagaPostThreadInterfaceType = {
    ancestors: {
        id: string;
        depth: number;
        post: PostTargetInterface;
    }[];
    descendants: {
        id: string;
        depth: number;
        post: PostTargetInterface;
    }[];
    rootInterface?: {
        id: string;
        depth: number;
        post: PostTargetInterface;
    };
    rootObject?: PostObjectType;
};
export { postObjectSchema };
export type { PostRootObjectType, PostStatsType, PostObjectType, PostAuthorType, PostMediaAttachmentType, ActivityPubReactionStateType, PostMentionObjectType, DhaagaPostThreadInterfaceType, };
//# sourceMappingURL=post.d.ts.map