import { z } from 'zod';
declare const appNotificationGroupedUserItemSchema: z.ZodObject<{
    item: z.ZodObject<{
        id: z.ZodString;
        avatarUrl: z.ZodString;
        displayName: z.ZodNullable<z.ZodString>;
        parsedDisplayName: z.ZodArray<z.ZodAny>;
        handle: z.ZodString;
        instance: z.ZodString;
        banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        meta: z.ZodObject<{
            isProfileLocked: z.ZodBoolean;
            isBot: z.ZodBoolean;
            fields: z.ZodArray<z.ZodObject<{
                name: z.ZodOptional<z.ZodString>;
                value: z.ZodOptional<z.ZodString>;
                verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                cid: z.ZodOptional<z.ZodString>;
                cts: z.ZodOptional<z.ZodString>;
                src: z.ZodOptional<z.ZodString>;
                uri: z.ZodOptional<z.ZodString>;
                val: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        description: z.ZodString;
        parsedDescription: z.ZodArray<z.ZodAny>;
        stats: z.ZodObject<{
            posts: z.ZodNullable<z.ZodNumber>;
            followers: z.ZodNullable<z.ZodNumber>;
            following: z.ZodNullable<z.ZodNumber>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
        }, z.core.$strip>;
        relationship: z.ZodNullable<z.ZodObject<{
            $type: z.ZodOptional<z.ZodLiteral<"app.bsky.actor.defs#viewerState">>;
            muting: z.ZodNullable<z.ZodBoolean>;
            blocking: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
            blockedBy: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
            following: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
            followedBy: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
            showingReblogs: z.ZodNullable<z.ZodBoolean>;
            notifying: z.ZodNullable<z.ZodBoolean>;
            languages: z.ZodArray<z.ZodString>;
            mutingNotifications: z.ZodNullable<z.ZodBoolean>;
            requested: z.ZodNullable<z.ZodBoolean>;
            domainBlocking: z.ZodNullable<z.ZodBoolean>;
            endorsed: z.ZodNullable<z.ZodBoolean>;
            note: z.ZodNullable<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
    types: z.ZodArray<z.ZodString>;
    extraData: z.ZodAny;
}, z.core.$strip>;
declare const appNotificationObjectSchema: z.ZodObject<{
    id: z.ZodString;
    type: z.ZodString;
    createdAt: z.ZodCoercedDate<unknown>;
    user: z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        avatarUrl: z.ZodString;
        displayName: z.ZodNullable<z.ZodString>;
        parsedDisplayName: z.ZodArray<z.ZodAny>;
        handle: z.ZodString;
        instance: z.ZodString;
        banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        meta: z.ZodObject<{
            isProfileLocked: z.ZodBoolean;
            isBot: z.ZodBoolean;
            fields: z.ZodArray<z.ZodObject<{
                name: z.ZodOptional<z.ZodString>;
                value: z.ZodOptional<z.ZodString>;
                verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                cid: z.ZodOptional<z.ZodString>;
                cts: z.ZodOptional<z.ZodString>;
                src: z.ZodOptional<z.ZodString>;
                uri: z.ZodOptional<z.ZodString>;
                val: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        description: z.ZodString;
        parsedDescription: z.ZodArray<z.ZodAny>;
        stats: z.ZodObject<{
            posts: z.ZodNullable<z.ZodNumber>;
            followers: z.ZodNullable<z.ZodNumber>;
            following: z.ZodNullable<z.ZodNumber>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
        }, z.core.$strip>;
        relationship: z.ZodNullable<z.ZodObject<{
            $type: z.ZodOptional<z.ZodLiteral<"app.bsky.actor.defs#viewerState">>;
            muting: z.ZodNullable<z.ZodBoolean>;
            blocking: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
            blockedBy: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
            following: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
            followedBy: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
            showingReblogs: z.ZodNullable<z.ZodBoolean>;
            notifying: z.ZodNullable<z.ZodBoolean>;
            languages: z.ZodArray<z.ZodString>;
            mutingNotifications: z.ZodNullable<z.ZodBoolean>;
            requested: z.ZodNullable<z.ZodBoolean>;
            domainBlocking: z.ZodNullable<z.ZodBoolean>;
            endorsed: z.ZodNullable<z.ZodBoolean>;
            note: z.ZodNullable<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
    post: z.ZodNullable<z.ZodObject<{
        uuid: z.ZodString;
        id: z.ZodString;
        visibility: z.ZodString;
        createdAt: z.ZodString;
        postedBy: z.ZodObject<{
            id: z.ZodString;
            avatarUrl: z.ZodString;
            displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsedDisplayName: z.ZodArray<z.ZodAny>;
            handle: z.ZodString;
            instance: z.ZodString;
        }, z.core.$strip>;
        content: z.ZodObject<{
            raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsed: z.ZodArray<z.ZodAny>;
            media: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                alt: z.ZodNullable<z.ZodString>;
                type: z.ZodString;
                blurhash: z.ZodNullable<z.ZodString>;
            }, z.core.$strip>>;
            links: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                title: z.ZodString;
                description: z.ZodString;
                bannerImageUrl: z.ZodNullable<z.ZodString>;
                bannerWidth: z.ZodOptional<z.ZodNumber>;
                bannerHeight: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        interaction: z.ZodObject<{
            boosted: z.ZodBoolean;
            liked: z.ZodBoolean;
            bookmarked: z.ZodBoolean;
        }, z.core.$strip>;
        stats: z.ZodObject<{
            replyCount: z.ZodNumber;
            boostCount: z.ZodNumber;
            likeCount: z.ZodNumber;
            reactions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                count: z.ZodNumber;
                me: z.ZodBoolean;
                accounts: z.ZodArray<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            mediaContainerHeight: z.ZodNumber;
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
            translationOutput: z.ZodOptional<z.ZodString>;
            translationType: z.ZodOptional<z.ZodString>;
            reactionEmojis: z.ZodArray<z.ZodObject<{
                height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                name: z.ZodString;
                url: z.ZodString;
            }, z.core.$strip>>;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                text: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            customEmojiCount: z.ZodOptional<z.ZodNumber>;
        }, z.core.$strip>;
        meta: z.ZodObject<{
            sensitive: z.ZodBoolean;
            cw: z.ZodNullable<z.ZodString>;
            isBoost: z.ZodBoolean;
            isReply: z.ZodBoolean;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                handle: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodString>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
        state: z.ZodObject<{
            isBookmarkStateFinal: z.ZodBoolean;
        }, z.core.$strip>;
        atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            viewer: z.ZodOptional<z.ZodObject<{
                like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                pinned: z.ZodOptional<z.ZodAny>;
                repost: z.ZodOptional<z.ZodAny>;
                replyDisabled: z.ZodOptional<z.ZodBoolean>;
                threadMuted: z.ZodOptional<z.ZodBoolean>;
            }, z.core.$strip>>;
        }, z.core.$strip>>>;
        replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
            replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
            replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
            replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                    links: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        title: z.ZodString;
                        description: z.ZodString;
                        bannerImageUrl: z.ZodNullable<z.ZodString>;
                        bannerWidth: z.ZodOptional<z.ZodNumber>;
                        bannerHeight: z.ZodOptional<z.ZodNumber>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    customEmojiCount: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        rootPost: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
                links: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    title: z.ZodString;
                    description: z.ZodString;
                    bannerImageUrl: z.ZodNullable<z.ZodString>;
                    bannerWidth: z.ZodOptional<z.ZodNumber>;
                    bannerHeight: z.ZodOptional<z.ZodNumber>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                customEmojiCount: z.ZodOptional<z.ZodNumber>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
    }, z.core.$strip>>;
    extraData: z.ZodAny;
    read: z.ZodBoolean;
    users: z.ZodOptional<z.ZodArray<z.ZodObject<{
        item: z.ZodObject<{
            id: z.ZodString;
            avatarUrl: z.ZodString;
            displayName: z.ZodNullable<z.ZodString>;
            parsedDisplayName: z.ZodArray<z.ZodAny>;
            handle: z.ZodString;
            instance: z.ZodString;
            banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            meta: z.ZodObject<{
                isProfileLocked: z.ZodBoolean;
                isBot: z.ZodBoolean;
                fields: z.ZodArray<z.ZodObject<{
                    name: z.ZodOptional<z.ZodString>;
                    value: z.ZodOptional<z.ZodString>;
                    verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    cid: z.ZodOptional<z.ZodString>;
                    cts: z.ZodOptional<z.ZodString>;
                    src: z.ZodOptional<z.ZodString>;
                    uri: z.ZodOptional<z.ZodString>;
                    val: z.ZodOptional<z.ZodString>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            description: z.ZodString;
            parsedDescription: z.ZodArray<z.ZodAny>;
            stats: z.ZodObject<{
                posts: z.ZodNullable<z.ZodNumber>;
                followers: z.ZodNullable<z.ZodNumber>;
                following: z.ZodNullable<z.ZodNumber>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
            }, z.core.$strip>;
            relationship: z.ZodNullable<z.ZodObject<{
                $type: z.ZodOptional<z.ZodLiteral<"app.bsky.actor.defs#viewerState">>;
                muting: z.ZodNullable<z.ZodBoolean>;
                blocking: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
                blockedBy: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
                following: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
                followedBy: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
                showingReblogs: z.ZodNullable<z.ZodBoolean>;
                notifying: z.ZodNullable<z.ZodBoolean>;
                languages: z.ZodArray<z.ZodString>;
                mutingNotifications: z.ZodNullable<z.ZodBoolean>;
                requested: z.ZodNullable<z.ZodBoolean>;
                domainBlocking: z.ZodNullable<z.ZodBoolean>;
                endorsed: z.ZodNullable<z.ZodBoolean>;
                note: z.ZodNullable<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        types: z.ZodArray<z.ZodString>;
        extraData: z.ZodAny;
    }, z.core.$strip>>>;
    uri: z.ZodOptional<z.ZodString>;
    cid: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
type NotificationObjectType = z.infer<typeof appNotificationObjectSchema>;
type NotificationUserGroupType = z.infer<typeof appNotificationGroupedUserItemSchema>;
declare const mastoApiV2NotificationGroupSchema: z.ZodObject<{
    groupKey: z.ZodString;
    latestPageNotificationAt: z.ZodDate;
    mostRecentNotificationId: z.ZodNumber;
    notificationsCount: z.ZodNumber;
    pageMaxId: z.ZodString;
    pageMinId: z.ZodString;
    sampleAccountIds: z.ZodArray<z.ZodString>;
    statusId: z.ZodString;
    type: z.ZodEnum<{
        "admin.report": "admin.report";
        "admin.sign_up": "admin.sign_up";
        favourite: "favourite";
        follow: "follow";
        follow_request: "follow_request";
        mention: "mention";
        moderation_warning: "moderation_warning";
        poll: "poll";
        quote: "quote";
        quoted_update: "quoted_update";
        reblog: "reblog";
        severed_relationships: "severed_relationships";
        status: "status";
        update: "update";
    }>;
}, z.core.$strip>;
type MastoApiGroupedNotificationType = z.infer<typeof mastoApiV2NotificationGroupSchema>;
export { appNotificationGroupedUserItemSchema, appNotificationObjectSchema, mastoApiV2NotificationGroupSchema, };
export type { MastoApiGroupedNotificationType, NotificationUserGroupType, NotificationObjectType, };
//# sourceMappingURL=notifications.d.ts.map