import z from 'zod';
declare const postLinkAttachmentObjectSchema: z.ZodObject<{
    url: z.ZodString;
    title: z.ZodString;
    description: z.ZodString;
    bannerImageUrl: z.ZodNullable<z.ZodString>;
    bannerWidth: z.ZodOptional<z.ZodNumber>;
    bannerHeight: z.ZodOptional<z.ZodNumber>;
}, z.core.$strip>;
type PostLinkAttachmentObjectType = z.infer<typeof postLinkAttachmentObjectSchema>;
declare const akkomaCardObjectSchema: z.ZodObject<{
    type: z.ZodLiteral<"link">;
    url: z.ZodString;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    image: z.ZodNullable<z.ZodString>;
    pleroma: z.ZodObject<{
        opengraph: z.ZodObject<{
            site_name: z.ZodString;
            'image:height': z.ZodOptional<z.ZodCoercedNumber<unknown>>;
            'image:width': z.ZodOptional<z.ZodCoercedNumber<unknown>>;
            type: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>;
    }, z.core.$strip>;
}, z.core.$strip>;
type AkkomaCardObjectType = z.infer<typeof akkomaCardObjectSchema>;
declare const mastoApiCardObjectSchema: z.ZodObject<{
    type: z.ZodLiteral<"link">;
    url: z.ZodString;
    title: z.ZodString;
    description: z.ZodString;
    language: z.ZodString;
    width: z.ZodNumber;
    height: z.ZodNumber;
    publishedAt: z.ZodCoercedDate<unknown>;
    blurhash: z.ZodString;
    image: z.ZodNullable<z.ZodString>;
    imageDescription: z.ZodString;
}, z.core.$strip>;
type MastoApiCardObjectType = z.infer<typeof mastoApiCardObjectSchema>;
export { postLinkAttachmentObjectSchema, akkomaCardObjectSchema, mastoApiCardObjectSchema, };
export type { AkkomaCardObjectType, MastoApiCardObjectType, PostLinkAttachmentObjectType, };
//# sourceMappingURL=link-attachments.d.ts.map