import { z } from 'zod';
const appMessageObjectSchema = z.object({
    id: z.string(),
    senderId: z.string(),
    content: z.object({
        raw: z.string().nullable().optional(),
    }),
    embed: z.any().nullable(),
    createdAt: z.coerce.date(),
    facets: z.array(z.any()),
    reactions: z.array(z.object({
        value: z.string(),
        senderId: z.string(),
        createdAt: z.coerce.date(),
    })),
    deleted: z.boolean(),
});
const appChatRoomObjectSchema = z.object({
    id: z.string(),
    members: z.array(z.object({
        id: z.string(),
        handle: z.string(),
        displayName: z.string().optional(),
        avatar: z.string().optional(),
    })),
    unreadCount: z.number().nullable(),
    muting: z.boolean(),
    lastMessage: appMessageObjectSchema.nullable(),
});
export { appMessageObjectSchema, appChatRoomObjectSchema };
//# sourceMappingURL=chat.js.map